/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sequence;

import jp.ossc.nimbus.core.*;

/**
 * {@link StringSequenceService}MBeanC^tF[XB<p>
 * 
 * @author H.Nakano
 */
public interface StringSequenceServiceMBean extends ServiceBaseMBean {
    
    /**
     * Ԃԍ̃tH[}bgݒ肷B<p>
     * tH[}bg̎w@́AȉB<br>
     * <ul>
     *   <li>Œvf́Â܂܎w肷B</li>
     *   <li>vf́A"Jn,I"Ŏw肷B܂AJnAI1Ŏw肵Ȃ΂ȂȂB</li>
     *   <li>ReLXgϐvf́A"%ReLXgL[%"Ŏw肷B</li>
     * </ul>
     * ܂Aevf́A;ŋ؂B<br>
     * <pre>
     *  ݒF
     *    ID_;%HOST_NAME%;_;0,9;0,9;0,9;0,9;0,9
     *    
     *  ԌʁF
     *    ID_server1_00001
     * </pre>
     * 
     * @param format Ԃԍ̃tH[}bg
     */
    public void setFormat(String format);
    
    /**
     * Ԃԍ̃tH[}bg擾B<p>
     * 
     * @return Ԃԍ̃tH[}bg
     */
    public String getFormat();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     * ԂԍɃReLXgϐvfgꍇɁA擾ContextT[rXݒ肷B<br>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * Ԃԍit@Cݒ肷B<p>
     * ̑ݒ肷ƁAԂԍt@CɉiB<br>
     * ܂AT[rX̊JnɁAit@C݂ꍇ́AǂݍŔԍ𕜌āAŏIԔԍƂB<br>
     *
     * @param file Ԃԍit@C
     */
    public void setPersistFile(String file);
    
    /**
     * Ԃԍit@C擾B<p>
     *
     * @return Ԃԍit@C
     */
    public String getPersistFile();
    
    /**
     * ԍ𔭔Ԃ閈ɉi邩ǂݒ肷B<p>
     * {@link #setPersistFile(String)}ŉit@Cݒ肵Ăꍇ̂݁ALłB<br>
     * ftHǵAfalseŁAT[rX̒~̂݉iB̏ꍇAvZXkillȂǁAT[rX̒~Ȃꍇɂ́AiȂB<br>
     *
     * @param isEveryTime ԍ𔭔Ԃ閈ɉiꍇtrue
     */
    public void setPersistEveryTime(boolean isEveryTime);
    
    /**
     * ԍ𔭔Ԃ閈ɉi邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAԍ𔭔Ԃ閈ɉi
     */
    public boolean isPersistEveryTime();
}
