/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.io.Serializable;
import java.sql.*;
import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * JDBCRlNVt@NgB<p>
 * java.sql.DriverManagergāARlNV擾B<br>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="ConnectionFactory"
 *                  code="jp.ossc.nimbus.service.sql.JDBCConnectionFactoryService"&gt;
 *             &lt;attribute name="DriverName"&gt;com.mysql.jdbc.Driver&lt;/attribute&gt;
 *             &lt;attribute name="ConnectionURL"&gt;jdbc:mysql://localhost/sample?useUnicode=true&amp;characterEncoding=MS932&lt;/attribute&gt;
 *             &lt;attribute name="UserName"&gt;hoge&lt;/attribute&gt;
 *             &lt;attribute name="Password"&gt;fuga&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class JDBCConnectionFactoryService extends ServiceBase
 implements ConnectionFactory, JDBCConnectionFactoryServiceMBean, Serializable{
    
    private static final long serialVersionUID = -1395958772628393323L;
    
    /**
     * JDBChCoB<p>
     */
    private String driverName;
    
    /**
     * JDBCڑURLB<p>
     */
    private String connectionURL;
    
    /**
     * JDBCڑ[UB<p>
     */
    private String userName;
    
    /**
     * JDBCڑpX[hB<p>
     */
    private String password;
    
    /**
     * JDBCڑvpeBB<p>
     */
    private Properties info = new Properties();
    
    /**
     * R~bgtOB<p>
     * R~bg̏ꍇAtrueB
     */
    private boolean isAutoCommit = true;
    
    /**
     * JnsB<p>
     * hCoݒ肳ĂȂꍇ͗OthrowB<br>
     * JDBCڑURLݒ肳ĂȂꍇ͗OthrowB<br>
     * JDBCڑ[UJDBCڑpX[hЕݒ肳Ăꍇ͗OthrowB<br>
     * JDBCڑ[UJDBCڑvpeBɐݒ肳Ăꍇ͗OthrowB<br>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        if(getDriverName() == null){
            throw new IllegalArgumentException("Driver name is null.");
        }
        if(getConnectionURL() == null){
            throw new IllegalArgumentException("Connection URL is null.");
        }
        if((getUserName() != null && getPassword() == null)
            || (getUserName() == null && getPassword() != null)){
            throw new IllegalArgumentException(
                "Only one of the two cannot specify \"UserName\""
                 + " and \"Password.\""
            );
        }
        if(getUserName() != null && getConnectionProperties().size() != 0){
            throw new IllegalArgumentException(
                "It cannot specify simultaneously \"UserName\""
                 + " and \"ConnectionProperties.\""
            );
        }
        Class.forName(getDriverName(), true, NimbusClassLoader.getInstance());
    }
    
    // ConnectionFactoryJavaDoc
    public Connection getConnection() throws ConnectionFactoryException{
        Connection con = null;
        try{
            if(getUserName() != null){
                con = DriverManager.getConnection(
                    getConnectionURL(),
                    getUserName(),
                    getPassword()
                );
            }else if(getConnectionProperties().size() != 0){
                con = DriverManager.getConnection(
                    getConnectionURL(),
                    getConnectionProperties()
                );
            }else{
                con = DriverManager.getConnection(getConnectionURL());
            }
            con.setAutoCommit(isAutoCommit);
        }catch(Exception e){
            throw new ConnectionFactoryException(e);
        }
        return con;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public void setDriverName(String name){
        driverName = name;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public String getDriverName(){
        return driverName;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public void setConnectionURL(String url){
        connectionURL = url;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public String getConnectionURL(){
        return connectionURL;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public void setUserName(String name){
        userName = name;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public String getUserName(){
        return userName;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public void setPassword(String password){
        this.password = password;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public String getPassword(){
        return password;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public void setConnectionProperties(Properties prop){
        info.putAll(prop);
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public Properties getConnectionProperties(){
        return info;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public void setAutoCommit(boolean isAuto){
        isAutoCommit = isAuto;
    }
    
    // JDBCConnectionFactoryServiceMBeanJavaDoc
    public boolean isAutoCommit(){
        return isAutoCommit;
    }
}
