/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer.mail;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link MailMessageWriterService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MailMessageWriterService
 */
public interface MailMessageWriterServiceMBean extends ServiceBaseMBean{
    
    /**
     * javax.mail.SessionJNDIlookup鎞̃ftHgJNDIB<p>
     */
    public static final String DEFAULT_MAIL_SESSION_JNDI_NAME = "java:/Mail";
    
    /**
     * javax.mail.SessioñvpeBݒ肷B<p>
     *
     * @param prop javax.mail.SessioñvpeB
     */
    public void setSessionProperties(Properties prop);
    
    /**
     * javax.mail.SessioñvpeB擾B<p>
     *
     * @return javax.mail.SessioñvpeB
     */
    public Properties getSessionProperties();
    
    /**
     * javax.mail.AuthenticatorT[rX̃T[rXݒ肷B<p>
     *
     * @param name javax.mail.AuthenticatorT[rX̃T[rX
     */
    public void setAuthenticatorServiceName(ServiceName name);
    
    /**
     * javax.mail.AuthenticatorT[rX̃T[rX擾B<p>
     *
     * @return javax.mail.AuthenticatorT[rX̃T[rX
     */
    public ServiceName getAuthenticatorServiceName();
    
    /**
     * javax.mail.Messagẽwb_ݒ肷B<p>
     *
     * @param prop javax.mail.Messagẽwb_
     */
    public void setHeaders(Properties prop);
    
    /**
     * javax.mail.Messagẽwb_擾B<p>
     *
     * @return javax.mail.Messagẽwb_
     */
    public Properties getHeaders();
    
    /**
     * javax.mail.Messagẽwb_{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param keys WritableRecord̃L[z
     */
    public void setHeaderKeys(String[] keys);
    
    /**
     * javax.mail.Messagẽwb_{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[s擾B<p>
     *
     * @return WritableRecord̃L[z
     */
    public String[] getHeaderKeys();
    
    /**
     * javax.mail.SessioñvpeB"mail.smtp.from"{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setEnvelopeFromAddressKey(String key);
    
    /**
     * javax.mail.SessioñvpeB"mail.smtp.from"{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getEnvelopeFromAddressKey();
    
    /**
     * javax.mail.SessioñvpeB"mail.smtp.from"ݒ肷B<p>
     *
     * @param address javax.mail.SessioñvpeB"mail.smtp.from"
     */
    public void setEnvelopeFromAddress(String address);
    
    /**
     * javax.mail.SessioñvpeB"mail.smtp.from"擾B<p>
     *
     * @return javax.mail.SessioñvpeB"mail.smtp.from"
     */
    public String getEnvelopeFromAddress();
    
    /**
     * javax.mail.SessioñvpeB"mail.smtp.from"[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setEnvelopeFromAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.SessioñvpeB"mail.smtp.from"[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isEnvelopeFromAddressValidate();
    
    /**
     * javax.mail.MessageFromAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setFromAddressKey(String key);
    
    /**
     * javax.mail.MessageFromAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getFromAddressKey();
    
    /**
     * javax.mail.MessageFromAhXݒ肷B<p>
     *
     * @param address javax.mail.MessageFromAhX
     */
    public void setFromAddress(String address);
    
    /**
     * javax.mail.MessageFromAhX擾B<p>
     *
     * @return javax.mail.MessageFromAhX
     */
    public String getFromAddress();
    
    /**
     * javax.mail.MessageFromAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setFromPersonalKey(String key);
    
    /**
     * javax.mail.MessageFromAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getFromPersonalKey();
    
    /**
     * javax.mail.MessageFromAhX̕\ݒ肷B<p>
     *
     * @param personal javax.mail.MessageFromAhX̕\
     */
    public void setFromPersonal(String personal);
    
    /**
     * javax.mail.MessageFromAhX̕\擾B<p>
     *
     * @return javax.mail.MessageFromAhX̕\
     */
    public String getFromPersonal();
    
    /**
     * javax.mail.MessageFromAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setFromPersonalEncodingKey(String key);
    
    /**
     * javax.mail.MessageFromAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getFromPersonalEncodingKey();
    
    /**
     * javax.mail.MessageFromAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageFromAhX̕\GR[fBO
     */
    public void setFromPersonalEncoding(String encoding);
    
    /**
     * javax.mail.MessageFromAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageFromAhX̕\GR[fBO
     */
    public String getFromPersonalEncoding();
    
    /**
     * javax.mail.MessageFromAhX[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setFromAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.MessageFromAhX[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isFromAddressValidate();
    
    /**
     * javax.mail.MessageSenderAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setSenderAddressKey(String key);
    
    /**
     * javax.mail.MessageSenderAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getSenderAddressKey();
    
    /**
     * javax.mail.MessageSenderAhXݒ肷B<p>
     *
     * @param address javax.mail.MessageSenderAhX
     */
    public void setSenderAddress(String address);
    
    /**
     * javax.mail.MessageSenderAhX擾B<p>
     *
     * @return javax.mail.MessageSenderAhX
     */
    public String getSenderAddress();
    
    /**
     * javax.mail.MessageSenderAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setSenderPersonalKey(String key);
    
    /**
     * javax.mail.MessageSenderAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getSenderPersonalKey();
    
    /**
     * javax.mail.MessageSenderAhX̕\ݒ肷B<p>
     *
     * @param personal javax.mail.MessageSenderAhX̕\
     */
    public void setSenderPersonal(String personal);
    
    /**
     * javax.mail.MessageSenderAhX̕\擾B<p>
     *
     * @return javax.mail.MessageSenderAhX̕\
     */
    public String getSenderPersonal();
    
    /**
     * javax.mail.MessageSenderAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setSenderPersonalEncodingKey(String key);
    
    /**
     * javax.mail.MessageSenderAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getSenderPersonalEncodingKey();
    
    /**
     * javax.mail.MessageSenderAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageSenderAhX̕\GR[fBO
     */
    public void setSenderPersonalEncoding(String encoding);
    
    /**
     * javax.mail.MessageSenderAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageSenderAhX̕\GR[fBO
     */
    public String getSenderPersonalEncoding();
    
    /**
     * javax.mail.MessageSenderAhX[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setSenderAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.MessageSenderAhX[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isSenderAddressValidate();
    
    /**
     * javax.mail.MessageToAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setToAddressKey(String key);
    
    /**
     * javax.mail.MessageToAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getToAddressKey();
    
    /**
     * javax.mail.MessageToAhXݒ肷B<p>
     *
     * @param address javax.mail.MessageToAhXz
     */
    public void setToAddress(String[] address);
    
    /**
     * javax.mail.MessageToAhX擾B<p>
     *
     * @return javax.mail.MessageToAhXz
     */
    public String[] getToAddress();
    
    /**
     * javax.mail.MessageToAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setToPersonalKey(String key);
    
    /**
     * javax.mail.MessageToAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getToPersonalKey();
    
    /**
     * javax.mail.MessageToAhX̕\ݒ肷B<p>
     *
     * @param personal javax.mail.MessageToAhX̕\z
     */
    public void setToPersonals(String[] personal);
    
    /**
     * javax.mail.MessageToAhX̕\擾B<p>
     *
     * @return javax.mail.MessageToAhX̕\z
     */
    public String[] getToPersonals();
    
    /**
     * javax.mail.MessageToAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setToPersonalEncodingKey(String key);
    
    /**
     * javax.mail.MessageToAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getToPersonalEncodingKey();
    
    /**
     * javax.mail.MessageToAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageToAhX̕\GR[fBOz
     */
    public void setToPersonalEncodings(String[] encoding);
    
    /**
     * javax.mail.MessageToAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageToAhX̕\GR[fBOz
     */
    public String[] getToPersonalEncodings();
    
    /**
     * javax.mail.MessageToAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageToAhX̕\GR[fBO
     */
    public void setToPersonalEncoding(String encoding);
    
    /**
     * javax.mail.MessageToAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageToAhX̕\GR[fBO
     */
    public String getToPersonalEncoding();
    
    /**
     * javax.mail.MessageToAhX[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setToAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.MessageToAhX[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isToAddressValidate();
    
    /**
     * javax.mail.MessageCcAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setCcAddressKey(String key);
    
    /**
     * javax.mail.MessageCcAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getCcAddressKey();
    
    /**
     * javax.mail.MessageCcAhXݒ肷B<p>
     *
     * @param address javax.mail.MessageCcAhXz
     */
    public void setCcAddress(String[] address);
    
    /**
     * javax.mail.MessageCcAhX擾B<p>
     *
     * @return javax.mail.MessageCcAhXz
     */
    public String[] getCcAddress();
    
    /**
     * javax.mail.MessageCcAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setCcPersonalKey(String key);
    
    /**
     * javax.mail.MessageCcAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getCcPersonalKey();
    
    /**
     * javax.mail.MessageCcAhX̕\ݒ肷B<p>
     *
     * @param personal javax.mail.MessageCcAhX̕\z
     */
    public void setCcPersonals(String[] personal);
    
    /**
     * javax.mail.MessageCcAhX̕\擾B<p>
     *
     * @return javax.mail.MessageCcAhX̕\z
     */
    public String[] getCcPersonals();
    
    /**
     * javax.mail.MessageCcAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setCcPersonalEncodingKey(String key);
    
    /**
     * javax.mail.MessageCcAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getCcPersonalEncodingKey();
    
    /**
     * javax.mail.MessageCcAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageCcAhX̕\GR[fBOz
     */
    public void setCcPersonalEncodings(String[] encoding);
    
    /**
     * javax.mail.MessageCcAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageCcAhX̕\GR[fBO
     */
    public String[] getCcPersonalEncodings();
    
    /**
     * javax.mail.MessageCcAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageCcAhX̕\GR[fBO
     */
    public void setCcPersonalEncoding(String encoding);
    
    /**
     * javax.mail.MessageCcAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageCcAhX̕\GR[fBO
     */
    public String getCcPersonalEncoding();
    
    /**
     * javax.mail.MessageCcAhX[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setCcAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.MessageCcAhX[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isCcAddressValidate();
    
    /**
     * javax.mail.MessageBccAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setBccAddressKey(String key);
    
    /**
     * javax.mail.MessageBccAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getBccAddressKey();
    
    /**
     * javax.mail.MessageBccAhXݒ肷B<p>
     *
     * @param address javax.mail.MessageBccAhXz
     */
    public void setBccAddress(String[] address);
    
    /**
     * javax.mail.MessageBccAhX擾B<p>
     *
     * @return javax.mail.MessageBccAhXz
     */
    public String[] getBccAddress();
    
    /**
     * javax.mail.MessageBccAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setBccPersonalKey(String key);
    
    /**
     * javax.mail.MessageBccAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getBccPersonalKey();
    
    /**
     * javax.mail.MessageBccAhX̕\ݒ肷B<p>
     *
     * @param personal javax.mail.MessageBccAhX̕\z
     */
    public void setBccPersonals(String[] personal);
    
    /**
     * javax.mail.MessageBccAhX̕\擾B<p>
     *
     * @return javax.mail.MessageBccAhX̕\z
     */
    public String[] getBccPersonals();
    
    /**
     * javax.mail.MessageBccAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setBccPersonalEncodingKey(String key);
    
    /**
     * javax.mail.MessageBccAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getBccPersonalEncodingKey();
    
    /**
     * javax.mail.MessageBccAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageBccAhX̕\GR[fBOz
     */
    public void setBccPersonalEncodings(String[] encoding);
    
    /**
     * javax.mail.MessageBccAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageBccAhX̕\GR[fBO
     */
    public String[] getBccPersonalEncodings();
    
    /**
     * javax.mail.MessageBccAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageBccAhX̕\GR[fBO
     */
    public void setBccPersonalEncoding(String encoding);
    
    /**
     * javax.mail.MessageBccAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageBccAhX̕\GR[fBO
     */
    public String getBccPersonalEncoding();
    
    /**
     * javax.mail.MessageBccAhX[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setBccAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.MessageBccAhX[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isBccAddressValidate();
    
    /**
     * javax.mail.MessageReplyToAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setReplyToAddressKey(String key);
    
    /**
     * javax.mail.MessageReplyToAhX{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getReplyToAddressKey();
    
    /**
     * javax.mail.MessageReplyToAhXݒ肷B<p>
     *
     * @param address javax.mail.MessageReplyToAhXz
     */
    public void setReplyToAddress(String[] address);
    
    /**
     * javax.mail.MessageReplyToAhX擾B<p>
     *
     * @return javax.mail.MessageReplyToAhXz
     */
    public String[] getReplyToAddress();
    
    /**
     * javax.mail.MessageReplyToAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setReplyToPersonalKey(String key);
    
    /**
     * javax.mail.MessageReplyToAhX̕\{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getReplyToPersonalKey();
    
    /**
     * javax.mail.MessageReplyToAhX̕\ݒ肷B<p>
     *
     * @param personal javax.mail.MessageReplyToAhX̕\z
     */
    public void setReplyToPersonals(String[] personal);
    
    /**
     * javax.mail.MessageReplyToAhX̕\擾B<p>
     *
     * @return javax.mail.MessageReplyToAhX̕\z
     */
    public String[] getReplyToPersonals();
    
    /**
     * javax.mail.MessageReplyToAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setReplyToPersonalEncodingKey(String key);
    
    /**
     * javax.mail.MessageReplyToAhX̕\GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getReplyToPersonalEncodingKey();
    
    /**
     * javax.mail.MessageReplyToAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageReplyToAhX̕\GR[fBOz
     */
    public void setReplyToPersonalEncodings(String[] encoding);
    
    /**
     * javax.mail.MessageReplyToAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageReplyToAhX̕\GR[fBO
     */
    public String[] getReplyToPersonalEncodings();
    
    /**
     * javax.mail.MessageReplyToAhX̕\GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageReplyToAhX̕\GR[fBO
     */
    public void setReplyToPersonalEncoding(String encoding);
    
    /**
     * javax.mail.MessageReplyToAhX̕\GR[fBO擾B<p>
     *
     * @return javax.mail.MessageReplyToAhX̕\GR[fBO
     */
    public String getReplyToPersonalEncoding();
    
    /**
     * javax.mail.MessageReplyToAhX[AhXƂĐ؂邩ǂݒ肷B<p>
     *
     * @param isValidate ؂ꍇtrue
     */
    public void setReplyToAddressValidate(boolean isValidate);
    
    /**
     * javax.mail.MessageReplyToAhX[AhXƂĐ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA؂
     */
    public boolean isReplyToAddressValidate();
    
    /**
     * javax.mail.MessageSubject{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setSubjectKey(String key);
    
    /**
     * javax.mail.MessageSubject{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getSubjectKey();
    
    /**
     * javax.mail.MessageSubjectݒ肷B<p>
     *
     * @param subject javax.mail.MessageSubject
     */
    public void setSubject(String subject);
    
    /**
     * javax.mail.MessageSubject擾B<p>
     *
     * @return javax.mail.MessageSubject
     */
    public String getSubject();
    
    /**
     * javax.mail.MessageSubject̕GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setSubjectEncodingKey(String key);
    
    /**
     * javax.mail.MessageSubject̕GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getSubjectEncodingKey();
    
    /**
     * javax.mail.MessageSubject̕GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageSubject̕GR[fBO
     */
    public void setSubjectEncoding(String encoding);
    
    /**
     * javax.mail.MessageSubject̕GR[fBO擾B<p>
     *
     * @return javax.mail.MessageSubject̕GR[fBO
     */
    public String getSubjectEncoding();
    
    /**
     * javax.mail.MessageContentID{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setContentIDKey(String key);
    
    /**
     * javax.mail.MessageContentID{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getContentIDKey();
    
    /**
     * javax.mail.MessageContentIDݒ肷B<p>
     *
     * @param id javax.mail.MessageContentID
     */
    public void setContentID(String id);
    
    /**
     * javax.mail.MessageContentID擾B<p>
     *
     * @return javax.mail.MessageContentID
     */
    public String getContentID();
    
    /**
     * javax.mail.MessageContentLanguage{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setContentLanguageKey(String key);
    
    /**
     * javax.mail.MessageContentLanguage{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getContentLanguageKey();
    
    /**
     * javax.mail.MessageContentLanguageݒ肷B<p>
     *
     * @param lang javax.mail.MessageContentLanguage
     */
    public void setContentLanguage(String[] lang);
    
    /**
     * javax.mail.MessageContentLanguage擾B<p>
     *
     * @return javax.mail.MessageContentLanguage
     */
    public String[] getContentLanguage();
    
    /**
     * javax.mail.MessageContentMD5{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setContentMD5Key(String key);
    
    /**
     * javax.mail.MessageContentMD5{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getContentMD5Key();
    
    /**
     * javax.mail.MessageContentMD5ݒ肷B<p>
     *
     * @param val javax.mail.MessageContentMD5
     */
    public void setContentMD5(String val);
    
    /**
     * javax.mail.MessageContentMD5擾B<p>
     *
     * @return javax.mail.MessageContentMD5
     */
    public String getContentMD5();
    
    /**
     * javax.mail.MessageDescription{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setDescriptionKey(String key);
    
    /**
     * javax.mail.MessageDescription{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getDescriptionKey();
    
    /**
     * javax.mail.MessageDescriptionݒ肷B<p>
     *
     * @param val javax.mail.MessageDescription
     */
    public void setDescription(String val);
    
    /**
     * javax.mail.MessageDescription擾B<p>
     *
     * @return javax.mail.MessageDescription
     */
    public String getDescription();
    
    /**
     * javax.mail.MessageDescription̕GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setDescriptionEncodingKey(String key);
    
    /**
     * javax.mail.MessageDescription̕GR[fBO{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getDescriptionEncodingKey();
    
    /**
     * javax.mail.MessageDescription̕GR[fBOݒ肷B<p>
     *
     * @param encoding javax.mail.MessageDescription̕GR[fBO
     */
    public void setDescriptionEncoding(String encoding);
    
    /**
     * javax.mail.MessageDescription̕GR[fBO擾B<p>
     *
     * @return javax.mail.MessageDescription̕GR[fBO
     */
    public String getDescriptionEncoding();
    
    /**
     * javax.mail.MessageDisposition{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setDispositionKey(String key);
    
    /**
     * javax.mail.MessageDisposition{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getDispositionKey();
    
    /**
     * javax.mail.MessageDispositionݒ肷B<p>
     *
     * @param val javax.mail.MessageDisposition
     */
    public void setDisposition(String val);
    
    /**
     * javax.mail.MessageDisposition擾B<p>
     *
     * @return javax.mail.MessageDisposition
     */
    public String getDisposition();
    
    /**
     * Ytt@C{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setFilePartKey(String key);
    
    /**
     * Ytt@C{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getFilePartKey();
    
    /**
     * Ytt@C̃t@C̕R[h{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setFileCharsetKey(String key);
    
    /**
     * Ytt@C̃t@C̕R[h{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getFileCharsetKey();
    
    /**
     * Ytt@C̃t@C̕R[hݒ肷B<p>
     *
     * @param charset R[h
     */
    public void setFileCharset(String charset);
    
    /**
     * Ytt@C̃t@C̕R[h擾B<p>
     *
     * @return R[h
     */
    public String getFileCharset();
    
    /**
     * Ytt@C̃t@ČR[h{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̃L[
     */
    public void setFileLanguageKey(String key);
    
    /**
     * Ytt@C̃t@ČR[h{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̃L[擾B<p>
     *
     * @return WritableRecord̃L[
     */
    public String getFileLanguageKey();
    
    /**
     * Ytt@C̃t@ČR[hݒ肷B<p>
     *
     * @param lang R[h
     */
    public void setFileLanguage(String lang);
    
    /**
     * Ytt@C̃t@ČR[h擾B<p>
     *
     * @return R[h
     */
    public String getFileLanguage();
    
    /**
     * [̖{{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̊JnCfbNXw肷{@link jp.ossc.nimbus.service.writer.WritableElement WritableElement}̃L[ݒ肷B<p>
     *
     * @param key WritableRecord̊JnCfbNXw肷WritableElement̃L[
     */
    public void setBodyIndexKey(String key);
    
    /**
     * [̖{{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̊JnCfbNXw肷{@link jp.ossc.nimbus.service.writer.WritableElement WritableElement}̃L[擾B<p>
     *
     * @return WritableRecord̊JnCfbNXw肷WritableElement̃L[
     */
    public String getBodyIndexKey();
    
    /**
     * [̖{{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̊JnCfbNXݒ肷B<p>
     *
     * @param index WritableRecord̊JnCfbNX
     */
    public void setBodyIndex(int index);
    
    /**
     * [̖{{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}擾Đݒ肷ۂ́AWritableRecord̊JnCfbNX擾B<p>
     *
     * @return WritableRecord̊JnCfbNX
     */
    public int getBodyIndex();
    
    /**
     * [̖{ݒ肷B<p>
     *
     * @param text [̖{
     */
    public void setBodyText(String text);
    
    /**
     * [̖{擾B<p>
     *
     * @return [̖{
     */
    public String getBodyText();
    
    /**
     * [̖{̕GR[fBOݒ肷B<p>
     *
     * @param encoding [̖{̕GR[fBO
     */
    public void setBodyEncoding(String encoding);
    
    /**
     * [̖{̕GR[fBO擾B<p>
     *
     * @return [̖{̕GR[fBO
     */
    public String getBodyEncoding();
    
    /**
     * SMTPT[õzXgݒ肷B<p>
     *
     * @param name SMTPT[õzXg
     */
    public void setSmtpHostName(String name);
    
    /**
     * SMTPT[õzXg擾B<p>
     *
     * @return SMTPT[õzXg
     */
    public String getSmtpHostName();
    
    /**
     * SMTPT[õ|[gԍݒ肷B<p>
     *
     * @param port SMTPT[õ|[gԍ
     */
    public void setSmtpPort(int port);
    
    /**
     * SMTPT[õ|[gԍ擾B<p>
     *
     * @return SMTPT[õ|[gԍ
     */
    public int getSmtpPort();
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.SmtpKeepAliveChecker SmtpKeepAliveChecker}I{@link jp.ossc.nimbus.service.distribute.KeepAliveCheckerSelector KeepAliveCheckerSelector}T[rX̃T[rXݒ肷B<p>
     *
     * @param name KeepAliveCheckerSelectorT[rX̃T[rX
     */
    public void setSmtpKeepAliveCheckerSelectorServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.SmtpKeepAliveChecker SmtpKeepAliveChecker}I{@link jp.ossc.nimbus.service.distribute.KeepAliveCheckerSelector KeepAliveCheckerSelector}T[rX̃T[rX擾B<p>
     *
     * @return KeepAliveCheckerSelectorT[rX̃T[rX
     */
    public ServiceName getSmtpKeepAliveCheckerSelectorServiceName();
    
    /**
     * [MgC񐔂ݒ肷B<p>
     *
     * @param count [MgC
     */
    public void setRetryCount(int count);
    
    /**
     * [MgC񐔂擾B<p>
     *
     * @return [MgC
     */
    public int getRetryCount();
    
    /**
     * [MgCԊu[ms]ݒ肷B<p>
     *
     * @param millis [MgCԊu[ms]
     */
    public void setRetryInterval(long millis);
    
    /**
     * [MgCԊu[ms]擾B<p>
     *
     * @return [MgCԊu[ms]
     */
    public long getRetryInterval();
    
    /**
     * javax.mail.SessionJNDIlookupۂɎgp{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JndiFinderT[rX̃T[rX
     */
    public void setJndiFinderServiceName(ServiceName name);
    
    /**
     * javax.mail.SessionJNDIlookupۂɎgp{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rX擾B<p>
     *
     * @return JndiFinderT[rX̃T[rX
     */
    public ServiceName getJndiFinderServiceName();
    
    /**
     * javax.mail.SessionJNDIlookupۂɎgpJNDIݒ肷B<p>
     *
     * @param name javax.mail.SessionJNDI
     */
    public void setMailSessionJndiName(String name);
    
    /**
     * javax.mail.SessionJNDIlookupۂɎgpJNDI擾B<p>
     *
     * @return javax.mail.SessionJNDI
     */
    public String getMailSessionJndiName();
}