/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.lang.IllegalArgumentException;

/**
 * K\Ro[^B<p>
 * 
 * @author Y.Yamashina
 */
public class PatternStringConverter
 implements StringConverter, java.io.Serializable{
    
    private static final long serialVersionUID = 9056240502325078689L;
    
    /**
     * ϊp^[zB<p>
     */
    protected Object[][] convertObjects;
    
    /**
     * }b`OtOB<p>
     */
    protected int matchingFlag = -1;
    
    /**
     * ̐K\Ro[^𐶐B<p>
     */
    public PatternStringConverter(){
    }
    
    /**
     * w肳ꂽ}b`tO̐K\Ro[^𐶐B<p>
     *
     * @param flags }b`tO
     */
    public PatternStringConverter(int flags){
        setMatchingFlag(flags);
    }
    
    /**
     * w肳ꂽ}b`tOƕϊp^[̐K\Ro[^𐶐B<p>
     *
     * @param fromStrs ϊΏېK\p^[z
     * @param toStrs ϊ㕶z
     */
    public PatternStringConverter(
        int flags,
        String[] fromStrs,
        String[] toStrs
    ){
        setMatchingFlag(flags);
        setConvertStrings(fromStrs, toStrs);
    }
    
    /**
     * K\̃}b`Os̃}b`tOݒ肷B<p>
     * }b`tOƂ́APattern.CASE_INSENSITIVEAPattern.MULTILINEAPattern.DOTALLAPattern.UNICODE_CASEAPattern.CANON_EQ Ȃǂ܂ރrbg}XNłB
     *
     * @param flags }b`tO
     */
    public void setMatchingFlag(int flags){
        // }b`OtOύXꂽꍇApatternč쐬
        if(matchingFlag != flags && convertObjects != null){
            for(int i = 0; i < convertObjects.length; i++){
                Pattern pattern = (Pattern)convertObjects[i][0];
                
                Pattern newPattern = null;
                if(flags != -1){
                    newPattern = Pattern.compile(pattern.pattern(), flags);
                } else {
                    newPattern = Pattern.compile(pattern.pattern());
                }
                convertObjects[i][0] = newPattern;
            }
        }
        matchingFlag = flags;
    }
    
    /**
     * K\̃}b`Os̃}b`tO擾B<p>
     *
     * @return }b`tO
     */
    public int getMatchingFlag(){
        return matchingFlag;
    }
    
    /**
     * ϊp^[ݒ肷B<p>
     *
     * @param fromStrs ϊΏېK\p^[z
     * @param toStrs ϊ㕶z
     */
    public void setConvertStrings(String[] fromStrs, String[] toStrs){
        if(toStrs == null && fromStrs == null){
            convertObjects = null;
        }else if((toStrs == null || fromStrs == null)
            || toStrs.length != fromStrs.length){
            throw new IllegalArgumentException("Invalid ConvertStrings.");
        }else{
            final Object[][] convObjs = new Object[toStrs.length][];
            try{
                for(int i = 0; i < toStrs.length; i++){
                    if(fromStrs[i] == null || toStrs[i] == null){
                        throw new IllegalArgumentException(
                            "Invalid ConvertStrings."
                        );
                    }
                    Pattern pattern = null;
                    if(matchingFlag!=-1) {
                    	pattern = Pattern.compile(fromStrs[i], matchingFlag);
                    } else {
                    	pattern = Pattern.compile(fromStrs[i]);
                    }
                    convObjs[i] = new Object[]{pattern, toStrs[i]};
                }
            }catch(PatternSyntaxException pe){
                //`ꂽ}b`tOɑΉȂrbgl flags ɐݒ肳ꂽꍇ
                throw new IllegalArgumentException("Invalid ConvertStrings.");
            }catch(IllegalArgumentException ie){
                //\̍\łꍇ
                throw new IllegalArgumentException("Invalid ConvertStrings.");
            }
            
            convertObjects = convObjs;
        }
    }
    
    // ConverterJavaDoc
    @Override
    public Object convert(Object obj) throws ConvertException{
        if(obj == null){
            return null;
        }else{
            return convert(
                (String)(obj instanceof String ? obj : String.valueOf(obj))
            );
        }
    }
    
    /**
     * ϊB<p>
     * ϊp^[zgĕϊB<br>
     *
     * @param str ϊΏۂ̕ 
     * @return ϊ̕
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public String convert(String str) throws ConvertException{
        String result = str;
        final Object[][] convObjects = convertObjects;
        
        if(convObjects != null){
            for(int i = 0; i < convObjects.length; i++){
                Pattern pattern = (Pattern)convObjects[i][0];
                
                Matcher matcher = pattern.matcher(result);
                result = matcher.replaceAll(Matcher.quoteReplacement((String)convObjects[i][1]));
            }
        }
        return result;
    }
}
