/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.validator;

/**
 * of[^ۃNXB<p>
 * 
 * @author M.Takata
 */
public abstract class AbstractStringValidator
 implements Validator, java.io.Serializable{
    
    private static final long serialVersionUID = -468946068283281754L;
    
    /**
     * nulle邩ǂ̃tOB<p>
     * truȅꍇAeBftHǵAtrueB<br>
     */
    protected boolean isAllowNull = true;
    
    /**
     * 󕶎e邩ǂ̃tOB<p>
     * truȅꍇAeBftHǵAfalseB<br>
     */
    protected boolean isAllowEmpty;
    
    /**
     * StringȊÕIuWFNge邩ǂ̃tOB<p>
     * truȅꍇAtoString()ŕɕϊČ؂BftHǵAfalseB<br>
     */
    protected boolean isAllowObject;
    
    /**
     * 󔒂g邩ǂ̃tOB<p>
     * truȅꍇAgČ؂BftHǵAfalseB<br>
     */
    protected boolean isTrim;
    
    /**
     * 󔒂gꍇ̋󔒕̔zB<p>
     * ݒ肳ĂȂꍇ́A{@link Character#isWhitespace(char)}gpB<br>
     */
    protected char[] whiteSpaceCharacters;
    
    /**
     * nulle邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     * 
     * @param isAllow truȅꍇAe
     */
    public void setAllowNull(boolean isAllow){
        isAllowNull = isAllow;
    }
    
    /**
     * nulle邩ǂ𔻒肷B<p>
     * 
     * @return eꍇAtrue
     */
    public boolean isAllowNull(){
        return isAllowNull;
    }
    
    /**
     * 󕶎e邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     * 
     * @param isAllow truȅꍇAe
     */
    public void setAllowEmpty(boolean isAllow){
        isAllowEmpty = isAllow;
    }
    
    /**
     * 󕶎e邩ǂ𔻒肷B<p>
     * 
     * @return eꍇAtrue
     */
    public boolean isAllowEmpty(){
        return isAllowEmpty;
    }
    
    /**
     * StringȊÕIuWFNge邩ǂݒ肷B<p>
     * truȅꍇAtoString()ŕɕϊČ؂B<br>
     * ftHǵAfalseB<br>
     *
     * @param isAllow truȅꍇAe
     */
    public void setAllowObject(boolean isAllow){
        isAllowObject = isAllow;
    }
    
    /**
     * StringȊÕIuWFNge邩ǂ𔻒肷B<p>
     *
     * @return eꍇAtrue
     */
    public boolean isAllowObject(){
        return isAllowObject;
    }
    
    /**
     * 󔒂g邩ǂݒ肷B<p>
     * truȅꍇAgČ؂B<br>
     * ftHǵAfalseB<br>
     *
     * @param trim truȅꍇAg
     */
    public void setTrim(boolean trim){
        isTrim = trim;
    }
    
    /**
     * 󔒂g邩ǂ𔻒肷B<p>
     *
     * @return gꍇAtrue
     */
    public boolean isTrim(){
        return isTrim;
    }
    
    /**
     * 󔒂gꍇ̋󔒕ݒ肷B<p>
     * ݒ肳ĂȂꍇ́A{@link Character#isWhitespace(char)}gpB<br>
     * 
     * @param chars 󔒂gꍇ̋󔒕z
     */
    public void setWhiteSpaceCharacters(char[] chars){
        whiteSpaceCharacters = chars;
    }
    
    /**
     * 󔒂gꍇ̋󔒕擾B<p>
     * 
     * @return 󔒂gꍇ̋󔒕z
     */
    public char[] getWhiteSpaceCharacters(){
        return whiteSpaceCharacters;
    }
    
    /**
     * w肳ꂽIuWFNg؂B<p>
     * null`FbNAStringǂ̃`FbNA󕶎`FbNʉ߂āA{@link #validateString(String)}ĂяoB<br>
     *
     * @param obj ؑΏۂ̃IuWFNg
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     * @see #validateString(String)
     */
    @Override
    public boolean validate(Object obj) throws ValidateException{
        if(obj == null){
            return isAllowNull;
        }
        String str = null;
        if(obj instanceof String){
            str = (String)obj;
        }else{
            if(!isAllowObject){
                return false;
            }
            str = obj.toString();
        }
        if(isTrim){
            str = trim(str);
        }
        if(str.length() == 0 && isAllowEmpty){
            return true;
        }
        return validateString(str);
    }
    
    /**
     * w肳ꂽ؂B<p>
     *
     * @param str ؑΏۂ̕
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    protected abstract boolean validateString(String str)
     throws ValidateException;
    
    /**
     * w肳ꂽ̑Ő󔒂gB<p>
     *
     * @param str gΏە
     * @return g̕
     */
    protected String trim(String str){
        String result = str;
        for(int i = 0, max = result.length(); i < max; i++){
            final char c = result.charAt(i);
            if(!isWhitespace(c)){
                result = result.substring(i);
                break;
            }
        }
        for(int i = result.length(); --i >= 0;){
            final char c = result.charAt(i);
            if(!isWhitespace(c)){
                result = result.substring(0, i + 1);
                break;
            }
        }
        return result;
    }
    
    /**
     * w肳ꂽ󔒂ǂ𔻒肷B<p>
     *
     * @param c Ώە
     * @return 󔒂̏ꍇAtrue
     */
    protected boolean isWhitespace(char c){
        if(whiteSpaceCharacters == null || whiteSpaceCharacters.length == 0){
            return Character.isWhitespace(c);
        }
        for(int i = 0; i < whiteSpaceCharacters.length; i++){
            if(c == whiteSpaceCharacters[i]){
                return true;
            }
        }
        return false;
    }
}