/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link FloatArrayEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class FloatArrayEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
            {"100", new Float[]{new Float("100")}},
            {"100,", new Float[]{new Float("100")}},
            {"100,200.1", new Float[]{new Float("100"), new Float("200.1")}},
            {" \t 100,    200.1\n    , 300.2  ", new Float[]{new Float("100"), new Float("200.1"), new Float("300.2")}},
            {"100,<!--  200.1\n  -->,300.2", new Float[]{new Float("100"), new Float("300.2")}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.FloatArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.FloatArrayEditor#getValue()",
                    "Normal"},
          dataProvider = "SetAsText")
  public void testSetText(String paramStr, Float[] answerArray){
        arrayEditorSetText(FloatArrayEditor.class, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
            {"test.FloatArrayEditor.value", "123.4", "100,${test.FloatArrayEditor.value}", new Float[]{new Float("100"),new Float("123.4")}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.FloatArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.FloatArrayEditor#getValue()",
                    "Normal"},
  dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Float[] answerArray){
        arrayEditorSetTextSystemProperty(FloatArrayEditor.class, propertyKeyStr, propertyValStr, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsValue")
    public Object[][] dataSetAsValue(){
        return new Object[][]{
            {new Float[]{new Float("100")}, "100.0"},
            {new Float[]{new Float("100"), new Float("200.1")}, "100.0,200.1"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.FloatArrayEditor#setAsValue(java.math.Float)",
                    "jp.ossc.nimbus.beans.FloatArrayEditor#getAsText()",
                    "Normal"},
  dataProvider = "SetAsValue")
    public void testSetValue(Float[] paramArray, String answerStr){
        arrayEditorSetValue(FloatArrayEditor.class, paramArray, answerStr);
    }
}
