/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.*;
import java.beans.*;
import java.io.*;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link ServiceName}z^PropertyEditorNXB<p>
 * "[T[rXo^}l[W]#[T[rX]"̕s؂ŕw肵{@link ServiceName}^̔zIuWFNgɕϊB<br>
 * ŏƍŌ̋󔒂ƉsŐ󔒂̓gB󔒂́A{@link java.lang.Character#isWhitespace(char)}Ŕ肳B܂A"&lt;!--""--&gt;"Ɉ͂܂ꂽ̓RgƉ߂ꖳB܂A"${""}"Ɉ͂܂ꂽ́ÃVXevpeBƒuB<br>
 * <p>
 * F<br>
 * &nbsp;&nbsp;Manager1#Service1<br>
 * &nbsp;&nbsp;#Service2<br>
 * &nbsp;&nbsp;&lt;!--Manager1#Service3--&gt;<br>
 * &nbsp;&nbsp;Service4<br>
 * <br>
 * ̂悤ȕ񂪁A{@link #setServiceManagerName(String)}"Manager2"Ɛݒ肵Ă΁A<br>
 * <br>
 * &nbsp;&nbsp;new ServiceName[]{<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;new ServiceName("Manager1", "Service1"),<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;new ServiceName("Manager2", "Service2"),<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;new ServiceName("Nimbus", "Service4")<br>
 * &nbsp;&nbsp;}<br>
 * <br>
 * ̂悤ɕϊB<br>
 * 񂩂T[rXւ̕ϊ@́A{@link ServiceNameEditor}QƁB
 *
 * @author M.Takata
 * @see ServiceNameEditor
 */
public class ServiceNameArrayEditor extends PropertyEditorSupport
 implements java.io.Serializable{
    
    private static final long serialVersionUID = 5748447494310773866L;
    
    private String managerName;
    
    /**
     * {@link jp.ossc.nimbus.core.ServiceManager ServiceManager}̖OȗĂT[rX{@link ServiceName}ɕϊꍇɁAgpServiceManager̖Oݒ肷B<p>
     *
     * @param name ServiceManager̖O
     */
    public void setServiceManagerName(String name){
        managerName = name;
    }
    
    /**
     * w肳ꂽ͂ăvpeBlݒ肷B<p>
     *
     * @param text ͂镶
     */
    @Override
    public void setAsText(String text){
        if(text == null){
            setValue(null);
            return;
        }
        final String tmpText = jp.ossc.nimbus.core.Utility.replaceSystemProperty(Utility.xmlComentOut(text), false);
        final int length = tmpText.length();
        final StringReader sr = new StringReader(tmpText);
        final BufferedReader br = new BufferedReader(sr, length);
        final List<ServiceName> list = new ArrayList<ServiceName>();
        final ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(managerName);
        try{
            String line = null;
            while((line = br.readLine()) != null){
                final String name = Utility.trim(line);
                if(name.length() == 0){
                    continue;
                }
                editor.setAsText(name);
                list.add((ServiceName)editor.getValue());
            }
        }catch(IOException e){
            // NȂ͂
            e.printStackTrace();
        }finally{
            try{
                br.close();
            }catch(IOException e){
                // NȂ͂
                e.printStackTrace();
            }
            sr.close();
        }
        setValue(list.toArray(new ServiceName[list.size()]));
    }
    
    /**
     * vpeB擾B<p>
     *
     * @return vpeB
     */
    @Override
    public String getAsText(){
        final ServiceName[] names = (ServiceName[])getValue();
        if(names == null){
            return null;
        }
        final StringWriter sw = new StringWriter();
        final PrintWriter writer = new PrintWriter(sw);
        for(int i = 0, max = names.length; i < max; i++){
            writer.print(names[i].toString());
            if(i != max - 1){
                writer.println();
            }
        }
        return sw.toString();
    }
}
