/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans.dataset;

import java.util.*;

/**
 * ėpIȃf[^W\BeanB<p>
 * {@link Header wb_[}ƁA{@link RecordList R[hXg}𖼑OƕRtĊǗB<br>
 * wb_[͕̃vpeBBeanŁAR[hXǵAwb_[Ɠlɕ̃vpeB{@link Record R[h}ƂBeanXgBeanłB<br>
 * wb_[AyуR[hXg̃R[h́Aǂ̂悤Beanɂ̂ivpeBA^ȂǁjR[hXL[}Œ`āAIBean鎖łB<br>
 * {@link RecordSchema R[hXL[}}́A{@link PropertySchema vpeBXL[}}̏WłA<br>
 * <pre>
 *   vpeBXL[}̎NX:vpeBXL[}`
 *   vpeBXL[}̎NX:vpeBXL[}`
 *                   :
 * </pre>
 * Ƃ悤ɁAvpeB̐s؂Œ`B<br>
 * ܂AvpeBXL[}̎NX͏ȗ\ŁAȗꍇ́A{@link DefaultPropertySchema}KpB<br>
 * ȉɃTvR[hB<br>
 * <pre>
 *     import jp.ossc.nimbus.beans.dataset.*;
 *     
 *     // f[^Zbg𐶐
 *     DataSet dataSet = new DataSet("sample");
 *     
 *     // f[^Zbg̃XL[}ȉ̂悤ɒ`
 *     // wb_F
 *     //   vpeB  ^
 *     //        A        java.lang.String
 *     //        B        long
 *     // 
 *     // R[hXgF
 *     //   vpeB  ^
 *     //        C        int
 *     //        D        java.lang.String
 *     //        E        java.lang.String
 *     dataSet.setSchema(
 *         ":A,java.lang.String\n"
 *             + ":B,long",
 *         ":C,int\n"
 *             + ":D,java.lang.String\n"
 *             + ":E,java.lang.String"
 *     );
 *     
 *     // wb_擾Ēlݒ肷
 *     Header header = dataSet.getHeader();
 *     header.setProperty("A", "hoge");
 *     header.setProperty("B", 100l);
 *     
 *     // R[hXg擾
 *     RecordList recordList = dataSet.getRecordList();
 *     // R[h1𐶐āAlݒ肷
 *     Record record1 = recordList.createRecord();
 *     record1.setProperty("C", 1);
 *     record1.setProperty("D", "hoge1");
 *     record1.setProperty("E", "fuga1");
 *     recordList.addRecord(record1);
 *     // R[h2𐶐āAlݒ肷
 *     Record record2 = recordList.createRecord();
 *     record2.setProperty("C", 2);
 *     record2.setProperty("D", "hoge2");
 *     record2.setProperty("E", "fuga2");
 *     recordList.addRecord(record2);
 * </pre>
 *
 * @author M.Takata
 */
public class DataSet implements java.io.Serializable, Cloneable{
    
    private static final long serialVersionUID = 452460154073106633L;
    
    /**
     * f[^Zbg̖OB<p>
     */
    protected String name;
    
    /**
     * wb_[̃}bvB<p>
     * L[̓wb_[Al{@link Header wb_[}
     */
    protected Map<String, Header> headerMap;
    
    /**
     * R[hXg̃}bvB<p>
     * L[̓R[hXgAl{@link RecordList R[hXg}
     */
    protected Map<String, RecordList> recordListMap;
    
    /**
     * lXgꂽR[hXg̃XL[}̃}bvB<p>
     * L[̓R[hXgAl̓R[hXL[}
     */
    protected transient Map<String, String> nestedRecordListMap;
    
    /**
     * lXgꂽR[h̃XL[}̃}bvB<p>
     * L[̓R[hAl{@link RecordSchema R[hXL[}}
     */
    protected transient Map<String, String> nestedRecordMap;
    
    /**
     * ̃f[^Zbg𐶐B<p>
     */
    public DataSet(){
    }
    
    /**
     * Ot̃f[^Zbg𐶐B<p>
     *
     * @param name O
     */
    public DataSet(String name){
        this.name = name;
    }
    
    /**
     * f[^Zbg擾B<p>
     *
     * @return f[^Zbg
     */
    public String getName(){
        return name;
    }
    
    /**
     * f[^Zbgݒ肷B<p>
     *
     * @param name f[^Zbg
     */
    public void setName(String name){
        this.name = name;
    }
    
    /**
     * OȂ{@link Header wb_[}̃XL[}ݒ肷B<p>
     * {@link #setHeaderSchema(String, String) setHeaderSchema(null, schema)}ĂяôƓB<br>
     *
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setHeaderSchema(String schema)
     throws PropertySchemaDefineException{
        setHeaderSchema(null, schema);
    }
    
    /**
     * w肵O{@link Header wb_[}𐶐B<p>
     *
     * @param name wb_[
     * @param schema XL[}
     * @return wb_[
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected Header createHeader(String name, String schema)
     throws PropertySchemaDefineException{
        return new Header(name, schema);
    }
    
    /**
     * w肵O{@link Header wb_[}𐶐B<p>
     *
     * @param name wb_[
     * @param schema XL[}
     * @return wb_[
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected Header createHeader(String name, RecordSchema schema)
     throws PropertySchemaDefineException{
        return new Header(name, schema);
    }
    
    /**
     * w肵O{@link Header wb_[}̃XL[}ݒ肷B<p>
     *
     * @param name wb_[
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setHeaderSchema(String name, String schema)
     throws PropertySchemaDefineException{
        if(headerMap == null){
            headerMap = Collections.<String, Header>synchronizedMap(new LinkedHashMap<String, Header>());
        }
        headerMap.put(name, createHeader(name, schema));
    }
    
    /**
     * OȂ{@link Header wb_[}̃XL[}ݒ肷B<p>
     * {@link #setHeaderSchema(String, RecordSchema) setHeaderSchema(null, schema)}ĂяôƓB<br>
     *
     * @param schema XL[}
     */
    public void setHeaderSchema(RecordSchema schema){
        setHeaderSchema(null, schema);
    }
    
    /**
     * w肵O{@link Header wb_[}̃XL[}ݒ肷B<p>
     *
     * @param name wb_[
     * @param schema XL[}
     */
    public void setHeaderSchema(String name, RecordSchema schema){
        if(headerMap == null){
            headerMap = Collections.<String, Header>synchronizedMap(new LinkedHashMap<String, Header>());
        }
        headerMap.put(name, createHeader(name, schema));
    }
    
    /**
     * OȂ{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     * {@link #setRecordListSchema(String, String) setRecordListSchema(null, schema)}ĂяôƓB<br>
     *
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setRecordListSchema(String schema)
     throws PropertySchemaDefineException{
        setRecordListSchema(null, schema);
    }
    
    /**
     * w肵O{@link RecordList R[hXg}𐶐B<p>
     *
     * @param name R[hXg
     * @param schema XL[}
     * @return R[hXg
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected RecordList createRecordList(String name, String schema)
     throws PropertySchemaDefineException{
        return new RecordList(name, schema);
    }
    
    /**
     * w肵O{@link RecordList R[hXg}𐶐B<p>
     *
     * @param name R[hXg
     * @param schema XL[}
     * @return R[hXg
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected RecordList createRecordList(String name, RecordSchema schema)
     throws PropertySchemaDefineException{
        return new RecordList(name, schema);
    }
    
    /**
     * w肵O{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     *
     * @param name R[hXg
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setRecordListSchema(String name, String schema)
     throws PropertySchemaDefineException{
        
        if(recordListMap == null){
            recordListMap = Collections.<String, RecordList>synchronizedMap(new LinkedHashMap<String, RecordList>());
        }
        recordListMap.put(
            name,
            createRecordList(name, schema)
        );
    }
    
    /**
     * OȂ{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     * {@link #setRecordListSchema(String, RecordSchema) setRecordListSchema(null, schema)}ĂяôƓB<br>
     *
     * @param schema XL[}
     */
    public void setRecordListSchema(RecordSchema schema){
        setRecordListSchema(null, schema);
    }
    
    /**
     * w肵O{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     *
     * @param name R[hXg
     * @param schema XL[}
     */
    public void setRecordListSchema(String name, RecordSchema schema){
        
        if(recordListMap == null){
            recordListMap = Collections.<String, RecordList>synchronizedMap(new LinkedHashMap<String, RecordList>());
        }
        recordListMap.put(
            name,
            createRecordList(name, schema)
        );
    }
    
    /**
     * w肵ÕlXg{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     *
     * @param name R[hXg
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setNestedRecordListSchema(String name, String schema)
     throws PropertySchemaDefineException{
        
        if(nestedRecordListMap == null){
            nestedRecordListMap = Collections.<String, String>synchronizedMap(new LinkedHashMap<String, String>());
        }
        RecordSchema recSchema = RecordSchema.getInstance(schema);
        nestedRecordListMap.put(
            name,
            recSchema.getSchema()
        );
    }
    
    /**
     * w肵ÕlXg{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     *
     * @param name R[hXg
     * @param schema XL[}
     */
    public void setNestedRecordListSchema(String name, RecordSchema schema){
        
        if(nestedRecordListMap == null){
            nestedRecordListMap = Collections.<String, String>synchronizedMap(new LinkedHashMap<String, String>());
        }
        nestedRecordListMap.put(
            name,
            schema.getSchema()
        );
    }
    
    /**
     * w肵ÕlXg{@link RecordList R[hXg}̃XL[}擾B<p>
     *
     * @param name R[hXg
     * @return XL[}
     */
    public RecordSchema getNestedRecordListSchema(String name)
     throws PropertySchemaDefineException{
        if(nestedRecordListMap == null){
            return null;
        }
        final String schema = nestedRecordListMap.get(name);
        return schema == null ? null : RecordSchema.getInstance(schema);
    }
    
    /**
     * `ꂽɕ񂾃lXgR[hXgz擾B<p>
     *
     * @return lXgR[hXgz
     */
    public String[] getNestedRecordListSchemaNames(){
        return nestedRecordListMap == null ? new String[0] : nestedRecordListMap.keySet().toArray(new String[nestedRecordListMap.size()]);
    }
    
    /**
     * lXgR[hXg̐擾B<p>
     *
     * @return lXgR[hXg̐
     */
    public int getNestedRecordListSchemaSize(){
        return nestedRecordListMap == null ? 0 : nestedRecordListMap.size();
    }
    
    /**
     * lXgR[hXg̃}bv擾B<p>
     *
     * @return lXgR[hXg̃}bvBL[̓R[hXgAl̓XL[}
     */
    public Map<String, String> getNestedRecordListSchemaMap(){
        if(nestedRecordListMap == null){
            nestedRecordListMap = Collections.<String, String>synchronizedMap(new LinkedHashMap<String, String>());
        }
        return nestedRecordListMap;
    }
    
    /**
     * w肵ÕlXg{@link Record R[h}̃XL[}ݒ肷B<p>
     *
     * @param name R[h
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setNestedRecordSchema(String name, String schema)
     throws PropertySchemaDefineException{
        
        if(nestedRecordMap == null){
            nestedRecordMap = Collections.synchronizedMap(new LinkedHashMap<String, String>());
        }
        RecordSchema recSchema = RecordSchema.getInstance(schema);
        nestedRecordMap.put(
            name,
            recSchema.getSchema()
        );
    }
    
    /**
     * w肵ÕlXg{@link Record R[h}̃XL[}ݒ肷B<p>
     *
     * @param name R[h
     * @param schema XL[}
     */
    public void setNestedRecordSchema(String name, RecordSchema schema){
        
        if(nestedRecordMap == null){
            nestedRecordMap = Collections.synchronizedMap(new LinkedHashMap<String, String>());
        }
        nestedRecordMap.put(
            name,
            schema.getSchema()
        );
    }
    
    /**
     * w肵ÕlXg{@link Record R[h}̃XL[}擾B<p>
     *
     * @param name R[h
     * @return XL[}
     */
    public RecordSchema getNestedRecordSchema(String name)
     throws PropertySchemaDefineException{
        if(nestedRecordMap == null){
            return null;
        }
        final String schema = nestedRecordMap.get(name);
        return schema == null ? null : RecordSchema.getInstance(schema);
    }
    
    /**
     * `ꂽɕ񂾃lXgR[hz擾B<p>
     *
     * @return lXgR[hz
     */
    public String[] getNestedRecordSchemaNames(){
        return nestedRecordMap == null ? new String[0] : nestedRecordMap.keySet().toArray(new String[nestedRecordMap.size()]);
    }
    
    /**
     * lXgR[h̐擾B<p>
     *
     * @return lXgR[h̐
     */
    public int getNestedRecordSchemaSize(){
        return nestedRecordMap == null ? 0 : nestedRecordMap.size();
    }
    
    /**
     * lXgR[h̃}bv擾B<p>
     *
     * @return lXgR[h̃}bvBL[̓R[hAl̓XL[}
     */
    public Map<String,String> getNestedRecordSchemaMap(){
        if(nestedRecordMap == null){
            nestedRecordMap = Collections.synchronizedMap(new LinkedHashMap<String, String>());
        }
        return nestedRecordMap;
    }
    
    /**
     * OȂ{@link Header wb_[}{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     * {@link #setHeaderSchema(String, String) setHeaderSchema(null, schema)}{@link #setRecordListSchema(String, String) setRecordListSchema(null, schema)}ĂяôƓB<br>
     *
     * @param headerSchema wb_[̃XL[}
     * @param recordListSchema R[hXg̃XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setSchema(String headerSchema, String recordListSchema)
     throws PropertySchemaDefineException{
        setSchema(null, headerSchema, recordListSchema);
    }
    
    /**
     * w肵O{@link Header wb_[}{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     *
     * @param name wb_[yуR[hXg
     * @param headerSchema wb_[̃XL[}
     * @param recordListSchema R[hXg̃XL[}
     */
    public void setSchema(
        String name,
        RecordSchema headerSchema,
        RecordSchema recordListSchema
    ){
        if(headerSchema != null){
            setHeaderSchema(name, headerSchema);
        }
        if(recordListSchema != null){
            setRecordListSchema(name, recordListSchema);
        }
    }
    
    /**
     * OȂ{@link Header wb_[}{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     * {@link #setHeaderSchema(String, RecordSchema) setHeaderSchema(null, schema)}{@link #setRecordListSchema(String, RecordSchema) setRecordListSchema(null, schema)}ĂяôƓB<br>
     *
     * @param headerSchema wb_[̃XL[}
     * @param recordListSchema R[hXg̃XL[}
     */
    public void setSchema(RecordSchema headerSchema, RecordSchema recordListSchema){
        setSchema(null, headerSchema, recordListSchema);
    }
    
    /**
     * w肵O{@link Header wb_[}{@link RecordList R[hXg}̃XL[}ݒ肷B<p>
     *
     * @param name wb_[yуR[hXg
     * @param headerSchema wb_[̃XL[}
     * @param recordListSchema R[hXg̃XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setSchema(
        String name,
        String headerSchema,
        String recordListSchema
    ) throws PropertySchemaDefineException{
        if(headerSchema != null){
            setHeaderSchema(name, headerSchema);
        }
        if(recordListSchema != null){
            setRecordListSchema(name, recordListSchema);
        }
    }
    
    /**
     * OȂ{@link Header wb_[}擾B<p>
     * {@link #getHeader(String) getHeader(null)}ĂяôƓB<br>
     *
     * @return wb_[
     */
    public Header getHeader(){
        return getHeader(null);
    }
    
    /**
     * w肵O{@link Header wb_[}擾B<p>
     *
     * @param name wb_[
     * @return wb_[
     */
    public Header getHeader(String name){
        return headerMap == null ? null : headerMap.get(name);
    }
    
    /**
     * `ꂽɕ񂾃wb_[z擾B<p>
     *
     * @return wb_[z
     */
    public String[] getHeaderNames(){
        return headerMap == null ? new String[0] : headerMap.keySet().toArray(new String[headerMap.size()]);
    }
    
    /**
     * wb_[̐擾B<p>
     *
     * @return wb_[̐
     */
    public int getHeaderSize(){
        return headerMap == null ? 0 : headerMap.size();
    }
    
    /**
     * wb_[̃}bv擾B<p>
     *
     * @return wb_[̃}bvBL[̓wb_[Al{@link Header wb_[}
     */
    public Map<String, Header> getHeaderMap(){
        if(headerMap == null){
            headerMap = Collections.<String, Header>synchronizedMap(new LinkedHashMap<String, Header>());
        }
        return headerMap;
    }
    
    /**
     * wb_[ǉB<p>
     *
     * @param header wb_[
     */
    public void addHeader(Header header){
        if(headerMap == null){
            headerMap = Collections.<String, Header>synchronizedMap(new LinkedHashMap<String, Header>());
        }
        headerMap.put(header.getName(), header);
    }
    
    /**
     * OȂ{@link RecordList R[hXg}擾B<p>
     * {@link #getRecordList(String) getRecordList(null)}ĂяôƓB<br>
     *
     * @return R[hXg
     */
    public RecordList getRecordList(){
        return getRecordList(null);
    }
    
    /**
     * w肵O{@link RecordList R[hXg}擾B<p>
     *
     * @param name R[hXg
     * @return R[hXg
     */
    public RecordList getRecordList(String name){
        return recordListMap == null ? null : recordListMap.get(name);
    }
    
    /**
     * `ꂽɕ񂾃R[hXgz擾B<p>
     *
     * @return R[hXgz
     */
    public String[] getRecordListNames(){
        return recordListMap == null ? new String[0] : recordListMap.keySet().toArray(new String[recordListMap.size()]);
    }
    
    /**
     * R[hXg̐擾B<p>
     *
     * @return R[hXg̐
     */
    public int getRecordListSize(){
        return recordListMap == null ? 0 : recordListMap.size();
    }
    
    /**
     * R[hXg̃}bv擾B<p>
     *
     * @return R[hXg̃}bvBL[̓R[hXgAl{@link RecordList R[hXg}
     */
    public Map<String, RecordList> getRecordListMap(){
        if(recordListMap == null){
            recordListMap = Collections.<String, RecordList>synchronizedMap(new LinkedHashMap<String, RecordList>());
        }
        return recordListMap;
    }
    
    /**
     * R[hXgǉB<p>
     *
     * @param recList R[hXg
     */
    public void addRecordList(RecordList recList){
        if(recordListMap == null){
            recordListMap = Collections.<String, RecordList>synchronizedMap(new LinkedHashMap<String, RecordList>());
        }
        recordListMap.put(recList.getName(), recList);
    }
    
    /**
     * w肵ÕlXg{@link RecordList R[hXg}𐶐B<p>
     *
     * @param name R[hXg
     * @return R[hXg
     */
    public RecordList createNestedRecordList(String name){
        if(nestedRecordListMap == null
             || !nestedRecordListMap.containsKey(name)){
            return null;
        }
        return createRecordList(
            name,
            RecordSchema.getInstance(nestedRecordListMap.get(name))
        );
    }
    
    /**
     * w肵ÕlXg{@link Record R[h}𐶐B<p>
     *
     * @param name R[h
     * @return R[h
     */
    public Record createNestedRecord(String name){
        if(nestedRecordMap == null
             || !nestedRecordMap.containsKey(name)){
            return null;
        }
        return new Record(
            RecordSchema.getInstance(nestedRecordMap.get(name))
        );
    }
    
    /**
     * f[^ZbgNAB<p>
     * wb_[̃f[^ƃR[hXg̃R[h폜B<br>
     */
    public void clear(){
        if(headerMap != null && headerMap.size() != 0){
            final String[] headerNames = headerMap.keySet()
                .toArray(new String[headerMap.size()]);
            for(String headerName : headerNames){
                final Header header = getHeader(headerName);
                if(header != null){
                    header.clear();
                }
            }
        }
        if(recordListMap != null && recordListMap.size() != 0){
            final String[] recListNames = recordListMap.keySet()
                .toArray(new String[recordListMap.size()]);
            for(String recListName : recListNames){
                final RecordList recList = getRecordList(recListName);
                if(recList != null){
                    recList.clear();
                }
            }
        }
    }
    
    /**
     * OȂ{@link Header wb_[}؂B<p>
     *
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validateHeader() throws PropertyGetException, PropertyValidateException{
        Header header = getHeader();
        if(header == null){
            return false;
        }
        return header.validate();
    }
    
    /**
     * w肳ꂽ{@link Header wb_[}؂B<p>
     *
     * @param name wb_[
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validateHeader(String name) throws PropertyGetException, PropertyValidateException{
        Header header = getHeader(name);
        if(header == null){
            return false;
        }
        return header.validate();
    }
    
    /**
     * SĂ{@link Header wb_[}؂B<p>
     *
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validateHeaders() throws PropertyGetException, PropertyValidateException{
        if(headerMap == null || headerMap.size() == 0){
            return true;
        }
        Iterator<Header> headers = headerMap.values().iterator();
        while(headers.hasNext()){
            Header header = headers.next();
            if(!header.validate()){
                return false;
            }
        }
        return true;
    }
    
    /**
     * OȂ{@link RecordList R[hXg}؂B<p>
     *
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validateRecordList() throws PropertyGetException, PropertyValidateException{
        RecordList recordList = getRecordList();
        if(recordList == null){
            return false;
        }
        return recordList.validate();
    }
    
    /**
     * w肳ꂽ{@link RecordList R[hXg}؂B<p>
     *
     * @param name wb_[
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validateRecordList(String name) throws PropertyGetException, PropertyValidateException{
        RecordList recordList = getRecordList(name);
        if(recordList == null){
            return false;
        }
        return recordList.validate();
    }
    
    /**
     * SĂ{@link RecordList R[hXg}؂B<p>
     *
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validateRecordLists() throws PropertyGetException, PropertyValidateException{
        if(recordListMap == null || recordListMap.size() == 0){
            return true;
        }
        Iterator<RecordList> recordLists = recordListMap.values().iterator();
        while(recordLists.hasNext()){
            RecordList recordList = recordLists.next();
            if(!recordList.validate()){
                return false;
            }
        }
        return true;
    }
    
    /**
     * SĂ{@link Header wb_[}y{@link RecordList R[hXg}؂B<p>
     *
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validate() throws PropertyGetException, PropertyValidateException{
        if(!validateHeaders()){
            return false;
        }
        if(!validateRecordLists()){
            return false;
        }
        return true;
    }
    
    /**
     * f[^Zbg𕡐B<p>
     *
     * @return f[^Zbg
     */
    public Object clone(){
        return cloneDataSet();
    }
    
    /**
     * XL[}f[^Ȃ̃f[^Zbg𕡐B<p>
     *
     * @return ̃f[^Zbg
     */
    public DataSet cloneSchema(){
        return cloneDataSet(false);
    }
    
    /**
     * f[^Zbg𕡐B<p>
     *
     * @return f[^Zbg
     */
    public DataSet cloneDataSet(){
        return cloneDataSet(true);
    }
    
    /**
     * f[^Zbg𕡐B<p>
     *
     * @param hasData f[^ꍇtrue
     * @return f[^Zbg
     */
    protected DataSet cloneDataSet(boolean hasData){
        DataSet dataSet = null;
        try{
            dataSet = (DataSet)super.clone();
            dataSet.headerMap = null;
            dataSet.recordListMap = null;
            dataSet.nestedRecordListMap = null;
            dataSet.nestedRecordMap = null;
        }catch(CloneNotSupportedException e){
            return null;
        }
        if(headerMap != null && headerMap.size() != 0){
            final String[] headerNames = headerMap.keySet()
                .toArray(new String[headerMap.size()]);
            dataSet.headerMap
                 = Collections.<String, Header>synchronizedMap(new LinkedHashMap<String, Header>());
            for(String headerName : headerNames){
                final Header header = getHeader(headerName);
                if(header != null){
                    dataSet.headerMap.put(
                        headerName,
                        hasData ? (Header)header.cloneRecord() : (Header)header.cloneSchema()
                    );
                }
            }
        }
        if(recordListMap != null && recordListMap.size() != 0){
            final String[] recListNames = recordListMap.keySet()
                .toArray(new String[recordListMap.size()]);
            dataSet.recordListMap
                 = Collections.<String, RecordList>synchronizedMap(new LinkedHashMap<String, RecordList>());
            for(String recListName : recListNames){
                final RecordList recList = getRecordList(recListName);
                if(recList != null){
                    dataSet.recordListMap.put(
                        recListName,
                        hasData ? recList.cloneRecordList()
                             : recList.cloneSchema()
                    );
                }
            }
        }
        if(nestedRecordListMap != null && nestedRecordListMap.size() != 0){
            dataSet.nestedRecordListMap
                 = Collections.<String, String>synchronizedMap(new LinkedHashMap<String, String>());
            dataSet.nestedRecordListMap.putAll(nestedRecordListMap);
        }
        if(nestedRecordMap != null && nestedRecordMap.size() != 0){
            dataSet.nestedRecordMap
                 = Collections.synchronizedMap(new LinkedHashMap<String, String>());
            dataSet.nestedRecordMap.putAll(nestedRecordMap);
        }
        return dataSet;
    }
    
    /**
     * ̃f[^Zbg̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        return super.toString() + "{name=" + name + '}';
    }
}