/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

/**
 * t@NgT[rXC^tF[XB<p>
 * T[rX񋟂IuWFNg𐶐t@NgC^tF[XłB<p>
 * {@link Service}́ACX^XP{@link ServiceManager}ɓo^āÃIuWFNgP̃CX^XQƂĎgT[rX`邽߂̃C^tF[XłB<br>
 * ɑ΂āÃC^tF[X́ACX^XPServiceManagerɓo^Ƃ͓ł邪AT[rXsIuWFNǵAServiceManager擾鎞ɁA{@link #newInstance()}ɂĖ񐶐ʂ̃IuWFNgƂȂB]āAT[rXǵAꂼقȂIuWFNggp鎖ɂȂB<br>
 * ́AႦ΁AT[rX`͂PŁA̎̂ƂȂT[rX͕gpꍇȂǂɗpB<br>
 * <p>
 * ̃t@NgɂĐꂽIuWFNǵAT[rXƂēo^ȂB]āÂ܂܂ł͂PxĂ܂IuWFNǵÃt@Ng؂藣邽߁Ãt@Ng̑ύXĂAf邱Ƃ͂ȂB<br>
 * AꍇɂẮÃt@Ng̑ς鎖ŁAɐꂽIuWFNg̑ςꍇB̃t@NǵAIuWFNgǗ@\A{@link #setManagement(boolean)}ɂĂ̋@\ON/OFF𐧌\łB<br>
 * AAӂKvȂ̂́AsetManagement(true)ɂāAIuWFNǵÃt@NgŊǗ邽߁AgĝĂĂÃt@NgT[rXjȂAKx[WȂB<br>
 * ]āAt@NgɊǗꂽIuWFNgǵAĝĂŎgpׂł͂ȂBĝĂŎgpꍇ́AsetManagement(false)ɂāAǗȂIuWFNgƂĎgpׂłB<br>
 * 
 * @author M.Takata
 * @see Service
 */
public interface FactoryService<T>{
    
    /**
     * ̃t@NgIuWFNgǗ邩ǂݒ肷B<p>
     * trueɂꍇǍÃt@NgɂĐIuWFNǵÃt@Ng̊ǗɒuBǗĂIuWFNǵÃt@Ng̑̕ύX𔽉fBiǂ̂悤ȑǗ邩́AɈˑĵ߁Ãt@NgQƂێ̂ŁAgQƂ̂ĂĂAKx[WȂB̃t@NgAjꂽꍇɂ́AǗĂIuWFNg̎QƂjB<br>
     * falseɂꍇǍÃt@NgɂĐIuWFNǵÃt@Ng̊ǗɒuȂBǗĂȂIuWFNǵÃt@Ng̑̕ύX𔽉fȂB̂߁Ãt@NgQƂێ邱Ƃ͂Ȃ̂ŁAgQƂ̂ĂƁAKx[W̑ΏۂɂȂB<br>
     *
     * @param isManaged ǗꍇtrueAǗȂꍇfalse
     * @see #isManagement()
     */
    public void setManagement(boolean isManaged);
    
    /**
     * ̃t@NgɂāǍɐIuWFNgAǗ邩ǂ𒲂ׂB<b>
     *
     * @return ǗꍇtrueAǗȂꍇfalse
     * @see #setManagement(boolean)
     */
    public boolean isManagement();
    
    /**
     * ̃t@NgIuWFNgXbhPʂɐ邩ǂݒ肷B<p>
     * ftHgfalseB
     *
     * @param isThreadLocal ǗꍇtrueAǗȂꍇfalse
     * @see #isThreadLocal()
     */
    public void setThreadLocal(boolean isThreadLocal);
    
    /**
     * ̃t@NgIuWFNgXbhPʂɐ邩ǂ𒲂ׂB<b>
     *
     * @return XbhPʂɐꍇtrueAXbhPʂɐȂꍇfalse
     * @see #setThreadLocal(boolean)
     */
    public boolean isThreadLocal();
    
    /**
     * ̃t@NgǗĂIuWFNgjB<p>
     *
     * @param service jT[rXIuWFNg
     */
    public void release(Object service);
    
    /**
     * ̃t@NgǗĂIuWFNgSĔjB<p>
     */
    public void release();
    
    /**
     * T[rX񋟂IuWFNg𐶐B<p>
     * {@link #isManagement()}truȅԂŁÃ\bhĂяoƁAIuWFNǵÃt@NgɂĊǗAt@Ng̑ύXfB<br>
     * isManagement()falsȅԂŁÃ\bhĂяoƁAIuWFNǵÃt@NgɂĊǗȂ߁At@Ng̑ύX͔fȂBĝẴIuWFNgłB<br>
     *
     * @return T[rX񋟂IuWFNg
     * @see #setManagement(boolean)
     */
    public T newInstance();
}