/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import org.w3c.dom.*;

/**
 * vpeBGfB^&lt;property-editor&gt;vf^f[^B<p>
 * T[rX`t@C&lt;property-editor&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class PropertyEditorMetaData extends MetaData
 implements Serializable{
    
    private static final long serialVersionUID = -3886753647250989241L;
    
    /**
     * &lt;nimbus&gt;vf̎qvf&lt;property-editor&gt;vf̗vfB<p>
     */
    public static final String PROPERTY_EDITOR_TAG_NAME = "property-editor";
    
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    
    protected String type;
    
    protected String editor;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public PropertyEditorMetaData(MetaData parent){
        super(parent);
    }
    
    /**
     * &lt;property-editor&gt;vftype̒l擾B<p>
     * 
     * @return type̒l
     */
    public String getType(){
        return type;
    }
    
    /**
     * &lt;property-editor&gt;vftype̒lݒ肷B<p>
     * 
     * @param type type̒l
     */
    public void setType(String type){
        this.type = type;
    }
    
    /**
     * &lt;property-editor&gt;vf̓e̒l擾B<p>
     * 
     * @return PropertyEditor̃NX
     */
    public String getEditor(){
        return editor;
    }
    
    /**
     * &lt;property-editor&gt;vf̓e̒lݒ肷B<p>
     * 
     * @param editor PropertyEditor̃NX
     */
    public void setEditor(String editor){
        this.editor = editor;
    }
    
    /**
     * &lt;property-editor&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;property-editor&gt;vfElement
     * @exception DeploymentException &lt;property-editor&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        if(!element.getTagName().equals(PROPERTY_EDITOR_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + PROPERTY_EDITOR_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
        type = getUniqueAttribute(element, TYPE_ATTRIBUTE_NAME);
        if(type.length() == 0){
            throw new DeploymentException(
                "Element of " + PROPERTY_EDITOR_TAG_NAME + " must have valid " + TYPE_ATTRIBUTE_NAME + " attribute."
            );
        }
        editor = getElementContent(element);
        if(editor == null){
            throw new DeploymentException("Contents of " + PROPERTY_EDITOR_TAG_NAME + " element is null.");
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(PROPERTY_EDITOR_TAG_NAME)
           .append(" type=\"").append(type)
           .append("\">");
        if(editor != null){
            buf.append(editor);
        }
        buf.append("</").append(PROPERTY_EDITOR_TAG_NAME).append('>');
        return buf;
    }
}