/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.util.*;

import jp.ossc.nimbus.service.log.*;
import jp.ossc.nimbus.service.message.*;

/**
 * T[rXNXB<p>
 * {@link ServiceManager}ŊǗA\ȃT[rX̊NXłB<br>
 * T[rX̊J҂́AʏÃNXpāAT[rXB<br>
 * <pre>
 *   public class MyService extends ServiceBase{
 *             F
 * </pre>
 * ̃NX̃TuNX́AServiceManagerɂāAi{@link #create()}jANi{@link #start()}jA~i{@link #stop()}jApi{@link #destroy()}ǰ_@𐧌䂷鎖\łBꂼ̓̃\bhicreate()Astart()Astop()Adestroy()jɂ́AsĂ̂ŁAʏ́AI[o[ChĂ͂ȂB̃NXgăT[rX̐̎sɂ́A{@link #createService()}A{@link #startService()}A{@link #stopService()}A{@link #destroyService()}AƂȂĂ̂ŁAKvɉăI[o[Ch邱ƁB<br>
 * <pre>
 *   public class MyService extends ServiceBase{
 *             F
 *       public void createService() throws Exception{
 *                 F
 *       }
 *       public void startService() throws Exception{
 *                 F
 *       }
 *       public void stopService() throws Exception{
 *                 F
 *       }
 *       public void destroyService() throws Exception{
 *                 F
 *       }
 *             F
 * </pre>
 * create()Astart()Astop()Adestroy()̂S̓̎ŁAԂ̐䂪sĂB܂Acreate()ł́A{@link #setServiceManagerName(String)}Őݒ肳ꂽServiceManagerɁA{@link #setServiceName(String)}Őݒ肳ꂽOŎgo^BlɁAdestroy()ł́AServiceManager玩go^B<br>
 * 
 * @author M.Takata
 * @see ServiceManager
 */
public abstract class ServiceBase
 implements ServiceBaseMBean, ServiceProxy,
            ServiceStateListenable, Serializable{
    
    private static final long serialVersionUID = -2021965433743797247L;
    
    // bZ[WID`
    private static final String SVC__ = "SVC__";
    private static final String SVC__0 = SVC__ + 0;
    private static final String SVC__00 = SVC__0 + 0;
    private static final String SVC__000 = SVC__00 + 0;
    private static final String SVC__0000 = SVC__000 + 0;
    private static final String SVC__00001 = SVC__0000 + 1;
    private static final String SVC__00002 = SVC__0000 + 2;
    private static final String SVC__00003 = SVC__0000 + 3;
    private static final String SVC__00004 = SVC__0000 + 4;
    private static final String SVC__00005 = SVC__0000 + 5;
    private static final String SVC__00006 = SVC__0000 + 6;
    private static final String SVC__00007 = SVC__0000 + 7;
    private static final String SVC__00008 = SVC__0000 + 8;
    private static final String SVC__00009 = SVC__0000 + 9;
    private static final String SVC__00010 = SVC__000 + 10;
    private static final String SVC__00011 = SVC__000 + 11;
    private static final String SVC__00012 = SVC__000 + 12;
    private static final String SVC__00013 = SVC__000 + 13;
    private static final String SVC__00014 = SVC__000 + 14;
    private static final String SVC__00015 = SVC__000 + 15;
    private static final String SVC__00016 = SVC__000 + 16;
    private static final String SVC__00017 = SVC__000 + 17;
    private static final String SVC__00018 = SVC__000 + 18;
    private static final String SVC__00019 = SVC__000 + 19;
    private static final String SVC__00020 = SVC__000 + 20;
    private static final String SVC__00021 = SVC__000 + 21;
    private static final String SVC__00022 = SVC__000 + 22;
    private static final String SVC__00023 = SVC__000 + 23;
    private static final String SVC__00024 = SVC__000 + 24;
    private static final String SVC__00025 = SVC__000 + 25;
    private static final String SVC__00026 = SVC__000 + 26;
    private static final String SVC__00027 = SVC__000 + 27;
    private static final String SVC__00028 = SVC__000 + 28;
    private static final String SVC__00029 = SVC__000 + 29;
    private static final String SVC__00030 = SVC__000 + 30;
    private static final String SVC__00031 = SVC__000 + 31;
    private static final String SVC__00032 = SVC__000 + 32;
    private static final String SVC__00033 = SVC__000 + 33;
    private static final String SVC__00034 = SVC__000 + 34;
    private static final String SVC__00035 = SVC__000 + 35;
    private static final String SVC__00036 = SVC__000 + 36;
    private static final String SVC__00037 = SVC__000 + 37;
    private static final String SVC__00038 = SVC__000 + 38;
    private static final String SVC__00039 = SVC__000 + 39;
    private static final String SVC__00040 = SVC__000 + 40;
    private static final String SVC__00041 = SVC__000 + 41;
    private static final String SVC__00042 = SVC__000 + 42;
    private static final String SVC__00043 = SVC__000 + 43;
    private static final String SVC__00044 = SVC__000 + 44;
    private static final String SVC__00045 = SVC__000 + 45;
    private static final String SVC__00046 = SVC__000 + 46;
    private static final String SVC__00047 = SVC__000 + 47;
    private static final String SVC__00048 = SVC__000 + 48;
    private static final String SVC__00049 = SVC__000 + 49;
    private static final String SVC__00050 = SVC__000 + 50;
    private static final String SVC__00051 = SVC__000 + 51;
    private static final String SVC__00052 = SVC__000 + 52;
    private static final String SVC__00053 = SVC__000 + 53;
    private static final String SVC__00054 = SVC__000 + 54;
    private static final String SVC__00055 = SVC__000 + 55;
    private static final String SVC__00056 = SVC__000 + 56;
    private static final String SVC__00057 = SVC__000 + 57;
    private static final String SVC__00058 = SVC__000 + 58;
    private static final String SVC__00059 = SVC__000 + 59;
    private static final String SVC__00060 = SVC__000 + 60;
    private static final String SVC__00061 = SVC__000 + 61;
    private static final String SVC__00062 = SVC__000 + 62;
    private static final String SVC__00063 = SVC__000 + 63;
    private static final String SVC__00064 = SVC__000 + 64;
    private static final String SVC__00065 = SVC__000 + 65;
    private static final String SVC__00066 = SVC__000 + 66;
    private static final String SVC__00067 = SVC__000 + 67;
    private static final String SVC__00068 = SVC__000 + 68;
    private static final String SVC__00069 = SVC__000 + 69;
    private static final String SVC__00070 = SVC__000 + 70;
    private static final String SVC__00071 = SVC__000 + 71;
    private static final String SVC__00072 = SVC__000 + 72;
    private static final String SVC__00073 = SVC__000 + 73;
    private static final String SVC__00074 = SVC__000 + 74;
    private static final String SVC__00075 = SVC__000 + 75;
    private static final String SVC__00076 = SVC__000 + 76;
    private static final String SVC__00077 = SVC__000 + 77;
    private static final String SVC__00078 = SVC__000 + 78;
    private static final String SVC__00079 = SVC__000 + 79;
    private static final String SVC__00080 = SVC__000 + 80;
    private static final String SVC__00081 = SVC__000 + 81;
    private static final String SVC__00082 = SVC__000 + 82;
    private static final String SVC__00083 = SVC__000 + 83;
    private static final String SVC__00084 = SVC__000 + 84;
    private static final String SVC__00085 = SVC__000 + 85;
    private static final String SVC__00086 = SVC__000 + 86;
    private static final String SVC__00087 = SVC__000 + 87;
    private static final String SVC__00088 = SVC__000 + 88;
    
    /**
     * T[rX̏Ԃ\lB<p>
     * ĺA{@link #State.DESTROYED}łB
     * 
     * @see #getState()
     */
    protected volatile State state = State.DESTROYED;
    
    /**
     * T[rX̖OB<p>
     *
     * @see #setServiceName(String)
     * @see #getServiceName()
     */
    protected String name;
    
    /**
     * T[rX̖OB<p>
     *
     * @see #getServiceNameObject()
     */
    protected ServiceName nameObj;
    
    /**
     * ̃T[rXo^ServiceManagerB<p>
     */
    protected transient ServiceManager manager;
    
    /**
     * ̃T[rXo^ServiceManager̃T[rXB<p>
     *
     * @see #setServiceManagerName(String)
     * @see #getServiceManagerName()
     */
    protected String managerName;
    
    /**
     * bv{@link ServiceBaseSupport}IuWFNgB<p>
     * ServiceBaseSupportC^tF[XIuWFNgRXgN^̈ɓnŁÃNXpȂĂÃNX̎𗘗pł悤ɂ邽߂̂́B
     */
    protected ServiceBaseSupport support;
    
    /**
     * ̃T[rXɓo^ꂽT[rXԃXĩXgB<p>
     * 
     * @see #addServiceStateListener(ServiceStateListener)
     * @see #removeServiceStateListener(ServiceStateListener)
     */
    protected transient List<ServiceStateListener> serviceStateListeners = Collections.<ServiceStateListener>synchronizedList(new ArrayList<ServiceStateListener>());
    
    /**
     * ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX̖OB<p>
     * 
     * @see #getSystemLoggerServiceName()
     * @see #setSystemLoggerServiceName(ServiceName)
     */
    protected ServiceName loggerServiceName;
    
    /**
     * ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rXB<p>
     */
    protected transient LoggerWrapper logger
         = new LoggerWrapper(ServiceManagerFactory.getLogger());
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX̖OB<p>
     * 
     * @see #getSystemMessageRecordFactoryServiceName()
     * @see #setSystemMessageRecordFactoryServiceName(ServiceName)
     */
    protected ServiceName messageServiceName;
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rXB<p>
     */
    protected transient MessageRecordFactoryWrapper message
         = new MessageRecordFactoryWrapper(
            ServiceManagerFactory.getMessageRecordFactory()
         );
    
    /**
     * RXgN^B<p>
     */
    public ServiceBase(){
    }
    
    /**
     * {@link ServiceBaseSupport}C^tF[XT[rXNXbvāAServiceBase̎𗘗pł悤ɂ邽߂̃RXgN^B<p>
     * 
     * @param support ServiceBaseSupportC^tF[XNX̃CX^X
     */
    protected ServiceBase(ServiceBaseSupport support){
        this();
        this.support = support;
        if(support != null){
            support.setServiceBase(this);
        }
    }
    
    /**
     * ̃T[rXǗ{@link ServiceManager}ݒ肷B<p>
     * ServiceManagerCX^XϐɊi[ƓɁA{@link ServiceManager#getLogger()}Ŏ擾{@link Logger}ÃT[rX̎{@link LoggerWrapper}̃ftHgLoggerɐݒ肷B܂A{@link #setSystemLoggerServiceName(ServiceName)}LoggerT[rXݒ肳ĂȂꍇ́ALoggerWrapper̃JgLoggerɂݒ肷B<br>
     *
     * @param mng ̃T[rXǗServiceManager
     */
    protected void setServiceManager(ServiceManager mng){
        if(manager != null && manager.equals(mng)){
            return;
        }
        manager = mng;
        if(manager != null){
            if(manager.getServiceName() != null
                    && !manager.getServiceName().equals(getServiceManagerName())){
                setServiceManagerName(manager.getServiceName());
            }
            if(loggerServiceName == null){
                logger.setLogger(manager.getLogger());
            }
            if(messageServiceName == null){
                message.setMessageRecordFactory(
                    manager.getMessageRecordFactory()
                );
            }
        }
    }
    
    /**
     * ̃T[rXǗ{@link ServiceManager}擾B<p>
     * 
     * @return ̃T[rXǗServiceManager
     */
    public ServiceManager getServiceManager(){
        return manager;
    }
    
    /**
     * T[rX𐶐B<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>{@link #isNecessaryToCreate()}̌ĂяoB߂lfalsȅꍇ́A𒆎~B</li>
     *   <li>{@link #preCreateService()}̌ĂяoBOꍇ́A{@link Service.State#FAILED}ɑJڂB</li>
     *   <li>{@link #createService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     *   <li>{@link #postCreateService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     * </ol>
     *
     * @exception Exception preCreateService()AcreateService()ApostCreateService()ŗOꍇ
     * @see #isNecessaryToCreate()
     * @see #preCreateService()
     * @see #createService()
     * @see #postCreateService()
     */
    @Override
    public synchronized void create() throws Exception{
        
        if(manager == null && managerName != null){
            setServiceManager(ServiceManagerFactory.findManager(managerName));
        }
        
        if(managerName != null){
            logger.write(SVC__00001, managerName, name);
        }else{
            if(name == null){
                setServiceName(toString());
            }
            logger.write(SVC__00002, name);
        }
        
        try{
            if(!isNecessaryToCreate()){
                if(managerName != null){
                    logger.write(
                        SVC__00003,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00004,
                        name, getState()
                    );
                }
                return;
            }
            
            if(managerName != null){
                logger.write(SVC__00005, managerName, name);
            }else{
                logger.write(SVC__00006, name);
            }
            preCreateService();
            if(managerName != null){
                logger.write(SVC__00007, managerName, name);
            }else{
                logger.write(SVC__00008, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00009, managerName, name);
            }else{
                logger.write(SVC__00010, name);
            }
            createService();
            if(managerName != null){
                logger.write(SVC__00011, managerName, name);
            }else{
                logger.write(SVC__00012, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00013, managerName, name);
            }else{
                logger.write(SVC__00014, name);
            }
            postCreateService();
            if(managerName != null){
                logger.write(SVC__00015, managerName, name);
            }else{
                logger.write(SVC__00016, name);
            }
        }catch(Exception e){
            if(managerName != null){
                logger.write(SVC__00017, e, managerName, name);
            }else{
                logger.write(SVC__00018, e, name);
            }
            state = State.FAILED;
            processStateChanged(State.FAILED, e);
            throw e;
        }catch(Error e){
            if(managerName != null){
                logger.write(SVC__00017, e, managerName, name);
            }else{
                logger.write(SVC__00018, e, name);
            }
            state = State.FAILED;
            processStateChanged(State.FAILED, e);
            throw e;
        }
        
        if(managerName != null){
            logger.write(SVC__00019, managerName, name);
        }else{
            logger.write(SVC__00020, name);
        }
    }
    
    /**
     * T[rX𐶐Kv邩ׂB<p>
     *
     * @return T[rX𐶐KvꍇtrueAłȂꍇfalse
     * @exception Exception sȏԂŃT[rX𐶐悤ƂꍇBł́AthrowȂBI[o[ChꍇɁAKvȂΗOthrowłB
     * @see #create()
     * @see #isNecessaryToCreate(Service)
     */
    protected boolean isNecessaryToCreate() throws Exception{
        return isNecessaryToCreate(this);
    }
    
    /**
     * w肳ꂽT[rX𐶐Kv邩ׂB<p>
     * T[rXԂ{@link Service.State#CREATING}܂́A{@link Service.State#CREATED}A{@link Service.State#STARTING}A{@link Service.State#STARTED}̏ꍇAfalseԂB<br>
     * T[rXԂLȊȌꍇAtrueԂB<br>
     *
     * @param service T[rX
     * @return T[rX𐶐KvꍇtrueAłȂꍇfalse
     */
    public static final boolean isNecessaryToCreate(Service service){
        switch(service.getState()){
        case CREATING:
        case CREATED:
        case STARTING:
        case STARTED:
            return false;
        default:
            return true;
        }
    }
    
    /**
     * T[rX𐶐OsB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԂ̑JځB{@link Service.State#CREATING}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #create()
     */
    protected void preCreateService() throws Exception{
        
        state = State.CREATING;
        processStateChanged(State.CREATING);
    }
    
    /**
     * T[rX𐶐㏈sB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>ServiceManagerւ̓o^B{@link #getServiceManagerName()}Ŏ擾łT[rXServiceManagerɁA{@link #getServiceName()}Ŏ擾łT[rXŁAgo^Bǂ炩null̏ꍇAo^ȂB</li>
     *   <li>T[rXԂ̑JځBcreateService()̌ĂяoɍsƁA{@link #State.CREATED}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #create()
     */
    protected void postCreateService() throws Exception{
        
        if(manager == null && managerName != null){
            setServiceManager(ServiceManagerFactory.findManager(managerName));
        }
        if(manager != null && getServiceName() != null){
            if(manager.isRegisteredService(getServiceName())){
                final Service registeredService
                     = manager.getService(getServiceName());
                if(registeredService != this){
                    logger.write(
                        SVC__00088,
                        managerName, name
                    );
                    manager.stopService(getServiceName());
                    manager.destroyService(getServiceName());
                    if(manager.isRegisteredService(getServiceName())){
                        manager.unregisterService(getServiceName());
                    }
                    manager.registerService(getServiceName(), this);
                }
            }else{
                manager.registerService(getServiceName(), this);
            }
        }
        
        state = State.CREATED;
        processStateChanged(State.CREATED);
    }
    
    // ServiceBaseMBean JavaDoc
    @Override
    public synchronized void restart() throws Exception{
        stop();
        start();
    }
    
    /**
     * T[rXJnB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>{@link #isNecessaryToStart()}̌ĂяoB߂lfalsȅꍇ́AJn𒆎~B</li>
     *   <li>{@link #preStartService()}̌ĂяoBOꍇ́A{@link Service.State#FAILED}ɑJڂB</li>
     *   <li>{@link #startService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     *   <li>{@link #postStartService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     * </ol>
     *
     * @exception IllegalStateException T[rXԃ`FbNɎsꍇ
     * @exception Exception preStartService()AstartService()ApostStartService()ŗOꍇ
     * @see #preStartService()
     * @see #startService()
     * @see #postStartService()
     */
    @Override
    public synchronized void start() throws Exception{
        
        if(managerName != null){
            logger.write(SVC__00021, managerName, name);
        }else{
            logger.write(SVC__00022, name);
        }
        
        try{
            if(!isNecessaryToStart()){
                if(managerName != null){
                    logger.write(
                        SVC__00023,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00024,
                        name, getState()
                    );
                }
                return;
            }
            
            if(managerName != null){
                logger.write(SVC__00025, managerName, name);
            }else{
                logger.write(SVC__00026, name);
            }
            preStartService();
            if(managerName != null){
                logger.write(SVC__00027, managerName, name);
            }else{
                logger.write(SVC__00028, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00029, managerName, name);
            }else{
                logger.write(SVC__00030, name);
            }
            startService();
            if(managerName != null){
                logger.write(SVC__00031, managerName, name);
            }else{
                logger.write(SVC__00032, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00033, managerName, name);
            }else{
                logger.write(SVC__00034, name);
            }
            postStartService();
            if(managerName != null){
                logger.write(SVC__00035, managerName, name);
            }else{
                logger.write(SVC__00036, name);
            }
        }catch(Exception e){
            if(managerName != null){
                logger.write(SVC__00037, e, managerName, name);
            }else{
                logger.write(SVC__00038, e, name);
            }
            state = State.FAILED;
            processStateChanged(State.FAILED, e);
            throw e;
        }catch(Error e){
            if(managerName != null){
                logger.write(SVC__00037, e, managerName, name);
            }else{
                logger.write(SVC__00038, e, name);
            }
            state = State.FAILED;
            processStateChanged(State.FAILED, e);
            throw e;
        }
        
        if(managerName != null){
            logger.write(SVC__00039, managerName, name);
        }else{
            logger.write(SVC__00040, name);
        }
    }
    
    /**
     * T[rXJnKv邩ׂB<p>
     *
     * @return T[rXJnKvꍇtrueAłȂꍇfalse
     * @exception Exception sȏԂŃT[rX𐶐悤Ƃꍇ
     * @see #start()
     * @see #isNecessaryToStart(Service)
     */
    protected boolean isNecessaryToStart() throws Exception{
        return isNecessaryToStart(this);
    }
    
    /**
     * w肳ꂽT[rXJnKv邩ׂB<p>
     * T[rXԂ{@link Service.State#CREATED}܂́A{@link Service.State#STOPPED}̏ꍇAtrueԂB<br>
     * T[rXԂ{@link Service.State#STARTING}܂́A{@link Service.State#STARTED}̏ꍇAfalseԂB<br>
     * T[rXԂLȊȌꍇAIllegalStateExceptionthrowB<br>
     *
     * @param service T[rX
     * @return T[rXJnKvꍇtrueAłȂꍇfalse
     * @exception IllegalStateException sȏԂŃT[rXJn悤Ƃꍇ
     */
    public static final boolean isNecessaryToStart(Service service) throws IllegalStateException{
        switch(service.getState()){
        case CREATED:
        case STOPPED:
            return true;
        case STARTING:
        case STARTED:
            return false;
        default:
            throw new IllegalStateException(
                ServiceManagerFactory.getMessageRecordFactory().findMessage(
                    SVC__00041,
                    State.STARTING, service.getState()
                )
            );
        }
    }
    
    /**
     * T[rXJnOsB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԂ̑JځB{@link Service.State#STARTING}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #start()
     */
    protected void preStartService() throws Exception{
        state = State.STARTING;
        processStateChanged(State.STARTING);
    }
    
    /**
     * T[rXJnB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԂ̑JځBstartService()̌ĂяoɍsƁA{@link Service.State#STARTED}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #start()
     */
    protected void postStartService() throws Exception{
        state = State.STARTED;
        processStateChanged(State.STARTED);
    }
    
    /**
     * T[rX~B<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>{@link #isNecessaryToStop()}̌ĂяoB߂lfalsȅꍇ́A~𒆎~B</li>
     *   <li>{@link #preStopService()}̌ĂяoBOꍇ́A{@link Service.State#FAILED}ɑJڂB</li>
     *   <li>{@link #stopService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     *   <li>{@link #postStopService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     * </ol>
     *
     * @see #preStopService()
     * @see #stopService()
     * @see #postStopService()
     */
    @Override
    public synchronized void stop(){
        
        if(managerName != null){
            logger.write(SVC__00042, managerName, name);
        }else{
            logger.write(SVC__00043, name);
        }
        
        try{
            if(!isNecessaryToStop()){
                if(managerName != null){
                    logger.write(
                        SVC__00044,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00045,
                        name, getState()
                    );
                }
                return;
            }
            
            if(managerName != null){
                logger.write(SVC__00046, managerName, name);
            }else{
                logger.write(SVC__00047, name);
            }
            preStopService();
            if(managerName != null){
                logger.write(SVC__00048, managerName, name);
            }else{
                logger.write(SVC__00049, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00050, managerName, name);
            }else{
                logger.write(SVC__00051, name);
            }
            stopService();
            if(managerName != null){
                logger.write(SVC__00052, managerName, name);
            }else{
                logger.write(SVC__00053, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00054, managerName, name);
            }else{
                logger.write(SVC__00055, name);
            }
            postStopService();
            if(managerName != null){
                logger.write(SVC__00056, managerName, name);
            }else{
                logger.write(SVC__00057, name);
            }
        }catch(Exception e){
            if(managerName != null){
                logger.write(SVC__00058, e, managerName, name);
            }else{
                logger.write(SVC__00059, e, name);
            }
            state = State.FAILED;
            try{
                processStateChanged(State.FAILED, e);
            }catch(Exception ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }catch(Error ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }
            return;
        }catch(Error e){
            if(managerName != null){
                logger.write(SVC__00058, e, managerName, name);
            }else{
                logger.write(SVC__00059, e, name);
            }
            state = State.FAILED;
            try{
                processStateChanged(State.FAILED, e);
            }catch(Exception ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }catch(Error ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }
            return;
        }
        
        if(managerName != null){
            logger.write(SVC__00062, managerName, name);
        }else{
            logger.write(SVC__00063, name);
        }
    }
    
    /**
     * T[rX~Kv邩ׂB<p>
     *
     * @return T[rX~KvꍇtrueAłȂꍇfalse
     * @exception Exception sȏԂŃT[rX~悤Ƃꍇ
     * @see #isNecessaryToStop(Service)
     */
    protected boolean isNecessaryToStop() throws Exception{
        return isNecessaryToStop(this);
    }
    
    /**
     * T[rX~Kv邩ׂB<p>
     * T[rXԂ{@link Service.State#STARTED}̏ꍇAtrueԂB<br>
     * T[rXԂ{@link Service.State#CREATED}܂́A{@link Service.State#STOPPING}A{@link Service.State#STOPPED}A{@link Service.State#DESTROYED}̏ꍇAfalseԂB<br>
     * T[rXԂLȊȌꍇAIllegalStateExceptionthrowB<br>
     *
     * @return T[rX~KvꍇtrueAłȂꍇfalse
     * @exception IllegalStateException sȏԂŃT[rX~悤Ƃꍇ
     */
    public static final boolean isNecessaryToStop(Service service) throws IllegalStateException{
        switch(service.getState()){
        case STARTED:
            return true;
        case CREATED:
        case STOPPING:
        case STOPPED:
        case DESTROYED:
            return false;
        default:
            throw new IllegalStateException(
                ServiceManagerFactory.getMessageRecordFactory().findMessage(
                    SVC__00041,
                    State.STOPPING, service.getState()
                )
            );
        }
    }
    
    /**
     * T[rX~OsB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԃ`FbNBT[rXԂ{@link #State.STARTED}łȂꍇAs킸ɕԂB</li>
     *   <li>T[rXԂ̑JځBT[rXԃ`FbNʉ߂ƁA{@link Service.State#STOPPING}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #stop()
     */
    protected void preStopService() throws Exception{
        state = State.STOPPING;
        processStateChanged(State.STOPPING);
    }
    
    /**
     * T[rX~㏈sB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԂ̑JځBstopService()̌ĂяoɍsƁA{@link Service.State#STOPPED}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #stop()
     */
    protected void postStopService() throws Exception{
        state = State.STOPPED;
        processStateChanged(State.STOPPED);
    }
    
    /**
     * T[rXjB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>{@link #isNecessaryToDestroy()}̌ĂяoB߂lfalsȅꍇ́Aj𒆎~B</li>
     *   <li>{@link #preDestroyService()}̌ĂяoBOꍇ́A{@link Service.State#FAILED}ɑJڂB</li>
     *   <li>{@link #destroyService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     *   <li>{@link #postDestroyService()}̌ĂяoBOꍇ́AFAILEDɑJڂB</li>
     * </ol>
     *
     * @see #preDestroyService()
     * @see #destroyService()
     * @see #postDestroyService()
     */
    @Override
    public synchronized void destroy(){
        
        if(managerName != null){
            logger.write(SVC__00064, managerName, name);
        }else{
            logger.write(SVC__00065, name);
        }
        
        try{
            if(!isNecessaryToDestroy()){
                if(managerName != null){
                    logger.write(
                        SVC__00066,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00067,
                        name, getState()
                    );
                }
                return;
            }
            
            if(managerName != null){
                logger.write(SVC__00068, managerName, name);
            }else{
                logger.write(SVC__00069, name);
            }
            preDestroyService();
            if(managerName != null){
                logger.write(SVC__00070, managerName, name);
            }else{
                logger.write(SVC__00071, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00072, managerName, name);
            }else{
                logger.write(SVC__00073, name);
            }
            destroyService();
            if(managerName != null){
                logger.write(SVC__00074, managerName, name);
            }else{
                logger.write(SVC__00075, name);
            }
            
            if(managerName != null){
                logger.write(SVC__00076, managerName, name);
            }else{
                logger.write(SVC__00077, name);
            }
            postDestroyService();
            if(managerName != null){
                logger.write(SVC__00078, managerName, name);
            }else{
                logger.write(SVC__00079, name);
            }
        }catch(Exception e){
            if(managerName != null){
                logger.write(SVC__00080, e, managerName, name);
            }else{
                logger.write(SVC__00081, e, name);
            }
            state = State.FAILED;
            try{
                processStateChanged(State.FAILED, e);
            }catch(Exception ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }catch(Error ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }
            return;
        }catch(Error e){
            if(managerName != null){
                logger.write(SVC__00080, e, managerName, name);
            }else{
                logger.write(SVC__00081, e, name);
            }
            state = State.FAILED;
            try{
                processStateChanged(State.FAILED, e);
            }catch(Exception ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }catch(Error ex){
                if(managerName != null){
                    logger.write(
                        SVC__00060,
                        ex,
                        managerName, name, getState()
                    );
                }else{
                    logger.write(
                        SVC__00061,
                        ex,
                        name, getState()
                    );
                }
                state = State.FAILED;
                return;
            }
            return;
        }
        
        if(managerName != null){
            logger.write(SVC__00082, managerName, name);
        }else{
            logger.write(SVC__00083, name);
        }
    }
    
    /**
     * T[rXjKv邩ׂB<p>
     *
     * @return T[rXjKvꍇtrueAłȂꍇfalse
     * @exception Exception sȏԂŃT[rXj悤Ƃꍇ
     * @see #isNecessaryToDestroy(Service)
     */
    protected boolean isNecessaryToDestroy() throws Exception{
        return isNecessaryToDestroy(this);
    }
    
    /**
     * w肳ꂽT[rXjKv邩ׂB<p>
     * T[rXԂ{@link Service.State#CREATED}܂́A{@link Service.State#STARTED}A{@link Service.State#STOPPED}A{@link Service.State#FAILED}̏ꍇAtrueԂB<br>
     * T[rXԂ{@link Service.State#DESTROYING}܂́A{@link Service.State#DESTROYED}̏ꍇAfalseԂB<br>
     * T[rXԂLȊȌꍇAIllegalStateExceptionthrowB<br>
     *
     * @param service T[rX
     * @return T[rXjKvꍇtrueAłȂꍇfalse
     * @exception IllegalStateException sȏԂŃT[rXj悤Ƃꍇ
     */
    public static boolean isNecessaryToDestroy(Service service) throws IllegalStateException{
        switch(service.getState()){
        case CREATED:
        case STARTED:
        case STOPPED:
        case FAILED:
            return true;
        case DESTROYING:
        case DESTROYED:
            return false;
        default:
            throw new IllegalStateException(
                ServiceManagerFactory.getMessageRecordFactory().findMessage(
                    SVC__00041,
                    State.DESTROYING, service.getState()
                )
            );
        }
    }
    
    /**
     * T[rXjOsB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԂ{@link Service.State#STOPPED}łȂꍇA{@link #stop()}ĂяoB</li>
     *   <li>T[rXԂ̑JځB{@link Service.State#DESTROYING}ɑJڂB</li>
     *   <li>ServiceManager̍폜B{@link #getServiceManagerName()}Ŏ擾łT[rXServiceManagerA{@link #getServiceName()}Ŏ擾łT[rXŁAg폜Bǂ炩null̏ꍇA폜ȂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #destroy()
     */
    protected void preDestroyService() throws Exception{
        boolean isNecessaryToStop = false;
        try{
            isNecessaryToStop = isNecessaryToStop();
        }catch(Exception e){}
        if(isNecessaryToStop){
            stop();
        }
        
        state = State.DESTROYING;
        processStateChanged(State.DESTROYING);
        
        if(manager == null && managerName != null){
            setServiceManager(ServiceManagerFactory.findManager(managerName));
        }
        if(manager != null && getServiceName() != null){
            Service service = null;
            try{
                service = manager.getService(getServiceName());
            }catch(ServiceNotFoundException e){
            }
            if(service == this){
                manager.unregisterService(getServiceName());
            }
        }
    }
    
    /**
     * T[rXj㏈sB<p>
     * <b><i>̃\bh́AʏAI[o[ChĂ͂ȂB</i></b><br>
     * ̃\bhɂ́Aȉ̎sĂB<br>
     * <ol>
     *   <li>T[rXԂ̑JځBdestroyService()̌ĂяoɍsƁA{@link Service.State#DESTROYED}ɑJڂB</li>
     * </ol>
     *
     * @exception Exception {@link #processStateChanged(State)}ŗOꍇ
     * @see #destroy()
     */
    protected void postDestroyService() throws Exception{
        state = State.DESTROYED;
        processStateChanged(State.DESTROYED);
    }
    
    /**
     * T[rXݒ肷B<p>
     * {@link ServiceLoader}ŃT[rX[hꍇ́AServiceLoaderݒ肷B<br>
     *
     * @param name T[rX
     * @see #getServiceName()
     */
    @Override
    public void setServiceName(String name){
        this.name = name;
        if(name != null && name.length() != 0){
            if(getServiceManagerName() != null
                    && (nameObj == null || !name.equals(nameObj.getServiceName()))){
                nameObj = new ServiceName(managerName, name);
            }
        }else{
            nameObj = null;
        }
    }
    
    // ServiceJavaDoc
    @Override
    public String getServiceName(){
        return name;
    }
    
    // ServiceJavaDoc
    @Override
    public ServiceName getServiceNameObject(){
        return nameObj;
    }
    
    // ServiceJavaDoc
    @Override
    public State getState(){
        return state;
    }
    
    /**
     * T[rX𐶐B<p>
     * ̃T[rXɕKvȃIuWFNg̐Ȃǂ̏sB<br>
     * ̃NXpăT[rXT[rXJ҂́AT[rX̐Ã\bhI[o[ChĎ邱ƁBftHǵAłB<br>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     * @see #create()
     */
    public void createService() throws Exception{
        if(support != null){
            support.createService();
        }
    }
    
    /**
     * T[rXJnB<p>
     * ̃T[rX𗘗p\ȏԂɂB̃\bȟĂяóÃT[rX̋@\𗘗pł鎖ۏ؂B<br>
     * ̃NXpăT[rXT[rXJ҂́AT[rX̊JnÃ\bhI[o[ChĎ邱ƁBftHǵAłB<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     * @see #start()
     */
    public void startService() throws Exception{
        if(support != null){
            support.startService();
        }
    }
    
    /**
     * T[rX~B<p>
     * ̃T[rX𗘗ps\ȏԂɂB̃\bȟĂяóÃT[rX̋@\𗘗pł鎖͕ۏ؂ȂB<br>
     * ̃NXpăT[rXT[rXJ҂́AT[rX̒~Ã\bhI[o[ChĎ邱ƁBftHǵAłB<br>
     *
     * @exception Exception T[rX̒~ɎsꍇBAAstop()ňׂāA͑sB
     * @see #stop()
     */
    public void stopService() throws Exception{
        if(support != null){
            support.stopService();
        }
    }
    
    /**
     * T[rXjB<p>
     * ̃T[rXŎgp郊\[XJB̃\bȟĂяóÃT[rX̋@\𗘗pł鎖͕ۏ؂ȂB<br>
     * ̃NXpăT[rXT[rXJ҂́AT[rX̔jÃ\bhI[o[ChĎ邱ƁBftHǵAłB<br>
     *
     * @exception Exception T[rX̔jɎsꍇBAAdestroy()ňׂāA͑sB
     * @see #destroy()
     */
    public void destroyService() throws Exception{
        if(support != null){
            support.destroyService();
        }
    }
    
    // ServiceBaseMBeanJavaDoc
    @Override
    public void setSystemLoggerServiceName(final ServiceName name){
        if(name == null){
            loggerServiceName = null;
            if(logger != null){
                logger.setLogger(logger.getDefaultLogger());
            }
        }else if(ServiceManagerFactory.isRegisteredService(name)
             && ServiceManagerFactory.getService(name).getState()
                 == State.STARTED
        ){
            loggerServiceName = name;
            if(logger != null){
                if(managerName != null){
                    logger.write(
                        SVC__00084,
                        managerName, this.name, loggerServiceName
                    );
                }else{
                    logger.write(
                        SVC__00085,
                        this.name, loggerServiceName
                    );
                }
                logger.setLogger(
                    (Logger)ServiceManagerFactory
                        .getServiceObject(loggerServiceName),
                    ServiceManagerFactory.getService(loggerServiceName)
                );
            }
        }else{
            ServiceManagerFactory.addServiceStateListener(
                name,
                new ServiceStateListener(){
                    public void stateChanged(ServiceStateChangeEvent e)
                     throws Exception{
                        ServiceManagerFactory
                            .removeServiceStateListener(name, this);
                        setSystemLoggerServiceName(name);
                    }
                    public boolean isEnabledState(State st){
                        return st == State.STARTED;
                    }
                }
            );
        }
    }
    
    // ServiceBaseMBeanJavaDoc
    @Override
    public ServiceName getSystemLoggerServiceName(){
        return loggerServiceName;
    }
    
    // ServiceBaseMBeanJavaDoc
    @Override
    public void setSystemMessageRecordFactoryServiceName(
        final ServiceName name
    ){
        if(name == null){
            messageServiceName = null;
            if(message != null){
                message.setMessageRecordFactory(message.getDefaultMessageRecordFactory());
            }
        }else if(ServiceManagerFactory.isRegisteredService(name)
             && ServiceManagerFactory.getService(name).getState()
                 == State.STARTED
        ){
            messageServiceName = name;
            if(message != null){
                if(managerName != null){
                    logger.write(
                        SVC__00086,
                        managerName, this.name, messageServiceName
                    );
                }else{
                    logger.write(
                        SVC__00087,
                        this.name, messageServiceName
                    );
                }
                message.setMessageRecordFactory(
                    (MessageRecordFactory)ServiceManagerFactory
                        .getServiceObject(messageServiceName),
                    ServiceManagerFactory.getService(messageServiceName)
                );
            }
        }else{
            ServiceManagerFactory.addServiceStateListener(
                name,
                new ServiceStateListener(){
                    public void stateChanged(ServiceStateChangeEvent e)
                     throws Exception{
                        ServiceManagerFactory
                            .removeServiceStateListener(name, this);
                        setSystemMessageRecordFactoryServiceName(name);
                    }
                    public boolean isEnabledState(State st){
                        return st == State.STARTED;
                    }
                }
            );
        }
    }
    
    // ServiceBaseMBeanJavaDoc
    @Override
    public ServiceName getSystemMessageRecordFactoryServiceName(){
        return messageServiceName;
    }
    
    /**
     * ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}擾B<p>
     *
     * @return ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}
     */
    public Logger getLogger(){
        return logger;
    }
    
    /**
     * ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}ݒ肷B<p>
     *
     * @param log ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}
     */
    public void setLogger(Logger log){
        if(log == null){
            if(logger != null){
                logger.setLogger(logger.getDefaultLogger());
            }
        }else{
            if(log instanceof Service){
                final Service logService = (Service)log;
                final String managerName = logService.getServiceManagerName();
                final String serviceName = logService.getServiceName();
                if(managerName != null && serviceName != null){
                    setSystemLoggerServiceName(
                        new ServiceName(managerName, serviceName)
                    );
                    return;
                }
            }
            if(managerName != null){
                logger.write(
                    SVC__00084,
                    managerName, this.name, null
                );
            }else{
                logger.write(
                    SVC__00085,
                    this.name, null
                );
            }
            logger.setLogger(
                log,
                (log instanceof Service) ? (Service)log : null
            );
        }
    }
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX擾B<p>
     *
     * @return Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX
     */
    public MessageRecordFactory getMessageRecordFactory(){
        return message;
    }
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}ݒ肷B<p>
     *
     * @param msg Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}
     */
    public void setMessageRecordFactory(MessageRecordFactory msg){
        if(msg == null){
            if(message != null){
                message.setMessageRecordFactory(message.getDefaultMessageRecordFactory());
            }
        }else{
            if(msg instanceof Service){
                final Service msgService = (Service)msg;
                final String managerName = msgService.getServiceManagerName();
                final String serviceName = msgService.getServiceName();
                if(managerName != null && serviceName != null){
                    setSystemMessageRecordFactoryServiceName(
                        new ServiceName(managerName, serviceName)
                    );
                    return;
                }
            }
            if(managerName != null){
                logger.write(
                    SVC__00086,
                    managerName, this.name, null
                );
            }else{
                logger.write(
                    SVC__00087,
                    this.name, null
                );
            }
            message.setMessageRecordFactory(
                msg,
                (msg instanceof Service) ? (Service)msg : null
            );
        }
    }
    
    /**
     * ̃T[rXo^{@link ServiceManager}̃T[rX擾B<p>
     *
     * @return ServiceManager̃T[rX
     * @see #setServiceManagerName(String)
     */
    @Override
    public String getServiceManagerName(){
        return managerName;
    }
    
    /**
     * ̃T[rXo^{@link ServiceManager}̃T[rXݒ肷B<p>
     * {@link ServiceLoader}ŃT[rX[hꍇ́AServiceLoaderAo^ׂServiceManagermĂAYServiceManagerɓo^鎞ɁAo^ServiceManagerɂĐݒ肳B<br>
     *
     * @param name ServiceManager̃T[rX
     * @see #getServiceManagerName()
     */
    @Override
    public void setServiceManagerName(String name){
        if(managerName != null && managerName.equals(name)){
            return;
        }
        managerName = name;
        if(name != null){
            if(getServiceName() != null
                    && (nameObj == null || !managerName.equals(nameObj.getServiceManagerName()))){
                nameObj = new ServiceName(managerName, getServiceName());
            }
        }else{
            nameObj = null;
        }
        if(managerName != null && (manager == null || !managerName.equals(manager.getServiceName()))){
            setServiceManager(ServiceManagerFactory.findManager(managerName));
        }
    }
    
    /**
     * {@link ServiceBaseSupport}̃bvƂĐꂽꍇɁAbvServiceBaseSupport̃CX^X擾B<p>
     *
     * @see #ServiceBase(ServiceBaseSupport)
     */
    @Override
    public Object getTarget(){
        if(support != null){
            return support;
        }
        return this;
    }
    
    /**
     * T[rX̏ԂύXꂽĎServiceStateListenerǉB<p>
     *
     * @param listener ServiceStateListenerIuWFNg
     */
    @Override
    public void addServiceStateListener(ServiceStateListener listener){
        if(!serviceStateListeners.contains(listener)){
            serviceStateListeners.add(listener);
        }
    }
    
    /**
     * T[rX̏ԂύXꂽĎServiceStateListener폜B<p>
     *
     * @param listener ServiceStateListenerIuWFNg
     */
    @Override
    public void removeServiceStateListener(ServiceStateListener listener){
        serviceStateListeners.remove(listener);
    }
    
    /**
     * T[rX̏ԂύXꂽServiceStateListenerɒʒmB<p>
     * T[rX̏ԂύXꂽꍇɁAĂяo܂BAAI[o[Chꍇ́AKsuper.processStateChanged(State)ĂяoƁB<br>
     * 
     * @param state ύX̃T[rX̏
     * @see ServiceStateListener
     */
    protected void processStateChanged(State state) throws Exception{
        processStateChanged(state, null);
    }
    
    /**
     * T[rX̏ԂύXꂽServiceStateListenerɒʒmB<p>
     * T[rX̏ԂύXꂽꍇɁAĂяo܂BAAI[o[Chꍇ́AKsuper.processStateChanged(State)ĂяoƁB<br>
     * 
     * @param state ύX̃T[rX̏
     * @param th ԕύXɔO
     * @see ServiceStateListener
     */
    protected void processStateChanged(State state, Throwable th) throws Exception{
        final List<ServiceStateListener> listeners
             = new ArrayList<ServiceStateListener>(serviceStateListeners);
        for(ServiceStateListener listener : listeners){
            if(listener.isEnabledState(state)){
                listener.stateChanged(th == null ? new ServiceStateChangeEvent(this) : new ServiceStateChangeEvent(this, th));
            }
        }
    }
    
    /**
     * fVACYsB<p>
     *
     * @param in fVACY̌ƂȂXg[
     * @exception IOException ǂݍ݂Ɏsꍇ
     * @exception ClassNotFoundException fVACY悤ƂIuWFNg̃NXȂꍇ
     */
    private void readObject(java.io.ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        logger = new LoggerWrapper(ServiceManagerFactory.getLogger());
        message = new MessageRecordFactoryWrapper(
            ServiceManagerFactory.getMessageRecordFactory()
        );
        serviceStateListeners = Collections.<ServiceStateListener>synchronizedList(new ArrayList<ServiceStateListener>());
        if(manager == null && managerName != null){
            setServiceManager(ServiceManagerFactory.findManager(managerName));
        }
        if(loggerServiceName != null){
            setSystemLoggerServiceName(loggerServiceName);
        }
        if(messageServiceName != null){
            setSystemMessageRecordFactoryServiceName(messageServiceName);
        }
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂB<p>
     * ȉ̏ŁArsB<br>
     * <ol>
     *   <li>objnull̏ꍇAfalse</li>
     *   <li>obj̎QƂ̃CX^X̎QƂƓꍇAtrue</li>
     *   <li>{@link #getServiceName()}null̏ꍇA{Object#equals(Object)}ɈϏ</li>
     *   <li>objServicẽCX^XłȂꍇAfalse</li>
     *   <li>objServicẽCX^XŁA{@link Service#getServiceManagerName()}Ƃ̃CX^X{@link #getServiceManagerName()}A{@link Service#getServiceName()}Ƃ̃CX^X{@link #getServiceName()}ꍇAtrueBłȂꍇAfalse</li>
     * </ol>
     *
     * @param obj rΏۂ̎QƃIuWFNg
     * @return obj Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇtrueAłȂꍇfalse
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(this == obj){
            return true;
        }
        if(name == null){
            return super.equals(obj);
        }
        if(obj instanceof Service){
            final Service service = (Service)obj;
            final String mngName = service.getServiceManagerName();
            if(managerName == null){
                return mngName != null
                     ? false : name.equals(service.getServiceName());
            }else{
                if(managerName.equals(mngName)
                     && name.equals(service.getServiceName())){
                    return true;
                }
            }
        }
        return false;
    }
    
    /**
     * IuWFNg̃nbVR[hlԂB<p>
     *
     * @return nbVR[hl
     */
    @Override
    public int hashCode(){
        if(name == null){
            return super.hashCode();
        }else{
            return managerName != null
                 ? managerName.hashCode() + name.hashCode() : name.hashCode();
        }
    }
    
    
    /**
     * ̃CX^X̕\ԂB<p>
     *
     * @return ̃CX^X̕\
     */
    @Override
    public String toString(){
        StringBuilder buf = new StringBuilder();
        if(support != null){
            buf.append(support.toString());
        }else{
            buf.append(super.toString());
        }
        if(managerName != null || name != null){
            buf.append(':');
        }
        if(managerName != null){
            buf.append(managerName);
        }
        if(managerName != null){
            buf.append('#');
        }
        if(name != null){
            buf.append(name);
        }
        return buf.toString();
    }
    
    /**
     * T[rX~yєjꂸɃKx[W悤ƂꍇɁA~yєjsB<p>
     *
     * @exception Throwable ~AyєjɎsꍇ
     */
    @Override
    protected void finalize() throws Throwable{
        try{
            final State state = getState();
            if(state.ordinal() <= State.STARTED.ordinal()){
                final String name = getServiceName();
                final ServiceManager manager = getServiceManager();
                if(name == null && manager == null){
                    if(isNecessaryToStop()){
                        stop();
                    }
                    if(isNecessaryToDestroy()){
                        destroy();
                    }
                }else{
                    Service service = null;
                    try{
                        service = manager.getService(name);
                    }catch(ServiceNotFoundException e){
                    }
                    if(service == this){
                        if(isNecessaryToStop()){
                            manager.stopService(name);
                        }
                        if(isNecessaryToDestroy()){
                            manager.destroyService(name);
                        }
                    }else{
                        if(isNecessaryToStop()){
                            stop();
                        }
                        if(isNecessaryToDestroy()){
                            destroy();
                        }
                    }
                }
            }
        }catch(Throwable th){
        }
        super.finalize();
    }
}