/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop;

import java.util.Properties;

import jp.ossc.nimbus.core.*;

/**
 * {@link SelectableServletFilterInterceptorChainListService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see SelectableServletFilterInterceptorChainListService
 */
public interface SelectableServletFilterInterceptorChainListServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * LɂURLƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX}bsOB<p>
     * NGXgURLw肳ꂽURLɊYꍇɁAURLɃ}bsOꂽInterceptorChainListT[rXIB<br>
     *
     * @param mapping URLiK\jInterceptorChainListT[rX̃T[rX̃}bsOBURL=T[rX
     */
    public void setEnabledURLMapping(Properties mapping);
    
    /**
     * LɂURLƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return URLiK\jInterceptorChainListT[rX̃T[rX̃}bsO
     */
    public Properties getEnabledURLMapping();
    
    /**
     * LɂURIƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX}bsOB<p>
     * NGXgURIw肳ꂽURIɊYꍇɁAURIɃ}bsOꂽInterceptorChainListT[rXIB<br>
     *
     * @param mapping URIiK\jInterceptorChainListT[rX̃T[rX̃}bsOBURI=T[rX
     */
    public void setEnabledURIMapping(Properties mapping);
    
    /**
     * LɂURIƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return URIiK\jInterceptorChainListT[rX̃T[rX̃}bsO
     */
    public Properties getEnabledURIMapping();
    
    /**
     * LɂT[ubgpXƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX}bsOB<p>
     * NGXgT[ubgpXw肳ꂽT[ubgpXɊYꍇɁÃT[ubgpXɃ}bsOꂽInterceptorChainListT[rXIB<br>
     *
     * @param mapping T[ubgpXiK\jInterceptorChainListT[rX̃T[rX̃}bsOBT[ubgpX=T[rX
     */
    public void setEnabledPathMapping(Properties mapping);
    
    /**
     * LɂT[ubgpXƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return T[ubgpXiK\jInterceptorChainListT[rX̃T[rX̃}bsO
     */
    public Properties getEnabledPathMapping();
    
    /**
     * ɂURLƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX}bsOB<p>
     * NGXgURLw肳ꂽURLɊYȂꍇɁAURLɃ}bsOꂽInterceptorChainListT[rXIB<br>
     *
     * @param mapping URLiK\jInterceptorChainListT[rX̃T[rX̃}bsOBURL=T[rX
     */
    public void setDisabledURLMapping(Properties mapping);
    
    /**
     * ɂURLƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return URLiK\jInterceptorChainListT[rX̃T[rX̃}bsO
     */
    public Properties getDisabledURLMapping();
    
    /**
     * ɂURIƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX}bsOB<p>
     * NGXgURIw肳ꂽURIɊYȂꍇɁAURIɃ}bsOꂽInterceptorChainListT[rXIB<br>
     *
     * @param mapping URIiK\jInterceptorChainListT[rX̃T[rX̃}bsOBURI=T[rX
     */
    public void setDisabledURIMapping(Properties mapping);
    
    /**
     * ɂURIƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return URIiK\jInterceptorChainListT[rX̃T[rX̃}bsO
     */
    public Properties getDisabledURIMapping();
    
    /**
     * ɂT[ubgpXƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX}bsOB<p>
     * NGXgT[ubgpXw肳ꂽT[ubgpXɊYȂꍇɁÃT[ubgpXɃ}bsOꂽInterceptorChainListT[rXIB<br>
     *
     * @param mapping T[ubgpXiK\jInterceptorChainListT[rX̃T[rX̃}bsOBT[ubgpX=T[rX
     */
    public void setDisabledPathMapping(Properties mapping);
    
    /**
     * ɂT[ubgpXƂ̎Ɏgp{@link InterceptorChainList}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return T[ubgpXiK\jInterceptorChainListT[rX̃T[rX̃}bsO
     */
    public Properties getDisabledPathMapping();
    
    /**
     * Y{@link InterceptorChainList}݂ȂꍇɑIInterceptorChainListT[rX̃T[rXݒ肷B<p>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setDefaultInterceptorChainListServiceName(ServiceName name);
    
    /**
     * Y{@link InterceptorChainList}݂ȂꍇɑIInterceptorChainListT[rX̃T[rX擾B<p>
     *
     * @return InterceptorChainListT[rX̃T[rX
     */
    public ServiceName getDefaultInterceptorChainListServiceName();
}
