/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link BlockadeInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see BlockadeInterceptorService
 */
public interface BlockadeInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    public static final String DEFAULT_PROPERTY_NAME_PATH    = "path";
    public static final String DEFAULT_PROPERTY_NAME_STATE   = "state";
    public static final String DEFAULT_PROPERTY_NAME_MESSAGE = "message";
    
    /**
     * ǏԁFJB<p>
     */
    public static final int BLOCKADE_STATE_OPEN        = 0;
    
    /**
     * ǏԁFǁB<p>
     * SẴ[UǂĂԁB<br>
     */
    public static final int BLOCKADE_STATE_CLOSE       = 1;
    
    /**
     * ǏԁFeXgJB<p>
     * [Û݊JĂԁB<br>
     */
    public static final int BLOCKADE_STATE_TEST_OPEN   = 2;
    
    /**
     * vIuWFNgNGXg擾鎞Ɏgp鑮ݒ肷B<p>
     * ftHgĺA{@link StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME}B<br>
     *
     * @param name 
     * @see StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME
     */
    public void setRequestObjectAttributeName(String name);
    
    /**
     * vIuWFNgNGXg擾鎞Ɏgp鑮擾B<p>
     *
     * @return 
     */
    public String getRequestObjectAttributeName();
    
    /**
     * NGXg̃[U肷vpeBƁA[UR[h}X^̃[U肷vpeB̃}bsOݒ肷B<p>
     * eXgJT|[gꍇ́Aݒ肷B<br>
     *
     * @param mapping NGXg̃[U肷vpeB=[UR[h}X^̃[U肷vpeB
     */
    public void setSpecialUserMapping(Map<String,String> mapping);
    
    /**
     * NGXg̃[U肷vpeBƁA[UR[h}X^̃[U肷vpeB̃}bsO擾B<p>
     *
     * @return NGXg̃[U肷vpeB=[UR[h}X^̃[U肷vpeB
     */
    public Map<String,String> getSpecialUserMapping();
    
    /**
     * {@link jp.ossc.nimbus.service.codemaster.CodeMasterFinder CodeMasterFinder}T[rX̃T[rXݒ肷B<p>
     * R[h}X^̓ǂݎѐۏ؂ꍇ́Ȃ̑ɁA{@link #setThreadContextServiceName(ServiceName)}ݒ肷B<br>
     *
     * @param name CodeMasterFinderT[rX̃T[rX
     */
    public void setCodeMasterFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.codemaster.CodeMasterFinder CodeMasterFinder}T[rX̃T[rX擾B<p>
     *
     * @return CodeMasterFinderT[rX̃T[rX
     */
    public ServiceName getCodeMasterFinderServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.context.ThreadContextService ThreadContextService}T[rX̃T[rXݒ肷B<p>
     * R[h}X^̓ǂݎѐۏ؂ꍇ́A{@link #setCodeMasterFinderServiceName(ServiceName)}̑ɂ̑ݒ肷B<br>
     *
     * @param name ThreadContextServiceT[rX̃T[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.ThreadContextService ThreadContextService}T[rX̃T[rX擾B<p>
     *
     * @return ThreadContextServiceT[rX̃T[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * ǃR[h}X^̃R[h}X^L[ݒ肷B<p>
     *
     * @param key R[h}X^L[
     */
    public void setBlockadeCodeMasterKey(String key);
    
    /**
     * ǃR[h}X^̃R[h}X^L[擾B<p>
     *
     * @return R[h}X^L[
     */
    public String getBlockadeCodeMasterKey();
    
    /**
     * [UR[h}X^̃R[h}X^L[ݒ肷B<p>
     * eXgJT|[gꍇ́Aݒ肷B<br>
     *
     * @param key R[h}X^L[
     */
    public void setSpecialUserCodeMasterKey(String key);
    
    /**
     * [UR[h}X^̃R[h}X^L[擾B<p>
     *
     * @return R[h}X^L[
     */
    public String getSpecialUserCodeMasterKey();
    
    /**
     * ǃR[h}X^̃pX\vpeBݒ肷B<p>
     * ftHǵA{@link #DEFAULT_PROPERTY_NAME_PATH}
     *
     * @param name pX\vpeB
     * @see #DEFAULT_PROPERTY_NAME_PATH
     */
    public void setPathPropertyName(String name);
    
    /**
     * ǃR[h}X^̃pX\vpeB擾B<p>
     *
     * @return pX\vpeB
     */
    public String getPathPropertyName();
    
    /**
     * ǃR[h}X^̕ǏԂ\vpeBݒ肷B<p>
     * ftHǵA{@link #DEFAULT_PROPERTY_NAME_STATE}
     *
     * @param name ǏԂ\vpeB
     * @see #DEFAULT_PROPERTY_NAME_STATE
     */
    public void setStatePropertyName(String name);
    
    /**
     * ǃR[h}X^̕ǏԂ\vpeB擾B<p>
     *
     * @return ǏԂ\vpeB
     */
    public String getStatePropertyName();
    
    /**
     * ǃR[h}X^̕ǃbZ[W\vpeBݒ肷B<p>
     * ftHǵA{@link #DEFAULT_PROPERTY_NAME_MESSAGE}
     *
     * @param name ǃbZ[W\vpeB
     * @see #DEFAULT_PROPERTY_NAME_MESSAGE
     */
    public void setMessagePropertyName(String name);
    
    /**
     * ǃR[h}X^̕ǃbZ[W\vpeB擾B<p>
     *
     * @return ǃbZ[W\vpeB
     */
    public String getMessagePropertyName();
}