/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.*;
import java.util.*;
import java.util.zip.*;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.context.*;
import jp.ossc.nimbus.service.journal.*;
import jp.ossc.nimbus.util.converter.*;

/**
 * Xg[C^[Zv^B<p>
 *
 * @author M.Takata
 */
public class StreamExchangeInterceptorService
 extends ServletFilterInterceptorService
 implements StreamExchangeInterceptorServiceMBean{
    
    private static final long serialVersionUID = 7618395554145055608L;
    
    /** wb_[ : Content-Encoding */
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    /** Content-Encoding : deflate */
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    /** Content-Encoding : gzip */
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    /** Content-Encoding : x-zip */
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    
    protected ServiceName requestStreamConverterServiceName;
    protected StreamConverter requestStreamConverter;
    
    protected ServiceName responseStreamConverterServiceName;
    protected StreamConverter responseStreamConverter;
    
    protected ServiceName threadContextServiceName;
    protected Context<Object, Object> threadContext;
    
    protected ServiceName journalServiceName;
    protected Journal journal;
    
    protected ServiceName exchangeEditorFinderServiceName;
    protected EditorFinder exchangeEditorFinder;
    
    protected ServiceName exchangeRequestEditorFinderServiceName;
    protected EditorFinder exchangeRequestEditorFinder;
    
    protected ServiceName exchangeResponseEditorFinderServiceName;
    protected EditorFinder exchangeResponseEditorFinder;
    
    protected String responseContentType;
    
    protected String requestObjectAttributeName
         = DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String responseObjectAttributeName
         = DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;
    
    protected String requestObjectContextKey
         = DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;
    protected String responseObjectContextKey
         = DEFAULT_RESPONSE_OBJECT_CONTEXT_KEY;
    
    protected boolean isRequestStreamInflate = true;
    
    protected String exchangeJournalKey = DEFAULT_EXCHANGE_JOURNAL_KEY;
    protected String exchangeRequestJournalKey = DEFAULT_EXCHANGE_REQ_JOURNAL_KEY;
    protected String exchangeResponseJournalKey = DEFAULT_EXCHANGE_RES_JOURNAL_KEY;
    protected String requestBytesJournalKey = DEFAULT_REQUEST_BYTES_JOURNAL_KEY;
    protected String requestObjectJournalKey = DEFAULT_REQUEST_OBJECT_JOURNAL_KEY;
    protected String responseBytesJournalKey = DEFAULT_RESPONSE_BYTES_JOURNAL_KEY;
    protected String responseObjectJournalKey = DEFAULT_RESPONSE_OBJECT_JOURNAL_KEY;
    protected String exceptionJournalKey = DEFAULT_EXCEPTION_JOURNAL_KEY;
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setRequestStreamConverterServiceName(ServiceName name){
        requestStreamConverterServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getRequestStreamConverterServiceName(){
        return requestStreamConverterServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setResponseStreamConverterServiceName(ServiceName name){
        responseStreamConverterServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getResponseStreamConverterServiceName(){
        return responseStreamConverterServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setThreadContextServiceName(ServiceName name){
        threadContextServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getThreadContextServiceName(){
        return threadContextServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setJournalServiceName(ServiceName name){
        journalServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getJournalServiceName(){
        return journalServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeEditorFinderServiceName(ServiceName name){
        exchangeEditorFinderServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getExchangeEditorFinderServiceName(){
        return exchangeEditorFinderServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeRequestEditorFinderServiceName(ServiceName name){
        exchangeRequestEditorFinderServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getExchangeRequestEditorFinderServiceName(){
        return exchangeRequestEditorFinderServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeResponseEditorFinderServiceName(ServiceName name){
        exchangeResponseEditorFinderServiceName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getExchangeResponseEditorFinderServiceName(){
        return exchangeResponseEditorFinderServiceName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setResponseContentType(String type){
        responseContentType = type;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getResponseContentType(){
        return responseContentType;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setRequestObjectAttributeName(String name){
        requestObjectAttributeName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getRequestObjectAttributeName(){
        return requestObjectAttributeName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setResponseObjectAttributeName(String name){
        responseObjectAttributeName = name;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getResponseObjectAttributeName(){
        return responseObjectAttributeName;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setRequestObjectContextKey(String key){
        requestObjectContextKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getRequestObjectContextKey(){
        return requestObjectContextKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setResponseObjectContextKey(String key){
        responseObjectContextKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getResponseObjectContextKey(){
        return responseObjectContextKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setRequestStreamInflate(boolean isInflate){
        isRequestStreamInflate = isInflate;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public boolean isRequestStreamInflate(){
        return isRequestStreamInflate;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeJournalKey(String key){
        exchangeJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getExchangeJournalKey(){
        return exchangeJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeRequestJournalKey(String key){
        exchangeRequestJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getExchangeRequestJournalKey(){
        return exchangeRequestJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeResponseJournalKey(String key){
        exchangeResponseJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getExchangeResponseJournalKey(){
        return exchangeResponseJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setRequestBytesJournalKey(String key){
        requestBytesJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getRequestBytesJournalKey(){
        return requestBytesJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setRequestObjectJournalKey(String key){
        requestObjectJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getRequestObjectJournalKey(){
        return requestObjectJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setResponseBytesJournalKey(String key){
        responseBytesJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getResponseBytesJournalKey(){
        return responseBytesJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setResponseObjectJournalKey(String key){
        responseObjectJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getResponseObjectJournalKey(){
        return responseObjectJournalKey;
    }
    
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public void setExceptionJournalKey(String key){
        exceptionJournalKey = key;
    }
    // StreamExchangeInterceptorServiceMBean JavaDoc
    public String getExceptionJournalKey(){
        return exceptionJournalKey;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(requestStreamConverterServiceName == null
             && requestStreamConverter == null){
            throw new IllegalArgumentException("It is necessary to specify RequestStreamConverterServiceName or RequestStreamConverter.");
        }
        if(requestStreamConverterServiceName != null){
            requestStreamConverter = ServiceManagerFactory
                .getServiceObject(requestStreamConverterServiceName);
        }
        if(responseStreamConverterServiceName == null
             && responseStreamConverter == null){
            throw new IllegalArgumentException("It is necessary to specify ResponseStreamConverterServiceName or ResponseStreamConverter.");
        }
        if(responseStreamConverterServiceName != null){
            responseStreamConverter = ServiceManagerFactory
                .getServiceObject(responseStreamConverterServiceName);
        }
        
        if(threadContextServiceName != null){
            threadContext = ServiceManagerFactory
                .getServiceObject(threadContextServiceName);
        }
        
        if(journalServiceName != null){
            journal = ServiceManagerFactory
                .getServiceObject(journalServiceName);
        }
        
        if(exchangeEditorFinderServiceName != null){
            exchangeEditorFinder = (EditorFinder)ServiceManagerFactory
                .getServiceObject(
                    exchangeEditorFinderServiceName
                );
        }
        
        if(exchangeRequestEditorFinderServiceName != null){
            exchangeRequestEditorFinder = ServiceManagerFactory
                .getServiceObject(
                    exchangeRequestEditorFinderServiceName
                );
        }
        
        if(exchangeResponseEditorFinderServiceName != null){
            exchangeResponseEditorFinder = ServiceManagerFactory
                .getServiceObject(
                    exchangeResponseEditorFinderServiceName
                );
        }
    }
    
    /**
     * vXg[vIuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rXݒ肷B<p>
     *
     * @param conv StreamConverterT[rX
     */
    public void setRequestStreamConverter(StreamConverter conv){
        requestStreamConverter = conv;
    }
    
    /**
     * vXg[vIuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX擾B<p>
     *
     * @return StreamConverterT[rX
     */
    public StreamConverter getRequestStreamConverter(){
        return requestStreamConverter;
    }
    
    /**
     * IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rXݒ肷B<p>
     *
     * @param conv StreamConverterT[rX
     */
    public void setResponseStreamConverter(StreamConverter conv){
        responseStreamConverter = conv;
    }
    
    /**
     * IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX擾B<p>
     *
     * @return StreamConverterT[rX
     */
    public StreamConverter getResponseStreamConverter(){
        return responseStreamConverter;
    }
    
    /**
     * vIuWFNgyщIuWFNg悹{@link jp.ossc.nimbus.service.context.Context Context}T[rXݒ肷B<p>
     *
     * @param context ContextT[rX
     */
    public void setThreadContext(Context<Object, Object> context){
        threadContext = context;
    }
    
    /**
     * vIuWFNgyщIuWFNg悹{@link jp.ossc.nimbus.service.context.Context Context}T[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public Context<Object, Object> getThreadContext(){
        return threadContext;
    }
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rXݒ肷B<p>
     *
     * @param journal JournalT[rX
     */
    public void setJournal(Journal journal){
        this.journal = journal;
    }
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX擾B<p>
     *
     * @return JournalT[rX
     */
    public Journal getJournal(){
        return journal;
    }
    
    /**
     * W[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rXݒ肷B<p>
     *
     * @param finder EditorFinderT[rX
     */
    public void setExchangeEditorFinder(EditorFinder finder){
        exchangeEditorFinder = finder;
    }
    
    /**
     * W[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX擾B<p>
     *
     * @return EditorFinderT[rX
     */
    public EditorFinder getExchangeEditorFinder(){
        return exchangeEditorFinder;
    }
    
    /**
     * W[i̗vXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rXݒ肷B<p>
     *
     * @param finder EditorFinderT[rX
     */
    public void setExchangeRequestEditorFinder(EditorFinder finder){
        exchangeRequestEditorFinder = finder;
    }
    
    /**
     * W[i̗vXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX擾B<p>
     *
     * @return EditorFinderT[rX
     */
    public EditorFinder getExchangeRequestEditorFinder(){
        return exchangeRequestEditorFinder;
    }
    
    /**
     * W[ỉXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rXݒ肷B<p>
     *
     * @param finder EditorFinderT[rX
     */
    public void setExchangeResponseEditorFinder(EditorFinder finder){
        exchangeResponseEditorFinder = finder;
    }
    
    /**
     * W[ỉXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX擾B<p>
     *
     * @return EditorFinderT[rX
     */
    public EditorFinder getExchangeResponseEditorFinder(){
        return exchangeResponseEditorFinder;
    }
    
    /**
     * ConvertergăXg[ƓIuWFNǧsB<p>
     * ServletRequest#getInputStream()Ŏ擾̓Xg[StreamConverterœ̃IuWFNgɕϊāANGXg̑ɐݒ肵ÃC^[Zv^ĂяoB<br>
     * ܂ÃC^[Zv^̌Ăяoꍇ́ANGXg̑擾IuWFNgStreamConverterŃXg[ɕϊāAServletResponse#getOutputStream()Ŏ擾o̓Xg[ɏށB<br>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invokeFilter(
        ServletFilterInvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() != State.STARTED){
            return chain.invokeNext(context);
        }
        try{
            if(journal != null){
                journal.startJournal(exchangeJournalKey, exchangeEditorFinder);
            }
            final ServletRequest request = context.getServletRequest();
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[2048];
            InputStream is = null;
            ByteArrayInputStream bais = null;
            try{
                if(journal != null){
                    journal.startJournal(
                        exchangeRequestJournalKey,
                        exchangeRequestEditorFinder
                    );
                }
                final ServletInputStream sis = request.getInputStream();
                try{
                    int size = 0;
                    while((size = sis.read(bytes)) != -1){
                        baos.write(bytes, 0, size);
                    }
                }finally{
                    if(sis != null){
                        sis.close();
                    }
                }
                if(journal != null){
                    journal.addInfo(
                        requestBytesJournalKey,
                        baos.toByteArray()
                    );
                }
                bais = new ByteArrayInputStream(baos.toByteArray());
                if(isRequestStreamInflate
                     && request instanceof HttpServletRequest){
                    is = decompress((HttpServletRequest)request, bais);
                }
                if(request.getCharacterEncoding() != null
                    && requestStreamConverter instanceof StreamStringConverter){
                    ((StreamStringConverter)requestStreamConverter)
                        .setCharacterEncodingToObject(
                            request.getCharacterEncoding());
                }
                final Object requestObj
                     = requestStreamConverter.convertToObject(is);
                if(journal != null){
                    journal.addInfo(
                        requestObjectJournalKey,
                        requestObj
                    );
                }
                request.setAttribute(requestObjectAttributeName, requestObj);
            }catch(Exception e){
                if(journal != null){
                    journal.addInfo(
                        exceptionJournalKey,
                        e
                    );
                }
                throw new InputExchangeException(e);
            }catch(Throwable th){
                if(journal != null){
                    journal.addInfo(
                        exceptionJournalKey,
                        th
                    );
                }
                throw th;
            }finally{
                if(is != null){
                    try{
                        is.close();
                    }catch(IOException e){}
                }
                if(bais != null){
                    try{
                        bais.close();
                    }catch(IOException e){}
                }
                if(journal != null){
                    journal.endJournal();
                }
            }
                
            final Object ret = chain.invokeNext(context);
            
            final ServletResponse response = context.getServletResponse();
            if(!response.isCommitted()){
                try{
                    if(journal != null){
                        journal.startJournal(
                            exchangeResponseJournalKey,
                            exchangeResponseEditorFinder
                        );
                    }
                    if(responseContentType != null){
                        response.setContentType(responseContentType);
                    }
                    final Object responseObj
                         = request.getAttribute(responseObjectAttributeName);
                    if(journal != null){
                        journal.addInfo(
                            responseObjectJournalKey,
                            responseObj
                        );
                    }
                    if(responseObj != null){
                        if(response.getCharacterEncoding() != null
                            && responseStreamConverter instanceof StreamStringConverter){
                            ((StreamStringConverter)responseStreamConverter)
                                .setCharacterEncodingToStream(
                                    response.getCharacterEncoding());
                        }
                        is = responseStreamConverter.convertToStream(responseObj);
                        final ServletOutputStream sos = response.getOutputStream();
                        int readLen = 0;
                        baos.reset();
                        while((readLen = is.read(bytes)) != -1){
                            baos.write(bytes, 0, readLen);
                            sos.write(bytes, 0, readLen);
                        }
                        if(journal != null){
                            journal.addInfo(
                                responseBytesJournalKey,
                                baos.toByteArray()
                            );
                        }
                    }
                }catch(Exception e){
                    if(journal != null){
                        journal.addInfo(
                            exceptionJournalKey,
                            e
                        );
                    }
                    throw new OutputExchangeException(e);
                }catch(Throwable th){
                    if(journal != null){
                        journal.addInfo(
                            exceptionJournalKey,
                            th
                        );
                    }
                    throw th;
                }finally{
                    if(journal != null){
                        journal.endJournal();
                    }
                }
            }
            return ret;
        }catch(Throwable th){
           if(journal != null){
                journal.addInfo(
                    exceptionJournalKey,
                    th
                );
           }
           throw th;
        }finally{
            if(journal != null){
                journal.endJournal();
            }
        }
    }
    
    /**
     * ̓Xg[̈kB<p>
     * (Content-EncodingɎw肳ꂽtŉ)
     * 
     * @param request HTTPNGXg
     * @param is ̓Xg[
     * @return kꂽ̓Xg[
     * @throws IOException T|[gĂȂk`(deflate, gzipȊO)w肳ꂽꍇ
     */
    @SuppressWarnings("unchecked")
    protected InputStream decompress(HttpServletRequest request, InputStream is) throws IOException {
        // wb_[[Content-Encoding]̒l擾
        Enumeration<String> encodeEnum = (Enumeration<String>)request.getHeaders(HEADER_CONTENT_ENCODING);
        if(encodeEnum == null || !encodeEnum.hasMoreElements()){
            return is;
        }
        InputStream in = is;
        // kꂽtŉ
        List<String> encodes = new ArrayList<String>();
        while(encodeEnum.hasMoreElements()){
            encodes.add(encodeEnum.nextElement());
        }
        for(int i = (encodes.size() - 1); i >= 0; i--){
            final String encode = (String)encodes.get(i);
            if(encode != null){
                if(encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1){
                    // deflatek
                    in = new InflaterInputStream(in);
                }else if(encode.indexOf(CONTENT_ENCODING_GZIP) != -1
                            || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1){
                    // gzipk
                    in = new GZIPInputStream(in);
                }else{
                    throw new IOException("Can not decompress. [" + encode + "]");
                }
            }
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final byte[] bytes = new byte[1024];
        int length = 0;
        while((length = in.read(bytes)) != -1){
            baos.write(bytes, 0, length);
        }
        byte[] outputBytes = baos.toByteArray();
        final ByteArrayInputStream bais
             = new ByteArrayInputStream(outputBytes);
        return bais;
    }
}