/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.invoker;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link JMXMBeanCallInvokerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see JMXMBeanCallInvokerService
 */
public interface JMXMBeanCallInvokerServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * javax.management.MBeanServerConnectionJNDĨftHglB<p>
     */
    public static final String DEFAULT_JMX_RMI_ADAPTOR_NAME = "jmx/invoker/RMIAdaptor";
    
    /**
     * javax.management.MBeanServerConnectionJNDIlookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JndiFinderT[rX̃T[rX
     */
    public void setJndiFinderServiceName(ServiceName name);
    
    /**
     * javax.management.MBeanServerConnectionJNDIlookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rX擾B<p>
     *
     * @return JndiFinderT[rX̃T[rX
     */
    public ServiceName getJndiFinderServiceName();
    
    /**
     * javax.management.MBeanServerConnectionJNDIݒ肷B<p>
     * ftHǵA{@link #DEFAULT_JMX_RMI_ADAPTOR_NAME}B<br>
     *
     * @param name javax.management.MBeanServerConnectionJNDI
     */
    public void setRMIAdaptorName(String name);
    
    /**
     * javax.management.MBeanServerConnectionJNDI擾B<p>
     *
     * @return javax.management.MBeanServerConnectionJNDI
     */
    public String getRMIAdaptorName();
    
    /**
     * JMX API RlN^T[o[̃AhXݒ肷B<p>
     *
     * @param url JMX API RlN^T[o[̃AhX
     */
    public void setServiceURL(String url);
    
    /**
     * JMX API RlN^T[o[̃AhX擾B<p>
     *
     * @return JMX API RlN^T[o[̃AhX
     */
    public String getServiceURL();
    
    /**
     * JMX API RlN^ڑ̊m@t鑮̃Zbgݒ肷B<p>
     *
     * @param env ̃Zbg
     */
    public void setJMXConnectorEnvironment(Map<String, ?> env);
    
    /**
     * JMX API RlN^ڑ̊m@t鑮̃Zbg擾B<p>
     *
     * @return ̃Zbg
     */
    public Map<String, ?> getJMXConnectorEnvironment();
    
    /**
     * ĂяoMBeanJMXIuWFNgݒ肷B<p>
     *
     * @param name JMXIuWFNg
     */
    public void setObjectName(String name);
    
    /**
     * ĂяoMBeanJMXIuWFNg擾B<p>
     *
     * @return JMXIuWFNg
     */
    public String getObjectName();
    
    /**
     * ĂяoMBeanJMXhCݒ肷B<p>
     * {@link #setObjectName(String)}ݒ肵Ăꍇ́AsvB<br>
     *
     * @param domain JMXhC
     */
    public void setObjectNameDomain(String domain);
    
    /**
     * ĂяoMBeanJMXhC擾B<p>
     *
     * @return JMXhC
     */
    public String getObjectNameDomain();
    
    /**
     * ĂяoMBeanJMXIuWFNg̃vpeBݒ肷B<p>
     * {@link #setObjectName(String)}ݒ肵Ăꍇ́AsvB<br>
     *
     * @param prop JMXIuWFNg̃vpeB
     */
    public void setObjectNameProperties(Map<String,String> prop);
    
    /**
     * ĂяoMBeanJMXIuWFNg̃vpeB擾B<p>
     *
     * @return JMXIuWFNg̃vpeB
     */
    public Map<String,String> getObjectNameProperties();
    
    /**
     * ĂяoMBeanJMXIuWFNg肷邽߂̃NG[ݒ肷B<p>
     * 
     * @param query NG[
     */
    public void setMBeanQuery(String query);
    
    /**
     * ĂяoMBeanJMXIuWFNg肷邽߂̃NG[擾B<p>
     * 
     * @return NG[
     */
    public String getMBeanQuery();
    
    /**
     * ĂяoMBeanJMXIuWFNg肷邽߂̐K\ݒ肷B<p>
     * 
     * @param regex K\
     */
    public void setObjectNameRegex(String regex);
    
    /**
     * ĂяoMBeanJMXIuWFNg肷邽߂̐K\擾B<p>
     * 
     * @return K\
     */
    public String getObjectNameRegex();

}
