/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.ftp;

import java.io.File;

/**
 * FTPNCAgB<p>
 *
 * @author M.Takata
 */
public interface FTPClient{
    
    /**
     * T[oɐڑB<p>
     *
     * @param host ڑT[õzXg
     * @exception FTPException T[oƂ̐ڑɎsꍇ
     */
    public void connect(String host) throws FTPException;
    
    /**
     * T[oɐڑB<p>
     *
     * @param host ڑT[õzXg
     * @param port ڑT[õ|[gԍ
     * @exception FTPException T[oƂ̐ڑɎsꍇ
     */
    public void connect(String host, int port) throws FTPException;
    
    /**
     * T[oɐڑB<p>
     *
     * @param host ڑT[õzXg
     * @param port ڑT[õ|[gԍ
     * @param localAddr NCAg̃AhX
     * @param localPort NCAg̃|[gԍ
     * @exception FTPException T[oƂ̐ڑɎsꍇ
     */
    public void connect(
        String host,
        int port,
        String localAddr,
        int localPort
    ) throws FTPException;
    
    /**
     * OCB<p>
     *
     * @param user [U
     * @param password pX[h
     * @exception FTPException OCɎsꍇ
     */
    public void login(String user, String password) throws FTPException;
    
    /**
     * OAEgB<p>
     * 
     * @exception FTPException OAEgɎsꍇ
     */
    public void logout() throws FTPException;
    
    /**
     * T[õt@Cꗗ擾B<p>
     * 
     * @return t@C̔z
     * @exception FTPException 擾Ɏsꍇ
     */
    public String[] ls() throws FTPException;
    
    /**
     * T[o̎w肳ꂽfBNg̃t@Cꗗ擾B<p>
     * 
     * @return t@C̔z
     * @exception FTPException 擾Ɏsꍇ
     */
    public String[] ls(String path) throws FTPException;
    
    /**
     * T[oł̃JgfBNg擾B<p>
     * 
     * @return JgfBNg̃pX
     * @exception FTPException 擾Ɏsꍇ
     */
    public String pwd() throws FTPException;
    
    /**
     * NCAgł̃JgfBNg擾B<p>
     * 
     * @return JgfBNg
     * @exception FTPException 擾Ɏsꍇ
     */
    public File lpwd() throws FTPException;
    
    /**
     * T[oł̃JgfBNgw肳ꂽpXɈړB<p>
     * 
     * @param path ړ̃pX
     * @exception FTPException ړɎsꍇ
     */
    public void cd(String path) throws FTPException;
    
    /**
     * NCAgł̃JgfBNgw肳ꂽpXɈړB<p>
     * 
     * @param path ړ̃pX
     * @exception FTPException ړɎsꍇ
     */
    public void lcd(String path) throws FTPException;
    
    /**
     * T[oŎw肳ꂽfBNg쐬B<p>
     * 
     * @param dir 쐬fBNg̃pX
     * @exception FTPException 쐬Ɏsꍇ
     */
    public void mkdir(String dir) throws FTPException;
    
    /**
     * T[oŎw肳ꂽt@C̃t@CύXB<p>
     * 
     * @param from ύXΏۂ̃t@C̃pX
     * @param to ύX̃t@C
     * @exception FTPException ύXɎsꍇ
     */
    public void rename(String from, String to) throws FTPException;
    
    /**
     * T[o̎w肳ꂽt@C擾B<p>
     * 
     * @param path 擾t@C̃pX
     * @return 擾t@C
     * @exception FTPException 擾Ɏsꍇ
     */
    public File get(String path) throws FTPException;
    
    /**
     * T[o̎w肳ꂽt@CAw肳ꂽÕt@CƂĎ擾B<p>
     * 
     * @param remote 擾t@C̃pX
     * @param local 擾̃t@C
     * @return 擾t@C
     * @exception FTPException 擾Ɏsꍇ
     */
    public File get(String remote, String local) throws FTPException;
    
    /**
     * T[o̎w肳ꂽSẴt@C擾B<p>
     * 
     * @param path 擾t@C̃pX
     * @return 擾t@Cz
     * @exception FTPException 擾Ɏsꍇ
     */
    public File[] mget(String path) throws FTPException;
    
    /**
     * T[oɎw肳ꂽt@C]B<p>
     * 
     * @param path ]t@C̃pX
     * @exception FTPException ]Ɏsꍇ
     */
    public void put(String path) throws FTPException;
    
    /**
     * T[oɎw肳ꂽt@CAw肳ꂽt@Cœ]B<p>
     * 
     * @param local ]t@C̃pX
     * @param remote ]ł̃t@C
     * @exception FTPException ]Ɏsꍇ
     */
    public void put(String local, String remote) throws FTPException;
    
    /**
     * T[oɎw肳ꂽSẴt@C]B<p>
     * 
     * @param path ]t@C̃pX
     * @exception FTPException ]Ɏsꍇ
     */
    public void mput(String path) throws FTPException;
    
    /**
     * T[o̎w肳ꂽt@C폜B<p>
     * 
     * @param path 폜t@C̃pX
     * @exception FTPException 폜Ɏsꍇ
     */
    public void delete(String path) throws FTPException;
    
    /**
     * T[o̎w肳ꂽSẴt@C폜B<p>
     * 
     * @param path 폜t@C̃pX
     * @exception FTPException 폜Ɏsꍇ
     */
    public void mdelete(String path) throws FTPException;
    
    /**
     * ][hASCIIɕύXB<p>
     * 
     * @exception FTPException ύXɎsꍇ
     */
    public void ascii() throws FTPException;
    
    /**
     * ][hoCiɕύXB<p>
     * 
     * @exception FTPException ύXɎsꍇ
     */
    public void binary() throws FTPException;
    
    /**
     * ][hw肳ꂽ[hɕύXB<p>
     * Ŏw肷][h́AˑB<br>
     *
     * @param type ][h
     * @exception FTPException ύXɎsꍇ
     */
    public void setTransferType(int type) throws FTPException;
    
    /**
     * ݂̓][h擾B<p>
     *
     * @return ][h
     * @exception FTPException 擾Ɏsꍇ
     */
    public int getTransferType() throws FTPException;
    
    /**
     * ANeBuFTPɐ؂ւB<p>
     * 
     * @exception FTPException ύXɎsꍇ
     */
    public void active() throws FTPException;
    
    /**
     * pbVuFTPɐ؂ւB<p>
     * 
     * @exception FTPException ύXɎsꍇ
     */
    public void passive() throws FTPException;
    
    /**
     * T[oƂ̐ڑؒfB<p>
     * 
     * @exception FTPException ؒfɎsꍇ
     */
    public void close() throws FTPException;
}