/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link HttpClientFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see HttpClientFactoryService
 */
public interface HttpClientFactoryServiceMBean extends ServiceBaseMBean{
    
    public static final String JOURNAL_ACCESS = "Access";
    public static final String JOURNAL_ACCESS_EXCEPTION = "Exception";
    public static final String JOURNAL_REQUEST = "Request";
    public static final String JOURNAL_REQUEST_ACTION = "Action";
    public static final String JOURNAL_REQUEST_URI = "URI";
    public static final String JOURNAL_REQUEST_COOKIES = "Cookies";
    public static final String JOURNAL_REQUEST_HEADERS = "Headers";
    public static final String JOURNAL_REQUEST_PARAMS = "Parameters";
    public static final String JOURNAL_REQUEST_OBJECT = "InputObject";
    public static final String JOURNAL_REQUEST_BODY = "Body";
    public static final String JOURNAL_RESPONSE = "Response";
    public static final String JOURNAL_RESPONSE_STATUS = "Status";
    public static final String JOURNAL_RESPONSE_HEADERS = "Headers";
    public static final String JOURNAL_RESPONSE_BODY = "Body";
    public static final String JOURNAL_RESPONSE_OBJECT = "OutputObject";
    
    /**
     * HTTP̃\Pbgڑۂ̃^CAEgݒ肷B<p>
     *
     * @param millis ^CAEg[ms]
     */
    public void setConnectionTimeout(int millis);
    
    /**
     * HTTP̃\Pbgڑۂ̃^CAEg擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public int getConnectionTimeout();
    
    /**
     * HTTP̃\PbgꂽꍇɁA\PbgɎcĂf[^̑Mҋ@^CAEgݒ肷B<p>
     *
     * @param millis ^CAEg[ms]
     */
    public void setLinger(int millis);
    
    /**
     * HTTP̃\PbgꂽꍇɁA\PbgɎcĂf[^̑Mҋ@^CAEg擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public int getLinger();
    
    /**
     * HTTP̃\Pbg̎Mobt@TCYݒ肷B<p>
     *
     * @param size HTTP̃\Pbg̎Mobt@TCY
     */
    public void setReceiveBufferSize(int size);
    
    /**
     * HTTP̃\Pbg̎Mobt@TCY擾B<p>
     *
     * @return HTTP̃\Pbg̎Mobt@TCY
     */
    public int getReceiveBufferSize();
    
    /**
     * HTTP̃\Pbg̑Mobt@TCYݒ肷B<p>
     *
     * @param size HTTP̃\Pbg̑Mobt@TCY
     */
    public void setSendBufferSize(int size);
    
    /**
     * HTTP̃\Pbg̑Mobt@TCY擾B<p>
     *
     * @return HTTP̃\Pbg̑Mobt@TCY
     */
    public int getSendBufferSize();
    
    /**
     * HTTP̃\Pbg̎M^CAEgݒ肷B<p>
     *
     * @param millis HTTP̃\Pbg̎M^CAEg[ms]
     */
    public void setSoTimeout(int millis);
    
    /**
     * HTTP̃\Pbg̎M^CAEg擾B<p>
     *
     * @return HTTP̃\Pbg̎M^CAEg[ms]
     */
    public int getSoTimeout();
    
    /**
     * NGXg̃Reg^Cv擾B<p>
     *
     * @return Reg^Cv
     */
    public String getRequestContentType();
    
    /**
     * NGXg̃Reg^Cvݒ肷B<p>
     * HTTPNGXgɊɐݒ肳Ăꍇ́A炪D悳B<br>
     *
     * @param type Reg^Cv
     */
    public void setRequestContentType(String type);
    
    /**
     * NGXg̕GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getRequestCharacterEncoding();
    
    /**
     * NGXg̕GR[fBOݒ肷B<p>
     * HTTPNGXgɊɐݒ肳Ăꍇ́A炪D悳B<br>
     *
     * @param encoding GR[fBO
     */
    public void setRequestCharacterEncoding(String encoding);
    
    /**
     * HTTP̃o[W擾B<p>
     *
     * @return HTTP̃o[W
     */
    public String getHttpVersion();
    
    /**
     * HTTP̃o[Wݒ肷B<p>
     * HTTPNGXgɊɐݒ肳Ăꍇ́A炪D悳B<br>
     *
     * @param version HTTP̃o[W
     */
    public void setHttpVersion(String version);
    
    /**
     * NGXg̃wb_ݒ肷B<p>
     * HTTPNGXgɊɐݒ肳Ăꍇ́A炪D悳B<br>
     *
     * @param name wb_
     * @param values wb_l̔z
     */
    public void setRequestHeaders(String name, String[] values);
    
    /**
     * NGXg̃wb_擾B<p>
     *
     * @param name wb_
     * @return wb_l̔z
     */
    public String[] getRequestHeaders(String name);
    
    /**
     * vLṼzXgƃ|[gԍݒ肷B<p>
     *
     * @param proxy zXg:|[gԍ
     */
    public void setProxy(String proxy);
    
    /**
     * vLṼzXgƃ|[gԍ擾B<p>
     *
     * @return zXg:|[gԍ
     */
    public String getProxy();
    
    /**
     * [JAhXݒ肷B<p>
     *
     * @param address [JAhX
     * @exception java.net.UnknownHostException w肳ꂽAhXsȏꍇ
     */
    public void setLocalAddress(String address)
     throws java.net.UnknownHostException;
    
    /**
     * [JAhX擾B<p>
     *
     * @return [JAhX
     */
    public String getLocalAddress();
    
    /**
     * Jakarta HttpClient̃p[^ݒ肷B<p>
     *
     * @param name p[^
     * @param value l
     */
    public void setHttpClientParam(String name, Object value);
    
    /**
     * Jakarta HttpClient̃p[^擾B<p>
     *
     * @param name p[^
     * @return l
     */
    public Object getHttpClientParam(String name);
    
    /**
     * Jakarta HttpClient̃p[^̃}bv擾B<p>
     *
     * @return Jakarta HttpClient̃p[^̃}bv
     */
    public Map<String, Object> getHttpClientParamMap();
    
    /**
     * NGXg̃Xg[kꍇ臒l[byte]ݒ肷B<p>
     * ݒ肵Ȃꍇ́AXg[̃TCYɊւ炸kB<br>
     *
     * @param length 臒l[byte]
     */
    public void setRequestDeflateLength(int length);
    
    /**
     * NGXg̃Xg[kꍇ臒l[byte]擾B<p>
     *
     * @return 臒l[byte]
     */
    public int getRequestDeflateLength();
    
    /**
     * HTTPNGXgɐݒ肳ꂽ̓IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rXݒ肷B<p>
     * HTTPNGXgɊɐݒ肳Ăꍇ́A炪D悳B<br>
     *
     * @param name StreamConverterT[rX̃T[rX
     */
    public void setRequestStreamConverterServiceName(ServiceName name);
    
    /**
     * HTTPNGXgɐݒ肳ꂽ̓IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rX擾B<p>
     *
     * @return StreamConverterT[rX̃T[rX
     */
    public ServiceName getRequestStreamConverterServiceName();
    
    /**
     * HTTPX|X̃Xg[o̓IuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rXݒ肷B<p>
     * HTTPX|XɊɐݒ肳Ăꍇ́A炪D悳B<br>
     *
     * @param name StreamConverterT[rX̃T[rX
     */
    public void setResponseStreamConverterServiceName(ServiceName name);
    
    /**
     * HTTPX|X̃Xg[o̓IuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rX擾B<p>
     *
     * @return StreamConverterT[rX̃T[rX
     */
    public ServiceName getResponseStreamConverterServiceName();
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JournalT[rX̃T[rX
     */
    public void setJournalServiceName(ServiceName name);
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B<p>
     *
     * @return JournalT[rX̃T[rX
     */
    public ServiceName getJournalServiceName();
    
    /**
     * W[iɐݒ肷ʔԂ𔭍s{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SequenceT[rX̃T[rX
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * W[iɐݒ肷ʔԂ𔭍s{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rX擾B<p>
     *
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * W[iɐݒ肷ʔԂ擾{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * W[iɐݒ肷ʔԂ擾{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.http.HttpClient HttpClient}𐶐ۂɎgp{@link jp.ossc.nimbus.service.semaphore.Semaphore Semaphore}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SemaphoreT[rX̃T[rX
     */
    public void setSemaphoreServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.http.HttpClient HttpClient}𐶐ۂɎgp{@link jp.ossc.nimbus.service.semaphore.Semaphore Semaphore}T[rX̃T[rX擾B<p>
     *
     * @return SemaphoreT[rX̃T[rX
     */
    public ServiceName getSemaphoreServiceName();
    
    /**
     * org.apache.commons.httpclient.HttpConnectionManager̃NXݒ肷B<p>
     *
     * @param clazz HttpConnectionManager̃NX
     */
    public void setHttpConnectionManagerClass(Class<?> clazz);
    
    /**
     * org.apache.commons.httpclient.HttpConnectionManager̃NX擾B<p>
     *
     * @return HttpConnectionManager̃NX
     */
    public Class<?> getHttpConnectionManagerClass();
    
    /**
     * W[i{@link jp.ossc.nimbus.service.http.HttpResponse#getObject()}o͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇAtrue
     */
    public void setOutputJournalResponseObject(boolean isOutput);
    
    /**
     * W[i{@link jp.ossc.nimbus.service.http.HttpResponse#getObject()}o͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean isOutputJournalResponseObject();
}