/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link ByteArrayJournalEditorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ByteArrayJournalEditorService
 */
public interface ByteArrayJournalEditorServiceMBean extends ServiceBaseMBean{
    
    /**
     * 16iɕϊ郂[hB<p>
     */
    public static final String CONVERT_HEX = "HEX";
    
    /**
     * 10iɕϊ郂[hB<p>
     */
    public static final String CONVERT_DECIMAL = "DECIMAL";
    
    /**
     * 8iɕϊ郂[hB<p>
     */
    public static final String CONVERT_OCTAL = "OCTAL";
    
    /**
     * oCgɕϊ郂[hB<p>
     */
    public static final String CONVERT_LENGTH = "LENGTH";
    
    /**
     * ϊ[hݒ肷B<p>
     * 8iA10iA16i[hyсAGR[hϊ[hwłB<br>
     * GR[hϊw肷ꍇ́AϊGR[hAϊ[hƂĎw肷B<br>
     *
     * @param mode ϊ[h
     * @exception java.io.UnsupportedEncodingException w肳ꂽGR[hT|[gĂȂꍇ
     * @see #CONVERT_HEX
     * @see #CONVERT_DECIMAL
     * @see #CONVERT_OCTAL
     * @see #CONVERT_LENGTH
     */
    public void setConvertMode(String mode) throws java.io.UnsupportedEncodingException;
    
    /**
     * ϊ[h擾B<p>
     *
     * @return ϊ[h
     */
    public String getConvertMode();
    
    public void setMaxArraySize(int max);
    public int getMaxArraySize();
}