/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.LinkedHashMap;

import jp.ossc.nimbus.service.journal.EditorFinder;
import jp.ossc.nimbus.service.journal.JournalInfo;
import jp.ossc.nimbus.service.journal.JournalRecord;

/**
 * {@link JournalRecord}MapIuWFNgɕҏWW[iGfB^[B<p>
 *
 * @author M.Takata
 */
public class JournalRecordMapJournalEditorService extends MapJournalEditorServiceBase implements JournalRecordMapJournalEditorServiceMBean{
    
    private static final long serialVersionUID = 932456129763089688L;
    private String[] secretJournalInfos;
    private Set<String> secretJournalInfoSet;
    private String[] enabledJournalInfos;
    private Set<String> enabledJournalInfoSet;
    private String[] disabledJournalInfos;
    private Set<String> disabledJournalInfoSet;
    
    @Override
    public void setSecretJournalInfos(String[] keys){
        secretJournalInfos = keys;
    }
    
    @Override
    public String[] getSecretJournalInfos(){
        return secretJournalInfos;
    }
    
    @Override
    public void setEnabledJournalInfos(String[] keys){
        enabledJournalInfos = keys;
    }
    
    @Override
    public String[] getEnabledJournalInfos(){
        return enabledJournalInfos;
    }
    
    @Override
    public void setDisabledJournalInfos(String[] keys){
        disabledJournalInfos = keys;
    }
    
    @Override
    public String[] getDisabledJournalInfos(){
        return disabledJournalInfos;
    }
    
    @Override
    public void createService(){
        secretJournalInfoSet = new HashSet<String>();
        enabledJournalInfoSet = new HashSet<String>();
        disabledJournalInfoSet = new HashSet<String>();
    }
    
    @Override
    public void startService(){
        if(secretJournalInfos != null){
            for(int i = 0; i < secretJournalInfos.length; i++){
                secretJournalInfoSet.add(secretJournalInfos[i]);
            }
        }
        if(enabledJournalInfos != null){
            for(int i = 0; i < enabledJournalInfos.length; i++){
                enabledJournalInfoSet.add(enabledJournalInfos[i]);
            }
        }
        if(disabledJournalInfos != null){
            for(int i = 0; i < disabledJournalInfos.length; i++){
                disabledJournalInfoSet.add(disabledJournalInfos[i]);
            }
        }
    }
    
    @Override
    public void stopService(){
        secretJournalInfoSet.clear();
        enabledJournalInfoSet.clear();
        disabledJournalInfoSet.clear();
    }
    
    @Override
    public void destroyService(){
        secretJournalInfoSet = null;
        enabledJournalInfoSet = null;
        disabledJournalInfoSet = null;
    }
    
    @Override
    protected Map<String, Object> toMap(EditorFinder finder, String key, Object value){
        JournalRecord record = (JournalRecord)value;
        final Map<String, Object> result = new LinkedHashMap<String, Object>();
        putMap(result, REQUEST_ID_KEY, record.getRequestId());
        if(isOutputMapKey(START_TIME_KEY)){
            putMap(result, START_TIME_KEY, isSecretMapKey(START_TIME_KEY) ? null : makeObjectFormat(finder, null, record.getStartTime()));
        }
        if(isSecretMapKey(INFO_KEY)){
            putMap(result, INFO_KEY, null);
        }else if(isOutputMapKey(INFO_KEY)){
            List<JournalInfo> infos = record.getInfos();
            if(infos != null && infos.size() != 0){
                Map<String, List<Object>> infoMap = null;
                for(int i = 0, imax = infos.size(); i < imax; i++){
                    JournalInfo info = infos.get(i);
                    final String infoKey = info.getKey();
                    if(!disabledJournalInfoSet.isEmpty()
                            && disabledJournalInfoSet.contains(infoKey)){
                           continue;
                       }
                    if(!enabledJournalInfoSet.isEmpty()
                         && !enabledJournalInfoSet.contains(infoKey)){
                        continue;
                    }
                    if(infoMap == null){
                        infoMap = new LinkedHashMap<String, List<Object>>();
                    }
                    List<Object> infoList = infoMap.get(infoKey);
                    if(infoList == null){
                        infoList = new ArrayList<Object>();
                        infoMap.put(infoKey, infoList);
                    }
                    if(!secretJournalInfoSet.isEmpty()
                         && secretJournalInfoSet.contains(infoKey)){
                        infoList.add(getSecretString());
                    }else{
                        Object infoObj = info.toObject(finder);
                        infoList.add(infoObj);
                    }
                }
                if(infoMap != null){
                    putMap(result, INFO_KEY, infoMap);
                }
            }
        }
        if(isOutputMapKey(END_TIME_KEY)){
            putMap(result, END_TIME_KEY, isSecretMapKey(END_TIME_KEY) ? null : makeObjectFormat(finder, null, record.getEndTime()));
        }
        putMap(result, PERFORMANCE_KEY, new Long(record.getEndTime().getTime() - record.getStartTime().getTime()));
        return result;
    }
}