/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.message;

import java.util.Locale;

/**
 * bZ[WR[hC^[tFCXB<p>
 *
 * @author H.Nakano
 */
public interface MessageRecordFactory{
    
    /**
     * w肵bZ[WID̃bZ[WR[h擾B<p>
     *
     * @param messageId bZ[WID
     * @return bZ[WR[h
     */
    public MessageRecord findMessageRecord(String messageId);
    
    /**
     * w肵bZ[WID̃ev[gbZ[W擾B<p>
     * ev[gbZ[Wɂ́Aߍ݃bZ[W̃L[[ĥ܂܊܂܂B<br>
     *
     * @param messageId bZ[WID
     * @return ev[gbZ[W
     */
    public String findMessageTemplete(String messageId);
    
    /**
     * w肵bZ[WID̎w胍P[ev[gbZ[W擾B<p>
     * ev[gbZ[Wɂ́Aߍ݃bZ[W̃L[[ĥ܂܊܂܂B<br>
     *
     * @param messageId bZ[WID
     * @param lo P[
     * @return w胍P[ev[gbZ[W
     */
    public String findMessageTemplete(String messageId, Locale lo);
    
    /**
     * w肵bZ[WID̃bZ[W擾B<p>
     *
     * @param messageId bZ[WID
     * @param embeds ߍ݃p[^z
     * @return bZ[W
     */
    public String findMessage(String messageId, Object... embeds);
    
    /**
     * w肵bZ[WID̎w胍P[bZ[W擾B<p>
     *
     * @param messageId bZ[WID
     * @param lo P[
     * @param embeds ߍ݃p[^z
     * @return bZ[W
     */
    public String findMessage(String messageId, Locale lo, Object... embeds);
    
    /**
     * w肵P[̃bZ[WR[hǂݍށB<p>
     * 
     * @param lo P[
     */
    public void findLocale(Locale lo);
}
