/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.queue;

import java.io.*;

import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.lang.IllegalServiceStateException;

/**
 * xQueueT[rXB<p>
 *
 * @author M.Takata
 */
public class DelayQueueService<E> extends DefaultQueueService<E>
 implements DelayQueueServiceMBean, Serializable{
    
    private static final long serialVersionUID = 4071276435068575666L;
    
    private long delayTime = -1;
    
    private boolean isDelay = true;
    
    // DelayQueueServiceMBean JavaDoc
    public void setDelayTime(long millis){
        delayTime = millis;
    }
    // DelayQueueServiceMBean JavaDoc
    public long getDelayTime(){
        return delayTime;
    }
    
    // DelayQueueServiceMBean JavaDoc
    public boolean isDelay(){
        return isDelay;
    }
    // DelayQueueServiceMBean JavaDoc
    public void setDelay(boolean isDelay){
        boolean isChangeNoDelay = this.isDelay && !isDelay;
        this.isDelay = isDelay;
        
        if(isChangeNoDelay){
            peekMonitor.notifyAllMonitor();
            if(isSafeGetOrder){
                getMonitor.notifyMonitor();
            }else{
                getMonitor.notifyAllMonitor();
            }
        }
    }
    
    @SuppressWarnings("unchecked")
    protected  void pushElement(Object element){
        if(getState() != State.STARTED || fourceEndFlg){
            throw new IllegalServiceStateException(this);
        }
        if(!(element instanceof QueueElement<?>)){
            element = new QueueElement<Object>(element);
        }
        if(maxThresholdSize > 0
             && (pushMonitor.isWait()
                    || (size() >= maxThresholdSize))
             && !fourceEndFlg
        ){
            try{
                pushMonitor.initAndWaitMonitor();
            }catch(InterruptedException e){
                return;
            }finally{
                pushMonitor.releaseMonitor();
            }
        }
        
        if(cache == null){
            queueElements.add(element);
        }else{
            final CachedReference<Object> ref = cache.add(element);
            if(ref != null){
                ref.addCacheRemoveListener(this);
                queueElements.add(ref);
            }else{
                queueElements.add(element);
            }
        }
        int size = size();
        if(size > maxDepth){
            maxDepth = size;
        }
        count++;
        countDelta++;
        lastPushedTime = System.currentTimeMillis();
        
        peekMonitor.notifyAllMonitor();
        if(getMonitor.isWait()){
            long waitTime = 0;
            if(isDelay){
                QueueElement<E> firstElement
                     = (QueueElement<E>)getQueueElement(false);
                waitTime = delayTime - (System.currentTimeMillis() - firstElement.pushTime);
            }
            if(!isDelay || waitTime <= 0){
                if(isSafeGetOrder){
                    getMonitor.notifyMonitor();
                }else{
                    getMonitor.notifyAllMonitor();
                }
            }
        }
        if(pushMonitor.isWait() && size() < maxThresholdSize){
            pushMonitor.notifyMonitor();
        }
    }
    
    @SuppressWarnings("unchecked")
    protected E getQueueElement(long timeOutMs, boolean isRemove){
        if(delayTime <= 0 || !isDelay){
            return super.getQueueElement(timeOutMs, isRemove);
        }
        long processTime = 0;
        try{
            if(isRemove){
                getMonitor.initMonitor();
            }else{
                peekMonitor.initMonitor();
            }
            // IłȂꍇ
            while(!fourceEndFlg){
                
                long curSleepTime = 0;
                
                // L[ɗ܂Ăꍇ
                if(size() > 0){
                    // QƂ邾̏ꍇ
                    // ܂́ÃXbhԍŏɑ҂Ăꍇ
                    if(!isRemove
                        || !isSafeGetOrder
                        || getMonitor.isFirst()
                    ){
                        // ŏ̗vfQƂ
                        QueueElement<E> firstElement
                             = (QueueElement<E>)getQueueElement(false);
                        final long currentTime = System.currentTimeMillis();
                        curSleepTime = delayTime - (currentTime - firstElement.pushTime);
                        
                        // xԂ߂Ăꍇ
                        if(!isDelay || curSleepTime <= 0){
                            // L[擾
                            final QueueElement<E> element = (QueueElement<E>)getQueueElement(isRemove);
                            getMonitor.releaseMonitor();
                            
                            // QƂł͂ȂAL[ɗ܂ĂāA
                            // ɑ҂ĂXbhꍇ
                            if(isRemove && size() > 0 && getMonitor.isWait()){
                                if(isSafeGetOrder){
                                    getMonitor.notifyMonitor();
                                }else{
                                    getMonitor.notifyAllMonitor();
                                }
                            }
                            if(isRemove){
                                if(pushMonitor.isWait() && size() < maxThresholdSize){
                                    pushMonitor.notifyMonitor();
                                }
                                return element == null ? null : element.rawElement;
                            }
                        }
                        // QƂł͂ȂÃXbhOɑ҂ĂXbhꍇ
                        else if(getMonitor.isWait()){
                            // ԍŏɑ҂ĂXbhN
                            getMonitor.notifyMonitor();
                        }
                    }
                }
                
                // L[ɗ܂ĂȂꍇ
                // ܂́ÃXbhOɑ҂ĂXbhꍇ
                if(curSleepTime == 0){
                    curSleepTime = timeOutMs >= 0 ? timeOutMs - processTime : sleepTime;
                }else{
                    curSleepTime = Math.min(curSleepTime, timeOutMs >= 0 ? timeOutMs - processTime : sleepTime);
                }
                
                // I܂̓^CAEg̏ꍇ
                if(fourceEndFlg || timeOutMs == 0 || (timeOutMs > 0 && timeOutMs <= processTime)){
                    break;
                }
                
                // ^CAEgw肪ꍇ́A^CAEg܂sleep
                // ^CAEgw肪Ȃꍇ́AsleepTimesleepĂ݂
                long proc = 0;
                if(timeOutMs >= 0){
                    proc = System.currentTimeMillis();
                }
                try{
                    if(curSleepTime > 0){
                        long waitTime = 0;
                        if(size() != 0 && isDelay){
                            QueueElement<E> firstElement
                                 = (QueueElement<E>)getQueueElement(false);
                            waitTime = delayTime - (System.currentTimeMillis() - firstElement.pushTime);
                        }
                        if(size() == 0
                            || !isRemove
                            || (isSafeGetOrder && !getMonitor.isFirst())
                            || waitTime > 0
                        ){
                            getMonitor.initAndWaitMonitor(curSleepTime);
                        }
                    }
                }catch(InterruptedException e){
                    return null;
                }
                if(timeOutMs >= 0){
                    proc = System.currentTimeMillis() - proc;
                    processTime += proc;
                }
            }
            
            // Ȉꍇ
            if(fourceEndFlg){
                final QueueElement<E> element = (QueueElement<E>)getQueueElement(isRemove);
                return element == null ? null : element.rawElement;
            }
            // ^CAEg̏ꍇ
            else{
                if(isRemove
                    && size() > 0
                    && getMonitor.isWait()
                ){
                    long waitTime = 0;
                    if(isDelay){
                        QueueElement<E> firstElement
                             = (QueueElement<E>)getQueueElement(false);
                        waitTime = delayTime - (System.currentTimeMillis() - firstElement.pushTime);
                    }
                    if(!isDelay || waitTime <= 0){
                        if(isSafeGetOrder){
                            getMonitor.notifyMonitor();
                        }else{
                            getMonitor.notifyAllMonitor();
                        }
                    }
                }
                
                return null;
            }
        }finally{
            if(isRemove){
                getMonitor.releaseMonitor();
            }else{
                peekMonitor.releaseMonitor();
            }
        }
    }
    
    public static class QueueElement<E> implements Serializable{
        
        private static final long serialVersionUID = 3734646743111972208L;
        
        public E rawElement;
        public long pushTime;
        
        public QueueElement(E element){
            this(element, System.currentTimeMillis());
        }
        
        public QueueElement(E element, long time){
            rawElement = element;
            pushTime = time;
        }
    }
}