/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import java.util.*;

/**
 * o̓R[hB<p>
 * {@link WritableElement}𕡐ȀyуL[Ƃ̃}bsOB<br>
 * 
 * @author Y.Tokuda
 */
public class WritableRecord implements java.io.Serializable{
    
    private static final long serialVersionUID = 7030165706406015562L;
    
    //oϐ
    protected Map<Object, WritableElement> elements;
    
    /**
     * ̃CX^X𐶐B<p>
     */
    public WritableRecord(){
        elements = new LinkedHashMap<Object, WritableElement>();
    }
    
    /**
     * vfǉB<p>
     *
     * @param elem vf
     */
    public void addElement(WritableElement elem){
        elements.put(elem.getKey() == null ? elem : elem.getKey(), elem);
    }
    
    /**
     * vf̃Xg擾B<p>
     *
     * @return WritableElementList
     */
    public List<WritableElement> getElements(){
        return new ArrayList<WritableElement>(elements.values());
    }
    
    /**
     * vf̃}bsO擾B<p>
     *
     * @return WritableElement̃}bsO
     */
    public Map<Object, WritableElement> getElementMap(){
        return elements;
    }
    
    /**
     * vf̕\擾B<p>
     * {@link WritableElement}ǉꂽŁAeWritableElement{@link WritableElement#toString()}ĂяoAԂB<br>
     *
     * @return \
     */
    public String toString(){
        final StringBuilder ret = new StringBuilder();
        for(WritableElement element : elements.values()){
            ret.append(element.toString());
        }
        return ret.toString();
    }
}
