/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer.db;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link DatabaseMessageWriterService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DatabaseMessageWriterService
 */
public interface DatabaseMessageWriterServiceMBean
 extends ServiceBaseMBean, jp.ossc.nimbus.service.writer.MessageWriter{
    
    /**
     * {@link jp.ossc.nimbus.service.connection.ConnectionFactory ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.connection.ConnectionFactory ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * INSERTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsOݒ肷B<p>
     * ȉ̃tH[}bgŎw肷B<br>
     * INSERTPreparedStatementpSQL=ߍ݃p[^̃L[,c<br>
     * Eӂ̖ߍ݃p[^̃L[Ƃ́A{@link DatabaseMessageWriterService#write(jp.ossc.nimbus.service.writer.WritableRecord)}\bh̓͂œn{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}Ɋi[Ă{@link jp.ossc.nimbus.service.writer.WritableElement WritableElement}̃L[łB<br>
     * <pre>
     * F
     *   insert into log_table(id, message) values(?, ?)=ID,MESSAGE
     * </pre>
     *
     * @param sqls INSERTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public void setInsertSQL(Map<String, String> sqls);
    
    /**
     * INSERTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO擾B<p>
     *
     * @return INSERTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public Map<String, String> getInsertSQL();
    
    /**
     * UPDATEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsOݒ肷B<p>
     * ȉ̃tH[}bgŎw肷B<br>
     * UPDATEPreparedStatementpSQL=ߍ݃p[^̃L[,c<br>
     * Eӂ̖ߍ݃p[^̃L[Ƃ́A{@link DatabaseMessageWriterService#write(jp.ossc.nimbus.service.writer.WritableRecord)}\bh̓͂œn{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}Ɋi[Ă{@link jp.ossc.nimbus.service.writer.WritableElement WritableElement}̃L[łB<br>
     * <pre>
     * F
     *   update log_table set message=? where id=?=MESSAGE,ID
     * </pre>
     *
     * @param sqls UPDATEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public void setUpdateSQL(Map<String, String> sqls);
    
    /**
     * UPDATEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO擾B<p>
     *
     * @return UPDATEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public Map<String, String> getUpdateSQL();
    
    /**
     * DELETEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsOݒ肷B<p>
     * ȉ̃tH[}bgŎw肷B<br>
     * DELETEPreparedStatementpSQL=ߍ݃p[^̃L[,c<br>
     * Eӂ̖ߍ݃p[^̃L[Ƃ́A{@link DatabaseMessageWriterService#write(jp.ossc.nimbus.service.writer.WritableRecord)}\bh̓͂œn{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}Ɋi[Ă{@link jp.ossc.nimbus.service.writer.WritableElement WritableElement}̃L[łB<br>
     * <pre>
     * F
     *   delete from log_table where id=?=ID
     * </pre>
     *
     * @param sqls DELETEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public void setDeleteSQL(Map<String, String> sqls);
    
    /**
     * DELETEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO擾B<p>
     *
     * @return DELETEPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public Map<String, String> getDeleteSQL();
    
    /**
     * SELECTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsOݒ肷B<p>
     * ȉ̃tH[}bgŎw肷B<br>
     * SELECTPreparedStatementpSQL=ߍ݃p[^̃L[,c<br>
     * Eӂ̖ߍ݃p[^̃L[Ƃ́A{@link DatabaseMessageWriterService#write(jp.ossc.nimbus.service.writer.WritableRecord)}\bh̓͂œn{@link jp.ossc.nimbus.service.writer.WritableRecord WritableRecord}Ɋi[Ă{@link jp.ossc.nimbus.service.writer.WritableElement WritableElement}̃L[łB<br>
     * <pre>
     * F
     *   select count(*) from log_table where id=?=ID
     * </pre>
     * Ŏw肷SELECŤʂ́AR[hłȂ΂ȂȂB<br>
     * ܂ASELECT́AINSERTƁAUPDATE܂DELETEݒ肳Ăꍇ̂ݗLłB<br>
     * SELECTINSERTݒ肳Ăꍇ́ASELECŤʂ0̎INSERTB<br>
     * SELECTUPDATEݒ肳Ăꍇ́ASELECŤʂ0łȂUPDATEB<br>
     * SELECTDELETEݒ肳Ăꍇ́ASELECŤʂ0łȂDELETEB<br>
     * SELECTƁAINSERTAUPDATEݒ肳Ăꍇ́ASELECŤʂ0̎INSERTA0łȂUPDATEB<br>
     * SELECTƁAINSERTADELETEݒ肳Ăꍇ́ASELECŤʂ0̎INSERTA0łȂDELETEINSERTB<br>
     *
     * @param sqls SELECTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public void setSelectSQL(Map<String, String> sqls);
    
    /**
     * SELECTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO擾B<p>
     *
     * @return SELECTPreparedStatementpSQLƖߍ݃p[^̃L[Ƃ̃}bsO
     */
    public Map<String, String> getSelectSQL();
    
    /**
     * SQLob`sۂ̃obt@TCYݒ肷B<p>
     * ftHǵA0Ńob`sȂB<br>
     * 0ȏ̒lw肷ƁÃTCYA{@link DatabaseMessageWriterService#write(jp.ossc.nimbus.service.writer.WritableRecord)}\bȟĂяoe𗭂ߍ݁ASQLob`sB<br>
     * 
     * @param size obt@TCY
     */
    public void setBufferSize(int size);
    
    /**
     * SQLob`sۂ̃obt@TCY擾B<p>
     * 
     * @return obt@TCY
     */
    public int getBufferSize();
    
    /**
     * SQLob`sۂ̃^CAEgݒ肷B<p>
     * ftHǵA0Ń^CAEgȂB<br>
     * 0ȏ̒lw肷ƁA{@link DatabaseMessageWriterService#write(jp.ossc.nimbus.service.writer.WritableRecord)}\bhŌɌĂяoꂽw肳ꂽԂo߂ƁA܂Ăob`SQL̐Ɋւ炸SQLob`sB<br>
     * AA{@link #setBufferSize(int)}0ȏ̒liob`sLɂȂljݒ肳ĂȂꍇ́A̐ݒ͖łB<br>
     * 
     * @param timeout ^CAEg[ms]
     */
    public void setBufferTimeout(long timeout);
    
    /**
     * SQLob`sۂ̃^CAEg擾B<p>
     * 
     * @return ^CAEg[ms]
     */
    public long getBufferTimeout();
    
    /**
     * R~bg邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAR~bg
     */
    public boolean isAutoCommit();
    
    /**
     * R~bg邩ǂݒ肷B<p>
     * AA{@link #setBufferSize(int)}ɗLȒlݒ肵Ăꍇ́AʃXbhŃob`s邽߁ȂɊւ炸AIɃR~bgB<br>
     * ftHǵAtrueB<br>
     *
     * @return R~bgꍇAtrue
     */
    public void setAutoCommit(boolean isAuto);
}
