/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beanflow.BeanFlowFactory;
import jp.ossc.nimbus.service.beanflow.BeanFlow;
import jp.ossc.nimbus.service.beanflow.BeanFlowException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;

/**
 * BeanFlowsT[ubgB<p>
 * GETyPOSTHTTPNGXg󂯕tāANGXgpXɉANVBeanFlowĂяoB<br>
 * ܂ANGXǧ؂sBeanFlowpӂĂ΁AOɂBeanFlowĂяoA؃G[̏ꍇ́AANVBeanFlow͌ĂяoȂB<br>
 * <p>
 * NGXgƃX|X̕ϊsC^[Zv^Ƒgݍ킹鎖ŁAC^[Zv^ϊāANGXg̑ɐݒ肵̓IuWFNg{@link BeanFlowServletContext}ɐݒ肵BeanFlowւƓnłB<br>
 * ܂ABeanFlow{@link BeanFlowServletContext#setOutput(Object)}ĂяoAo̓IuWFNgݒ肵ĕԂƁAo̓IuWFNgNGXgɐݒ肵AϊC^[Zv^ɓnB<br>
 * <p>
 * ȉɁAT[ubgweb.xml`B<br>
 * <pre>
 * &lt;servlet&gt;
 *     &lt;servlet-name&gt;BeanFlowServlet&lt;/servlet-name&gt;
 *     &lt;servlet-class&gt;jp.ossc.nimbus.servlet.BeanFlowServlet&lt;/servlet-class&gt;
 *     &lt;init-param&gt;
 *         &lt;param-name&gt;Validate&lt;/param-name&gt;
 *         &lt;param-value&gt;true&lt;/param-value&gt;
 *     &lt;/init-param&gt;
 * &lt;/servlet&gt;
 * 
 * &lt;servlet-mapping&gt;
 *     &lt;servlet-name&gt;BeanFlowServlet&lt;/servlet-name&gt;
 *     &lt;url-pattern&gt;*.bf&lt;/url-pattern&gt;
 * &lt;/servlet-mapping&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class BeanFlowServlet extends HttpServlet{
    
    private static final long serialVersionUID = -5548272719656324613L;
    
    /**
     * BeanFlowSelectorT[rX̏p[^B<p>
     */
    public static final String INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME = "BeanFlowSelectorServiceName";
    
    /**
     * BeanFlowFactoryT[rX̏p[^B<p>
     */
    public static final String INIT_PARAM_NAME_BEAN_FLOW_FACTORY_SERVICE_NAME = "BeanFlowFactoryServiceName";
    
    /**
     * BeanFlowstȌp[^B<p>
     */
    public static final String INIT_PARAM_NAME_VALIDATE = "Validate";
    
    /**
     * BeanFlow̑Oȕp[^B<p>
     */
    public static final String INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX = "ValidateFlowPrefix";
    
    /**
     * ̓IuWFNg̃NGXg̏p[^B<p>
     */
    public static final String INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME = "InputAttributeName";
    
    /**
     * o̓IuWFNg̃NGXg̏p[^B<p>
     */
    public static final String INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME = "OutputAttributeName";
    
    /**
     * BeanFlow̑OũftHglB<p>
     */
    public static final String DEFAULT_VALIDATE_FLOW_PREFIX = "validate";
    
    /**
     * {@link BeanFlowFactory}T[rX̃T[rXB<p>
     */
    protected ServiceName beanFlowFactoryServiceName;
    
    /**
     * {@link BeanFlowSelector}T[rX̃T[rXB<p>
     */
    protected ServiceName beanFlowSelectorServiceName;
    
    /**
     * ftHg{@link BeanFlowSelector}B<p>
     */
    protected DefaultBeanFlowSelectorService defaultBeanFlowSelector;
    
    /**
     * BeanFlowstOB<p>
     * ftHǵAfalseŌBeanFlow͌ĂяoȂB<br>
     */
    protected boolean isValidate;
    
    /**
     * BeanFlow̑OuB<p>
     * ftHǵA{@link #DEFAULT_VALIDATE_FLOW_PREFIX}B<br>
     */
    protected String validateFlowPrefix = DEFAULT_VALIDATE_FLOW_PREFIX;
    
    /**
     * ̓IuWFNg̃NGXgB<p>
     * ftHǵA{@link StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME}B<br>
     */
    protected String inputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    
    /**
     * o̓IuWFNg̃NGXgB<p>
     * ftHǵA{@link StreamExchangeInterceptorServiceMBean#DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME}B<br>
     */
    protected String outputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;
    
    /**
     * T[ubg̏sB<p>
     *
     * @exception ServletException T[ubg̏Ɏsꍇ
     */
    public void init() throws ServletException{
        beanFlowFactoryServiceName
            = getBeanFlowFactoryServiceName();
        if(beanFlowFactoryServiceName == null){
            throw new ServletException("BeanFlowFactoryServiceName is null.");
        }
        beanFlowSelectorServiceName
            = getBeanFlowSelectorServiceName();
        if(beanFlowSelectorServiceName == null){
            defaultBeanFlowSelector = new DefaultBeanFlowSelectorService();
            try{
                defaultBeanFlowSelector.create();
                defaultBeanFlowSelector.start();
            }catch(Exception e){
                throw new ServletException(e);
            }
        }
        isValidate = isValidate();
        final String prefix = getValidateFlowPrefix();
        if(prefix != null && prefix.length() != 0){
            validateFlowPrefix = prefix;
        }
        final String inputName = getInputAttributeName();
        if(inputName != null){
            inputAttributeName = inputName;
        }
        final String outputName = getOutputAttributeName();
        if(outputName != null){
            outputAttributeName = outputName;
        }
    }
    
    /**
     * p[^{@link #INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME}Ŏw肳ꂽ{@link BeanFlowFactory}T[rX̃T[rX擾B<p>
     *
     * @return BeanFlowFactoryT[rX̃T[rX
     */
    protected ServiceName getBeanFlowSelectorServiceName(){
        final ServletConfig config = getServletConfig();
        final String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME);
        if(serviceNameStr == null){
            return null;
        }
        final ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }
    
    /**
     * p[^{@link #INIT_PARAM_NAME_BEAN_FLOW_FACTORY_SERVICE_NAME}Ŏw肳ꂽ{@link BeanFlowFactory}T[rX̃T[rX擾B<p>
     *
     * @return BeanFlowFactoryT[rX̃T[rX
     */
    protected ServiceName getBeanFlowFactoryServiceName(){
        final ServletConfig config = getServletConfig();
        final String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_BEAN_FLOW_FACTORY_SERVICE_NAME);
        if(serviceNameStr == null){
            return null;
        }
        final ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }
    
    /**
     * p[^{@link #INIT_PARAM_NAME_VALIDATE}Ŏw肳ꂽ؃t[gptO擾B<p>
     *
     * @return ؃t[gptOBtruȅꍇA؃t[gpB
     */
    protected boolean isValidate(){
        final ServletConfig config = getServletConfig();
        final String isValidateStr = config.getInitParameter(INIT_PARAM_NAME_VALIDATE);
        return isValidateStr == null ? false : Boolean.valueOf(isValidateStr).booleanValue();
    }
    
    /**
     * p[^{@link #INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX}Ŏw肳ꂽBeanFlowOu擾B<p>
     * NGXgpX̑OɁȂOutt[BeanFlow̃t[ƂB<br>
     *
     * @return BeanFlowOu
     */
    protected String getValidateFlowPrefix(){
        final ServletConfig config = getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX);
    }
    
    /**
     * p[^{@link #INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME}Ŏw肳ꂽ̓IuWFNg̃NGXg擾B<p>
     * ̑ŁAHTTPNGXg̓IuWFNg擾āA{@link BeanFlowServletContext}ɐݒ肷B<br>
     *
     * @return ̓IuWFNg̃NGXg
     */
    protected String getInputAttributeName(){
        final ServletConfig config = getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME);
    }
    
    /**
     * p[^{@link #INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME}Ŏw肳ꂽo̓IuWFNg̃NGXg擾B<p>
     * {@link BeanFlowServletContext#getOutput()}Ŏ擾o̓IuWFNgȂŁAHTTPNGXgݒ肷B<br>
     *
     * @return o̓IuWFNg̃NGXg
     */
    protected String getOutputAttributeName(){
        final ServletConfig config = getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME);
    }
    
    /**
     * GET\bhĂяoB<p>
     * {@link #doService(HttpServletRequest, HttpServletResponse)}ĂяoB<br>
     * 
     * @param req HTTPNGXg
     * @param resp HTTPX|X
     * @exception ServletException
     * @exception IOException
     */
    protected void doGet(
        HttpServletRequest req,
        HttpServletResponse resp
    ) throws ServletException, IOException{
        doService(req, resp);
    }
    
    /**
     * POST\bhĂяoB<p>
     * {@link #doService(HttpServletRequest, HttpServletResponse)}ĂяoB<br>
     * 
     * @param req HTTPNGXg
     * @param resp HTTPX|X
     * @exception ServletException
     * @exception IOException
     */
    protected void doPost(
        HttpServletRequest req,
        HttpServletResponse resp
    ) throws ServletException, IOException{
        doService(req, resp);
    }
    
    /**
     * BeanFlowyуANVBeanFlow̌Ăяo𐧌䂷B<p>
     * 
     * @param req HTTPNGXg
     * @param resp HTTPX|X
     * @exception ServletException
     * @exception IOException
     */
    protected void doService(
        HttpServletRequest req,
        HttpServletResponse resp
    ) throws ServletException, IOException{
        
        String flowName = processSelectBeanFlow(req, resp);
        
        if(flowName == null || flowName.length() == 0){
            handleNotFound(req, resp, flowName);
            return;
        }
        final BeanFlowFactory beanFlowFactory
            = (BeanFlowFactory)ServiceManagerFactory
                .getServiceObject(beanFlowFactoryServiceName);
        if(!beanFlowFactory.containsFlow(flowName)){
            handleNotFound(req, resp, flowName);
            return;
        }
        final BeanFlowServletContext context = new BeanFlowServletContext(
            req,
            resp,
            req.getAttribute(inputAttributeName)
        );
        if(validateFlowPrefix != null){
            final String validateFlowName = validateFlowPrefix + flowName;
            if(beanFlowFactory.containsFlow(validateFlowName)){
                BeanFlow validateFlow = null;
                try{
                    validateFlow = beanFlowFactory.createFlow(validateFlowName);
                }catch(BeanFlowException e){
                    throw new ServletException(e);
                }
                if(!processValidate(req, resp, context, validateFlow)){
                    if(!handleValidateError(req, resp, context)){
                        return;
                    }
                }
            }
        }
        BeanFlow flow = null;
        try{
            flow = beanFlowFactory.createFlow(flowName);
        }catch(BeanFlowException e){
            throw new ServletException(e);
        }
        processAction(req, resp, context, flow);
    }
    
    protected String processSelectBeanFlow(
        HttpServletRequest req,
        HttpServletResponse resp
    ) throws ServletException, IOException{
        BeanFlowSelector beanFlowSelector = defaultBeanFlowSelector;
        if(beanFlowSelectorServiceName != null){
            beanFlowSelector = (BeanFlowSelector)ServiceManagerFactory
                .getServiceObject(beanFlowSelectorServiceName);
        }
        return beanFlowSelector.selectBeanFlow(req);
    }
    
    protected void handleNotFound(
        HttpServletRequest req,
        HttpServletResponse resp,
        String flowName
    ) throws ServletException, IOException{
        resp.sendError(
            HttpServletResponse.SC_NOT_FOUND,
            "Flow '" + flowName + "' is not found."
        );
    }
    
    protected boolean processValidate(
        HttpServletRequest req,
        HttpServletResponse resp,
        BeanFlowServletContext context,
        BeanFlow validateFlow
    ) throws ServletException, IOException{
        try{
            final Object ret = validateFlow.execute(context);
            boolean result = false;
            if(ret != null && ret instanceof Boolean){
                result = ((Boolean)ret).booleanValue();
            }
            if(!result && context.getOutput() != null){
                req.setAttribute(outputAttributeName, context.getOutput());
            }
            return result;
        }catch(Exception e){
            return handleValidateException(req, resp, context, e);
        }
    }
    
    protected boolean handleValidateException(
        HttpServletRequest req,
        HttpServletResponse resp,
        BeanFlowServletContext context,
        Exception e
    ) throws ServletException, IOException{
        throw new ServletException("Validate error.", e);
    }
    
    protected boolean handleValidateError(
        HttpServletRequest req,
        HttpServletResponse resp,
        BeanFlowServletContext context
    ) throws ServletException, IOException{
        return false;
    }
    
    protected void processAction(
        HttpServletRequest req,
        HttpServletResponse resp,
        BeanFlowServletContext context,
        BeanFlow flow
    ) throws ServletException, IOException{
        try{
            final Object ret = flow.execute(context);
            if(context.getOutput() == null){
                if(ret != null){
                    req.setAttribute(outputAttributeName, ret);
                }
            }else{
                req.setAttribute(outputAttributeName, context.getOutput());
            }
        }catch(Exception e){
            handleActionException(req, resp, context, e);
        }
    }
    
    protected boolean handleActionException(
        HttpServletRequest req,
        HttpServletResponse resp,
        BeanFlowServletContext context,
        Exception e
    ) throws ServletException, IOException{
        throw new ServletException("Flow error.", e);
    }
}