/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans.dataset;

/**
 * vpeB̃XL[}`B<p>
 * 
 * @author M.Takata
 */
public interface PropertySchema{
    
    /**
     * vpeB̃XL[}`ݒ肷B<p>
     *
     * @param schema vpeB̃XL[}`
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public void setSchema(String schema) throws PropertySchemaDefineException;
    
    /**
     * vpeB̃XL[}擾B<p>
     *
     * @return vpeB̃XL[}
     */
    public String getSchema();
    
    /**
     * vpeB̖O擾B<p>
     *
     * @return vpeB̖O
     */
    public String getName();
    
    /**
     * vpeB̌^擾B<p>
     *
     * @return vpeB̌^
     */
    public Class<?> getType();
    
    /**
     * L[ǂ𔻕ʂB<p>
     *
     * @return truȅꍇAL[
     */
    public boolean isPrimaryKey();
    
    /**
     * vpeB̒lݒ肷鎞ɌĂяoB<p>
     *
     * @param val ݒ肵悤ƂĂvpeB̒l
     * @return ݒ肳vpeB̒l
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     */
    public Object set(Object val) throws PropertySetException;
    
    /**
     * vpeB̒l擾鎞ɌĂяoB<p>
     *
     * @param val 擾悤ƂĂvpeB̒l
     * @return 擾vpeB̒l
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     */
    public Object get(Object val) throws PropertyGetException;
    
    /**
     * tH[}bgꂽvpeB̒l擾鎞ɌĂяoB<p>
     *
     * @param val 擾悤ƂĂtH[}bgꂽvpeB̒l
     * @return 擾tH[}bgꂽvpeB̒l
     * @exception PropertyGetException vpeB̎擾Ɏsꍇ
     */
    public Object format(Object val) throws PropertyGetException;
    
    /**
     * p[XăvpeB̒lݒ肷鎞ɌĂяoB<p>
     *
     * @param val ݒ肵悤ƂĂp[XvpeB̒l
     * @return ݒ肳p[XꂽvpeB̒l
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     */
    public Object parse(Object val) throws PropertySetException;
    
    /**
     * vpeB̒l؂鎞ɌĂяoB<p>
     *
     * @param val ؂悤ƂĂvpeB̒l
     * @return ،ʁBtruȅꍇAؐ
     * @exception PropertyValidateException vpeB̌؎ɗOꍇ
     */
    public boolean validate(Object val) throws PropertyValidateException;
}
