/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.semaphore.*;

/**
 * ʐC^[Zv^B<p>
 * Ăяoɑ΂āAZ}tHT[rXgėʐsC^[Zv^łB<br>
 * ȉɁAR܂łɃANZXłȂ悤ɗʐ䂷C^[Zv^̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="FlowControlInterceptor"
 *                  code="jp.ossc.nimbus.service.aop.interceptor.FlowControlInterceptorService"&gt;
 *             &lt;attribute name="SemaphoreServiceName"&gt;#Semaphore&lt;/attribute&gt;
 *             &lt;depends&gt;Semaphore&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="Semaphore"
 *                  code="jp.ossc.nimbus.service.semaphore.DefaultSemaphoreService"&gt;
 *             &lt;attribute name="ResourceCapacity"&gt;3&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 * @see Semaphore
 */
public class FlowControlInterceptorService extends ServiceBase
 implements Interceptor, FlowControlInterceptorServiceMBean{
    
    private static final long serialVersionUID = 519397295732596256L;
    
    private ServiceName semaphoreServiceName;
    private Semaphore semaphore;
    private long timeout = -1;
    private boolean isFailToObtainSemaphore = true;
    private int maxWaitingCount = -1;
    private long forceFreeTimeout = -1L;
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public void setSemaphoreServiceName(ServiceName name){
        semaphoreServiceName = name;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public ServiceName getSemaphoreServiceName(){
        return semaphoreServiceName;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public void setTimeout(long timeout){
        this.timeout = timeout;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public long getTimeout(){
        return timeout;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public void setMaxWaitingCount(int count){
        maxWaitingCount = count;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public int getMaxWaitingCount(){
        return maxWaitingCount;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public void setForceFreeTimeout(long timeout){
        forceFreeTimeout = timeout;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public long getForceFreeTimeout(){
        return forceFreeTimeout;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public void setFailToObtainSemaphore(boolean isThrow){
        isFailToObtainSemaphore = isThrow;
    }
    
    // FlowControlInterceptorServiceMBeanJavaDoc
    public boolean isFailToObtainSemaphore(){
        return isFailToObtainSemaphore;
    }
    
    /**
     * Semaphoreݒ肷B<p>
     *
     * @param semaphore Semaphore
     */
    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception {@link Semaphore}T[rX̎擾Ɏsꍇ
     */
    public void startService() throws Exception{
        if(semaphore == null && semaphoreServiceName != null){
            semaphore = ServiceManagerFactory.getServiceObject(
                semaphoreServiceName
            );
        }
        if(semaphore == null){
            DefaultSemaphoreService sem = new DefaultSemaphoreService();
            sem.create();
            sem.start();
            semaphore = sem;
        }
        semaphore.accept();
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    public void stopService() throws Exception{
        if(semaphore != null){
            semaphore.release();
        }
    }
    
    /**
     * ʐāÃC^[Zv^ĂяoB<p>
     * T[rXJnĂȂꍇAy{@link Semaphore}T[rXw肳ĂȂꍇ́Aʐs킸Ɏ̃C^[Zv^ĂяoB<br>
     * 
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invoke(
        InvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() == State.STARTED){
            final boolean isSuccess = semaphore.getResource(
                timeout,
                maxWaitingCount,
                forceFreeTimeout
            );
            Thread.interrupted();
            if(!isSuccess){
                if(isFailToObtainSemaphore){
                    throw new FailToObtainSemaphoreException();
                }else{
                    return null;
                }
            }
            try{
                return chain.invokeNext(context);
            }finally{
                semaphore.freeResource();
            }
        }else{
            return chain.invokeNext(context);
        }
    }
}
