/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.javassist;

import jp.ossc.nimbus.core.*;

/**
 * {@link MethodInterceptorAspectService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MethodInterceptorAspectService
 */
public interface MethodInterceptorAspectServiceMBean extends ServiceBaseMBean{
    
    /**
     * InterceptorΏۂ̃NX̃NXCqw肷B<p>
     * Ŏw肳ꂽNXCq̃NXInterceptorΏۂƂȂBw肵Ȃꍇ́ANXCq͌肳ȂB<br>
     * Cqے肷ꍇ́AeCq̑O"!"t^邱ƁB
     *
     * @param modifiers NXCq
     */
    public void setTargetClassModifiers(String modifiers);
    
    /**
     * InterceptorΏۂ̃NX̃NXCq擾B<p>
     *
     * @return NXCq
     */
    public String getTargetClassModifiers();
    
    /**
     * InterceptorΏۂ̃NXw肷B<p>
     * Ŏw肳ꂽNX̃NXInterceptorΏۂƂȂBw肵Ȃꍇ́ANX͌肳ȂB܂AK\w肷鎖\łB
     *
     * @param name pbP[W܂ފSCNXBK\B
     */
    public void setTargetClassName(String name);
    
    /**
     * InterceptorΏۂ̃NX擾B<p>
     *
     * @return pbP[W܂ފSCNXBK\B
     */
    public String getTargetClassName();
    
    /**
     * InterceptorȂΏۂ̃NXw肷B<p>
     * Ŏw肳ꂽNX̃NXInterceptorΏۂƂȂȂB܂AK\w肷鎖\łB
     *
     * @param name pbP[W܂ފSCNXBK\B
     */
    public void setNoTargetClassName(String name);
    
    /**
     * InterceptorȂΏۂ̃NX擾B<p>
     *
     * @return pbP[W܂ފSCNXBK\B
     */
    public String getNoTargetClassName();
    
    /**
     * InterceptorΏۂ̃CX^X̃NXw肷B<p>
     * Ŏw肳ꂽNX̃CX^XInterceptorΏۂƂȂBw肵Ȃꍇ́ACX^X͌肳ȂB
     *
     * @param name pbP[W܂ފSCNX
     */
    public void setTargetInstanceClassName(String name);
    
    /**
     * InterceptorΏۂ̃CX^X̃NX擾B<p>
     *
     * @return pbP[W܂ފSCNXB
     */
    public String getTargetInstanceClassName();
    
    /**
     * InterceptorΏۂ̃\bh̃\bhCqw肷B<p>
     * Ŏw肳ꂽ\bhCq̃\bhInterceptorΏۂƂȂBw肵Ȃꍇ́A\bhCq͌肳ȂB<br>
     * Cqے肷ꍇ́AeCq̑O"!"t^邱ƁB
     *
     * @param modifiers \bhCq
     */
    public void setTargetMethodModifiers(String modifiers);
    
    /**
     * InterceptorΏۂ̃\bh̃\bhCq擾B<p>
     *
     * @return \bhCq
     */
    public String getTargetMethodModifiers();
    
    /**
     * InterceptorΏۂ̃\bhw肷B<p>
     * Ŏw肳ꂽ\bh̃\bhInterceptorΏۂƂȂBw肵Ȃꍇ́A\bh͌肳ȂB܂AK\w肷鎖\łB
     *
     * @param name \bhBK\B
     */
    public void setTargetMethodName(String name);
    
    /**
     * InterceptorΏۂ̃\bh擾B<p>
     *
     * @return \bhBK\B
     */
    public String getTargetMethodName();
    
    /**
     * InterceptorΏۂ̃\bḧ̌^\NXw肷B<p>
     * Ŏw肳ꂽ^\bhInterceptorΏۂƂȂBw肵Ȃꍇ́A^͌肳ȂB܂AK\w肷鎖\łB
     *
     * @param paramTypes \bḧ̌^\NX̔zBK\B
     */
    public void setTargetParameterTypes(String[] paramTypes);
    
    /**
     * InterceptorΏۂ̃\bḧ̌^\NX擾B<p>
     *
     * @return \bḧ̌^\NX̔zBK\B
     */
    public String[] getTargetParameterTypes();
    
    /**
     * }Interceptor`F[̃Xgł{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rXw肷B<p>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setInterceptorChainListServiceName(ServiceName name);
    
    /**
     * }Interceptor`F[̃Xgł{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rX擾B<p>
     *
     * @return InterceptorChainListT[rX̃T[rX
     */
    public ServiceName getInterceptorChainListServiceName();
    
    /**
     * C^[ZvgΏۂĂяo{@link jp.ossc.nimbus.service.aop.Invoker Invoker}T[rX̃T[rXݒ肷B<p>
     * ftHgł́A{@link WrappedMethodReflectionCallInvokerService}IɐgpB<br>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setInvokerServiceName(ServiceName name);
    
    /**
     * C^[ZvgΏۂĂяo{@link jp.ossc.nimbus.service.aop.Invoker Invoker}T[rX̃T[rX擾B<p>
     *
     * @return InvokerT[rX̃T[rX
     */
    public ServiceName getInvokerServiceName();
    
    /**
     * ̃T[rXÓIRpCɎgp邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isStatic ÓIRpCɎgpꍇ́Atrue
     */
    public void setStaticCompile(boolean isStatic);
    
    /**
     * ̃T[rXÓIRpCɎgp邩ǂ𔻒ݒ肷B<p>
     *
     * @return truȅꍇAÓIRpCɎgp
     */
    public boolean isStaticCompile();
    
    /**
     * ̃AXyNgϊʂAXyNg̃L[ݒ肷B<p>
     * L[AXyNǵAdăAXyNgȂB<br>
     * ftHgł́AT[rXgpB<br>
     *
     * @param key AXyNg̃L[
     */
    public void setAspectKey(String key);
    
    /**
     * ̃AXyNgϊʂAXyNg̃L[擾B<p>
     *
     * @return AXyNg̃L[
     */
    public String getAspectKey();
    
    /**
     * NimbusClassLoaderVMxAspectTranslatoro^邩ǂݒ肷B<p>
     * ftHgtrueŁAVMxAspectTranslatoro^Bfalseɐݒ肷ƁAThreadContextxAspectTranslatoro^B
     *
     * @param isRegister VMxAspectTranslatoro^ꍇ́Atrue
     */
    public void setRegisterVMClassLoader(boolean isRegister);
    
    /**
     * NimbusClassLoaderVMxAspectTranslatoro^邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́AVMxAspectTranslatoro^Bfalsȅꍇ́AThreadContextxAspectTranslatoro^
     */
    public boolean isRegisterVMClassLoader();
}
