/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.util.*;

import jp.ossc.nimbus.core.ServiceBase;

/**
 * LbVLԂӂꌟ؃T[rXB<p>
 * LbVLԂłӂ؂OverflowValidatorłB<br>
 * ȉɁALbVĂ10b𒴂Ƃӂ邠ӂꌟ؃T[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="TimeExpierOverflowValidator"
 *                  code="jp.ossc.nimbus.service.cache.TimeExpierOverflowValidatorService"&gt;
 *             &lt;attribute name="ExpierTerm"&gt;10000&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class TimeExpierOverflowValidatorService<E> extends ServiceBase
 implements OverflowValidator<E>, CacheRemoveListener<E>, java.io.Serializable,
            TimeExpierOverflowValidatorServiceMBean{
    
    private static final long serialVersionUID = -5221705956555820688L;
    
    /**
     * LbVLԁB<p>
     */
    private long expierTerm = -1;
    
    /**
     * LbVL؂
     */
    private long period = -1;

    /**
     * LbVQƂƓo^Ԃ̏WB<p>
     */
    private Map<CachedReference<E>, Date> references;
    
    // TimeExpierOverflowValidatorServiceMBeanJavaDoc
    @Override
    public int size(){
        return references == null ? 0 : references.size();
    }
    
    /**
     * T[rX̐sB<p>
     * CX^Xϐ̏sB<br>
     * 
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        references = Collections.synchronizedMap(new LinkedHashMap<CachedReference<E>, Date>());
    }

    /**
     * T[rXJnB<p>
     * ̃T[rX𗘗p\ȏԂɂB<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception {
    }

    /**
     * T[rX̔jsB<p>
     * {@link #reset()}ĂяoB܂ACX^Xϐ̎QƂjB<br>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        reset();
        references = null;
    }
    
    // TimeExpierOverflowValidatorServiceMBeanJavaDoc
    @Override
    public void setExpierTerm(long millis) throws IllegalArgumentException{
        expierTerm = millis;
    }
    
    // TimeExpierOverflowValidatorServiceMBeanJavaDoc
    @Override
    public long getExpierTerm(){
        return expierTerm;
    }
    
    // TimeExpierOverflowValidatorServiceMBeanJavaDoc
    @Override
    public void setPeriod(long millis) throws IllegalArgumentException {
        period = millis;
    }

    // TimeExpierOverflowValidatorServiceMBeanJavaDoc
    @Override
    public long getPeriod() {
        return period;
    }

    /**
     * LbVLԂ߂Ă邩؂B<p>
     *
     * @return LbVLԂ߂ĂꍇA߂ĂLbV̐ԂB߂ĂȂꍇ́A0Ԃ
     */
    @Override
    public int validate(){
        if(references == null || references.size() == 0){
            return 0;
        }
        synchronized(references){
            if(getState() != State.STARTED){
                return 0;
            }
            final long currentTime = System.currentTimeMillis();
            if(getExpierTerm() < 0
                && period <= 0
            ){
                return 0;
            }
            final Object[] dates = references.values().toArray();

            boolean validateExpierTime = true;
            if (expierTerm < 0) {
                // LԂ̌؂͍sȂ
                validateExpierTime = false;
            }
            boolean validatePeriod = true;
            if (period <= 0) {
                // L؂̌؂͍sȂ
                validatePeriod = false;
            }

            int count = 0;
            for(; count < dates.length; count++){
                // LbVo^[ms]
                long refMillis = ((Date)dates[count]).getTime();
  
                // L
                if(validateExpierTime
                    && currentTime < refMillis + expierTerm){
                    validateExpierTime = false;
                }
                
                // L؂
                if(validatePeriod
                    && currentTime < refMillis + (period - (refMillis - 9 * 60 * 60 * 1000) % period)){
                    validatePeriod = false;
                }
                
                if (!validateExpierTime
                    && !validatePeriod) {
                    break;
                }
            }

            return count;
        }
    }

    // OverflowValidatorJavaDoc
    @Override
    public void add(CachedReference<E> ref){
        if(references == null || ref == null){
            return;
        }
        synchronized(references){
            if(!references.containsKey(ref)){
                references.put(ref, new Date());
                ref.addCacheRemoveListener(this);
            }
        }
    }
    
    // OverflowValidatorJavaDoc
    @Override
    public void remove(CachedReference<E> ref){
        if(references == null || ref == null){
            return;
        }
        synchronized(references){
            if(references.containsKey(ref)){
                references.remove(ref);
                ref.removeCacheRemoveListener(this);
            }
        }
    }
    
    // OverflowValidatorJavaDoc
    @Override
    public void reset(){
        if(references != null){
            synchronized(references){
                for(CachedReference<E> ref : references.keySet()){
                    remove(ref);
                }
                references.clear();
            }
        }
    }
    
    /**
     * {@link #add(CachedReference)}Œǉꂽ{@link CachedReference}̃LbVIuWFNg폜ꂽꍇɌĂяoB<p>
     * 폜ꂽLbVQƂ{@link #remove(CachedReference)}ŁAOverflowValidator폜B<br>
     *
     * @param ref 폜ꂽLbVIuWFNg̃LbVQ
     */
    @Override
    public void removed(CachedReference<E> ref){
        if(references == null){
            return;
        }
        remove(ref);
    }
}
