/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * ftHgReLXgB<p>
 * Cӂ̒萔lϐlȂǂAL[Ɋ֘AtĊi[A񋟂B<br>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="Context"
 *                  code="jp.ossc.nimbus.service.context.DefaultContextService"&gt;
 *             &lt;attribute name="HOME_PATH"&gt;/home&lt;/attribute&gt;
 *             &lt;attribute name="DOMAIN"&gt;nimbus2.ossc.jp&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class DefaultContextService<K, V> extends ServiceBase
 implements Context<K, V>, DefaultContextServiceMBean<K, V>, java.io.Serializable{
    
    private static final long serialVersionUID = 920050666611019516L;
    
    /**
     * ReLXgi[}bvB<p>
     */
    protected Map<K, V> context;
    
    protected ServiceName contextStoreServiceName;
    
    protected ContextStore<K, V> contextStore;
    
    protected boolean isLoadOnStart;
    
    protected boolean isLoadKeyOnStart;
    
    protected boolean isSaveOnStop;
    
    protected boolean isClearBeforeSave = true;
    
    @Override
    public void setContextStoreServiceName(ServiceName name){
        contextStoreServiceName = name;
    }
    @Override
    public ServiceName getContextStoreServiceName(){
        return contextStoreServiceName;
    }
    
    @Override
    public void setLoadOnStart(boolean isLoad){
        isLoadOnStart = isLoad;
    }
    @Override
    public boolean isLoadOnStart(){
        return isLoadOnStart;
    }
    
    @Override
    public void setLoadKeyOnStart(boolean isLoad){
        isLoadKeyOnStart = isLoad;
    }
    @Override
    public boolean isLoadKeyOnStart(){
        return isLoadKeyOnStart;
    }
    
    @Override
    public void setSaveOnStop(boolean isSave){
        isSaveOnStop = isSave;
    }
    @Override
    public boolean isSaveOnStop(){
        return isSaveOnStop;
    }
    
    @Override
    public void setClearBeforeSave(boolean isClear){
        isClearBeforeSave = isClear;
    }
    @Override
    public boolean isClearBeforeSave(){
        return isClearBeforeSave;
    }
    
    public void setContextStore(ContextStore<K, V> store){
        contextStore = store;
    }
    
    /**
     * T[rX̐sB<p>
     * CX^XϐB<br>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        context = Collections.synchronizedMap(new HashMap<K, V>());
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(contextStoreServiceName != null){
            contextStore = ServiceManagerFactory.getServiceObject(contextStoreServiceName);
        }
        if(contextStore == null && (isLoadOnStart || isLoadKeyOnStart|| isSaveOnStop)){
            throw new IllegalArgumentException("ContextStore is null.");
        }
        if(isLoadOnStart){
            load();
        }else if(isLoadKeyOnStart){
            loadKey();
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        if(isSaveOnStop){
            save();
        }
        context.clear();
    }
    
    /**
     * T[rX̔jsB<p>
     * CX^XϐjB<br>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        context = null;
    }
    
    @Override
    public synchronized void load() throws Exception{
        if(contextStore != null){
            contextStore.load(this);
        }
    }
    
    @Override
    public synchronized void loadKey() throws Exception{
        if(contextStore != null){
            contextStore.loadKey(this);
        }
    }
    
    @Override
    public void load(Object key) throws Exception{
        if(contextStore != null){
            contextStore.load(this, key);
        }
    }
    
    @Override
    public synchronized void save() throws Exception{
        if(contextStore != null){
            if(isClearBeforeSave){
                contextStore.clear();
            }
            contextStore.save(this);
        }
    }
    
    // ContextJavaDoc
    @Override
    public V get(Object key){
        V val = context.get(key);
        if(val == null){
            return null;
        }else if(val instanceof ServiceName){
            final ServiceName name = (ServiceName)val;
            try{
                val = ServiceManagerFactory.<V>getServiceObject(name);
            }catch(ServiceNotFoundException e){
                val = null;
            }
        }
        return val;
    }
    
    // ContextJavaDoc
    @Override
    public V put(K key, V value) {
        return context.put(key,value);
    }
    
    // ContextJavaDoc
    @Override
    public Set<K> keySet(){
        return context.keySet();
    }
    
    // ContextJavaDoc
    @Override
    public Collection<V> values() {
        return context.values();
    }
    
    // ContextJavaDoc
    @Override
    public V remove(Object key) {
        return context.remove(key);
    }
    
    // ContextJavaDoc
    @Override
    public void clear() {
        context.clear() ;
    }
    
    // ContextJavaDoc
    @Override
    public boolean isEmpty() {
        return context.isEmpty();
    }
    
    // ContextJavaDoc
    @Override
    public boolean containsKey(Object key) {
        return context.containsKey(key);
    }
    
    // ContextJavaDoc
    @Override
    public boolean containsValue(Object value) {
        return context.containsValue(value);
    }
    
    // ContextJavaDoc
    @Override
    public Set<Map.Entry<K,V>> entrySet(){
        return context.entrySet();
    }
    
    // ContextJavaDoc
    @Override
    public int size(){
        return context.size();
    }
    
    // ContextJavaDoc
    @Override
    public void putAll(Map<? extends K,? extends V> t){
        context.putAll(t);
    }
    
    /**
     * ReLXg̕ێnbVe[u𐶐B<p>
     *
     * @return ReLXg̕ێnbVe[u
     */
    public Hashtable<K, V> cloneHash(){
        return new Hashtable<K, V>(context);
    }
    
    // ContextJavaDoc
    @Override
    public Object get(String key) {
        return get((Object)key);
    }
    
    // ContextJavaDoc
    @Override
    public Object remove(String key){
        return remove((Object)key);
    }
    @Override
    public String list(){
        StringBuilder buf = new StringBuilder();
        synchronized(context){
            for(Iterator<K> ite = context.keySet().iterator(); ite.hasNext();){
                K key = ite.next();
                buf.append(key);
                buf.append(" : ");
                buf.append(context.get(key));
                buf.append('\n');
            }
        }
        return buf.toString();
    }
    
    @Override
    public Map<K, V> all(){
        return new HashMap<K, V>(context);
    }
 }
