/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DefaultContextService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DefaultContextService
 */
public interface DefaultContextServiceMBean<K, V> extends ServiceBaseMBean, Context<K, V> {
    
    /**
     * {@link ContextStore}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextStoreT[rX̃T[rX
     */
    public void setContextStoreServiceName(ServiceName name);
    
    /**
     * {@link ContextStore}T[rX̃T[rX擾B<p>
     *
     * @return ContextStoreT[rX̃T[rX
     */
    public ServiceName getContextStoreServiceName();
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgēǂݍݏsǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isLoad ǂݍݏsꍇAtrue
     */
    public void setLoadOnStart(boolean isLoad);
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgēǂݍݏsǂ𔻒肷B<p>
     *
     * @return truȅꍇAǂݍݏs
     */
    public boolean isLoadOnStart();
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgăL[̓ǂݍݏsǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isLoad ǂݍݏsꍇAtrue
     */
    public void setLoadKeyOnStart(boolean isLoad);
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgăL[̓ǂݍݏsǂ𔻒肷B<p>
     *
     * @return truȅꍇAǂݍݏs
     */
    public boolean isLoadKeyOnStart();
    
    /**
     * T[rX̒~ɁA{@link ContextStore}T[rXgďݏsǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isSave ݏsꍇAtrue
     */
    public void setSaveOnStop(boolean isSave);
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgďݏsǂ𔻒肷B<p>
     *
     * @return truȅꍇAݏs
     */
    public boolean isSaveOnStop();
    
    /**
     * ReLXg̏ݏ̑OɃXgANA邩ǂݒ肷B<p>
     * ftHǵAtrueŃNAB<br>
     *
     * @param isClear NAꍇAtrue
     */
    public void setClearBeforeSave(boolean isClear);
    
    /**
     * ReLXg̏ݏ̑OɃXgANA邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇANA
     */
    public boolean isClearBeforeSave();
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽReLXg擾B<p>
     *
     * @param key L[
     * @return L[Ɋ֘AtꂽReLXgBYReLXg񂪂Ȃꍇ́Anull
     */
    public Object get(String key);
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽReLXg폜B<p>
     *
     * @param key L[
     * @return 폜ꂽReLXgB폜ReLXg񂪂Ȃꍇ́Anull
     */
    public Object remove(String key);
    
    /**
     * uO(keytoString()) : l(valuetoString()) svƂ`ŃXgo͂B<p>
     *
     * @return Xg
     */
    public String list();
    
    /**
     * {@link ContextStore}T[rXgēǂݍݏsB<p>
     *
     * @exception Exception ǂݍݏɎsꍇ
     */
    public void load() throws Exception;
    
    /**
     * {@link ContextStore}T[rXgăL[̓ǂݍݏsB<p>
     *
     * @exception Exception ǂݍݏɎsꍇ
     */
    public void loadKey() throws Exception;
    
    /**
     * w肳ꂽL[ɊYl{@link ContextStore}T[rXgēǂݍݏsB<p>
     *
     * @exception Exception ǂݍݏɎsꍇ
     */
    public void load(Object key) throws Exception;
    
    /**
     * {@link ContextStore}T[rXgďݏsB<p>
     *
     * @exception Exception ݏɎsꍇ
     */
    public void save() throws Exception;
}
