/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.Set;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DistributedSharedContextService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DistributedSharedContextService
 */
public interface DistributedSharedContextServiceMBean<K> extends ServiceBaseMBean{
    
    /**
     * ftHg̃TuWFNgB<p>
     */
    public static final String DEFAULT_SUBJECT = "DistributedSharedContext";
    
    /**
     * NCAg[h̃TuWFNguB<p>
     */
    public static final String CLIENT_SUBJECT_SUFFIX = ".Client";
    
    /**
     * f[^̕Uݒ肷B<p>
     * ftHǵA2B<br>
     *
     * @param size U
     */
    public void setDistributedSize(int size) throws IllegalArgumentException;
    
    /**
     * f[^̕U擾B<p>
     *
     * @return U
     */
    public int getDistributedSize();
    
    /**
     * f[^̕ݒ肷B<p>
     * ftHǵA2B<br>
     *
     * @param size 
     */
    public void setReplicationSize(int size) throws IllegalArgumentException;
    
    /**
     * f[^̕擾B<p>
     *
     * @return 
     */
    public int getReplicationSize();
    
    /**
     * {@link SharedContextKeyDistributor}T[rX̃T[rXݒ肷B<p>
     * w肵Ȃꍇ́A{@link MD5HashSharedContextKeyDistributorService}KpB<br>
     * 
     * @param name SharedContextKeyDistributorT[rX̃T[rX
     */
    public void setSharedContextKeyDistributorServiceName(ServiceName name);
    
    /**
     * {@link SharedContextKeyDistributor}T[rX̃T[rX擾B<p>
     * 
     * @return SharedContextKeyDistributorT[rX̃T[rX
     */
    public ServiceName getSharedContextKeyDistributorServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.RequestConnectionFactoryService RequestConnectionFactoryService}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name RequestConnectionFactoryServiceT[rX̃T[rX
     */
    public void setRequestConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.RequestConnectionFactoryService RequestConnectionFactoryService}T[rX̃T[rX擾B<p>
     * 
     * @return RequestConnectionFactoryServiceT[rX̃T[rX
     */
    public ServiceName getRequestConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService ClusterService}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name ClusterServiceT[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService ClusterService}T[rX̃T[rX擾B<p>
     * 
     * @return ClusterServiceT[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * NCAg[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rXݒ肷B<p>
     * ReLXgCacheMapɊi[ăf[^̂ӂꐧsꍇAݒ肷B<br>
     * 
     * @param name CacheMapT[rX̃T[rX
     */
    public void setClientCacheMapServiceName(ServiceName name);
    
    /**
     * NCAg[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rX擾B<p>
     * 
     * @return CacheMapT[rX̃T[rX
     */
    public ServiceName getClientCacheMapServiceName();
    
    /**
     * T[o[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rXݒ肷B<p>
     * ReLXgCacheMapɊi[ꍇAݒ肷B<br>
     * 
     * @param name CacheMapT[rX̃T[rX
     */
    public void setServerCacheMapServiceName(ServiceName name);
    
    /**
     * T[o[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rX擾B<p>
     * 
     * @return CacheMapT[rX̃T[rX
     */
    public ServiceName getServerCacheMapServiceName();
    
    /**
     * {@link ContextStore}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name ContextStoreT[rX̃T[rX
     */
    public void setContextStoreServiceName(ServiceName name);
    
    /**
     * {@link ContextStore}T[rX̃T[rX擾B<p>
     * 
     * @return ContextStoreT[rX̃T[rX
     */
    public ServiceName getContextStoreServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rXݒ肷B<p>
     * C^[v^sT|[gꍇɁANG߂Interpreterݒ肷B<br>
     * 
     * @param name InterpreterT[rX̃T[rX
     */
    public void setInterpreterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rX擾B<p>
     * 
     * @return InterpreterT[rX̃T[rX
     */
    public ServiceName getInterpreterServiceName();
    
    /**
     * C^[v^ssXbhݒ肷B<p>
     * ftHǵA0ŗvMXbhł̂܂܏B<br>
     *
     * @param size C^[v^sXbh
     */
    public void setExecuteThreadSize(int size);
    
    /**
     * C^[v^ssXbh擾B<p>
     *
     * @return C^[v^sXbh
     */
    public int getExecuteThreadSize();
    
    /**
     * {@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX̃T[rXݒ肷B<p>
     * C^[v^sT|[gꍇɁAC^[v^s񓯊ɂꍇ̗vL[ݒ肷Bw肵Ȃꍇ́AL[gpB<br>
     * 
     * @param name QueueT[rX̃T[rX
     */
    public void setExecuteQueueServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX̃T[rX擾B<p>
     * 
     * @return QueueT[rX̃T[rX
     */
    public ServiceName getExecuteQueueServiceName();
    
    /**
     * TuWFNgݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SUBJECT}B
     *
     * @param subject TuWFNg
     */
    public void setSubject(String subject);
    
    /**
     * TuWFNg擾B<p>
     *
     * @return TuWFNg
     */
    public String getSubject();
    
    /**
     * NCAg/T[o[hݒ肷B<p>
     * ftHǵAfalseŃT[o[hB<br>
     *
     * @param isClient NCAg[h̏ꍇAtrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * NCAg/T[o[h𔻒肷B<p>
     *
     * @return truȅꍇANCAg[h
     */
    public boolean isClient();
    
    /**
     * nbVLǂݒ肷B<p>
     * ftHǵAtrueŗLB<br>
     *
     * @param isEnabled LɂꍇAtrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void setRehashEnabled(boolean isEnabled) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * nbVLǂ𔻒肷B<p>
     *
     * @return truȅꍇANCAg[h
     */
    public boolean isRehashEnabled();
    
    /**
     * ̃^CAEg[ms]ݒ肷B<p>
     * ftHǵA5000[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setSynchronizeTimeout(long timeout);
    
    /**
     * ̃^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getSynchronizeTimeout();
    
    /**
     * ReLXgU̍Ĕzũ^CAEg[ms]ݒ肷B<p>
     * ftHǵA10000[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setRehashTimeout(long timeout);
    
    /**
     * ReLXgU̍Ĕzũ^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getRehashTimeout();
    
    /**
     * ^CAEgw肵Ȃ\bhĂяoꍇɓKp^CAEg[ms]ݒ肷B<p>
     * ftHǵA1000[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setDefaultTimeout(long timeout);
    
    /**
     * ^CAEgw肵Ȃ\bhĂяoꍇɓKp^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getDefaultTimeout();
    
    /**
     * f[^m[hT[rXƂēo^邩ǂݒ肷B<p>
     * ftHǵAfalseœo^ȂB<br>
     *
     * @param isManage o^ꍇ́Atrue
     */
    public void setManagedDataNode(boolean isManage);
    
    /**
     * f[^m[hT[rXƂēo^邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo^
     */
    public boolean isManagedDataNode();
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgăL[̓ǂݍݏsǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isLoad ǂݍݏsꍇAtrue
     */
    public void setLoadKeyOnStart(boolean isLoad);
    
    /**
     * T[rX̊JnɁA{@link ContextStore}T[rXgăL[̓ǂݍݏsǂ𔻒肷B<p>
     *
     * @return truȅꍇAǂݍݏs
     */
    public boolean isLoadKeyOnStart();
    
    /**
     * ReLXg̕ۑ̑OɃXgANA邩ǂݒ肷B<p>
     * ftHǵAtrueŃNAB<br>
     *
     * @param isClear NAꍇAtrue
     */
    public void setClearBeforeSave(boolean isClear);
    
    /**
     * ReLXg̕ۑ̑OɃXgANA邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇANA
     */
    public boolean isClearBeforeSave();
    
    /**
     * {@link SharedContextUpdateListener}T[rX̃T[rXzݒ肷B<p>
     * 
     * @param names SharedContextUpdateListenerT[rX̃T[rXz
     */
    public void setSharedContextUpdateListenerServiceNames(ServiceName[] names);
    
    /**
     * {@link SharedContextUpdateListener}T[rX̃T[rXz擾B<p>
     * 
     * @return SharedContextUpdateListenerT[rX̃T[rXz
     */
    public ServiceName[] getSharedContextUpdateListenerServiceNames();
    
    /**
     * L[wCfbNXݒ肷B<p>
     * ReLXglIuWFNg̃vpeBL[ƂăCfbNX𒣂AReLXglɑ΂Ă̌s悤ɂB<br>
     * Őݒ肵CfbNXgāA{@link #searchByKeyIndex(String, Object)}Ō\ɂȂBB<br>
     *
     * @param name CfbNX
     * @param keyProps CfbNX̃L[ƂReLXglIuWFNg̃vpeBz
     * @see #searchByKeyIndex(String, Object)
     */
    public void setKeyIndex(String name, String[] keyProps);
    
    /**
     * ReLXgU̍ĔzusB<p>
     * m[h̏ꍇ́ASẴm[hɍĔzu߂oBm[hłȂꍇ́Am[hɍĔzu𑣂B<br>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void rehash() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgU̍ĔzusB<p>
     * m[h̏ꍇ́ASẴm[hɍĔzu߂oBm[hłȂꍇ́Am[hɍĔzu𑣂B<br>
     *
     * @param timeout ^CAEg
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void rehash(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgsB<p>
     * NCAg[h̏ꍇ́A[J̃ReLXgNAB܂AT[o[hŎm[h̏ꍇ́ASẴm[hɓ߂oBm[hłȂꍇ́Am[hɓ𑣂B<br>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgsB<p>
     * NCAg[h̏ꍇ́A[J̃ReLXgNAB܂AT[o[hŎm[h̏ꍇ́ASẴm[hɓ߂oB<br>
     *
     * @param timeout ^CAEg
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽL[̃bNJB<p>
     *
     * @param key L[
     * @return bNJłꍇ́Atrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean unlock(K key) throws SharedContextSendException;
    
    /**
     * w肳ꂽL[̃bNJB<p>
     *
     * @param key L[
     * @param force tO
     * @return bNJłꍇ́Atrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean unlock(K key, boolean force) throws SharedContextSendException;
    
    /**
     * L[̏W擾B<p>
     *
     * @return L[̏W
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Set<K> keySet() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * o^ĂL[̌擾B<p>
     *
     * @return L[̌
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public int size() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * Sč폜B<p>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void clear() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * Sč폜B<p>
     *
     * @param timeout ^CAEg[ms]
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * 񓯊őSč폜B<p>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void clearAsynch() throws SharedContextSendException;
    
    /**
     * w肳ꂽL[ǂ̃f[^m[hɊi[邩̃CfbNX擾B<p>
     *
     * @param key L[
     * @return f[^m[h̃CfbNX
     */
    public int getDataNodeIndex(Object key);
    
    /**
     * w肳ꂽCfbNX̃f[^m[hɓo^ĂL[̐擾B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return L[̐
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public int size(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽCfbNX̃f[^m[h̃L[̏W擾B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return L[̏W
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Set<K> keySet(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽCfbNX̃f[^m[hNCAg[hǂ𔻒肷B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return truȅꍇANCAg[h
     */
    public boolean isClient(int nodeIndex);
    
    /**
     * w肳ꂽCfbNX̃f[^m[hm[hǂ𔻒肷B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return truȅꍇAm[h
     */
    public boolean isMain(int nodeIndex);
    
    /**
     * UT[õf[^m[h̃NCAg/T[o[h̏Ԃ\B<p>
     *
     * @return UT[õf[^m[h̃NCAg/T[o[h̏Ԃ\
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public String displayDistributeInfo() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void load() throws Exception;
    
    /**
     * ReLXgǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @param timeout UT[oւ̒ʐM^CAEg[ms]
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void load(long timeout) throws Exception;
    
    /**
     * ReLXg̃L[̓ǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void loadKey() throws Exception;
    
    /**
     * ReLXg̃L[̓ǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @param timeout UT[oւ̒ʐM^CAEg[ms]
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void loadKey(long timeout) throws Exception;
    
    /**
     * w肵L[ɊYl̃ReLXgǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @param key L[
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void load(Object key) throws Exception;
    
    /**
     * w肵L[ɊYl̃ReLXgǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @param key L[
     * @param timeout UT[oւ̒ʐM^CAEg[ms]
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void load(Object key, long timeout) throws Exception;
    
    /**
     * ReLXgۑsB<p>
     * m[hłȂꍇAm[hɕۑ˗B<br>
     *
     * @param timeout UT[oւ̒ʐM^CAEg[ms]
     * @exception Exception ReLXgۑɎsꍇ
     */
    public void save(long timeout) throws Exception;
    
    /**
     * m[hǂ𔻒肷B<p>
     *
     * @return m[h̏ꍇtrue
     */
    public boolean isMain();
    
    /**
     * m[hID擾B<p>
     *
     * @return m[hID
     */
    public Object getId();
    
    /**
     * m[h̃m[hID擾B<p>
     *
     * @return m[hID
     */
    public Object getMainId();
}