/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.Map;
import java.util.Set;
import java.util.Collection;

import jp.ossc.nimbus.service.interpreter.EvaluateException;

/**
 * LReLXgB<p>
 *
 * @author M.Takata
 */
public interface SharedContext<K> extends Context<K, Object>{
    
    /**
     * w肳ꂽL[̃bNlB<p>
     *
     * @param key L[
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void lock(K key) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽL[̃bNlB<p>
     *
     * @param key L[
     * @param timeout ^CAEg[ms]
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void lock(K key, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽL[̃bNJB<p>
     *
     * @param key L[
     * @return bNJłꍇ́Atrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean unlock(K key) throws SharedContextSendException;
    
    /**
     * w肳ꂽL[̃bNJB<p>
     *
     * @param key L[
     * @param force tO
     * @return bNJłꍇ́Atrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean unlock(K key, boolean force) throws SharedContextSendException;
    
    /**
     * w肳ꂽL[̃bNۗLĂm[hID擾B<p>
     *
     * @param key L[
     * @return bNۗLĂm[hID
     */
    public Object getLockOwner(K key);
    
    /**
     * w肵L[ŁAw肵lǉB<p>
     *
     * @param key L[
     * @param value l
     * @param timeout ^CAEg[ms]
     * @return Âl
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Object put(K key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肵L[ŁAw肵l[JɒǉB<p>
     *
     * @param key L[
     * @param value l
     * @return Âl
     */
    public Object putLocal(K key, Object value);
    
    /**
     * w肵L[ŁAw肵l񓯊ɒǉB<p>
     *
     * @param key L[
     * @param value l
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void putAsynch(K key, Object value) throws SharedContextSendException;
    
    /**
     * w肵L[ŁAw肵XVB<p>
     *
     * @param key L[
     * @param diff 
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void update(K key, SharedContextValueDifference diff) throws SharedContextSendException;
    
    /**
     * w肵L[ŁAw肵XVB<p>
     *
     * @param key L[
     * @param diff 
     * @param timeout ^CAEg[ms]
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void update(K key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肵L[ŁAw肵[JɍXVB<p>
     *
     * @param key L[
     * @param diff 
     */
    public void updateLocal(K key, SharedContextValueDifference diff);
    
    /**
     * w肵L[ŁAw肵Ŕ񓯊ɍXVB<p>
     *
     * @param key L[
     * @param diff 
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void updateAsynch(K key, SharedContextValueDifference diff) throws SharedContextSendException;
    
    /**
     * w肵}bvǉB<p>
     *
     * @param t }bv
     * @param timeout ^CAEg[ms]
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void putAll(Map<? extends K, ? extends Object> t, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肵}bv[JɒǉB<p>
     *
     * @param t }bv
     */
    public void putAllLocal(Map<? extends K, ? extends Object> t);
    
    /**
     * w肵}bv񓯊ŒǉB<p>
     *
     * @param t }bv
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void putAllAsynch(Map<? extends K, ? extends Object> t) throws SharedContextSendException;
    
    /**
     * w肵L[̒l擾B<p>
     *
     * @param key L[
     * @param timeout ^CAEg[ms]
     * @return l
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肵L[̃[Jl擾B<p>
     *
     * @param key L[
     * @return l
     */
    public Object getLocal(Object key);
    
    /**
     * w肵L[폜B<p>
     *
     * @param key L[
     * @param timeout ^CAEg[ms]
     * @return 폜l
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肵L[[J폜B<p>
     *
     * @param key L[
     * @return 폜l
     */
    public Object removeLocal(Object key);
    
    /**
     * w肵L[񓯊ō폜B<p>
     *
     * @param key L[
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void removeAsynch(Object key) throws SharedContextSendException;
    
    /**
     * Sč폜B<p>
     *
     * @param timeout ^CAEg[ms]
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * [JSč폜B<p>
     */
    public void clearLocal();
    
    /**
     * SĔ񓯊ō폜B<p>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void clearAsynch() throws SharedContextSendException;
    
    /**
     * L[̏W擾B<p>
     *
     * @param timeout ^CAEg[ms]
     * @return L[̏W
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Set<K> keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * [J̃L[̏W擾B<p>
     *
     * @return L[̏W
     */
    public Set<K> keySetLocal();
    
    /**
     * o^ĂL[̌擾B<p>
     *
     * @param timeout ^CAEg[ms]
     * @return L[̌
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * [Jɓo^ĂL[̌擾B<p>
     *
     * @return L[̌
     */
    public int sizeLocal();
    
    /**
     * 󂩂ǂ肷B<p>
     *
     * @return truȅꍇA
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean isEmpty() throws SharedContextSendException;
    
    /**
     * [J󂩂ǂ肷B<p>
     *
     * @return truȅꍇA
     */
    public boolean isEmptyLocal();
    
    /**
     * w肳ꂽL[o^Ă邩𔻒肷B<p>
     *
     * @param key L[
     * @param timeout ^CAEg[ms]
     * @return o^Ăꍇtrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽL[[Jɓo^Ă邩𔻒肷B<p>
     *
     * @param key L[
     * @return o^Ăꍇtrue
     */
    public boolean containsKeyLocal(Object key);
    
    /**
     * w肳ꂽlo^Ă邩𔻒肷B<p>
     *
     * @param value l
     * @param timeout ^CAEg[ms]
     * @return o^Ăꍇtrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽl[Jɓo^Ă邩𔻒肷B<p>
     *
     * @param value l
     * @return o^Ăꍇtrue
     */
    public boolean containsValueLocal(Object value);
    
    /**
     * ̃ReLXg̃[J̓eSĊ܂ރ}bv擾B<p>
     *
     * @return ReLXg̃[J̓eSĊ܂ރ}bv
     */
    public Map<K, Object> allLocal();
    
    /**
     * ̃ReLXg̃[J̃Gg[W擾B<p>
     *
     * @return ReLXg̃[J̃Gg[W
     */
    public Set<Map.Entry<K, Object>> entrySetLocal();
    
    /**
     * [J̃ReLXg̏W擾B<p>
     *
     * @return ReLXg̏W
     */
    public Collection<Object> valuesLocal();
    
    /**
     * ReLXgsB<p>
     * NCAg[h̏ꍇ́A[J̃ReLXgNAB܂AT[o[hŎm[h̏ꍇ́ASẴm[hɓ߂oB<br>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgsB<p>
     * NCAg[h̏ꍇ́A[J̃ReLXgNAB܂AT[o[hŎm[h̏ꍇ́ASẴm[hɓ߂oB<br>
     *
     * @param timeout ^CAEg
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * NCAg/T[o[h𔻒肷B<p>
     *
     * @return truȅꍇANCAg[h
     */
    public boolean isClient();
    
    /**
     * m[hǂ𔻒肷B<p>
     *
     * @return m[h̏ꍇtrue
     */
    public boolean isMain();
    
    /**
     * m[hID擾B<p>
     *
     * @return m[hID
     */
    public Object getId();
    
    /**
     * m[h̃m[hID擾B<p>
     *
     * @return m[hID
     */
    public Object getMainId();
    
    /**
     * LReLXgXVXi[o^B<p>
     *
     * @param listener LReLXgXVXi[
     */
    public void addSharedContextUpdateListener(SharedContextUpdateListener<K> listener);
    
    /**
     * LReLXgXVXi[폜B<p>
     *
     * @param listener LReLXgXVXi[
     */
    public void removeSharedContextUpdateListener(SharedContextUpdateListener<K> listener);
    
    /**
     * L[wCfbNX͂B<p>
     *
     * @param name CfbNX
     * @exception SharedContextIllegalIndexException CfbNXsȏꍇ
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void analyzeKeyIndex(String name) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * L[wCfbNXŌB<p>
     *
     * @param name CfbNX
     * @param key L[ƂȂIuWFNg
     * @return ReLXgL[̏W
     * @exception SharedContextIllegalIndexException CfbNXsȏꍇ
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public  Set<K> searchByKeyIndex(String name, Object key) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * L[wCfbNXŌB<p>
     *
     * @param name CfbNX
     * @param key L[ƂȂIuWFNg
     * @param timeout ^CAEg
     * @return ReLXgL[̏W
     * @exception SharedContextIllegalIndexException CfbNXsȏꍇ
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Set<K> searchByKeyIndex(String name, Object key, long timeout) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * L[wCfbNXŃ[J猟B<p>
     *
     * @param name CfbNX
     * @param key L[ƂȂIuWFNg
     * @return ReLXgL[̏W
     * @exception SharedContextIllegalIndexException CfbNXsȏꍇ
     */
    public Set<K> searchByKeyIndexLocal(String name, Object key) throws SharedContextIllegalIndexException;
    
    /**
     * NGf[^m[hŃC^[v^sB<p>
     * NG̕@́A{@link jp.ossc.nimbuse.service.interpreter.Interpreter Interpreter}̎ɈˑB<br>
     * NGł́AReLXgϐ"context"ŎQƂłB<br>
     *
     * @param query NG
     * @param variables NGŎgpϐ}bv
     * @return s
     * @exception EvaluateException NG̎sŗOꍇ
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Object executeInterpretQuery(String query, Map<String, Object> variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * NGf[^m[hŃC^[v^sB<p>
     *
     * @param query NG
     * @param variables NGŎgpϐ}bv
     * @param timeout ^CAEg
     * @return s
     * @exception EvaluateException NG̎sŗOꍇ
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Object executeInterpretQuery(String query, Map<String, Object> variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException;
}