/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.distribute;

import java.net.*;
import java.io.*;
import java.util.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.daemon.*;

/**
 * SMTPT[o`FbJ[T[rXB<p>
 *
 * @author H.Nakano
 */
public class SmtpKeepAliveCheckerService extends ServiceBase
 implements SmtpKeepAliveCheckerServiceMBean{
    
    private static final long serialVersionUID = -1543463563116884001L;
    
    protected static final String C_HELLOW = "HELO localhost\r\n" ; //$NON-NLS-1$
    
    protected static final String C_WRONG_SIGN = "2" ; //$NON-NLS-1$
    protected static final String C_QUITE = "QUIT\r\n" ; //$NON-NLS-1$
    
    protected static final String C_EOF_KEY = "SMTP_00003" ; //$NON-NLS-1$
    protected static final String C_ERRSTATE_KEY = "SMTP_00004" ; //$NON-NLS-1$
    protected static final String C_NORMALSTATE_KEY = "SMTP_00005" ; //$NON-NLS-1$
    protected static final String C_TIMEOUT_KEY = "SMTP_00006" ; //$NON-NLS-1$
    protected static final String C_PROTOCOL_ERROR_KEY = "SMTP_00007" ; //$NON-NLS-1$
    protected static final String C_IOERROR_KEY = "SMTP_00008" ; //$NON-NLS-1$
    
    protected String mHostName;
    protected InetAddress mIp;
    protected volatile int mPort = 0;
    protected volatile int mConnectionTimeOut = 0;
    protected volatile int mTimeOut = 1000;
    
    protected String eofLogMessageId = C_EOF_KEY;
    protected String errorStateLogMessageId = C_ERRSTATE_KEY;
    protected String normalStateLogMessageId = C_NORMALSTATE_KEY;
    protected String timeoutLogMessageId = C_TIMEOUT_KEY;
    protected String protocolErrorLogMessageId = C_PROTOCOL_ERROR_KEY;
    protected String ioErrorLogMessageId = C_IOERROR_KEY;
    
    protected boolean isOutputEOFLogMessage;
    protected boolean isOutputErrorStateLogMessage;
    protected boolean isOutputNormalStateLogMessage;
    protected boolean isOutputTimeoutLogMessage;
    protected boolean isOutputProtocolErrorLogMessage;
    protected boolean isOutputIOErrorLogMessage;
    protected List<KeepAliveListener> keepAliveListeners;
    
    /**
     * JNDIT[o̐mF邩ǂ̃tOB<p>
     */
    protected boolean isAliveCheckSMTPServer;
    
    /**
     * SMTPT[o̐Ă邩ǂ̃tOB<p>
     */
    protected boolean isAliveSMTPServer;
    
    /**
     * SMTPT[o̐mFԊu[msec]B<p>
     */
    protected long aliveCheckSMTPServerInterval = 60000;
    
    /**
     * {@link Daemon}IuWFNgB<p>
     */
    protected Daemon daemon;
    
    protected boolean isLoggingDeadSMTPServer = true;
    
    protected boolean isLoggingRecoverSMTPServer = true;
    
    protected String deadSMTPServerLogMessageId = SMTP_SERVER_DEAD_MSG_ID;
    
    protected String recoverSMTPServerLogMessageId = SMTP_SERVER_RECOVER_MSG_ID;
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setHostName(String hostName) throws UnknownHostException{
        mHostName = hostName;
        mIp = InetAddress.getByName(hostName);
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getHostName(){
        return mHostName;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setPort(int port){
        mPort = port;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public int getPort(){
        return mPort;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setConnectionTimeoutMillis(int milisec){
        mConnectionTimeOut = milisec;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public int getConnectionTimeoutMillis(){
        return mConnectionTimeOut;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setTimeoutMillis(int milisec){
        mTimeOut = milisec;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public int getTimeoutMillis(){
        return mTimeOut;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setEOFLogMessageId(String id){
        eofLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getEOFLogMessageId(){
        return eofLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setErrorStateLogMessageId(String id){
        errorStateLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getErrorStateLogMessageId(){
        return errorStateLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setNormalStateLogMessageId(String id){
        normalStateLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getNormalStateLogMessageId(){
        return normalStateLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setTimeoutLogMessageId(String id){
        timeoutLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getTimeoutLogMessageId(){
        return timeoutLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setProtocolErrorLogMessageId(String id){
        protocolErrorLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getProtocolErrorLogMessageId(){
        return protocolErrorLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setIOErrorLogMessageId(String id){
        ioErrorLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getIOErrorLogMessageId(){
        return ioErrorLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setOutputEOFLogMessage(boolean isOutput){
        isOutputEOFLogMessage = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isOutputEOFLogMessage(){
        return isOutputEOFLogMessage;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setOutputErrorStateLogMessage(boolean isOutput){
        isOutputErrorStateLogMessage = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isOutputErrorStateLogMessage(){
        return isOutputErrorStateLogMessage;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setOutputNormalStateLogMessage(boolean isOutput){
        isOutputNormalStateLogMessage = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isOutputNormalStateLogMessage(){
        return isOutputNormalStateLogMessage;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setOutputTimeoutLogMessage(boolean isOutput){
        isOutputTimeoutLogMessage = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isOutputTimeoutLogMessage(){
        return isOutputTimeoutLogMessage;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setOutputProtocolErrorLogMessage(boolean isOutput){
        isOutputProtocolErrorLogMessage = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isOutputProtocolErrorLogMessage(){
        return isOutputProtocolErrorLogMessage;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setOutputIOErrorLogMessage(boolean isOutput){
        isOutputIOErrorLogMessage = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isOutputIOErrorLogMessage(){
        return isOutputIOErrorLogMessage;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setLoggingDeadSMTPServer(boolean isOutput){
        isLoggingDeadSMTPServer = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isLoggingDeadSMTPServer(){
        return isLoggingDeadSMTPServer;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setLoggingRecoverSMTPServer(boolean isOutput){
        isLoggingRecoverSMTPServer = isOutput;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isLoggingRecoverSMTPServer(){
        return isLoggingRecoverSMTPServer;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setDeadSMTPServerLogMessageId(String id){
        deadSMTPServerLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getDeadSMTPServerLogMessageId(){
        return deadSMTPServerLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setRecoverSMTPServerLogMessageId(String id){
        recoverSMTPServerLogMessageId = id;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public String getRecoverSMTPServerLogMessageId(){
        return recoverSMTPServerLogMessageId;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setAliveCheckSMTPServer(boolean isCheck){
        isAliveCheckSMTPServer = isCheck;
        if(isCheck && getState() == State.STARTED && !daemon.isRunning()){
            daemon.start();
        }
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isAliveCheckSMTPServer(){
        return isAliveCheckSMTPServer;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public void setAliveCheckSMTPServerInterval(long interval){
        aliveCheckSMTPServerInterval = interval;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public long getAliveCheckSMTPServerInterval(){
        return aliveCheckSMTPServerInterval;
    }
    
    // SmtpChekerServiceMBeanJavaDoc
    public boolean isAliveSMTPServer(){
        if(getState() != State.STARTED){
            return false;
        }else if(isAliveCheckSMTPServer){
            return isAliveSMTPServer;
        }else{
            return isAlive();
        }
    }
    
    // SmtpKeepAliveCheckerJavaDoc
    public String getHostIp(){
        return mIp == null ? null : mIp.getHostAddress();
    }
    
    // SmtpKeepAliveCheckerJavaDoc
    public int getHostPort(){
        return mPort;
    }
    
    public void createService() throws Exception{
        keepAliveListeners = new ArrayList<KeepAliveListener>();
        daemon = new Daemon(new KeepAliveCheckDaemon());
        daemon.setName("Nimbus SMTPCheckDaemon " + getServiceNameObject());
    }
    
    public void startService() throws Exception{
        
        isAliveSMTPServer = isAlive();
        
        if(isAliveCheckSMTPServer){
            // f[N
            daemon.start();
        }
    }
    
    public void stopService() throws Exception{
        
        // f[~
        daemon.stop();
    }
    
    public void destroyService() throws Exception{
        keepAliveListeners = null;
    }
    
    // KeepAliveCheckerJavaDoc
    public boolean isAlive(){
        return isAliveInternal() == null ? true : false;
    }
    protected Object isAliveInternal(){
        Object ret = null;
        Socket sock = null;
        try{
            final int len = 1024;
            // \Pbg𐶐ēǂݏ̃Xg[I[v
            sock = new Socket();
            sock.connect(new InetSocketAddress(mIp, mPort), mConnectionTimeOut);
            BufferedInputStream in = new BufferedInputStream(
                sock.getInputStream(),
                len
            );
            BufferedOutputStream out = new BufferedOutputStream(
                sock.getOutputStream(),
                len
            );
            
            // HELLOM
            out.write(C_HELLOW.getBytes(), 0, C_HELLOW.getBytes().length);
            out.flush();
            
            // ^CAEg҂ɂB
            sock.setSoTimeout(mTimeOut);
            
            // ǂ
            byte[] resBuf = new byte[len];
            int readLen = in.read(resBuf, 0, len);
            
            if(readLen == -1){    // ~
                if(isOutputEOFLogMessage){
                    getLogger().write(eofLogMessageId, getSMTPServerInfo());
                }
                ret = "Response reading detect EOF.";
            }else {                // ғ
                String retCode = new String(resBuf, 0, readLen);
                if(!retCode.startsWith(C_WRONG_SIGN)) {    // q
                    if(isOutputErrorStateLogMessage){
                        getLogger().write(errorStateLogMessageId, getSMTPServerInfo(), retCode);
                    }
                    ret = "Return code is : " + retCode;
                }else{
                    if(isOutputNormalStateLogMessage){
                        getLogger().write(normalStateLogMessageId, getSMTPServerInfo());
                    }
                }
                
                // \Pbgؒf
                out.write(C_QUITE.getBytes(), 0, C_QUITE.getBytes().length);
                out.flush();
            }
        }catch(InterruptedIOException e){ // ^CAEg
            if(isOutputTimeoutLogMessage){
                getLogger().write(timeoutLogMessageId, e, getSMTPServerInfo());
            }
            ret = e;
        }catch(SocketException e){ // vgRG[
            if(isOutputProtocolErrorLogMessage){
                getLogger().write(protocolErrorLogMessageId, e, getSMTPServerInfo());
            }
            ret = e;
        }catch(IOException e){ // \PbgǂݏG[
            if(isOutputIOErrorLogMessage){
                getLogger().write(ioErrorLogMessageId, e, getSMTPServerInfo());
            }
            ret = e;
        }finally{
            try{
                if(sock != null){
                    sock.close();
                }
            }catch(IOException ex){
                if(isOutputIOErrorLogMessage){
                    getLogger().write(ioErrorLogMessageId, ex, getSMTPServerInfo());
                }
                ret = ex;
            }
        }
        // `FbNʍXV
        return ret;
    }
    
    // KeepAliveCheckerJavaDoc
    public void addKeepAliveListener(KeepAliveListener listener){
        synchronized(keepAliveListeners){
            keepAliveListeners.add(listener);
        }
    }
    
    // KeepAliveCheckerJavaDoc
    public void removeKeepAliveListener(KeepAliveListener listener){
        synchronized(keepAliveListeners){
            keepAliveListeners.remove(listener);
        }
    }
    
    // KeepAliveCheckerJavaDoc
    public void clearKeepAliveListener(){
        synchronized(keepAliveListeners){
            keepAliveListeners.clear();
        }
    }
    
    protected String getSMTPServerInfo(){
        return getHostName() + ':' + getHostPort();
    }
    
    protected class KeepAliveCheckDaemon implements DaemonRunnable<Object>{
        
        /**
         * f[JnɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onStart(){
            return true;
        }
        
        /**
         * f[~ɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onStop(){
            return true;
        }
        
        /**
         * f[fɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onSuspend(){
            return true;
        }
        
        /**
         * f[ĊJɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onResume(){
            return true;
        }
        
        /**
         * 莞sleepAisAliveInternal()sāǍʂԂB<p>
         * 
         * @param ctrl DaemonControlIuWFNg
         * @return isAlive()̌
         */
        public Object provide(DaemonControl ctrl){
            try{
                Thread.sleep(aliveCheckSMTPServerInterval);
            }catch(InterruptedException e){
                Thread.interrupted();
            }
            return isAliveInternal();
        }
        
        /**
         * lookupedObjœnꂽIuWFNgB<p>
         * isAliveSMTPServertruȅԂŁAlookupedObj != null ̏ꍇASMTPT[o񂾎|̃G[Oo͂B<br>
         * isAliveSMTPServerfalsȅԂŁAlookupedObj == null ̏ꍇASMTPT[oA|̒ʒmOo͂B<br>
         *
         * @param lookupedObj isAlive()̌
         * @param ctrl DaemonControlIuWFNg
         */
        public void consume(Object lookupedObj, DaemonControl ctrl){
            if(!isAliveCheckSMTPServer){
                return;
            }
            if(isAliveSMTPServer){
                if(lookupedObj != null){
                    isAliveSMTPServer = false;
                    synchronized(keepAliveListeners){
                        for(KeepAliveListener keepAliveListener : keepAliveListeners){
                            keepAliveListener.onDead(SmtpKeepAliveCheckerService.this);
                        }
                    }
                    // G[Oo
                    if(isLoggingDeadSMTPServer){
                        if(lookupedObj instanceof Throwable){
                            getLogger().write(
                                deadSMTPServerLogMessageId,
                                (Throwable)lookupedObj,
                                getSMTPServerInfo(),
                                ((Throwable)lookupedObj).getMessage()
                            );
                        }else{
                            getLogger().write(
                                deadSMTPServerLogMessageId,
                                new Object[]{
                                    getSMTPServerInfo(),
                                    lookupedObj
                                }
                            );
                        }
                    }
                }
            }else{
                if(lookupedObj == null){
                    isAliveSMTPServer = true;
                    synchronized(keepAliveListeners){
                        for(KeepAliveListener keepAliveListener : keepAliveListeners){
                            keepAliveListener.onRecover(SmtpKeepAliveCheckerService.this);
                        }
                    }
                    if(isLoggingRecoverSMTPServer){
                        // ʒmOo
                        getLogger().write(
                            recoverSMTPServerLogMessageId,
                            getSMTPServerInfo()
                        );
                    }
                }
            }
        }
        
        /**
         * ȂB<p>
         */
        public void garbage(){
        }
    }
}
