/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.ga;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link SimpleGenericAlgorithmService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see SimpleGenericAlgorithmService
 */
public interface SimpleGeneticAlgorithmServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link SeedMatchMaker}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SeedMatchMakerT[rX̃T[rX
     */
    public void setSeedMatchMakerServiceName(ServiceName name);
    
    /**
     * {@link SeedMatchMaker}T[rX̃T[rX擾B<p>
     *
     * @return SeedMatchMakerT[rX̃T[rX
     */
    public ServiceName getSeedMatchMakerServiceName();
    
    /**
     * ㋣̊eV[h̓KlvZɍsꍇɎgp{@link jp.ossc.nimbus.service.queue.QueueHandlerContainer QueueHandlerContainer}T[rX̃T[rXݒ肷B<p>
     *
     * @param name QueueHandlerContainerT[rX̃T[rX
     */
    public void setQueueHandlerContainerServiceName(ServiceName name);
    
    /**
     * ㋣̊eV[h̓KlvZɍsꍇɎgp{@link jp.ossc.nimbus.service.queue.QueueHandlerContainer QueueHandlerContainer}T[rX̃T[rX擾B<p>
     *
     * @return QueueHandlerContainerT[rX̃T[rX
     */
    public ServiceName getQueueHandlerContainerServiceName();
    
    /**
     * ㋣̊eV[h̓KlvZɍsꍇ̃Xbhݒ肷B<p>
     * {@link #setQueueHandlerContainerServiceName(ServiceName)}w肳Ăꍇ́A{@link jp.ossc.nimbus.service.queue.QueueHandlerContainer QueueHandlerContainer}T[rX{@link jp.ossc.nimbus.service.queue.QueueHandlerContainer#getQueueHandlerSize() getQueueHandlerSize()}D悳B<br>
     * ftHǵA0ŒɓKlvZsB<br>
     *
     * @param num V[h̓KlvZ̕x
     */
    public void setParallelThreadNum(int num);
    
    /**
     * ㋣̊eV[h̓KlvZɍsꍇ̃Xbh擾B<p>
     *
     * @return V[h̓KlvZ̕x
     */
    public int getParallelThreadNum();
    
    /**
     * ㋣̊eV[h̓KlvZɍsꍇ̉҂[ms]ݒ肷B<p>
     * ftHǵA-1Ŗ҂B<br>
     *
     * @param timeout ҂[ms]
     */
    public void setParallelResponseTimout(long timeout);
    
    /**
     * ㋣̊eV[h̓KlvZɍsꍇ̉҂[ms]擾B<p>
     *
     * @return ҂[ms]
     */
    public long getParallelResponseTimout();
}
