/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.queue;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultQueueService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DefaultQueueService
 */
public interface DefaultQueueServiceMBean extends ServiceBaseMBean{
    
    /**
     * L[̏eʂݒ肷B<p>
     * T[rX̐Ɏgp鑮Ȃ̂ŁA̕ύX͂łȂB<br>
     * 0ȏ̒lݒ肷ƗLɂȂBftHgĺA-1Łueʂw肵ȂvłB<br>
     *
     * @param initial L[̏e
     */
    public void setInitialCapacity(int initial);
    
    /**
     * L[̏eʂ擾B<p>
     *
     * @return L[̏e
     */
    public int getInitialCapacity();
    
    /**
     * L[̗vfeʂzɁAeʂݒ肷B<p>
     * T[rX̐Ɏgp鑮Ȃ̂ŁA̕ύX͂łȂB<br>
     * 0ȏ̒lݒ肷ƗLɂȂB܂ALȏeʂݒ肳ĂȂꍇ́AƂȂBftHgĺA-1Łueʂw肵ȂvłB<br>
     *
     * @param increment e
     */
    public void setCapacityIncrement(int increment);
    
    /**
     * L[̗vfeʂzɁAeʂ擾B<p>
     *
     * @return e
     */
    public int getCapacityIncrement();
    
    /**
     * L[vfLbVLbVT[rXݒ肷B<p>
     * ̑ݒ肳ĂꍇAw肳ꂽLbVT[rXɁAL[vfLbVBL[ɂ́A{@link jp.ossc.nimbus.service.cache.CachedReference CachedReference}ێ邽߁AL[vf̐̓LbVT[rXɈς˂B<br>
     *
     * @param name {@link jp.ossc.nimbus.service.cache.Cache Cache}T[rX
     */
    public void setCacheServiceName(ServiceName name);
    
    /**
     * L[vfLbVLbVT[rX擾B<p>
     *
     * @return {@link jp.ossc.nimbus.service.cache.Cache Cache}T[rX
     */
    public ServiceName getCacheServiceName();
    
    /**
     * L[ɑ΂Ė擾҂Xbhsleep鎞Ԃݒ肷B<p>
     * L[҂̐擪łȂꍇAL[ɗ܂ĂȂꍇ́AĂsleepB<br>
     * ftHǵA10bB
     *
     * @param millis L[ɑ΂Ė擾҂Xbhsleep鎞[ms]
     */
    public void setSleepTime(long millis);
    
    /**
     * L[ɑ΂Ė擾҂Xbhsleep鎞Ԃ擾B<p>
     *
     * @return L[ɑ΂Ė擾҂Xbhsleep鎞[ms]
     */
    public long getSleepTime();
    
    /**
     * L[̍ő臒lݒ肷B<p>
     * L[̐[ő臒lɓBƁAL[ւ̓͑҂AL[̈ƓB<br>
     * ftHǵA-1ŁAő臒lȂ̏ԂłB<br>
     *
     * @param size L[̍ő臒l
     */
    public void setMaxThresholdSize(int size);
    
    /**
     * L[̍ő臒l擾B<p>
     *
     * @return L[̍ő臒l
     */
    public int getMaxThresholdSize();
    
    /**
     * L[vf擾ɗǂɓnۏ؂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAۏ؂
     */
    public boolean isSafeGetOrder();
    
    /**
     * L[vf擾ɗǂɓnۏ؂邩ǂݒ肷B<p>
     * ftHǵAtrueŕۏ؂B<br>
     *
     * @param isSafe ۏ؂ꍇAtrue
     */
    public void setSafeGetOrder(boolean isSafe);
    
    /**
     * Ŏgp{@link jp.ossc.nimbus.util.SynchronizeMonitor SynchronizeMonitor}̎NXݒ肷B<p>
     *
     * @param clazz SynchronizeMonitor̎NX
     */
    public void setSynchronizeMonitorClass(Class<?> clazz);
    
    /**
     * Ŏgp{@link jp.ossc.nimbus.util.SynchronizeMonitor SynchronizeMonitor}̎NX擾B<p>
     *
     * @return SynchronizeMonitor̎NX
     */
    public Class<?> getSynchronizeMonitorClass();
    
    /**
     * L[݂̗̌vfXg擾B<p>
     * Ŏ擾ꂽL[vf́Ȃł̓L[폜ȂB<br>
     *
     * @return L[݂̗̌vfXg
     */
    public List<?> elements();
    
    /**
     * L[B <p>
     */
    public void clear();
    
    /**
     * ܂łɃL[Ɋi[ꂽ擾B<p>
     *
     * @return ܂łɃL[Ɋi[ꂽ
     */
    public long getCount();
    
    /**
     * O₢킹L[Ɋi[ꂽ擾B<p>
     *
     * @return O₢킹L[Ɋi[ꂽ
     */
    public long getCountDelta();
    
    /**
     * ŌɃL[Ɋi[ꂽ擾B<p>
     *
     * @return ŌɃL[Ɋi[ꂽ
     */
    public long getLastPushedTimeMillis();
    
    /**
     * ŌɃL[Ɋi[ꂽ擾B<p>
     *
     * @return ŌɃL[Ɋi[ꂽ
     */
    public Date getLastPushedTime();
    
    /**
     * ݂̃L[̐[擾B<p>
     *
     * @return ݂̃L[̐[
     */
    public long getDepth();
    
    /**
     * O₢킹̃L[̐[擾B<p>
     *
     * @return O₢킹̃L[̐[
     */
    public long getDepthDelta();
    
    /**
     * ő哞B̃L[̐[擾B<p>
     *
     * @return ő哞B̃L[̐[
     */
    public long getMaxDepth();
}
