/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link TransactionSynchronizerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see TransactionSynchronizerService
 */
public interface TransactionSynchronizerServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setSourceConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getSourceConnectionFactoryServiceName();
    
    /**
     * {@link ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setDestinationConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getDestinationConnectionFactoryServiceName();
    
    /**
     * gUNVOe[ũe[uݒ肷B<p>
     * ftHǵA{@link jp.ossc.nimbus.util.sql.TransactionLoggingConnection#DEFAULT_TRANSACTION_TABLE_NAME}B<br>
     *
     * @param name e[u
     */
    public void setTransactionTableName(String name);
    
    /**
     * gUNVOe[ũe[u擾B<p>
     *
     * @return e[u
     */
    public String getTransactionTableName();
    
    /**
     * gUNVp[^Oe[ũe[uݒ肷B<p>
     * ftHǵA{@link jp.ossc.nimbus.util.sql.TransactionLoggingConnection#DEFAULT_TRANSACTION_PARAM_TABLE_NAME}B<br>
     *
     * @param name e[u
     */
    public void setTransactionParamTableName(String name);
    
    /**
     * gUNVp[^Oe[ũe[u擾B<p>
     *
     * @return e[u
     */
    public String getTransactionParamTableName();
    
    /**
     * {@link jp.ossc.nimbus.service.transaction.TransactionManagerFactory}T[rX̃T[rXݒ肷B<p>
     * ݒ肵ꍇAւ̃gUNVsƓ̃gUNVO̍폜𓯈gUNVŎsB<br>
     *
     * @param name TransactionManagerFactoryT[rX̃T[rX
     */
    public void setTransactionManagerFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.transaction.TransactionManagerFactory}T[rX̃T[rX擾B<p>
     *
     * @return TransactionManagerFactoryT[rX̃T[rX
     */
    public ServiceName getTransactionManagerFactoryServiceName();
    
    /**
     * T[rX̋Nɓsǂݒ肷B<p>
     * ftHǵAfalseŁANɓȂB<br>
     * 
     * @param isSynchronize sꍇ́Atrue
     */
    public void setSynchronizeOnStart(boolean isSynchronize);
    
    /**
     * T[rX̋Nɓsǂ𔻒肷B<p>
     * 
     * @return truȅꍇAs
     */
    public boolean isSynchronizeOnStart();
    
    /**
     * őob`sݒ肷B<p>
     * sꍇɁANG̃gUNVob`ssA
     * [obNZOgs\̂ŁA̍ő匏܂Ńob`܂ƈUR~bgB<br>
     * ftHǵA10B<br>
     * 
     * @param max őob`s
     */
    public void setMaxBatchCount(int max);
    
    /**
     * őob`s擾B<p>
     * 
     * @return őob`s
     */
    public int getMaxBatchCount();
    
    /**
     * f[^x[X𓯊B<p>
     * ̃gUNVOǂݍŁAɃgUNVsB̍ہAsgUNVO͍폜B<br>
     *
     * @return gUNV̌
     * @exception Exception ɗOꍇ
     */
    public int synchronize() throws Exception;
    
    /**
     * ݂̌̃gUNVO擾B<p>
     *
     * @return gUNVO
     * @exception Exception gUNVO̎擾Ɏsꍇ
     */
    public long countTransactionLog() throws Exception;
}