/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;


import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link StringEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class StringEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
            {"aaa", "aaa"},
            {" aaa ", " aaa "},
            {"\" aaa \"", " aaa "},
            {"\"\" aaa \"\"", "\" aaa \""}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.StringEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.StringEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsText")
    public void testSetAsText(String paramStr, String answer){
        editorSetText(StringEditor.class, paramStr, answer);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
            {"test.StringEditor.value", "abc", "\\u3042${test.StringEditor.value}", new String("abc")}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.StringEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.StringEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, String answer){
        editorSetTextSystemProperty(StringEditor.class, propertyKeyStr, propertyValStr, paramStr, answer);
    }
    
    @DataProvider(name = "SetValue")
    public Object[][] dataSetValue(){
        return new Object[][]{
            {"aaa", "aaa"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.StringEditor#setValue(java.math.BigDecimal)",
                    "jp.ossc.nimbus.beans.StringEditor#getAsText()",
                    "Normal"},
        dataProvider = "SetValue")
    public void testSetValue(String param, String answerStr){
        editorSetValue(StringEditor.class, param, answerStr);
    }
}
