# -*- coding: utf-8 -*-
#
#  Copyright (C) 2002 by Tamito KAJIYAMA
#  Copyright (C) 2003-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import gtk


keymap_old = {
    gtk.keysyms.BackSpace: 'back',
    gtk.keysyms.Tab: 'tab',
    gtk.keysyms.KP_Tab: 'tab',
    gtk.keysyms.Clear: 'clear',
    gtk.keysyms.Return: 'return',
    gtk.keysyms.KP_Enter: 'return',
    gtk.keysyms.Menu: '',
    gtk.keysyms.Pause: 'pause',
    gtk.keysyms.Kanji: '',
    gtk.keysyms.Escape: 'escape',
    gtk.keysyms.Henkan: '',
    gtk.keysyms.Muhenkan: '',
    gtk.keysyms.space: 'space',
    gtk.keysyms.Prior: 'prior',
    gtk.keysyms.Next: 'next',
    gtk.keysyms.End: 'end',
    gtk.keysyms.Home: 'home',
    gtk.keysyms.Left: 'left',
    gtk.keysyms.Up: 'up',
    gtk.keysyms.Right: 'right',
    gtk.keysyms.Down: 'down',
    gtk.keysyms.Select: '',
    gtk.keysyms.Print: '',
    gtk.keysyms.Execute: '',
    gtk.keysyms.Insert: '',
    gtk.keysyms.Delete: 'delete',
    gtk.keysyms.Help: '',
    gtk.keysyms._0: '0',
    gtk.keysyms._1: '1',
    gtk.keysyms._2: '2',
    gtk.keysyms._3: '3',
    gtk.keysyms._4: '4',
    gtk.keysyms._5: '5',
    gtk.keysyms._6: '6',
    gtk.keysyms._7: '7',
    gtk.keysyms._8: '8',
    gtk.keysyms._9: '9',
    gtk.keysyms.a: 'a',
    gtk.keysyms.b: 'b',
    gtk.keysyms.c: 'c',
    gtk.keysyms.d: 'd',
    gtk.keysyms.e: 'e',
    gtk.keysyms.f: 'f',
    gtk.keysyms.g: 'g',
    gtk.keysyms.h: 'h',
    gtk.keysyms.i: 'i',
    gtk.keysyms.j: 'j',
    gtk.keysyms.k: 'k',
    gtk.keysyms.l: 'l',
    gtk.keysyms.m: 'm',
    gtk.keysyms.n: 'n',
    gtk.keysyms.o: 'o',
    gtk.keysyms.p: 'p',
    gtk.keysyms.q: 'q',
    gtk.keysyms.r: 'r',
    gtk.keysyms.s: 's',
    gtk.keysyms.t: 't',
    gtk.keysyms.u: 'u',
    gtk.keysyms.v: 'v',
    gtk.keysyms.w: 'w',
    gtk.keysyms.x: 'x',
    gtk.keysyms.y: 'y',
    gtk.keysyms.z: 'z',
    gtk.keysyms.KP_0: '0',
    gtk.keysyms.KP_1: '1',
    gtk.keysyms.KP_2: '2',
    gtk.keysyms.KP_3: '3',
    gtk.keysyms.KP_4: '4',
    gtk.keysyms.KP_5: '5',
    gtk.keysyms.KP_6: '6',
    gtk.keysyms.KP_7: '7',
    gtk.keysyms.KP_8: '8',
    gtk.keysyms.KP_9: '9',
    gtk.keysyms.KP_Multiply: '*',
    gtk.keysyms.KP_Add: '+',
    gtk.keysyms.KP_Separator: '',
    gtk.keysyms.KP_Subtract: '-',
    gtk.keysyms.KP_Decimal: '',
    gtk.keysyms.KP_Divide: '/',
    gtk.keysyms.F1: 'f1',
    gtk.keysyms.F2: 'f2',
    gtk.keysyms.F3: 'f3',
    gtk.keysyms.F4: 'f4',
    gtk.keysyms.F5: 'f5',
    gtk.keysyms.F6: 'f6',
    gtk.keysyms.F7: 'f7',
    gtk.keysyms.F8: 'f8',
    gtk.keysyms.F9: 'f9',
    gtk.keysyms.F10: 'f10',
    gtk.keysyms.F11: 'f11',
    gtk.keysyms.F12: 'f12',
    gtk.keysyms.F13: 'f13',
    gtk.keysyms.F14: 'f14',
    gtk.keysyms.F15: 'f15',
    gtk.keysyms.F16: 'f16',
    gtk.keysyms.F17: 'f17',
    gtk.keysyms.F18: 'f18',
    gtk.keysyms.F19: 'f19',
    gtk.keysyms.F20: 'f20',
    gtk.keysyms.F21: 'f21',
    gtk.keysyms.F22: 'f22',
    gtk.keysyms.F23: 'f23',
    gtk.keysyms.F24: 'f24',
    gtk.keysyms.Num_Lock: '',
    gtk.keysyms.Scroll_Lock: '',
    gtk.keysyms.Shift_L: '',
    gtk.keysyms.Shift_R: '',
    gtk.keysyms.Control_L: '',
    gtk.keysyms.Control_R: '',
    }

keymap_new = {
    gtk.keysyms.BackSpace: '8',
    gtk.keysyms.Tab: '9',
    gtk.keysyms.KP_Tab: '9',
    gtk.keysyms.Clear: '12',
    gtk.keysyms.Return: '13',
    gtk.keysyms.KP_Enter: '13',
    gtk.keysyms.Menu: '18',
    gtk.keysyms.Pause: '19',
    gtk.keysyms.Kanji: '25',
    gtk.keysyms.Escape: '27',
    gtk.keysyms.Henkan: '28',
    gtk.keysyms.Muhenkan: '29',
    gtk.keysyms.space: '32',
    gtk.keysyms.Prior: '33',
    gtk.keysyms.Next: '34',
    gtk.keysyms.End: '35',
    gtk.keysyms.Home: '36',
    gtk.keysyms.Left: '37',
    gtk.keysyms.Up: '38',
    gtk.keysyms.Right: '39',
    gtk.keysyms.Down: '40',
    gtk.keysyms.Select: '41',
    gtk.keysyms.Print: '42',
    gtk.keysyms.Execute: '43',
    gtk.keysyms.Insert: '45',
    gtk.keysyms.Delete: '46',
    gtk.keysyms.Help: '47',
    gtk.keysyms._0: '48',
    gtk.keysyms._1: '49',
    gtk.keysyms._2: '50',
    gtk.keysyms._3: '51',
    gtk.keysyms._4: '52',
    gtk.keysyms._5: '53',
    gtk.keysyms._6: '54',
    gtk.keysyms._7: '55',
    gtk.keysyms._8: '56',
    gtk.keysyms._9: '57',
    gtk.keysyms.a: '65',
    gtk.keysyms.b: '66',
    gtk.keysyms.c: '67',
    gtk.keysyms.d: '68',
    gtk.keysyms.e: '69',
    gtk.keysyms.f: '70',
    gtk.keysyms.g: '71',
    gtk.keysyms.h: '72',
    gtk.keysyms.i: '73',
    gtk.keysyms.j: '74',
    gtk.keysyms.k: '75',
    gtk.keysyms.l: '76',
    gtk.keysyms.m: '77',
    gtk.keysyms.n: '78',
    gtk.keysyms.o: '79',
    gtk.keysyms.p: '80',
    gtk.keysyms.q: '81',
    gtk.keysyms.r: '82',
    gtk.keysyms.s: '83',
    gtk.keysyms.t: '84',
    gtk.keysyms.u: '85',
    gtk.keysyms.v: '86',
    gtk.keysyms.w: '87',
    gtk.keysyms.x: '88',
    gtk.keysyms.y: '89',
    gtk.keysyms.z: '90',
    gtk.keysyms.KP_0: '96',
    gtk.keysyms.KP_1: '97',
    gtk.keysyms.KP_2: '98',
    gtk.keysyms.KP_3: '99',
    gtk.keysyms.KP_4: '100',
    gtk.keysyms.KP_5: '101',
    gtk.keysyms.KP_6: '102',
    gtk.keysyms.KP_7: '103',
    gtk.keysyms.KP_8: '104',
    gtk.keysyms.KP_9: '105',
    gtk.keysyms.KP_Multiply: '106',
    gtk.keysyms.KP_Add: '107',
    gtk.keysyms.KP_Separator: '108',
    gtk.keysyms.KP_Subtract: '109',
    gtk.keysyms.KP_Decimal: '110',
    gtk.keysyms.KP_Divide: '111',
    gtk.keysyms.F1: '112',
    gtk.keysyms.F2: '113',
    gtk.keysyms.F3: '114',
    gtk.keysyms.F4: '115',
    gtk.keysyms.F5: '116',
    gtk.keysyms.F6: '117',
    gtk.keysyms.F7: '118',
    gtk.keysyms.F8: '119',
    gtk.keysyms.F9: '120',
    gtk.keysyms.F10: '121',
    gtk.keysyms.F11: '122',
    gtk.keysyms.F12: '123',
    gtk.keysyms.F13: '124',
    gtk.keysyms.F14: '125',
    gtk.keysyms.F15: '126',
    gtk.keysyms.F16: '127',
    gtk.keysyms.F17: '128',
    gtk.keysyms.F18: '129',
    gtk.keysyms.F19: '130',
    gtk.keysyms.F20: '131',
    gtk.keysyms.F21: '132',
    gtk.keysyms.F22: '133',
    gtk.keysyms.F23: '134',
    gtk.keysyms.F24: '135',
    gtk.keysyms.Num_Lock: '144',
    gtk.keysyms.Scroll_Lock: '145',
    gtk.keysyms.Shift_L: '160',
    gtk.keysyms.Shift_R: '161',
    gtk.keysyms.Control_L: '162',
    gtk.keysyms.Control_R: '163',
    }

def test():
    def key_press(widget, event):
        try:
            print keymap_old[event.keyval], \
                  keymap_new[event.keyval], '({0:d})'.format(event.keyval)
        except KeyError:
            if event.string:
                print repr(event.string), '({0:d})'.format(event.keyval)
            else:
                print 'unknown keyval:', event.keyval
    win = gtk.Window()
    win.set_events(gtk.gdk.KEY_PRESS_MASK)
    win.connect('destroy', gtk.main_quit)
    win.connect('key_press_event', key_press)
    win.show()
    gtk.main()


if __name__ == '__main__':
    test()
