# -*- coding: utf-8 -*-
#
#  Copyright (C) 2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

try:
    import feedparser
except:
    feedparser = None

import calendar
import time

from ninix.plugin import BasePlugin


class Plugin(BasePlugin):

    def get_updatetime(self, updated_parsed, updated):
        if updated_parsed:
            updated = time.localtime(calendar.timegm(updated_parsed))
            timestr = time.strftime("%Y/%m/%d %H:%M:%S", updated)
        elif updated:
            timestr = updated
        else:
            timestr = "----/--/-- --:--:--"
        updatetime = time.strptime(timestr, '%Y/%m/%d %H:%M:%S')
        return updatetime, timestr

    def create_message(self):
        num = self.get_variable('number')
        if num is None:
            return
        try:
            num = int(num)
        except:
            return
        if num < 0 or num > 64: ## FIXME
            return
        script = ''
        for index in range(num):
            url = self.get_variable('url{0}'.format(index))
            last_update = self.get_variable('updated{0}'.format(index))
            if last_update is not None:
                last_update = time.strptime(last_update, '%Y/%m/%d %H:%M:%S')
            fdp = feedparser.parse(url)
            #check updatetime
            updated_parsed = fdp.entries[0].updated_parsed
            updated = fdp.entries[0].updated
            updatetime, timestr = self.get_updatetime(
                updated_parsed, updated)
            if last_update is not None and updatetime <= last_update:
                continue
            script = ''.join((script, fdp.feed.subtitle, r':\n'))
            for entry in fdp['entries']:
                updated_parsed = entry.updated_parsed
                updated = entry.updated
                updatetime, _ = self.get_updatetime(
                    updated_parsed, updated)
                if last_update is not None and updatetime <= last_update:
                    continue
                title = entry['title']
                link = entry['link']
                script = ''.join((script, r'\q["', title, r'","', link, r'"]', r'\n\_w[3000]'))
            self.set_variable('updated{0}'.format(index), timestr)
        return script

    def run(self):
        if feedparser is None:
            raise SystemExit('Need feedparser - Universal Feed Parser for Python from http://www.feedparser.org/.')
        if len(self.args) > 0 and self.args[0] == 'url':
            url = self.open_dialog('URLを入力して下さい.')
            if not url:
                return
            num = self.get_variable('number')
            if num is None:
                num = 0
            try:
                num = int(num)
            except:
                num = 0
            self.set_variable('url{0}'.format(num), url)
            self.set_variable('updated{0}'.format(num), None)
            self.set_variable('number', str(num + 1))
            return
        script = self.create_message()
        if script:
            self.send_sstp('RSS reader',
                           script_odict={self.caller['ifghost']: script})
        return script


if __name__ == "__main__":
    rss_reader = Plugin(None, None, [], None, None, None, None)
    script = rss_reader.run()
    print(script)
    print(dir(rss_reader))
