﻿using System;
using System.Drawing;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Drawing.Imaging;
using System.Text;

namespace ColorDialog
{
    internal class AntiariasedCircle
    {
        public static Bitmap Create(float radius, float thickness, int quality, Color c)
        {
            int length = (int)(radius + thickness) * 2 + 10;
            int stride = length * 4;
            byte[] buffer = new byte[length * stride];
            float center = thickness + radius + 5;
            float circlesmall2 = (float)Math.Pow(radius - thickness / 2,2);
            float circlebig2 = (float)Math.Pow(radius + thickness / 2,2);
            for (int i = 0; i < length; i++)
            {
                for (int j = 0; j < length; j++)
                {
                    //poslength
                    /*double poslength = Math.Pow(i - center, 2) + Math.Pow(j - center, 2);
                    double poslength1 = Math.Pow(i - center, 2) + Math.Pow(j + 1 - center, 2);
                    double poslength2 = Math.Pow(i + 1 - center, 2) + Math.Pow(j - center, 2);
                    double poslength3 = Math.Pow(i + 1 - center, 2) + Math.Pow(j + 1 - center, 2);*/
                    float[] poss = new float[]{
                        (float)(Math.Pow(i - center, 2) + Math.Pow(j - center, 2)),
                        (float)(Math.Pow(i - center, 2) + Math.Pow(j + 1 - center, 2)),
                        (float)(Math.Pow(i + 1 - center, 2) + Math.Pow(j - center, 2)),
                        (float)(Math.Pow(i + 1 - center, 2) + Math.Pow(j + 1 - center, 2))
                    };
                    //checkincirclesmall
                    if (poss[0] < circlesmall2 && poss[1] < circlesmall2 && poss[2] < circlesmall2 && poss[3] < circlesmall2)
                    {
                        buffer[(length - 1 - i) * stride + j * 4 + 3] = 0;
                        continue;
                    }
                    //lastlize
                    int devidenum = quality;
                    int count = 0;
                    for (int k = 0; k < devidenum; k++)
                    {
                        for (int l = 0; l < devidenum; l++)
                        {
                            float pos = (float)(Math.Pow(i - center + (double)l / devidenum, 2) + Math.Pow(j - center + (double)k / devidenum, 2));
                            if (pos >= circlesmall2 && pos <= circlebig2)
                            {
                                count++;
                            }
                        }
                    }
                    byte a = (byte)(255 * count / (devidenum * devidenum));
                    buffer[(length - 1 - i) * stride + j * 4] = c.B;
                    buffer[(length - 1 - i) * stride + j * 4 + 1] = c.G;
                    buffer[(length - 1 - i) * stride + j * 4 + 2] = c.R;
                    buffer[(length - 1 - i) * stride + j * 4 + 3] = a;
                }
            }
            GCHandle GcHandle = GCHandle.Alloc(buffer, GCHandleType.Pinned);
            IntPtr scan0 = (IntPtr)(GcHandle.AddrOfPinnedObject().ToInt32() + (length - 1) * stride);
            Bitmap bitmap = new Bitmap(length, length, -stride, PixelFormat.Format32bppArgb, scan0);
            Bitmap ggg = new Bitmap(bitmap);
            GcHandle.Free();
            return ggg;
        }
    }
}
