﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using System.IO;
using NotepadNeueExtension;
using NotepadNeue;

namespace ExplorerExtension
{
    public partial class ExplorerExtension : CExtension
    {
        const string directorynodekey = "directory";
        const string notcheckednodetext = "karinode";
        const string cutsigntagtext = "forcut";

        TreeNode rightselectedfilenode = null;
        TreeNode rightselecteddirectorynode = null;
        TreeNode cutnode = null;
        string cutorcopyfilename;

        bool Renamemode = false;

        PictureBox p;
        PictureBox error;
        private ToolStripButton toolStripButton1;
        private ToolStripTextBox toolStripTextBox1;
        private ToolStrip toolStrip1;
        private IContainer components;
        private TextBox textBox1;
        private ToolStripMenuItem toolStripMenuItem6;
        private ToolStripContainer toolStripContainer1;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripMenuItem 新しいドキュメントに開くToolStripMenuItem;
        private ToolStripMenuItem toolStripMenuItem4;
        private ToolStripMenuItem toolStripMenuItem7;
        private ContextMenuStrip contextMenuStrip1;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripMenuItem toolStripMenuItem1;
        private ToolStripMenuItem toolStripMenuItem2;
        private ToolStripMenuItem toolStripMenuItem3;
        private ToolTip toolTip1;
        private MyTreeView treeView1;
        private ContextMenuStrip contextMenuStrip2;
        private ToolStripMenuItem toolStripMenuItem5;
        private ToolStripButton toolStripButton2;
        private FolderBrowserDialog folderBrowserDialog1;
        CheckBox cb;

        public override string ExtensionName
        {
            get
            {
                return "エクスプローラー";
            }
        }
        public override void Initialize(IExtensionHost Host)
        {
            InitializeLocal();
            this.Host = Host;
            Host.MainFormClosed += new EventHandler(Host_MainFormClosed);
            CurrentDirectory = Host.CurrentDirectory;
            UserDirectory = Host.GetSetting("ExplorerExtension", "UserDirectory");
            if (!Directory.Exists(UserDirectory))
            {
                UserDirectory = CurrentDirectory;
            }
            Initialize();
        }

        void Host_MainFormClosed(object sender, EventArgs e)
        {
            Host.SetSetting("ExplorerExtension", "UserDirectory", UserDirectory);
        }
        public ExplorerExtension()
        {
            //InitializeLocal();
        }

        void InitializeLocal()
        {
            InitializeComponent();
            this.GotFocus += new EventHandler(ExMyExplorer_GotFocus);
            Point basepoint = toolStripTextBox1.TextBox.Location;
            basepoint = new Point(toolStrip1.Location.X + basepoint.X, toolStrip1.Location.Y + basepoint.Y);
            Padding pad = toolStripTextBox1.Padding;
            p = new PictureBox();
            p.Size = new Size(16, 16);
            p.Padding = new Padding(0, 0, 0, 0);
            p.Location = new Point(basepoint.X + this.toolStripTextBox1.Width - 38 + pad.Left, basepoint.Y + 2 + pad.Top);
            p.Image = Properties.Resources.search;
            p.Cursor = Cursors.IBeam;
            p.MouseDown += new MouseEventHandler(p_MouseDown);
            error = new PictureBox();
            error.Size = new Size(16, 16);
            error.Padding = new Padding(0, 0, 0, 0);
            error.Location = new Point(basepoint.X + this.toolStripTextBox1.Width - 22 + pad.Left, basepoint.Y + 2 + pad.Top);
            error.Image = Properties.Resources.warn;
            error.Cursor = Cursors.IBeam;
            error.Visible = false;
            cb = new CheckBox();
            cb.Text = "";
            cb.Location = new Point(basepoint.X + this.toolStripTextBox1.Width - 22 + pad.Left, basepoint.Y + 3 + pad.Top);
            cb.Width = 14;
            cb.Height = 14;
            cb.Margin = new Padding(0, 0, 0, 0);
            toolStripTextBox1.GotFocus += new EventHandler(toolStripTextBox1_GotFocus);
            toolStripTextBox1.LostFocus += new EventHandler(toolStripTextBox1_LostFocus);
            this.Controls.Add(error);
            this.Controls.SetChildIndex(error, 0);
            this.Controls.Add(p);
            this.Controls.SetChildIndex(p, 0);
            this.Controls.Add(cb);
            this.Controls.SetChildIndex(cb, 0);
            this.toolTip1.SetToolTip(cb, "正規表現で検索ならチェック");
            this.toolTip1.SetToolTip(error, "正規表現にエラーがあります");
            cb.TabIndex = 1;
            cb.TabStop = true;
        }

        void ExMyExplorer_GotFocus(object sender, EventArgs e)
        {
            if (treeView1.Selectednode == null)
            {
                if (treeView1.Focusednode != null)
                {
                    treeView1.Selectednode = treeView1.Focusednode;
                    treeView1.DrawandReflash();
                }
                else
                {
                    if (treeView1.Nodes.Count > 0)
                    {
                        treeView1.Selectednode = treeView1.Nodes[0];
                        treeView1.DrawandReflash();
                    }
                }
            }
        }
        void toolStripTextBox1_LostFocus(object sender, EventArgs e)
        {
            p.Visible = true;
            cb.Visible = true;
        }

        void toolStripTextBox1_GotFocus(object sender, EventArgs e)
        {
            p.Visible = false;
            cb.Visible = false;
        }

        void p_MouseDown(object sender, MouseEventArgs e)
        {
            toolStripTextBox1.Focus();
        }
        public string UserDirectory
        {
            get;
            set;
        }
        public string CurrentDirectory
        {
            get;
            set;
        }
        public IExtensionHost Host
        {
            get;
            set;
        }
        public void Initialize()
        {
            this.treeView1.Nodes.Clear();
            TreeNode tn = CreateNormalNode(Path.GetFileName(Path.GetDirectoryName(UserDirectory)));
            this.treeView1.Nodes.Add(tn);
            this.treeView1.ImageList = new ImageList();
            this.treeView1.ImageList.ColorDepth = ColorDepth.Depth32Bit;
            this.treeView1.ImageList.Images.Add(directorynodekey, Properties.Resources.folder);
            tn.ImageKey = directorynodekey;
            tn.SelectedImageKey = directorynodekey;
            recursiveaddfile(tn, UserDirectory);
            tn.Expand();
            treeView1.Width = this.Width;
            if (treeView1.Nodes.Count > 0)
            {
                int height = recursivegetheight(treeView1.Nodes[0]);
                treeView1.Height = height > this.Height ? this.Height : height;
            }
            textBox1.LostFocus += new EventHandler(textBox1_LostFocus);
        }
        private void recursiveaddfile(TreeNode tn, string directory)
        {
            try
            {
                string[] dirs = Directory.GetDirectories(directory);

                for (int i = 0; i < dirs.Length; i++)
                {
                    TreeNode temp = CreateNormalNode(Path.GetFileNameWithoutExtension(dirs[i]));
                    if (temp.Text == "") continue;
                    tn.Nodes.Add(temp);
                    temp.ImageKey = directorynodekey;
                    temp.SelectedImageKey = directorynodekey;
                    TreeNode karinode = CreateNormalNode(notcheckednodetext);
                    temp.Nodes.Add(karinode);
                    //recursiveaddfile(temp, dirs[i]);
                }
                string[] fns = Directory.GetFiles(directory);
                for (int i = 0; i < fns.Length; i++)
                {
                    TreeNode temp = CreateNormalNode(Path.GetFileName(fns[i]));
                    tn.Nodes.Add(temp);
                    string extension = Path.GetExtension(fns[i]);
                    if (extension == "") extension = ".txt";
                    if (extension == ".exe")
                    {
                        Icon icon = IconHandler.IconHandler.IconFromExecuteFile(fns[i], IconHandler.IconSize.Small);
                        if (icon != null)
                        {
                            treeView1.ImageList.Images.Add(fns[i], icon);
                            temp.ImageKey = fns[i];
                            temp.SelectedImageKey = fns[i];
                            continue;
                        }
                    }
                    if (!treeView1.ImageList.Images.ContainsKey(extension))
                    {
                        Icon icon = IconHandler.IconHandler.IconFromExtension(extension, IconHandler.IconSize.Small);
                        treeView1.ImageList.Images.Add(extension, icon);
                    }
                    temp.ImageKey = extension;
                    temp.SelectedImageKey = extension;
                }
            }
            catch
            {
                MessageBox.Show("ファイルアクセスエラーです。 @ " + directory);
            }
        }
        private void treeView1_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            if (e.Node.Nodes.Count == 1 && e.Node.Nodes[0].Text == notcheckednodetext)
            {
                e.Node.Nodes.Clear();
                string s = treeView1.GetFullPath(e.Node);
                s = UserDirectory + s; //s.Substring(s.IndexOf("\\") + 1);
                recursiveaddfile(e.Node, s);
            }
        }

        private void treeView1_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if ((e.Button & MouseButtons.Right) == MouseButtons.Right)
            {
                if (e.Node.ImageKey != directorynodekey)
                {
                    rightselectedfilenode = e.Node;
                    contextMenuStrip1.Show(treeView1, e.X, e.Y);
                }
                else
                {
                    rightselecteddirectorynode = e.Node;
                    contextMenuStrip2.Show(treeView1, e.X, e.Y);
                }
            }
        }
        private void treeView1_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (e.Node.ImageKey != directorynodekey)
            {
                string s = treeView1.GetFullPath(e.Node);
                s = UserDirectory + s;
                Host.OpenFile(s);
            }
            /*string s = e.Node.FullPath;
            if (Path.GetExtension(s) == ".exe")
            {
                s = currentdirectory + s.Substring(s.IndexOf("\\") + 1);
                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                //ComSpecのパスを取得する
                psi.FileName = System.Environment.GetEnvironmentVariable("ComSpec");
                //出力を読み取れるようにする
                psi.RedirectStandardInput = false;
                psi.RedirectStandardOutput = false;
                psi.UseShellExecute = false;
                //ウィンドウを表示しないようにする
                psi.CreateNoWindow = false;
                psi.WorkingDirectory = this.currentdirectory;
                StreamWriter sw = new StreamWriter(currentdirectory + "temp.bat");
                sw.Write(s);
                sw.Close();
                //コマンドラインを指定（"/c"は実行後閉じるために必要）
                psi.Arguments = "/k temp.bat";
                //起動
                System.Diagnostics.Process.Start(psi);
            }
            else
            {
                s = s.Substring(s.IndexOf("\\") + 1);
                if (File.Exists(currentdirectory + s))
                {
                    try
                    {
                        System.Diagnostics.Process.Start(currentdirectory + s);
                    }
                    catch (Exception ee)
                    {
                        MessageBox.Show(ee.Message);
                    }
                }
            }*/
        }


        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            //open with a certain program
            if (rightselectedfilenode != null)
            {
                string filename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                if (Path.GetExtension(filename) == ".exe")
                {
                    System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                    //ComSpecのパスを取得する
                    psi.FileName = System.Environment.GetEnvironmentVariable("ComSpec");
                    //出力を読み取れるようにする
                    psi.RedirectStandardInput = false;
                    psi.RedirectStandardOutput = false;
                    psi.UseShellExecute = false;
                    //ウィンドウを表示しないようにする
                    psi.CreateNoWindow = false;
                    psi.WorkingDirectory = CurrentDirectory;
                    try
                    {
                        StreamWriter sw = new StreamWriter(CurrentDirectory + "temp.bat");
                        sw.Write("\"" + filename + "\"");
                        sw.Close();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                        return;
                    }
                    //コマンドラインを指定（"/c"は実行後閉じるために必要）
                    psi.Arguments = "/k temp.bat";
                    //起動
                    System.Diagnostics.Process.Start(psi);
                }
                else
                {
                    if (File.Exists(filename))
                    {
                        try
                        {
                            System.Diagnostics.Process.Start(filename);
                        }
                        catch (Exception ee)
                        {
                            MessageBox.Show(ee.Message);
                        }
                    }
                }
            }
        }
        private void ExMyExplorer_BackgroundImageChanged(object sender, EventArgs e)
        {
            if (toolStrip1.Width > 0 && toolStrip1.Height > 0 && treeView1.Width > 0 && treeView1.Height > 0)
            {
                Bitmap tempbit = new Bitmap(toolStrip1.Width, toolStrip1.Height);
                Graphics g = Graphics.FromImage(tempbit);
                if (this.BackgroundImage == null)
                {
                    SolidBrush sb = new SolidBrush(this.BackColor);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    toolStrip1.BackgroundImage = tempbit;
                    tempbit = new Bitmap(treeView1.Width, treeView1.Height);
                    g = Graphics.FromImage(tempbit);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    treeView1.BackgroundImage = tempbit;
                    sb.Dispose();
                }
                else
                {
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(0, 0, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    toolStrip1.BackgroundImage = tempbit;
                    tempbit = new Bitmap(treeView1.Width, treeView1.Height);
                    g = Graphics.FromImage(tempbit);
                    Point p = PointToClient(treeView1.PointToScreen(treeView1.Location));
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(p.X, p.Y, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    treeView1.BackgroundImage = tempbit;
                }
            }
        }

        private void ExMyExplorer_SizeChanged(object sender, EventArgs e)
        {
            treeView1.Width = this.Width;
            checkheight();
        }
        private void checkheight()
        {
            if (treeView1.Nodes.Count > 0)
            {
                int height = recursivegetheight(treeView1.Nodes[0]);
                treeView1.Height = height > this.Height - toolStrip1.Height ? this.Height - toolStrip1.Height : height;
            }
        }
        private int recursivegetheight(TreeNode tn)
        {
            MyTreeView.NodeState? ns = tn.Tag as MyTreeView.NodeState?;
            if (ns != null)
            {
                if ((ns & MyTreeView.NodeState.invisible) == MyTreeView.NodeState.invisible)
                {
                    return 0;
                }
            }
            if (tn.IsExpanded)
            {
                int sum = 0;
                for (int i = 0; i < tn.Nodes.Count; i++)
                {
                    sum += recursivegetheight(tn.Nodes[i]);
                }
                return treeView1.ItemHeight + sum;
            }
            else
            {
                return treeView1.ItemHeight;
            }
        }
        private void treeView1_AfterCollapse(object sender, TreeViewEventArgs e)
        {
            checkheight();
        }

        private void treeView1_AfterExpand(object sender, TreeViewEventArgs e)
        {
            checkheight();
        }

        private void 新しいドキュメントに開くToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (rightselectedfilenode != null)
            {
                string s = treeView1.GetFullPath(rightselectedfilenode);
                s = UserDirectory + s; //s.Substring(s.IndexOf("\\") + 1);
                Host.OpenFileToNewDocument(s);
            }
        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            //cut
            if (rightselectedfilenode != null)
            {
                if (cutnode != null)
                {
                    cutnode.Tag = null;
                    cutnode = null;
                }
                rightselectedfilenode.Tag = cutsigntagtext;
                cutnode = rightselectedfilenode;
                toolStripMenuItem3.Enabled = true;
                toolStripMenuItem5.Enabled = true;
                cutorcopyfilename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                treeView1.DrawandReflash();
            }
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            //copy
            if (rightselectedfilenode != null)
            {
                if (cutnode != null)
                {
                    cutnode.Tag = null;
                    cutnode = null;
                }
                toolStripMenuItem3.Enabled = true;
                toolStripMenuItem5.Enabled = true;
                cutorcopyfilename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                treeView1.DrawandReflash();
            }
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            if (rightselectedfilenode != null)
            {
                //paste
                if (cutnode != null)
                {
                    //paste cutnode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = Path.GetDirectoryName(UserDirectory + treeView1.GetFullPath(rightselectedfilenode));
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);

                            if (FileUtil.IsSameFile(cutorcopyfilename, destname))
                            {
                                MessageBox.Show("同じディレクトリ間での操作です");
                                return;
                            }
                            string extension = Path.GetExtension(cutorcopyfilename);
                            int iter = 0;
                            while (File.Exists(destname))
                            {
                                iter++;
                                destname = dir + "\\" + Path.GetFileNameWithoutExtension(cutorcopyfilename) + "(" + iter + ")" + extension;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            File.Delete(cutorcopyfilename);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
                else
                {
                    //paste copynode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = Path.GetDirectoryName(UserDirectory + treeView1.GetFullPath(rightselectedfilenode));
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);
                            string extension = Path.GetExtension(cutorcopyfilename);
                            int iter = 0;
                            while (File.Exists(destname))
                            {
                                iter++;
                                destname = dir + "\\" + Path.GetFileNameWithoutExtension(cutorcopyfilename) + "(" + iter + ")" + extension;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
            }
        }
        private void toolStripMenuItem6_Click(object sender, EventArgs e)
        {
            //rename
            if (rightselectedfilenode != null)
            {
                Point p = treeView1.GetNodePoint(rightselectedfilenode);
                textBox1.Location = new Point(p.X - 2, p.Y);
                textBox1.Text = rightselectedfilenode.Text;
                textBox1.Width = treeView1.NodeTextWidth(rightselectedfilenode) + 10;
                textBox1.Visible = true;
                textBox1.Focus();
                textBox1.SelectAll();
                Renamemode = true;
            }
        }
        private void treeView1_Scrolled(object sender, ScrollEventArgs e)
        {
            CheckRenameMode();
        }
        private void textBox1_LostFocus(object sender, EventArgs e)
        {
            CheckRenameMode();
        }
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter || e.KeyChar == (char)Keys.Escape)
            {
                e.Handled = true;
            }
        }
        private void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Return)
            {
                CheckRenameMode();
            }
        }
        private void CheckRenameMode()
        {
            if (Renamemode)
            {
                Renamemode = false;
                if (rightselectedfilenode != null)
                {
                    string filename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                    if (File.Exists(filename) && rightselectedfilenode.Text != textBox1.Text)
                    {
                        char[] invalidChars = System.IO.Path.GetInvalidFileNameChars();

                        if (textBox1.Text.IndexOfAny(invalidChars) < 0)
                        {
                            try
                            {
                                Microsoft.VisualBasic.FileIO.FileSystem.RenameFile(filename, this.textBox1.Text);
                                Host.QueryAlreadyOpenFile(filename, this.textBox1.Text);
                                TreeNode DirectoryNode = rightselectedfilenode.Parent;
                                string directoryname = UserDirectory + treeView1.GetFullPath(DirectoryNode);
                                PartialUpdate(DirectoryNode, directoryname);
                                treeView1.DrawandReflash();
                            }
                            catch (Exception exc)
                            {
                                MessageBox.Show(exc.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("ファイル名に使用できない文字が使われています。");
                        }
                    }
                }
                textBox1.Visible = false;
            }
        }
        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {

            if (rightselecteddirectorynode != null)
            {
                //paste to directory
                if (cutnode != null)
                {
                    cutnode.Tag = null;
                    cutnode = null;
                    toolStripMenuItem3.Enabled = false;
                    toolStripMenuItem5.Enabled = false;
                    //paste cutnode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = UserDirectory + treeView1.GetFullPath(rightselecteddirectorynode);
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);
                            int iter = 1;
                            while (File.Exists(destname))
                            {
                                StringBuilder sb = new StringBuilder();
                                for (int i = 0; i < iter; i++)
                                {
                                    sb.Append("コピー ～ ");
                                }
                                destname = dir + "\\" + sb.ToString() + Path.GetFileName(cutorcopyfilename);
                                iter++;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            File.Delete(cutorcopyfilename);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
                else
                {
                    //paste copynode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = UserDirectory + treeView1.GetFullPath(rightselecteddirectorynode);
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);
                            int iter = 1;
                            while (File.Exists(destname))
                            {
                                StringBuilder sb = new StringBuilder();
                                for (int i = 0; i < iter; i++)
                                {
                                    sb.Append("コピー ～ ");
                                }
                                destname = dir + "\\" + sb.ToString() + Path.GetFileName(cutorcopyfilename);
                                iter++;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
            }
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            //delete
            if (rightselectedfilenode != null)
            {
                if (MessageBox.Show("削除してもよろしいですか？", "削除確認", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    string filename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                    try
                    {
                        if (File.Exists(filename))
                        {
                            File.Delete(filename);
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show("エラーが発生しました\n" + ex.Message);
                    }
                    TreeNode DirectoryNode = rightselectedfilenode.Parent;
                    string directoryname = UserDirectory + treeView1.GetFullPath(DirectoryNode);
                    PartialUpdate(DirectoryNode, directoryname);
                    checkheight();
                    treeView1.DrawandReflash();
                }
            }
        }
        private void PartialUpdate(TreeNode DirectoryNode, string directoryname)
        {
            try
            {
                //checkopenedonce
                if (DirectoryNode.Nodes.Count == 1 && DirectoryNode.Nodes[0].Text == notcheckednodetext) return;
                string[] dirs = Directory.GetDirectories(directoryname);
                ArrayList shouldremove = new ArrayList();
                string[] dirsfordelete = new string[dirs.Length];
                for (int i = 0; i < dirs.Length; i++)
                {
                    dirsfordelete[i] = Path.GetFileNameWithoutExtension(dirs[i]);
                }
                //checknoexistnodes
                foreach (TreeNode tempnode in DirectoryNode.Nodes)
                {
                    if (tempnode.ImageKey != directorynodekey) break;
                    if (Array.IndexOf(dirsfordelete, tempnode.Text) == -1)
                    {
                        shouldremove.Add(tempnode);
                    }
                }
                for (int i = 0; i < shouldremove.Count; i++)
                {
                    DirectoryNode.Nodes.Remove(shouldremove[i] as TreeNode);
                }
                for (int i = 0; i < dirs.Length; i++)
                {
                    string dirname = Path.GetFileNameWithoutExtension(dirs[i]);
                    if (dirname == "") continue;
                    TreeNode tempdirnode = null;
                    if (ContainDirectoryNode(DirectoryNode.Nodes, dirname, out tempdirnode))
                    {
                        PartialUpdate(tempdirnode, dirs[i]);
                        continue;
                    }
                    //new directory
                    TreeNode temp = CreateNormalNode(dirname);
                    DirectoryNode.Nodes.Add(temp);
                    temp.ImageKey = directorynodekey;
                    temp.SelectedImageKey = directorynodekey;
                    TreeNode karinode = CreateNormalNode(notcheckednodetext);
                    temp.Nodes.Add(karinode);
                }
                //checknoexistnodes
                string[] fns = Directory.GetFiles(directoryname);
                string[] fnsfordelete = new string[fns.Length];
                for (int i = 0; i < fns.Length; i++)
                {
                    fnsfordelete[i] = Path.GetFileName(fns[i]);
                }
                shouldremove.Clear();
                foreach (TreeNode tempnode in DirectoryNode.Nodes)
                {
                    if (tempnode.ImageKey != directorynodekey)
                    {
                        if (Array.IndexOf(fnsfordelete, tempnode.Text) == -1)
                        {
                            shouldremove.Add(tempnode);
                        }
                    }
                }
                for (int i = 0; i < shouldremove.Count; i++)
                {
                    DirectoryNode.Nodes.Remove(shouldremove[i] as TreeNode);
                }
                for (int i = 0; i < fns.Length; i++)
                {
                    string filename = Path.GetFileName(fns[i]);
                    if (ContainFileNode(DirectoryNode.Nodes, filename))
                    {
                        continue;
                    }
                    TreeNode temp = CreateNormalNode(filename);
                    DirectoryNode.Nodes.Add(temp);
                    string extension = Path.GetExtension(fns[i]);
                    if (!treeView1.ImageList.Images.ContainsKey(extension))
                    {
                        Icon icon = IconHandler.IconHandler.IconFromExtension(extension, IconHandler.IconSize.Small);
                        Bitmap bit = icon.ToBitmap();
                        treeView1.ImageList.Images.Add(extension, bit);

                    }
                    temp.ImageKey = extension;
                    temp.SelectedImageKey = extension;
                }
                //sort nodes
                TreeNode[] forsort = new TreeNode[DirectoryNode.Nodes.Count];
                DirectoryNode.Nodes.CopyTo(forsort, 0);
                NodeComparer comp = new NodeComparer();
                Array.Sort(forsort, comp);
                DirectoryNode.Nodes.Clear();
                DirectoryNode.Nodes.AddRange(forsort);
            }
            catch
            {
                MessageBox.Show("ファイルアクセスエラーです。 @ " + directoryname);
            }
        }
        private bool ContainDirectoryNode(TreeNodeCollection Nodes, string name, out TreeNode DirectoryNode)
        {
            DirectoryNode = null;
            foreach (TreeNode tn in Nodes)
            {
                if (tn.ImageKey == directorynodekey && tn.Text == name)
                {
                    DirectoryNode = tn;
                    return true;
                }
            }
            return false;
        }
        private bool ContainFileNode(TreeNodeCollection Nodes, string name)
        {
            foreach (TreeNode tn in Nodes)
            {
                if (tn.ImageKey != directorynodekey && tn.Text == name)
                {
                    return true;
                }
            }
            return false;
        }
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            UpdateAll();
        }
        private void UpdateAll()
        {
            if (treeView1.Nodes.Count > 0)
            {
                TreeNode rootnode = treeView1.Nodes[0];
                PartialUpdate(rootnode, UserDirectory);
            }
            checkheight();
            treeView1.DrawandReflash();
        }
        private TreeNode CreateNormalNode(string text)
        {
            TreeNode ret = new TreeNode(text);
            ret.Tag = MyTreeView.NodeState.none;
            return ret;
        }

        private void toolStripTextBox1_TextChanged(object sender, EventArgs e)
        {
            System.Text.RegularExpressions.Regex reg = null;
            if (cb.Checked)
            {
                try
                {
                    reg = new System.Text.RegularExpressions.Regex(toolStripTextBox1.TextBox.Text);
                }
                catch
                {
                    error.Visible = true;
                    return;
                }
            }
            error.Visible = false;
            CheckText(treeView1.Nodes[0], toolStripTextBox1.TextBox.Text, reg);
            checkheight();
            treeView1.DrawandReflash();
        }

        private void CheckText(TreeNode Node, string text, System.Text.RegularExpressions.Regex reg)
        {
            try
            {
                if (text == "")
                {
                    Node.Tag = Node.Tag = MyTreeView.NodeState.none;
                    foreach (TreeNode child in Node.Nodes)
                    {
                        CheckText(child, text, reg);
                    }
                    return;
                }
                if (Node.Nodes.Count == 0)
                {
                    bool b = false;
                    if (reg != null)
                    {
                        b = reg.Match(Node.Text).Success;
                    }
                    else
                    {
                        b = Node.Text.Contains(text);
                    }
                    if (b)
                    {
                        Node.Tag = MyTreeView.NodeState.none;
                    }
                    else
                    {
                        Node.Tag = MyTreeView.NodeState.invisible;
                    }
                    return;
                }
                if (Node.IsExpanded)
                {
                    foreach (TreeNode child in Node.Nodes)
                    {
                        CheckText(child, text, reg);
                    }
                }
                bool visible = false;
                if (Node.IsExpanded)
                {
                    foreach (TreeNode child in Node.Nodes)
                    {
                        MyTreeView.NodeState? ns = child.Tag as MyTreeView.NodeState?;
                        if (ns != null)
                        {
                            if ((ns & MyTreeView.NodeState.invisible) != MyTreeView.NodeState.invisible) visible = true;
                        }
                    }
                }
                if (visible)
                {
                    Node.Tag = MyTreeView.NodeState.none;
                }
                else
                {
                    Node.Tag = MyTreeView.NodeState.invisible;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public class NodeComparer : System.Collections.IComparer, System.Collections.Generic.IComparer<TreeNode>
        {
            public int Compare(TreeNode x, TreeNode y)
            {
                //nullが最も小さいとする
                if (x == null && y == null)
                    return 0;
                if (x == null)
                    return -1;
                if (y == null)
                    return 1;

                //比較する
                if (x.ImageKey == directorynodekey && y.ImageKey == directorynodekey)
                {
                    StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
                    return sc.Compare(x.Text, y.Text);
                }
                else if (x.ImageKey == directorynodekey)
                {
                    return -1;
                }
                else if (y.ImageKey == directorynodekey)
                {
                    return 1;
                }
                else
                {
                    StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
                    return sc.Compare(x.Text, y.Text);
                }
            }
            public int Compare(object x, object y)
            {
                //nullが最も小さいとする
                if (x == null && y == null)
                    return 0;
                if (x == null)
                    return -1;
                if (y == null)
                    return 1;

                //String型以外の比較はエラー
                if (!(x is TreeNode) || !(y is TreeNode))
                    throw new ArgumentException();
                NodeComparer nc = new NodeComparer();

                return nc.Compare((TreeNode)x, (TreeNode)y);
            }
        }

        private void ExMyExplorer_KeyDown(object sender, KeyEventArgs e)
        {
            treeView1.Selectednode = treeView1.Focusednode;
            if (e.Control)
            {
                if (e.KeyCode == Keys.F)
                {
                    this.toolStripTextBox1.Focus();
                }
                else if (e.KeyCode == Keys.R)
                {
                    this.toolStripButton1_Click(sender, e);
                }
                else if (e.KeyCode == Keys.Return)
                {
                    treeView1.RightClick();
                }
            }
            else
            {
                if (e.KeyCode == Keys.Down)
                {
                    treeView1.DownSelectedNode();
                    e.Handled = true;
                    treeView1.DrawandReflash();
                }
                else if (e.KeyCode == Keys.Up)
                {
                    treeView1.UpSelectedNode();
                    e.Handled = true;
                    treeView1.DrawandReflash();
                }
                else if (e.KeyCode == Keys.Return)
                {
                    if (treeView1.Selectednode != null && treeView1.Selectednode.ImageKey == directorynodekey)
                    {
                        treeView1.ToggleSelectedNode();
                        treeView1.DrawandReflash();
                    }
                }
            }
        }

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.toolStripButton1 = new System.Windows.Forms.ToolStripButton();
            this.toolStripTextBox1 = new System.Windows.Forms.ToolStripTextBox();
            this.toolStrip1 = new System.Windows.Forms.ToolStrip();
            this.toolStripButton2 = new System.Windows.Forms.ToolStripButton();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.toolStripMenuItem6 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripContainer1 = new System.Windows.Forms.ToolStripContainer();
            this.treeView1 = new NotepadNeue.MyTreeView();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.新しいドキュメントに開くToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem4 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem7 = new System.Windows.Forms.ToolStripMenuItem();
            this.contextMenuStrip1 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem2 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem3 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.contextMenuStrip2 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.toolStripMenuItem5 = new System.Windows.Forms.ToolStripMenuItem();
            this.folderBrowserDialog1 = new System.Windows.Forms.FolderBrowserDialog();
            this.toolStrip1.SuspendLayout();
            this.toolStripContainer1.ContentPanel.SuspendLayout();
            this.toolStripContainer1.TopToolStripPanel.SuspendLayout();
            this.toolStripContainer1.SuspendLayout();
            this.contextMenuStrip1.SuspendLayout();
            this.contextMenuStrip2.SuspendLayout();
            this.SuspendLayout();
            // 
            // toolStripButton1
            // 
            this.toolStripButton1.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButton1.Image = global::ExplorerExtension.Properties.Resources.update;
            this.toolStripButton1.ImageTransparentColor = System.Drawing.Color.Red;
            this.toolStripButton1.Name = "toolStripButton1";
            this.toolStripButton1.Size = new System.Drawing.Size(23, 22);
            this.toolStripButton1.Text = "更新";
            this.toolStripButton1.Click += new System.EventHandler(this.toolStripButton1_Click);
            // 
            // toolStripTextBox1
            // 
            this.toolStripTextBox1.Name = "toolStripTextBox1";
            this.toolStripTextBox1.Size = new System.Drawing.Size(150, 25);
            this.toolStripTextBox1.TextChanged += new System.EventHandler(this.toolStripTextBox1_TextChanged);
            // 
            // toolStrip1
            // 
            this.toolStrip1.BackColor = System.Drawing.Color.Transparent;
            this.toolStrip1.Dock = System.Windows.Forms.DockStyle.None;
            this.toolStrip1.GripMargin = new System.Windows.Forms.Padding(0);
            this.toolStrip1.GripStyle = System.Windows.Forms.ToolStripGripStyle.Hidden;
            this.toolStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripButton2,
            this.toolStripButton1,
            this.toolStripTextBox1});
            this.toolStrip1.Location = new System.Drawing.Point(0, 0);
            this.toolStrip1.Name = "toolStrip1";
            this.toolStrip1.RenderMode = System.Windows.Forms.ToolStripRenderMode.Professional;
            this.toolStrip1.Size = new System.Drawing.Size(292, 25);
            this.toolStrip1.Stretch = true;
            this.toolStrip1.TabIndex = 2;
            this.toolStrip1.TabStop = true;
            this.toolStrip1.Text = "toolStrip1";
            // 
            // toolStripButton2
            // 
            this.toolStripButton2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButton2.Image = global::ExplorerExtension.Properties.Resources.folder;
            this.toolStripButton2.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolStripButton2.Name = "toolStripButton2";
            this.toolStripButton2.Size = new System.Drawing.Size(23, 22);
            this.toolStripButton2.Text = "ディレクトリを変更";
            this.toolStripButton2.Click += new System.EventHandler(this.toolStripButton2_Click);
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(91, 141);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(100, 19);
            this.textBox1.TabIndex = 10;
            this.textBox1.TabStop = false;
            this.textBox1.Visible = false;
            this.textBox1.KeyDown += new System.Windows.Forms.KeyEventHandler(this.textBox1_KeyDown);
            // 
            // toolStripMenuItem6
            // 
            this.toolStripMenuItem6.Name = "toolStripMenuItem6";
            this.toolStripMenuItem6.Size = new System.Drawing.Size(208, 22);
            this.toolStripMenuItem6.Text = "名前の変更";
            this.toolStripMenuItem6.Click += new System.EventHandler(this.toolStripMenuItem6_Click);
            // 
            // toolStripContainer1
            // 
            // 
            // toolStripContainer1.ContentPanel
            // 
            this.toolStripContainer1.ContentPanel.BackColor = System.Drawing.SystemColors.Window;
            this.toolStripContainer1.ContentPanel.Controls.Add(this.textBox1);
            this.toolStripContainer1.ContentPanel.Controls.Add(this.treeView1);
            this.toolStripContainer1.ContentPanel.Size = new System.Drawing.Size(292, 241);
            this.toolStripContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.toolStripContainer1.Location = new System.Drawing.Point(0, 0);
            this.toolStripContainer1.Name = "toolStripContainer1";
            this.toolStripContainer1.Size = new System.Drawing.Size(292, 266);
            this.toolStripContainer1.TabIndex = 3;
            this.toolStripContainer1.Text = "toolStripContainer1";
            // 
            // toolStripContainer1.TopToolStripPanel
            // 
            this.toolStripContainer1.TopToolStripPanel.Controls.Add(this.toolStrip1);
            // 
            // treeView1
            // 
            this.treeView1.BackColor = System.Drawing.SystemColors.Window;
            this.treeView1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.treeView1.DrawMode = System.Windows.Forms.TreeViewDrawMode.Normal;
            this.treeView1.Font = new System.Drawing.Font("MS UI Gothic", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            this.treeView1.HotTracking = true;
            this.treeView1.Indent = 19;
            this.treeView1.ItemHeight = 18;
            this.treeView1.Location = new System.Drawing.Point(0, 0);
            this.treeView1.Name = "treeView1";
            this.treeView1.Selectednode = null;
            this.treeView1.Size = new System.Drawing.Size(292, 241);
            this.treeView1.TabIndex = 11;
            this.treeView1.NodeMouseDoubleClick += new System.Windows.Forms.TreeNodeMouseClickEventHandler(this.treeView1_NodeMouseDoubleClick);
            this.treeView1.AfterCollapse += new System.Windows.Forms.TreeViewEventHandler(this.treeView1_AfterCollapse);
            this.treeView1.BeforeExpand += new System.Windows.Forms.TreeViewCancelEventHandler(this.treeView1_BeforeExpand);
            this.treeView1.NodeMouseClick += new System.Windows.Forms.TreeNodeMouseClickEventHandler(this.treeView1_NodeMouseClick);
            this.treeView1.AfterExpand += new System.Windows.Forms.TreeViewEventHandler(this.treeView1_AfterExpand);
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size(205, 6);
            // 
            // 新しいドキュメントに開くToolStripMenuItem
            // 
            this.新しいドキュメントに開くToolStripMenuItem.Name = "新しいドキュメントに開くToolStripMenuItem";
            this.新しいドキュメントに開くToolStripMenuItem.Size = new System.Drawing.Size(208, 22);
            this.新しいドキュメントに開くToolStripMenuItem.Text = "新しいドキュメントに開く";
            this.新しいドキュメントに開くToolStripMenuItem.Click += new System.EventHandler(this.新しいドキュメントに開くToolStripMenuItem_Click);
            // 
            // toolStripMenuItem4
            // 
            this.toolStripMenuItem4.Name = "toolStripMenuItem4";
            this.toolStripMenuItem4.Size = new System.Drawing.Size(208, 22);
            this.toolStripMenuItem4.Text = "ファイルを削除";
            this.toolStripMenuItem4.Click += new System.EventHandler(this.toolStripMenuItem4_Click);
            // 
            // toolStripMenuItem7
            // 
            this.toolStripMenuItem7.Name = "toolStripMenuItem7";
            this.toolStripMenuItem7.Size = new System.Drawing.Size(208, 22);
            this.toolStripMenuItem7.Text = "既定のプログラムで開く";
            this.toolStripMenuItem7.Click += new System.EventHandler(this.toolStripMenuItem7_Click);
            // 
            // contextMenuStrip1
            // 
            this.contextMenuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.新しいドキュメントに開くToolStripMenuItem,
            this.toolStripMenuItem7,
            this.toolStripSeparator1,
            this.toolStripMenuItem1,
            this.toolStripMenuItem2,
            this.toolStripMenuItem3,
            this.toolStripMenuItem4,
            this.toolStripSeparator2,
            this.toolStripMenuItem6});
            this.contextMenuStrip1.Name = "contextMenuStrip1";
            this.contextMenuStrip1.Size = new System.Drawing.Size(209, 170);
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(205, 6);
            // 
            // toolStripMenuItem1
            // 
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            this.toolStripMenuItem1.Size = new System.Drawing.Size(208, 22);
            this.toolStripMenuItem1.Text = "ファイルを切り取り";
            this.toolStripMenuItem1.Click += new System.EventHandler(this.toolStripMenuItem1_Click);
            // 
            // toolStripMenuItem2
            // 
            this.toolStripMenuItem2.Name = "toolStripMenuItem2";
            this.toolStripMenuItem2.Size = new System.Drawing.Size(208, 22);
            this.toolStripMenuItem2.Text = "ファイルをコピー";
            this.toolStripMenuItem2.Click += new System.EventHandler(this.toolStripMenuItem2_Click);
            // 
            // toolStripMenuItem3
            // 
            this.toolStripMenuItem3.Enabled = false;
            this.toolStripMenuItem3.Name = "toolStripMenuItem3";
            this.toolStripMenuItem3.Size = new System.Drawing.Size(208, 22);
            this.toolStripMenuItem3.Text = "ファイルを貼り付け";
            this.toolStripMenuItem3.Click += new System.EventHandler(this.toolStripMenuItem3_Click);
            // 
            // contextMenuStrip2
            // 
            this.contextMenuStrip2.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItem5});
            this.contextMenuStrip2.Name = "contextMenuStrip2";
            this.contextMenuStrip2.Size = new System.Drawing.Size(176, 26);
            // 
            // toolStripMenuItem5
            // 
            this.toolStripMenuItem5.Enabled = false;
            this.toolStripMenuItem5.Name = "toolStripMenuItem5";
            this.toolStripMenuItem5.Size = new System.Drawing.Size(175, 22);
            this.toolStripMenuItem5.Text = "ファイルを貼り付け";
            this.toolStripMenuItem5.Click += new System.EventHandler(this.toolStripMenuItem5_Click);
            // 
            // ExplorerExtension
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.ClientSize = new System.Drawing.Size(292, 266);
            this.Controls.Add(this.toolStripContainer1);
            this.KeyPreview = true;
            this.Name = "ExplorerExtension";
            this.SizeChanged += new System.EventHandler(this.ExMyExplorer_SizeChanged);
            this.BackgroundImageChanged += new System.EventHandler(this.ExMyExplorer_BackgroundImageChanged);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.ExMyExplorer_KeyDown);
            this.toolStrip1.ResumeLayout(false);
            this.toolStrip1.PerformLayout();
            this.toolStripContainer1.ContentPanel.ResumeLayout(false);
            this.toolStripContainer1.ContentPanel.PerformLayout();
            this.toolStripContainer1.TopToolStripPanel.ResumeLayout(false);
            this.toolStripContainer1.TopToolStripPanel.PerformLayout();
            this.toolStripContainer1.ResumeLayout(false);
            this.toolStripContainer1.PerformLayout();
            this.contextMenuStrip1.ResumeLayout(false);
            this.contextMenuStrip2.ResumeLayout(false);
            this.ResumeLayout(false);

        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = UserDirectory == null ? CurrentDirectory : UserDirectory;
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                UserDirectory = folderBrowserDialog1.SelectedPath + "\\";
                Initialize();
            }
        }
    }
}
