﻿using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Reflection;
using System.ComponentModel;
using System.Text;
using IronPython.Hosting;
using Microsoft.Scripting.Hosting;
using System.Collections;

namespace NotepadNeue
{
    class CustomToolStripMenuItem : ToolStripMenuItem
    {
        string executefilename;
        CustomShortcut cs;
        MainForm fm1;
        public CustomToolStripMenuItem(MainForm fm1)
        {
            this.fm1 = fm1;
            this.Click += new EventHandler(CustomToolStripMenuItem_Click);
            executefilename = "";
        }
        public String ExecuteFileName
        {
            get
            {
                return executefilename;
            }
            set
            {
                executefilename = value;
            }
        }
        public CustomShortcut ShortCut
        {
            get
            {
                return cs;
            }
            set
            {
                cs = value;
            }
        }
        void CustomToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (executefilename != "" && fm1.CurrentDocument != null)
            {
                try
                {
                    RunPython(executefilename);
                }
                catch (Exception ee)
                {
                    MessageBox.Show(ee.Message);
                }
                finally
                {
                    //fm1.CurrentDocument.MakeValidChange();
                    fm1.CurrentDocument.HighlightAll();
                }
            }
        }
        private void RunPython(string path)
        {
            ScriptSource source = StaticObjects.PythonEngine.CreateScriptSourceFromFile(path);
            ScriptScope scope = StaticObjects.PythonEngine.CreateScope();
            //fm1.CurrentDocument.MakeInvalidChange();
            scope.SetVariable("editor", fm1.CurrentDocument);
            scope.SetVariable("n2", fm1);
            source.Execute(scope);
        }
    }
}
