﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using NotepadNeueExtension;

namespace NotepadNeue
{
    public partial class ScrapedDataView : NotepadNeueExtension.ExDockContent
    {
        const string pool = "pool";
        const string function = "function";
        const string variable = "variable";
        const string klass = "class";
        const string namaspace = "namespace";
        const string definevalue = "definevalue";
        const string reserved = "reserved";
        const string buffer = "buffer";
        const string block = "block";

        public ScrapedDataView()
        {
            InitializeComponent();
        }
        public MainForm MainForm
        {
            get;
            set;
        }
        private void ExMyExplorer_BackgroundImageChanged(object sender, EventArgs e)
        {
            if (toolStrip1.Width > 0 && toolStrip1.Height > 0 && treeView1.Width > 0 && treeView1.Height > 0)
            {
                Bitmap tempbit = new Bitmap(toolStrip1.Width, toolStrip1.Height);
                Graphics g = Graphics.FromImage(tempbit);
                if (this.BackgroundImage == null)
                {
                    SolidBrush sb = new SolidBrush(this.BackColor);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    toolStrip1.BackgroundImage = tempbit;
                    tempbit = new Bitmap(treeView1.Width, treeView1.Height);
                    g = Graphics.FromImage(tempbit);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    treeView1.BackgroundImage = tempbit;
                    sb.Dispose();
                }
                else
                {
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(0, 0, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    toolStrip1.BackgroundImage = tempbit;
                    tempbit = new Bitmap(treeView1.Width, treeView1.Height);
                    g = Graphics.FromImage(tempbit);
                    Point p = PointToClient(treeView1.PointToScreen(treeView1.Location));
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(p.X, p.Y, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    treeView1.BackgroundImage = tempbit;
                }
            }
        }

        private void ExMyExplorer_SizeChanged(object sender, EventArgs e)
        {
            treeView1.Width = this.Width;
            checkheight();
        }
        private void checkheight()
        {
            if (treeView1.Nodes.Count > 0)
            {
                int height = recursivegetheight(treeView1.Nodes[0]);
                treeView1.Height = height > this.Height - toolStrip1.Height ? this.Height - toolStrip1.Height : height;
            }
        }
        private int recursivegetheight(TreeNode tn)
        {
            MyTreeView.NodeState? ns = tn.Tag as MyTreeView.NodeState?;
            if (ns != null)
            {
                if ((ns & MyTreeView.NodeState.invisible) == MyTreeView.NodeState.invisible)
                {
                    return 0;
                }
            }
            if (tn.IsExpanded)
            {
                int sum = 0;
                for (int i = 0; i < tn.Nodes.Count; i++)
                {
                    sum += recursivegetheight(tn.Nodes[i]);
                }
                return treeView1.ItemHeight + sum;
            }
            else
            {
                return treeView1.ItemHeight;
            }
        }
        private void treeView1_AfterCollapse(object sender, TreeViewEventArgs e)
        {
            checkheight();
        }

        private void treeView1_AfterExpand(object sender, TreeViewEventArgs e)
        {
            checkheight();
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            if (MainForm.CurrentDocument == null) return;
            treeView1.Nodes.Clear();
            EditorAssistData ead = MainForm.CurrentDocument.AssistData;
            string[] reserveds = MainForm.CurrentDocument.ExtensionInfo.ReservedWord;
            if (ead == null) return;
            TreeNode node = new TreeNode("データ");
            node.ImageKey = pool;
            this.treeView1.ImageList = new ImageList();
            this.treeView1.ImageList.ColorDepth = ColorDepth.Depth32Bit;
            this.treeView1.ImageList.Images.Add(pool, NotepadNeue.Properties.Resources.pool);
            this.treeView1.ImageList.Images.Add(function, NotepadNeue.Properties.Resources.function);
            this.treeView1.ImageList.Images.Add(variable, NotepadNeue.Properties.Resources.variable);
            this.treeView1.ImageList.Images.Add(klass, NotepadNeue.Properties.Resources._class);
            this.treeView1.ImageList.Images.Add(namaspace, NotepadNeue.Properties.Resources._namespace);
            this.treeView1.ImageList.Images.Add(definevalue, NotepadNeue.Properties.Resources.definevalue);
            this.treeView1.ImageList.Images.Add(reserved, NotepadNeue.Properties.Resources.reserved);
            this.treeView1.ImageList.Images.Add(buffer, NotepadNeue.Properties.Resources.buffer);
            this.treeView1.ImageList.Images.Add(block, NotepadNeue.Properties.Resources.block);

            treeView1.Nodes.Add(node);
            AddLoadedBuffer(node, ead);
            AddReserved(node, reserveds);
            AddDefineValue(node, ead);
            AddGlobalClass(node, ead);
            AddGlobalFunction(node, ead);
            AddGlobalNamespace(node, ead);
            AddGlobalVariable(node, ead);
            AddUsingNamespace(node, ead);
            AddVariableDatas(node, ead.VariableDatas);
            node.Expand();
            checkheight();
        }
        private void AddLoadedBuffer(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("ロード済みバッファ");
            parent.ImageKey = pool;
            node.Nodes.Add(parent);
            foreach (string s in eda.LoadedBufferName)
            {
                TreeNode tn = new TreeNode(s);
                tn.ImageKey = buffer;
                parent.Nodes.Add(tn);
            }
        }
        private void AddReserved(TreeNode node, string[] reserveds)
        {
            TreeNode parent = new TreeNode("予約語");
            parent.ImageKey = pool;
            node.Nodes.Add(parent);
            foreach (string s in reserveds)
            {
                TreeNode tn = new TreeNode(s);
                tn.ImageKey = reserved;
                parent.Nodes.Add(tn);
            }
        }
        private void AddUsingNamespace(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("使用名前空間");
            node.Nodes.Add(parent);
            parent.ImageKey = pool;
            foreach (NameSpaceInfo nsm in eda.UsingNameSpace)
            {
                TreeNode tn = new TreeNode(nsm.Name);
                tn.ImageKey = namaspace;
                parent.Nodes.Add(tn);
            }
        }
        private void AddGlobalClass(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("参照可能なクラス");
            node.Nodes.Add(parent);
            parent.ImageKey = pool;
            foreach (ObjectInfo oi in eda.GlobalClass)
            {
                AddObjectInfo(parent, oi);
            }
        }
        private void AddNamespaceInfo(TreeNode node, NameSpaceInfo nsm)
        {
            TreeNode tn = new TreeNode(nsm.Name);
            tn.Tag = nsm;
            tn.ImageKey = namaspace;
            node.Nodes.Add(tn);
            foreach (NameSpaceInfo namsm in nsm.GetAllNameSpace())
            {
                AddNamespaceInfo(tn, namsm);
            }
            foreach (ObjectInfo oi in nsm.GetAllObjectType())
            {
                AddObjectInfo(tn, oi);
            }
            foreach (FunctionInfo fi in nsm.GetAllFunction())
            {
                AddFunctionInfo(tn, fi);
            }
            foreach (VariableInfo vi in nsm.GetAllVariable())
            {
                AddVariableInfo(tn, vi);
            }
            foreach (DefineValueInfo dvi in nsm.GetAllDefineValue())
            {
                AddDefineValueInfo(tn, dvi);
            }
        }
        private void AddObjectInfo(TreeNode node, ObjectInfo oi)
        {
            TreeNode tn = new TreeNode(oi.Name);
            tn.Tag = oi;
            tn.ImageKey = klass;
            node.Nodes.Add(tn);
            foreach (VariableInfo vi in oi.GetAllVariable())
            {
                AddVariableInfo(tn, vi);
            }
            foreach (FunctionInfo fi in oi.GetAllFunction())
            {
                AddFunctionInfo(tn, fi);
            }
            foreach (DefineValueInfo dvi in oi.GetAllDefineValue())
            {
                AddDefineValueInfo(tn, dvi);
            }
        }
        private void AddVariableInfo(TreeNode node, VariableInfo vi)
        {
            TreeNode tn = new TreeNode(vi.Name + "(型 " + vi.Type + ")");
            tn.ImageKey = variable;
            tn.Tag = vi;
            node.Nodes.Add(tn);
        }
        private void AddFunctionInfo(TreeNode node, FunctionInfo fi)
        {
            TreeNode tn = new TreeNode(fi.Name);
            tn.Tag = fi;
            tn.ImageKey = function;
            node.Nodes.Add(tn);
            for (int i = 0; i < fi.ContentCount; i++)
            {
                TreeNode tnode = new TreeNode(fi.ContentAt(i));
                tnode.ImageKey = function;
                tn.Nodes.Add(tnode);
            }
        }
        private void AddDefineValueInfo(TreeNode node, DefineValueInfo dvi)
        {
            TreeNode tn = new TreeNode(dvi.Name + "(定義値 " + dvi.Value + ")");
            tn.Tag = dvi;
            tn.ImageKey = definevalue;
            node.Nodes.Add(tn);
        }
        private void AddGlobalNamespace(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("参照可能な名前空間");
            node.Nodes.Add(parent);
            parent.ImageKey = pool;
            foreach (NameSpaceInfo nsm in eda.GlobalNameSpace)
            {
                AddNamespaceInfo(parent, nsm);
            }
        }
        private void AddGlobalFunction(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("参照可能な関数");
            node.Nodes.Add(parent);
            parent.ImageKey = pool;
            foreach (FunctionInfo fi in eda.GlobalFunction)
            {
                AddFunctionInfo(parent, fi);
            }
        }
        private void AddGlobalVariable(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("参照可能な変数");
            node.Nodes.Add(parent);
            parent.ImageKey = pool;
            foreach (VariableInfo vi in eda.GlobalVariable)
            {
                AddVariableInfo(parent, vi);
            }
        }
        private void AddDefineValue(TreeNode node, EditorAssistData eda)
        {
            TreeNode parent = new TreeNode("参照可能な定義値");
            node.Nodes.Add(parent);
            parent.ImageKey = pool;
            foreach (DefineValueInfo dvi in eda.GlobalDefineValue)
            {
                AddDefineValueInfo(parent, dvi);
            }
        }
        private void AddVariableDatas(TreeNode node, BasicTree tree)
        {
            TreeNode tn = new TreeNode();
            tn.Tag = tree;
            tn.ImageKey = block;
            node.Nodes.Add(tn);
            foreach (EitherVariableOrTree evot in tree.VariableOrTrees)
            {
                if (evot.BasicTree != null)
                {
                    AddVariableDatas(tn, evot.BasicTree);
                }
                else
                {
                    AddVariableInfo(tn, evot.VariableInfo);
                }
            }
            foreach (FunctionInfo fi in tree.Functions)
            {
                AddFunctionInfo(tn, fi);
            }
        }

        private void treeView1_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (e.Node.Tag is AssistInformation)
            {
                AssistInformation assistInformation = e.Node.Tag as AssistInformation;
                MainForm.FindAndFocus(assistInformation.DefineLocation);
            }
            else if (e.Node.Tag is BasicTree)
            {
                BasicTree tree = e.Node.Tag as BasicTree;
                MainForm.GotoIndex(tree.Start);
            }
        }
    }
}
