﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;
using NotepadNeueExtension;
using Sgry.Azuki.WinForms;

namespace NotepadNeue
{
    public class ExAzukiControl : AzukiControl, IEditorControl
    {
        public event EventHandler ContentChanged;

        FunctionInfo currentShowingFunctionInfo;
        int currentArgCount;

        MainForm mainForm;
        MyToolTip toolTip;
        MyListBox dataGridView;
        ExtensionInfomation extensionInfo;

        EditorAssistData currentAssistData;
        EditorAssistData completeAssistData;
        EditorAssistData updatingAssistData;
        AssistInformationFilter filter;

        List<string> usedString = new List<string>();

        FunctionInfo[] userFunctions;

        NameSpaceInfo nullSpace = NullNameSpaceInfo.NullNSM;

        System.Windows.Forms.Timer timer;
        System.Windows.Forms.Timer hoverTimer;
        System.Windows.Forms.Timer checkFocusWordTimer;


        Thread anotherThread;
        NotepadUtility notepadUtility;

        string AnalyzeText = "";
        private ContextMenuStrip contextMenuStrip1;
        private System.ComponentModel.IContainer components;
        private ToolStripMenuItem toolStripMenuItem1;
        private List<Range> highlightRange = new List<Range>();

        [Flags]
        enum Bools
        {
            None = 0,
            DeleteChange = 1,
            ShouldCheckIndent = 2,
            UndoOrRedo = 4,
            Change = 8,
            FormatPrevious = 16
        }
        Bools bools = Bools.None;

        public string FileName
        {
            get
            {
                TextEditWindow tew = this.Parent as TextEditWindow;
                if (tew != null) return tew.Filename;
                return "";
            }
        }

        public ExAzukiControl(MainForm mainForm, MyToolTip toolTip, MyListBox dataGridView, NotepadUtility notepadUtility)
            : base()
        {
            InitializeComponent();
            Disposed += new EventHandler(ExAzukiControl_Disposed);
            currentAssistData = new EditorAssistData(this);
            this.contextMenuStrip1.Opening += new System.ComponentModel.CancelEventHandler(contextMenuStrip1_Opening);
            this.toolStripMenuItem1.Click += new EventHandler(toolStripMenuItem1_Click);
            this.mainForm = mainForm;
            this.toolTip = toolTip;
            this.dataGridView = dataGridView;
            this.notepadUtility = notepadUtility;
            AllowDrop = true;
            this.SetKeyBind(Keys.A | Keys.Control, null);
            this.SetKeyBind(Keys.Z | Keys.Control, null);
            this.SetKeyBind(Keys.Z | Keys.Control | Keys.Shift, null);
            this.SetKeyBind(Keys.Y | Keys.Control, null);
            this.SetKeyBind(Keys.X | Keys.Control, null);
            this.SetKeyBind(Keys.C | Keys.Control, null);
            this.SetKeyBind(Keys.V | Keys.Control, null);
            this.SetKeyBind(Keys.Tab, null);
            this.SetKeyBind(Keys.Tab | Keys.Shift, null);
            this.SetKeyBind(Keys.Oem4 | Keys.Control, null);
            this.SetKeyBind(Keys.Oem6 | Keys.Control, null);
            this.SetKeyBind(Keys.Shift | Keys.Back, Sgry.Azuki.Actions.BackSpace);
            this.SetKeyBind(Keys.Enter | Keys.Control, null);
            this.SetKeyBind(Keys.Enter | Keys.Control | Keys.Shift, null);

            hoverTimer = new System.Windows.Forms.Timer();
            hoverTimer.Interval = 500;
            hoverTimer.Tick += new EventHandler(hoverTimer_Tick);

            timer = new System.Windows.Forms.Timer();
            timer.Interval = 1000;
            timer.Tick += new EventHandler(timer_Tick);

            checkFocusWordTimer = new System.Windows.Forms.Timer();
            checkFocusWordTimer.Interval = 1000;
            checkFocusWordTimer.Tick += new EventHandler(checkFocusWordTimer_Tick);

            this.AutoIndentHook = null;
            /*if (nu.AutoFormat)
            {
                this.AutoIndentHook = Sgry.Azuki.AutoIndentHooks.CHook;
            }
            else
            {
                this.AutoIndentHook = null;
            }*/
        }

        void ExAzukiControl_Disposed(object sender, EventArgs e)
        {
            timer.Stop();
            hoverTimer.Stop();
            if (anotherThread != null && anotherThread.IsAlive)
            {
                anotherThread.Abort();
                anotherThread = null;
            }
        }

        void contextMenuStrip1_Opening(object sender, System.ComponentModel.CancelEventArgs e)
        {
            int begin, end;
            GetSelection(out begin, out end);
            if (begin == end)
            {
                Point p = this.PointToClient(Cursor.Position);
                int index = GetIndexFromPosition(p);
                SetSelection(index, index);
            }
        }

        private InputInfo[] CheckInput(int begin)
        {
            List<InputInfo> ret = new List<InputInfo>();
            if (begin <= 0)
            {
                return ret.ToArray();
            }
            int iter = begin - 1;
            int endanchor = begin;
            while (true)
            {
                if (iter < 0)
                {
                    ret.Add(new InputInfo(this.GetTextInRange(iter + 1, endanchor), InputInfoAccessType.None));
                    iter++;
                    break;
                }
                char c = this.Document[iter];
                if (Char.IsLetterOrDigit(c) || c == '_')
                {
                    iter--;
                    continue;
                }
                if (extensionInfo.AllowStringWhenAssist != null && extensionInfo.AllowStringWhenAssist.Length > 0 &&
                    iter - extensionInfo.AllowStringWhenAssist.Length + 1 >= 0 &&
                    this.Document.GetTextInRange(iter - extensionInfo.AllowStringWhenAssist.Length + 1, iter + 1) == extensionInfo.AllowStringWhenAssist)
                {
                    iter -= extensionInfo.AllowStringWhenAssist.Length;
                    continue;
                }
                //オブジェクトアクセサか調べる
                bool found = false;
                for (int i = 0; i < extensionInfo.ObjectAccessor.Length; i++)
                {
                    string accessor = extensionInfo.ObjectAccessor[i];
                    if (String.IsNullOrEmpty(accessor))
                    {
                        continue;
                    }
                    if (iter - accessor.Length + 1 >= 0)
                    {
                        if (this.Document.GetTextInRange(iter - accessor.Length + 1, iter + 1) == accessor)
                        {
                            InputInfoAccessType accessType = InputInfoAccessType.Object;
                            if (accessor == extensionInfo.ScopeAccessor)
                            {
                                accessType |= InputInfoAccessType.NameSpace;
                            }
                            ret.Add(new InputInfo(this.GetTextInRange(iter + 1, endanchor), accessType));
                            iter -= accessor.Length;
                            endanchor = iter + 1;
                            found = true;
                            break;
                        }
                    }
                    else
                    {
                        continue;
                    }
                }
                if (found)
                {
                    continue;
                }
                //スコープアクセサか調べる
                if (extensionInfo.ScopeAccessor != "")
                {
                    if (iter - extensionInfo.ScopeAccessor.Length + 1 >= 0)
                    {
                        if (this.Document.GetTextInRange(iter - extensionInfo.ScopeAccessor.Length + 1, iter + 1)
                            == extensionInfo.ScopeAccessor)
                        {
                            ret.Add(new InputInfo(this.GetTextInRange(iter + 1, endanchor), InputInfoAccessType.NameSpace));
                            iter -= extensionInfo.ScopeAccessor.Length;
                            endanchor = iter + 1;
                            continue;
                        }
                    }
                }
                //止まる
                iter++;
                ret.Add(new InputInfo(this.GetTextInRange(iter, endanchor), InputInfoAccessType.None));
                break;
            }

            ret.Reverse();
            return ret.ToArray();
        }

        AssistInformation[] FindAssistInformation(int begin)
        {
            int lineIndex, columnIndex;
            GetLineColumnIndexFromCharIndex(begin, out lineIndex, out columnIndex);
            string lineData = Document.GetLineContent(lineIndex);
            int charHead = GetLineHeadIndex(lineIndex);
            int charEnd = charHead + lineData.Length;
            int end = begin;
            //get back
            while (true)
            {
                if (end >= charEnd)
                {
                    break;
                }
                char c = lineData[end - charHead];
                if (Char.IsLetterOrDigit(c) || c == '_')
                {
                    end++;
                    continue;
                }
                break;
            }
            InputInfo[] inputInfos = CheckInput(end);

            if (inputInfos.Length == 0)
            {
                return new AssistInformation[0];
            }
            if (inputInfos.Length == 1)
            {
                return FindAssistInformation(inputInfos[0].Name, end + 1);
            }
            string lastTarget;
            AssistInformation prevAssistInformation;
            var info = FindAssistInformation(begin, inputInfos, out prevAssistInformation, out lastTarget);
            if (info != null)
            {
                return new AssistInformation[] { info };
            }
            return new AssistInformation[0];
        }

        private AssistInformation FindAssistInformation(int begin, InputInfo[] inputInfos, out AssistInformation prevAssistInformation, out string lastTarget)
        {
            prevAssistInformation = null;
            lastTarget = null;
            if (inputInfos.Length <= 1)
            {
                throw new Exception("few input infos");
            }

            string ObjectOrNameSpaceOrVariable = inputInfos[0].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
            InputInfoAccessType accessType = inputInfos[1].AccessType;
            if (accessType == InputInfoAccessType.Object)
            {
                VariableInfo[] vis;
                vis = currentAssistData.VariableDatas.GetVariableData(currentAssistData.GetCaretPos(begin));
                ObjectInfo firstobject = FindObject(ObjectOrNameSpaceOrVariable, vis);
                if (firstobject != null)
                {
                    for (int j = 1; j < inputInfos.Length; j++)
                    {
                        if (j == inputInfos.Length - 1)
                        {
                            lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                            prevAssistInformation = firstobject;
                            return FindAssistInformationFromObject(lastTarget, firstobject);
                        }
                        else
                        {
                            if (inputInfos[j + 1].AccessType != InputInfoAccessType.Object)
                            {
                                return null;
                            }
                            string target = inputInfos[j].Name;
                            VariableInfo tempvi = firstobject.GetVariableInfo(target);
                            if (tempvi == null)
                            {
                                return null;
                            }
                            firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                            if (firstobject == null)
                            {
                                return null;
                            }
                        }
                    }
                }
            }
            else if (accessType == InputInfoAccessType.NameSpace)
            {
                //今のアクセスできるネームスペースか調べる
                NameSpaceInfo firstnamespace = null;
                for (int i = 0; i < currentAssistData.GlobalNameSpace.Count; i++)
                {
                    if ((currentAssistData.GlobalNameSpace[i] as NameSpaceInfo).Name == ObjectOrNameSpaceOrVariable)
                    {
                        firstnamespace = currentAssistData.GlobalNameSpace[i] as NameSpaceInfo;
                        break;
                    }
                }
                if (firstnamespace == null)
                {
                    //オブジェクトのタイプかもしれないので調べる
                    ObjectInfo firstobject = GetObjectInfoFromCurrentBuffer(ObjectOrNameSpaceOrVariable);
                    if (firstobject == null)
                    {
                        return null;
                    }

                    for (int j = 1; j < inputInfos.Length; j++)
                    {
                        if (j == inputInfos.Length - 1)
                        {
                            lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                            prevAssistInformation = firstobject;
                            return FindAssistInformationFromObject(lastTarget, firstobject);
                        }
                        else
                        {
                            if (inputInfos[j + 1].AccessType != InputInfoAccessType.Object)
                            {
                                return null;
                            }
                            VariableInfo tempvi = firstobject.GetVariableInfo(inputInfos[j].Name);
                            if (tempvi == null)
                            {
                                return null;
                            }
                            firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                            if (firstobject == null)
                            {
                                return null;
                            }
                        }
                    }
                }
                else
                {
                    ObjectInfo nextobjectinfo = null;
                    for (int j = 1; j < inputInfos.Length; j++)
                    {
                        if (j == inputInfos.Length - 1)
                        {
                            if (firstnamespace != null)
                            {
                                lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                                prevAssistInformation = firstnamespace;
                                return FindAssistInformationFromNameSpace(lastTarget, firstnamespace);
                            }
                            else if (nextobjectinfo != null)
                            {
                                lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                                prevAssistInformation = nextobjectinfo;
                                return FindAssistInformationFromObject(lastTarget, nextobjectinfo);
                            }
                            return null;
                        }
                        else
                        {
                            if (firstnamespace == null)
                            {
                                return null;
                            }
                            if (inputInfos[j + 1].AccessType != InputInfoAccessType.NameSpace)
                            {
                                return null;
                            }
                            string target = inputInfos[j].Name;
                            NameSpaceInfo nsm = firstnamespace.GetNameSpaceManager(target);
                            if (nsm == null)
                            {
                                nextobjectinfo = firstnamespace.GetObjectInfo(target);
                            }
                            if (nsm == null && nextobjectinfo == null)
                            {
                                return null;
                            }
                            firstnamespace = nsm;
                        }
                    }
                }
            }
            else if (accessType == InputInfoAccessType.ObjectOrNameSpace)
            {
                //変数定義を調べる
                VariableInfo[] vis;
                ObjectInfo firstobject = null;
                NameSpaceInfo firstnamespace = null;
                vis = currentAssistData.VariableDatas.GetVariableData(currentAssistData.GetCaretPos(begin));
                firstobject = FindObject(ObjectOrNameSpaceOrVariable, vis);
                if (firstobject == null)
                {
                    //今のアクセスできるネームスペースか調べる
                    for (int i = 0; i < currentAssistData.GlobalNameSpace.Count; i++)
                    {
                        if ((currentAssistData.GlobalNameSpace[i] as NameSpaceInfo).Name == ObjectOrNameSpaceOrVariable)
                        {
                            firstnamespace = currentAssistData.GlobalNameSpace[i] as NameSpaceInfo;
                            break;
                        }
                    }
                    if (firstnamespace == null)
                    {
                        //オブジェクトのタイプか調べる
                        firstobject = GetObjectInfoFromCurrentBuffer(ObjectOrNameSpaceOrVariable);
                        if (firstobject == null)
                        {
                            return null;
                        }
                    }
                }
                if (firstobject != null)
                {
                    for (int j = 1; j < inputInfos.Length; j++)
                    {
                        if (j == inputInfos.Length - 1)
                        {
                            lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                            prevAssistInformation = firstobject;
                            return FindAssistInformationFromObject(lastTarget, firstobject);
                        }
                        else
                        {
                            if (inputInfos[j + 1].AccessType != InputInfoAccessType.ObjectOrNameSpace)
                            {
                                return null;
                            }
                            string target = inputInfos[j].Name;
                            VariableInfo tempvi = firstobject.GetVariableInfo(target);
                            if (tempvi == null)
                            {
                                return null;
                            }
                            firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                            if (firstobject == null)
                            {
                                return null;
                            }
                        }
                    }
                }
                else if (firstnamespace != null)
                {
                    ObjectInfo nextobjectinfo = null;
                    for (int j = 1; j < inputInfos.Length; j++)
                    {
                        if (j == inputInfos.Length - 1)
                        {
                            if (firstnamespace != null)
                            {
                                lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                                prevAssistInformation = firstnamespace;
                                return FindAssistInformationFromNameSpace(lastTarget, firstnamespace);
                            }
                            else if (nextobjectinfo != null)
                            {
                                lastTarget = inputInfos[j].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                                prevAssistInformation = nextobjectinfo;
                                return FindAssistInformationFromObject(lastTarget, nextobjectinfo);
                            }
                            return null;
                        }
                        else
                        {
                            if (firstnamespace != null)
                            {
                                if (inputInfos[j + 1].AccessType != InputInfoAccessType.ObjectOrNameSpace)
                                {
                                    return null;
                                }
                                string target = inputInfos[j].Name;
                                NameSpaceInfo nsm = firstnamespace.GetNameSpaceManager(target);
                                if (nsm == null)
                                {
                                    nextobjectinfo = firstnamespace.GetObjectInfo(target);
                                }
                                if (nsm == null && nextobjectinfo == null)
                                {
                                    return null;
                                }
                                firstnamespace = nsm;
                            }
                            else if (nextobjectinfo != null)
                            {
                                if (inputInfos[j + 1].AccessType != InputInfoAccessType.ObjectOrNameSpace)
                                {
                                    return null;
                                }
                                string target = inputInfos[j].Name;
                                VariableInfo tempvi = nextobjectinfo.GetVariableInfo(target);
                                if (tempvi == null)
                                {
                                    return null;
                                }
                                nextobjectinfo = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                                if (nextobjectinfo == null)
                                {
                                    return null;
                                }
                            }
                            else
                            {
                                return null;
                            }
                        }
                    }
                }
            }

            return null;
        }

        private AssistInformation FindAssistInformationFromObject(string target, ObjectInfo oi)
        {
            foreach (DefineValueInfo dvi in oi.GetAllDefineValue())
            {
                if (dvi.Name == target) return dvi;
            }
            foreach (VariableInfo vi in oi.GetAllVariable())
            {
                if (vi.Name == target) return vi;
            }
            foreach (FunctionInfo fi in oi.GetAllFunction())
            {
                if (fi.Name == target) return fi;
            }
            return null;
        }

        DefineLocation FindDefinitionFromNameSpace(string target, NameSpaceInfo nsm)
        {
            AssistInformation assistInformation = FindAssistInformationFromNameSpace(target, nsm);
            if (assistInformation == null)
            {
                return null;
            }
            else
            {
                return assistInformation.DefineLocation;
            }
        }

        private AssistInformation FindAssistInformationFromNameSpace(string target, NameSpaceInfo nsm)
        {
            foreach (DefineValueInfo dvi in nsm.GetAllDefineValue())
            {
                if (dvi.Name == target) return dvi;
            }
            foreach (VariableInfo vi in nsm.GetAllVariable())
            {
                if (vi.Name == target) return vi;
            }
            foreach (FunctionInfo fi in nsm.GetAllFunction())
            {
                if (fi.Name == target) return fi;
            }
            foreach (ObjectInfo oi in nsm.GetAllObjectType())
            {
                if (oi.Name == target) return oi;
            }
            foreach (NameSpaceInfo innsm in nsm.GetAllNameSpace())
            {
                if (innsm.Name == target) return innsm;
            }
            return null;
        }

        void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            int begin, end;
            GetSelection(out begin, out end);
            string s = GetTextInRange(begin, end);
            AssistInformation[] infos = FindAssistInformation(begin);
            if (infos.Length > 0)
            {
                mainForm.FindAndFocus(infos);
            }
            else
            {
                MessageBox.Show("見つかりませんでした");
            }
        }

        private AssistInformation[] FindAssistInformation(string target, int index)
        {
            EditorAssistData data = currentAssistData.IsEqualToNull ? completeAssistData : currentAssistData;
            if (data == null)
            {
                return new AssistInformation[0];
            }

            AssistInformation[] ret = data.FindAssistInformation(target);
            if (ret.Length == 0)
            {
                ret = data.VariableDatas.GetVariableData(index).Concat(data.VariableDatas.GetFunctionData(index))
                    .Where(i => i.Name == target).ToArray();
            }
            return ret;
        }

        public string ForError
        {
            get
            {
                return AnalyzeText;
            }
        }
        public EditorAssistData AssistData
        {
            get
            {
                return completeAssistData;
            }
        }
        public ExtensionInfomation ExtensionInfo
        {
            get
            {
                return extensionInfo;
            }
            set
            {
                extensionInfo = value;
                switch (extensionInfo.BuiltInMode.ToLower())
                {
                    case "latex":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Latex;
                        break;
                    case "batchfile":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.BatchFile;
                        break;
                    case "cpp":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Cpp;
                        break;
                    case "csharp":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.CSharp;
                        break;
                    case "diff":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Diff;
                        break;
                    case "ini":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Ini;
                        break;
                    case "java":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Java;
                        break;
                    case "pyhton":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Python;
                        break;
                    case "ruby":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Ruby;
                        break;
                    case "javascript":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.JavaScript;
                        break;
                    case "xml":
                        this.Highlighter = Sgry.Azuki.Highlighter.Highlighters.Xml;
                        break;
                    default:
                        this.Highlighter = extensionInfo.CustomHighlighter;
                        if (this.Highlighter != null)
                        {
                            extensionInfo.CustomHighlighter.SetCharClass(this, this.BackColor);
                        }
                        break;
                }
            }
        }
        public void DeleteChange()
        {
            bools |= Bools.DeleteChange;
        }
        public void UndoOrRedo()
        {
            bools |= Bools.UndoOrRedo;
        }
        public void MakeInvalidChange()
        {
            this.TextChanged -= this.ExAzukiControl_TextChanged;
            this.CaretMoved -= this.ExAzukiControl_CaretMoved;
        }
        public void MakeValidChange()
        {
            this.CaretMoved += this.ExAzukiControl_CaretMoved;
            this.TextChanged += this.ExAzukiControl_TextChanged;
        }
        public void HighlightAll()
        {
            try
            {
                this.Highlighter.Highlight(this.Document);
            }
            catch
            {
            }
        }
        public void HighlightRange(int begin, int end)
        {
            try
            {
                Highlighter.Highlight(this.Document, ref begin, ref end);
            }
            catch
            {
            }
        }
        public void ForceAutoFormat()
        {
            this.MakeInvalidChange();
            int lineIndex = 0;
            int lineCount = LineCount;
            this.Document.BeginUndo();
            while (lineIndex < lineCount)
            {
                CheckFormat(lineIndex);
                CheckIndent(lineIndex);
                lineCount += AddEolByEnclosure(lineIndex);
                lineIndex++;
            }
            this.Document.EndUndo();
            this.MakeValidChange();
        }
        public void KillThread()
        {
            if (anotherThread != null)
            {
                anotherThread.Abort();
                anotherThread = null;
            }
            timer.Stop();
            hoverTimer.Stop();
            checkFocusWordTimer.Stop();
        }
        void timer_Tick(object sender, EventArgs e)
        {
            timer.Stop();
            AnalyzeText = this.Text;
            if (notepadUtility.InputAssist)
            {
                if (anotherThread != null && anotherThread.IsAlive)
                {
                    //threadList.Add(new ManagedThread(anotherthread));
                    anotherThread.Abort();
                    anotherThread = null;
                }
                try
                {
                    anotherThread = new System.Threading.Thread(Analyze);
                    anotherThread.Start();
                }
                catch
                {

                }
            }
        }

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.contextMenuStrip1 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripMenuItem();
            this.contextMenuStrip1.SuspendLayout();
            this.SuspendLayout();
            // 
            // contextMenuStrip1
            // 
            this.contextMenuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItem1});
            this.contextMenuStrip1.Name = "contextMenuStrip1";
            this.contextMenuStrip1.Size = new System.Drawing.Size(132, 26);
            // 
            // toolStripMenuItem1
            // 
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            this.toolStripMenuItem1.Size = new System.Drawing.Size(131, 22);
            this.toolStripMenuItem1.Text = "定義へ移動";
            // 
            // ExAzukiControl
            // 
            this.ContextMenuStrip = this.contextMenuStrip1;
            this.ConvertsTabToSpaces = true;
            this.DrawingOption = ((Sgry.Azuki.DrawingOption)((((((((Sgry.Azuki.DrawingOption.DrawsFullWidthSpace | Sgry.Azuki.DrawingOption.DrawsTab)
                        | Sgry.Azuki.DrawingOption.DrawsEol)
                        | Sgry.Azuki.DrawingOption.HighlightCurrentLine)
                        | Sgry.Azuki.DrawingOption.ShowsLineNumber)
                        | Sgry.Azuki.DrawingOption.ShowsHRuler)
                        | Sgry.Azuki.DrawingOption.DrawsEof)
                        | Sgry.Azuki.DrawingOption.ShowsDirtBar)));
            this.DrawsEofMark = true;
            this.ShowsHRuler = true;
            this.TabWidth = 3;
            this.UsesTabForIndent = false;
            this.TextChanged += new System.EventHandler(this.ExAzukiControl_TextChanged);
            this.CaretMoved += new System.EventHandler(this.ExAzukiControl_CaretMoved);
            this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.ExAzukiControl_MouseMove);
            this.KeyUp += new System.Windows.Forms.KeyEventHandler(this.ExAzukiControl_KeyUp);
            this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.ExAzukiControl_MouseDown);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.ExAzukiControl_KeyPress);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.ExAzukiControl_KeyDown);
            this.contextMenuStrip1.ResumeLayout(false);
            this.ResumeLayout(false);

        }

        private void ClearHighlights()
        {
            foreach (Range range in highlightRange)
            {
                int start = Math.Max(0, range.Start),
                    end = Math.Min(TextLength, range.End);
                Document.Unmark(start, end, NotepadUtility.HighlightId);
            }
            highlightRange.Clear();
            Invalidate();
        }

        void checkFocusWordTimer_Tick(object sender, EventArgs e)
        {
            checkFocusWordTimer.Stop();

            int begin, end;
            this.GetSelection(out begin, out end);

            if (Document.ShouldBeIgnoredGrammatically(begin))
            {
                return;
            }

            string name = null;
            UpdateCurrentAssistData();
            AssistInformation[] assistInformations = FindAssistInformation(begin);
            if (assistInformations.Length == 0 || assistInformations.Length > 1)
            {
                return;
            }

            var headAssistInformation = assistInformations[0];
            name = headAssistInformation.Text;
            if (String.IsNullOrEmpty(name))
            {
                return;
            }

            string text = Text;
            int startIndex = 0, endIndex = text.Length;
            if (headAssistInformation is VariableInfo)
            {
                VariableInfo variableInfo = (VariableInfo)headAssistInformation;
                if (variableInfo.ParentTree != null)
                {
                    startIndex = variableInfo.ParentTree.Start;
                    endIndex = variableInfo.ParentTree.End;
                }
                highlightRange.Add(new Range(variableInfo.DefineLocation.DefineIndex,
                    variableInfo.DefineLocation.DefineIndex + name.Length));
            }
            else if (headAssistInformation is FunctionInfo)
            {
                FunctionInfo functionInfo = (FunctionInfo)headAssistInformation;
                if (functionInfo.ParentTree != null)
                {
                    startIndex = functionInfo.ParentTree.Start;
                    endIndex = functionInfo.ParentTree.End;
                }
                highlightRange.Add(new Range(functionInfo.DefineLocation.DefineIndex,
                    functionInfo.DefineLocation.DefineIndex + name.Length));
            }

            startIndex = text.IndexOf(name, startIndex);
            while (startIndex < endIndex)
            {
                if (startIndex < 0)
                {
                    break;
                }

                // check prev and next
                if (startIndex - 1 >= 0 && !IsValidChar(text[startIndex - 1]) &&
                    startIndex + name.Length < text.Length && !IsValidChar(text[startIndex + name.Length]))
                {
                    highlightRange.Add(new Range(startIndex, startIndex + name.Length));
                }

                startIndex = text.IndexOf(name, startIndex + name.Length);
            }

            foreach (Range range in highlightRange)
            {
                startIndex = Math.Max(range.Start, 0);
                endIndex = Math.Min(range.End, TextLength);
                if (!Document.ShouldBeIgnoredGrammatically(startIndex))
                {
                    Document.Mark(startIndex, endIndex, NotepadUtility.HighlightId);
                }
            }
            this.Invalidate();
        }

        private bool IsValidChar(char c)
        {
            return Char.IsLetterOrDigit(c) || c == '_';
        }

        private void ExAzukiControl_CaretMoved(object sender, EventArgs e)
        {
            checkFocusWordTimer.Stop();
            ClearBottomText();
            ClearHighlights();
            //checkclose
            int begin, end, column, row;
            this.GetSelection(out begin, out end);
            this.GetLineColumnIndexFromCharIndex(begin, out row, out column);
            mainForm.StatusLabel1 = (row + 1) + "行" + (column + 1) + "列";
            if (begin != end)
            {
                mainForm.StatusLabel2 = (end - begin).ToString() + "個の文字を選択中";
            }
            else
            {
                mainForm.StatusLabel2 = "";
            }
            if (begin != 0 && !this.Document.ShouldBeIgnoredGrammatically(begin - 1))
            {
                char beforechar = this.Document[begin - 1];
                for (int i = 0; i < extensionInfo.CorrespondPairs.Length / 2; i++)
                {
                    char c = extensionInfo.CorrespondPairs[2 * i + 1][0];
                    if (extensionInfo.CorrespondPairs[2 * i + 1].Length > 0 && beforechar == c)
                    {
                        int findresult = this.Document.FindMatchedBracket(begin - 1);
                        if (findresult != -1)
                        {
                            if (extensionInfo.LevelEnclosure.Length >= 2 && extensionInfo.LevelEnclosure[1].Length > 0 && beforechar == extensionInfo.LevelEnclosure[1][0])
                            {
                                int lineheadindex = this.GetLineHeadIndexFromCharIndex(findresult);
                                if (lineheadindex >= 0)
                                {
                                    string linetext = this.GetTextInRange(lineheadindex, findresult);
                                    linetext = linetext.TrimStart(new char[] { '\t', ' ' });
                                    if (String.IsNullOrEmpty(linetext))
                                    {
                                        int lineIndex = this.GetLineIndexFromCharIndex(lineheadindex);
                                        if (lineIndex > 0)
                                        {
                                            lineIndex--;
                                        }
                                        lineheadindex = GetLineHeadIndex(lineIndex);
                                        linetext = GetTextInRange(lineheadindex, lineheadindex + GetLineLength(lineIndex)).TrimStart(new char[] { '\t', ' ' });
                                    }
                                    mainForm.StatusLabel2 = linetext;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            checkFocusWordTimer.Start();
            //this.Invalidate();
        }

        private void ExAzukiControl_TextChanged(object sender, EventArgs e)
        {
            this.timer.Stop();
            bools |= Bools.Change;
            if (this.ContentChanged != null)
            {
                this.ContentChanged.Invoke(this, EventArgs.Empty);
            }
            int begin, end;
            Document.GetSelection(out begin, out end);
            //HighlightRange(this.GetLineHeadIndexFromCharIndex(begin), begin);
            if ((bools & Bools.DeleteChange) != Bools.DeleteChange)
            {
                CheckWordEventArgs eventArgs = new CheckWordEventArgs(this.Document, FileName, extensionInfo.Extension, this.CaretIndex, new Range(begin, end));
                if (!mainForm.CheckWord(eventArgs))
                {
                    if (!CheckWord(begin))
                    {
                        this.dataGridView.Visible = false;
                        //this.mytooltip.Hide();
                        if (!CheckFunction())
                        {
                            this.toolTip.Hide();
                        }
                    }
                    else
                    {
                        //this.mytooltip.Show();
                    }
                }
                else
                {
                    RefreshDataGrid();
                    dataGridView.AddRange(eventArgs.AssistInformations.ToArray());
                    ChangeStyleDataGrid();
                    dataGridView.Sort();

                    if (eventArgs.SelectIndex >= 0 && eventArgs.SelectIndex < eventArgs.AssistInformations.Count)
                    {
                        string data = eventArgs.AssistInformations[eventArgs.SelectIndex].Text;
                        bool probably;
                        int findresult = HitInDataGridWithMemory(data, out probably);
                        if (findresult == -1)
                        {
                            findresult = HitInDataGridWithMemoryCap(data.ToLower(), out probably);
                        }
                        if (findresult != -1 && !this.Document.ShouldBeIgnoredGrammatically(begin - data.Length))
                        {
                            dataGridView.SelectAndFinalize(findresult);
                            Point p = this.GetPositionFromIndex(begin);
                            SetDataGridViewLocation(new Point(p.X, p.Y + this.Font.Height));
                            if (probably)
                            {
                                dataGridView.SelectedIndex = -1;
                            }
                            dataGridView.Show();
                        }
                        else
                        {
                            dataGridView.EndUpdate();
                        }
                    }
                    else
                    {
                        dataGridView.EndUpdate();
                    }
                }
            }
            else
            {
                this.dataGridView.Visible = false;
                this.toolTip.Hide();
            }
            this.timer.Start();
        }

        private void SetDataGridViewLocation(Point pos)
        {
            Point screenPos = PointToScreen(pos);
            if (mainForm != null)
            {
                if (dataGridView.Height + screenPos.Y > mainForm.ClientSize.Height)
                {
                    screenPos.Y -= dataGridView.Height + this.Font.Height;
                }
                if (dataGridView.Width + screenPos.X > mainForm.ClientSize.Width)
                {
                    screenPos.X -= dataGridView.Width;
                }
            }

            dataGridView.Location = mainForm.PointToClient(screenPos);
        }

        private void ExAzukiControl_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (mainForm.IsShouldIgnoreKey) e.Handled = true;
            if (this.dataGridView.Visible)
            {
                if (e.KeyChar == '\r' || e.KeyChar == '\n')
                {
                    //this.TextChanged -= this_TextChanged;
                    //this.CaretMoved -= this_CaretMoved;
                    if (ReplaceAssist())
                    {
                        e.Handled = true;
                    }
                    //this.TextChanged += this_TextChanged;
                    //this.CaretMoved += this_CaretMoved;
                }
            }
            if (e.KeyChar == '\t')
            {
                if ((Control.ModifierKeys & Keys.Shift) == Keys.Shift)
                {
                    int begin = 0, end = 0;
                    this.GetSelection(out begin, out end);
                    if (begin > 0)
                    {
                        if (!UsesTabForIndent)
                        {
                            int trimindex = begin - TabWidth < 0 ? 0 : begin - TabWidth;
                            bool ok = true;
                            for (int i = trimindex; i < begin; i++)
                            {
                                if (this.Document[i] != ' ')
                                {
                                    ok = false;
                                    break;
                                }
                            }
                            if (ok)
                            {
                                this.Document.Replace("", trimindex, begin);
                                e.Handled = true;
                            }
                        }
                        else
                        {
                            if (this.Document[begin - 1] == '\t')
                            {
                                this.Document.Replace("", begin - 1, begin);
                                e.Handled = true;
                            }
                        }
                    }
                }
            }
        }
        public bool MoveUp()
        {
            if (dataGridView.Visible)
            {
                if (dataGridView.SelectedIndex > 0)
                {
                    dataGridView.SelectedIndex = dataGridView.SelectedIndex - 1;
                }
                else
                {
                    if (dataGridView.FocusedIndex >= 0)
                    {
                        dataGridView.SelectedIndex = dataGridView.FocusedIndex;
                    }
                }
                return true;
            }
            else if (toolTip.Visible)
            {
                if (currentShowingFunctionInfo != null)
                {
                    currentShowingFunctionInfo.GainDisplayNum(-1);
                    ChangeReferenceText(currentShowingFunctionInfo);
                }
                else
                {
                    toolTip.Hide();
                }
                return true;
            }
            return false;
        }
        public bool MoveDown()
        {
            if (dataGridView.Visible)
            {
                if (dataGridView.SelectedIndex >= 0 && dataGridView.SelectedIndex < dataGridView.Count - 1)
                {
                    dataGridView.SelectedIndex = dataGridView.SelectedIndex + 1;
                }
                else
                {
                    if (dataGridView.FocusedIndex >= 0)
                    {
                        dataGridView.SelectedIndex = dataGridView.FocusedIndex;
                    }
                }
                return true;
            }
            else if (toolTip.Visible)
            {
                if (currentShowingFunctionInfo != null)
                {
                    currentShowingFunctionInfo.GainDisplayNum(1);
                    ChangeReferenceText(currentShowingFunctionInfo);
                }
                else
                {
                    toolTip.Hide();
                }
                return true;
            }
            return false;
        }
        public bool MoveLeft()
        {
            if (dataGridView.Visible)
            {
                this.dataGridView.Visible = false;
                this.toolTip.Hide();
            }
            else if (toolTip.Visible)
            {
                toolTip.Hide();
            }
            return false;
        }
        public bool MoveRight()
        {
            if (dataGridView.Visible)
            {
                this.dataGridView.Visible = false;
                this.toolTip.Hide();
            }
            else if (toolTip.Visible)
            {
                toolTip.Hide();
            }
            return false;
        }
        private void ExAzukiControl_KeyDown(object sender, KeyEventArgs e)
        {
            if (mainForm.IsShouldIgnoreKey) e.Handled = true;
            if (e.KeyCode == Keys.Up)
            {
                if (MoveUp())
                {
                    e.Handled = true;
                }
            }
            else if (e.KeyCode == Keys.Down)
            {
                if (MoveDown())
                {
                    e.Handled = true;
                }
            }
            else if (e.KeyCode == Keys.Left)
            {
                if (MoveLeft())
                {
                    e.Handled = true;
                }
            }
            else if (e.KeyCode == Keys.Right)
            {
                if (MoveRight())
                {
                    e.Handled = true;
                }
            }
            if (e.KeyCode == Keys.Return)
            {
                if (notepadUtility.AutoFormat && !dataGridView.Visible)
                {
                    bools |= Bools.FormatPrevious;
                    /*int lineindex = 0, columnindex = 0;
                    this.Document.GetCaretIndex(out lineindex, out columnindex);
                    this.TextChanged -= ExAzukiControl_TextChanged;
                    this.CaretMoved -= ExAzukiControl_CaretMoved;
                    bools |= Bools.shouldcheckindent;
                    checkformat(lineindex);
                    this.TextChanged += ExAzukiControl_TextChanged;
                    this.CaretMoved += ExAzukiControl_CaretMoved;*/
                }
            }
            if (e.KeyCode == Keys.Back || e.KeyCode == Keys.Delete)
            {
                bools |= Bools.DeleteChange;
            }
            else
            {
                bools &= ~Bools.DeleteChange;
            }
            if (!e.Handled)
            {
                ClearHighlights();
            }
        }


        private void ExAzukiControl_KeyUp(object sender, KeyEventArgs e)
        {
            if ((bools & Bools.Change) != Bools.Change || !notepadUtility.AutoFormat || (bools & Bools.DeleteChange) == Bools.DeleteChange)
            {
                bools &= ~Bools.UndoOrRedo;
                bools &= ~Bools.Change;
                bools &= ~Bools.DeleteChange;
                return;
            }
            int begin = 0, end = 0;
            this.GetSelection(out begin, out end);
            int lineindex = 0, columnindex = 0;
            this.Document.GetCaretIndex(out lineindex, out columnindex);
            bool confirm = false;
            bool closed = false;
            if ((bools & Bools.UndoOrRedo) != Bools.UndoOrRedo && begin == end && begin <= this.TextLength && begin > 0)
            {
                char cc = Document.GetCharAt(begin - 1);
                confirm = !Document.ShouldBeIgnoredGrammatically(begin - 1) && CheckAutoFormat(cc);
            }
            if ((bools & Bools.UndoOrRedo) != Bools.UndoOrRedo && extensionInfo.LevelEnclosure.Length == 2 && extensionInfo.LevelEnclosure[1].Length >= 1)
            {
                if (begin == end && begin >= extensionInfo.LevelEnclosure[1].Length)
                {
                    string st = Document.GetTextInRange(begin - extensionInfo.LevelEnclosure[1].Length, begin);
                    if (st == extensionInfo.LevelEnclosure[1])
                    {
                        closed = true;
                    }
                }
            }
            bool anyformat = ((bools & Bools.FormatPrevious) == Bools.FormatPrevious) ||
                (closed && (bools & Bools.DeleteChange) != Bools.DeleteChange) ||
                (confirm && !dataGridView.Visible) || ((bools & Bools.ShouldCheckIndent) == Bools.ShouldCheckIndent);
            if (anyformat) this.Document.BeginUndo();
            if ((bools & Bools.FormatPrevious) == Bools.FormatPrevious)
            {
                this.TextChanged -= ExAzukiControl_TextChanged;
                this.CaretMoved -= ExAzukiControl_CaretMoved;
                bools |= Bools.ShouldCheckIndent;
                int prevLineIndex = lineindex - 1;
                if (prevLineIndex >= 0)
                {
                    CheckFormat(prevLineIndex);
                }
                this.TextChanged += ExAzukiControl_TextChanged;
                this.CaretMoved += ExAzukiControl_CaretMoved;
                bools &= ~Bools.FormatPrevious;
            }
            if (closed && (bools & Bools.DeleteChange) != Bools.DeleteChange && (bools & Bools.Change) == Bools.Change)
            {
                if (extensionInfo.LevelEnclosure.Length == 2 && extensionInfo.LevelEnclosure[0].Length >= 1 && notepadUtility.AutoFormatInScope)
                {
                    CheckIndentLines(0, lineindex, begin);
                }
                else
                {
                    CheckIndent(lineindex);
                }
            }
            if (confirm && !dataGridView.Visible)
            {
                this.TextChanged -= ExAzukiControl_TextChanged;
                this.CaretMoved -= ExAzukiControl_CaretMoved;
                CheckFormat(lineindex);
                CheckIndent(lineindex);
                this.TextChanged += ExAzukiControl_TextChanged;
                this.CaretMoved += ExAzukiControl_CaretMoved;
            }
            if ((bools & Bools.ShouldCheckIndent) == Bools.ShouldCheckIndent)
            {
                CheckIndent(lineindex);
                bools &= ~Bools.ShouldCheckIndent;
            }
            if (anyformat) this.Document.EndUndo();
            bools &= ~Bools.UndoOrRedo;
            bools &= ~Bools.Change;
            bools &= ~Bools.DeleteChange;
        }
        private void CheckIndentLines(int startLineIndex, int endLineIndex, int begin)
        {
            if (Document.ShouldBeIgnoredGrammatically(begin))
            {
                return;
            }

            this.SuspendLayout();
            this.TextChanged -= ExAzukiControl_TextChanged;
            this.CaretMoved -= ExAzukiControl_CaretMoved;
            try
            {
                string temp = this.Document.Text;
                int index = -1;
                int num0 = extensionInfo.LevelEnclosure[0].Length - 1;
                int num1 = extensionInfo.LevelEnclosure[1].Length - 1;
                int iter = 0;
                for (int i = begin - extensionInfo.LevelEnclosure[1].Length - 1; i >= 0; i--)
                {
                    if (Document.ShouldBeIgnoredGrammatically(i)) continue;
                    if (temp[i] == extensionInfo.LevelEnclosure[1][num1])
                    {
                        num1--;
                    }
                    else
                    {
                        num1 = extensionInfo.LevelEnclosure[1].Length - 1;
                    }
                    if (num1 == -1)
                    {
                        num1 = extensionInfo.LevelEnclosure[1].Length - 1;
                        iter++;
                    }
                    if (temp[i] == extensionInfo.LevelEnclosure[0][num0])
                    {
                        num0--;
                    }
                    else
                    {
                        num0 = extensionInfo.LevelEnclosure[0].Length - 1;
                    }
                    if (num0 == -1)
                    {
                        iter--;
                        num0 = extensionInfo.LevelEnclosure[0].Length - 1;
                        if (iter == -1)
                        {
                            index = i;
                            break;
                        }
                    }
                }
                if (index != -1)
                {
                    int zure = 0;
                    int slineindex = this.Document.GetLineIndexFromCharIndex(index);
                    for (int i = slineindex + zure; i <= endLineIndex + zure; i++)
                    {
                        CheckIndent(i);
                        zure += AddEolByEnclosure(i);
                    }
                    //index = this.Document.GetLineHeadIndex(endlineindex + zure) + this.Document.GetLineLength(endlineindex + zure);
                    //this.SetSelection(index, index);
                }
            }
            catch
            {
            }
            finally
            {
                this.ResumeLayout();
                this.CaretMoved += ExAzukiControl_CaretMoved;
                this.TextChanged += ExAzukiControl_TextChanged;
                ExAzukiControl_CaretMoved(this, EventArgs.Empty);
            }
        }

        private int AddEolByEnclosure(int lineIndex)
        {
            if (extensionInfo.LevelEnclosure.Length < 2)
            {
                return 0;
            }

            int zure = 0;
            string linest = this.Document.GetLineContent(lineIndex);
            int index = 0;
            if (HasSameCountClose(Document.GetLineHeadIndex(lineIndex), linest, extensionInfo.LevelEnclosure[0], extensionInfo.LevelEnclosure[1]))
            {
                return zure;
            }

            if ((index = linest.IndexOf(extensionInfo.LevelEnclosure[0])) != -1)
            {
                if (!Document.ShouldBeIgnoredGrammatically(index))
                {
                    if (!IsWhiteSpaceSequence(linest, extensionInfo.LevelEnclosure[0]))
                    {
                        if (notepadUtility.AdjustOpenEnclosure)
                        {
                            int fortemp = index;
                            index += Document.GetLineHeadIndex(lineIndex);
                            this.Document.Replace(Document.EolCode, index, index);
                            linest = linest.Substring(0, fortemp);
                            zure++;
                        }
                    }
                    else if (!IsWhiteSpaceSequence(SafeSubstring(linest, index + 1), ""))
                    {
                        if (notepadUtility.AdjustOpenEnclosure)
                        {
                            int fortemp = index;
                            index += Document.GetLineHeadIndex(lineIndex);
                            this.Document.Replace(Document.EolCode, index + 1, index + 1);
                            linest = linest.Substring(0, fortemp);
                            zure++;
                        }
                    }
                }
            }
            if ((index = linest.IndexOf(extensionInfo.LevelEnclosure[1])) != -1 && !IsWhiteSpaceSequence(linest, extensionInfo.LevelEnclosure[1]))
            {
                if (!Document.ShouldBeIgnoredGrammatically(index))
                {
                    index += Document.GetLineHeadIndex(lineIndex);
                    if (notepadUtility.AdjustCloseEnclosure)
                    {
                        this.Document.Replace(Document.EolCode, index, index);
                        CheckIndent(lineIndex);
                        zure++;
                    }
                }
            }

            return zure;
        }

        private bool HasSameCountClose(int headIndex, string str, string open, string close)
        {
            int openCount = 0, closeCount = 0;
            int startIndex = 0;
            while (startIndex >= 0 && startIndex < str.Length)
            {
                startIndex = str.IndexOf(open, startIndex);
                if (startIndex >= 0)
                {
                    if (!Document.ShouldBeIgnoredGrammatically(startIndex))
                    {
                        {
                            openCount++;
                        }
                    }
                }
                else
                {
                    break;
                }
                startIndex += open.Length;
            }

            startIndex = 0;
            while (startIndex >= 0 && startIndex < str.Length)
            {
                startIndex = str.IndexOf(close, startIndex);
                if (startIndex >= 0)
                {
                    if (!Document.ShouldBeIgnoredGrammatically(startIndex))
                    {
                        {
                            closeCount++;
                        }
                    }
                }
                else
                {
                    break;
                }
                startIndex += close.Length;
            }

            return openCount == closeCount;
        }

        private bool IsWhiteSpaceSequence(string st, string except)
        {
            int num = 0;
            for (int i = 0; i < st.Length; i++)
            {
                if (!Char.IsWhiteSpace(st[i]))
                {
                    if (except.Length > 0 && st[i] == except[num])
                    {
                        num++;
                        if (num == except.Length)
                        {
                            return true;
                        }
                    }
                    else
                    {
                        return false;
                    }
                }
            }
            return true;
        }
        private bool CheckAutoFormat(char c)
        {
            for (int i = 0; i < extensionInfo.AutoFormatChars.Length; i++)
            {
                if (c == extensionInfo.AutoFormatChars[i])
                {
                    return true;
                }
            }
            return false;
        }
        private void ExAzukiControl_MouseDown(object sender, MouseEventArgs e)
        {
            this.dataGridView.Visible = false;
            this.toolTip.Visible = false;
        }

        private void UpdateCurrentAssistData()
        {
            lock (this)
            {
                if (completeAssistData != null && currentAssistData != completeAssistData)
                {
                    currentAssistData = completeAssistData;
                    completeAssistData = null;
                }
            }
        }

        private bool CheckWord(int begin)
        {
            if (!notepadUtility.InputAssist)
            {
                return false;
            }
            InputInfo[] inputInfos = CheckInput(begin);
            if (inputInfos.Length == 0)
            {
                return false;
            }
            if (inputInfos.Length == 1)
            {
                //グローバルデータ
                //データグリッドの表示
                ClearDataGrid();
                string data = inputInfos[0].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                filter = new AssistInformationFilter(data);
                RefreshDataGrid();
                UpdateCurrentAssistData();
                VariableInfo[] vis = currentAssistData.VariableDatas.GetVariableData(begin);
                userFunctions = currentAssistData.VariableDatas.GetFunctionData(begin);
                AddToDataGrid(AddType.DefineValue | AddType.GlobalClass | AddType.GlobalFunction | AddType.GlobalNameSpace | AddType.GlobalVariable | AddType.UserFunction | AddType.ReservedWord);
                AddToDataGridVariableInfo(vis);
                ChangeStyleDataGrid();
                dataGridView.Sort();
                if (data == "")
                {
                    dataGridView.EndUpdate();
                    return false;
                }
                bool probably;
                int findresult = HitInDataGridWithMemory(data, out probably);
                if (findresult == -1)
                {
                    findresult = HitInDataGridWithMemoryCap(data.ToLower(), out probably);
                }
                if (findresult != -1 && !this.Document.ShouldBeIgnoredGrammatically(begin - data.Length))
                {
                    dataGridView.SelectAndFinalize(findresult);
                    Point p = this.GetPositionFromIndex(begin - data.Length);
                    SetDataGridViewLocation(new Point(p.X, p.Y + this.Font.Height));
                    if (probably)
                    {
                        dataGridView.SelectedIndex = -1;
                    }
                    dataGridView.Show();
                    return true;
                }
                else
                {
                    dataGridView.EndUpdate();
                    return false;
                }
            }
            string lastTarget;
            AssistInformation prevAssistInformation;
            AssistInformation assistInformation = FindAssistInformation(begin, inputInfos,
                out prevAssistInformation, out lastTarget);
            if (assistInformation == null)
            {
                assistInformation = prevAssistInformation;
            }
            if (assistInformation == null || lastTarget == null)
            {
                return false;
            }
            filter = new AssistInformationFilter(lastTarget);
            ClearDataGrid();
            if (assistInformation is ObjectInfo)
            {
                AddToDataGridObjectVariableAndFunction((ObjectInfo)assistInformation);
            }
            else if (assistInformation is NameSpaceInfo)
            {
                AddToDataGridNameSpaceObjectAndFunctionAndNameSpaceAndVariable((NameSpaceInfo)assistInformation);
            }
            ChangeStyleDataGrid();
            return ShowOrHideDataGrid(lastTarget, begin);
        }
        private bool ShowOrHideDataGrid(string target, int begin)
        {
            dataGridView.Sort();
            if (target == "")
            {
                int showindex = HitInDataGridWithMemory();
                if (showindex < 0) showindex = 0;
                dataGridView.SelectAndFinalize(showindex);
                Point p = this.GetPositionFromIndex(begin - 1);
                SetDataGridViewLocation(new Point(p.X, p.Y + this.Font.Height));
                dataGridView.Show();
                return true;
            }
            else
            {
                bool probably;
                int findresult = HitInDataGridWithMemory(target, out probably);
                if (findresult == -1)
                {
                    findresult = HitInDataGridWithMemoryCap(target, out probably);
                }
                if (findresult != -1 && !this.Document.ShouldBeIgnoredGrammatically(begin - target.Length))
                {
                    dataGridView.SelectAndFinalize(findresult);
                    Point p = this.GetPositionFromIndex(begin - target.Length);
                    SetDataGridViewLocation(new Point(p.X, p.Y + this.Font.Height));
                    if (probably)
                    {
                        dataGridView.SelectedIndex = -1;
                    }
                    dataGridView.Show();
                    return true;
                }
                else
                {
                    dataGridView.EndUpdate();
                    return false;
                }
            }
        }
        private ObjectInfo FindObject(string st, VariableInfo[] vis)
        {
            //変数が定義されているか
            string objecttype = "";
            bool found = false;
            for (int j = 0; j < vis.Length; j++)
            {
                if (vis[j].Name == st)
                {
                    objecttype = vis[j].Type;
                    found = true;
                    break;
                }
            }
            if (!found)
            {
                foreach (VariableInfo vi in currentAssistData.GlobalVariable)
                {
                    if (vi.Name == st)
                    {
                        objecttype = vi.Type;
                        found = true;
                        break;
                    }
                }
            }
            ObjectInfo objectinfo = null;
            if (found)
            {
                objectinfo = GetObjectInfoFromCurrentBuffer(objecttype);
            }
            return objectinfo;
        }
        private ObjectInfo GetObjectInfoFromCurrentBuffer(string type)
        {
            if (extensionInfo.TypeTrimChars != null && extensionInfo.TypeTrimChars.Length > 0)
            {
                type = type.Trim(extensionInfo.TypeTrimChars);
            }
            ObjectInfo ret = null;
            for (int i = 0; i < currentAssistData.LoadedBufferName.Count; i++)
            {
                NameSpaceInfo nsm = null;
                extensionInfo.BufferData.TryGetValue(currentAssistData.LoadedBufferName[i] as string, out nsm);
                if (nsm != null)
                {
                    ObjectInfo oi = nsm.GetObjectInfo(type);
                    if (oi != null)
                    {
                        ret = oi;
                        break;
                    }
                }
            }
            if (ret == null)
            {
                for (int j = 0; j < currentAssistData.GlobalNameSpace.Count; j++)
                {
                    ObjectInfo oi = (currentAssistData.GlobalNameSpace[j] as NameSpaceInfo).GetObjectInfo(type);
                    if (oi != null)
                    {
                        ret = oi;
                        break;
                    }
                }
            }
            if (ret == null)
            {
                for (int j = 0; j < currentAssistData.GlobalClass.Count; j++)
                {
                    ObjectInfo oi = currentAssistData.GlobalClass[j] as ObjectInfo;
                    if (oi != null && oi.Name == type)
                    {
                        ret = oi;
                        break;
                    }

                }
            }
            if (ret == null)
            {
                foreach (EditorAssistData assistData in mainForm.GetBuffers(extensionInfo))
                {
                    ret = assistData.GlobalClass.FirstOrDefault(c => c.Name == type);
                    if (ret != null)
                    {
                        break;
                    }
                }
            }
            return ret;
        }
        private int HitInDataGridWithMemory()
        {
            string[] alldata = new string[dataGridView.Count];
            int allstart = 0;
            for (int i = 0; i < dataGridView.Count; i++)
            {
                alldata[i] = dataGridView[i];
            }
            if (alldata.Length == 0)
            {
                return -1;
            }
            else
            {
                for (int i = usedString.Count - 1; i >= 0; i--)
                {
                    bool found = false;
                    int j = 0;
                    for (j = 0; j < alldata.Length; j++)
                    {
                        if (alldata[j] == usedString[i])
                        {
                            found = true;
                            break;
                        }
                    }
                    if (found)
                    {
                        return allstart + j;
                    }
                }
                //return allstart;
                return -1;
            }
        }
        private int HitInDataGridWithMemory(string data, out bool probably)
        {
            probably = false;
            SortedList<int, string> pool = new SortedList<int, string>(10);
            char sc = Char.ToLower(data[0]);
            for (int i = 0; i < dataGridView.Count; i++)
            {
                string target = dataGridView[i];
                if (target.StartsWith(data))
                {
                    pool.Add(i, target);
                }
                if (pool.Count > 0)
                {
                    char ec = Char.ToLower(target[0]);
                    if (sc != ec) break;
                }
            }
            if (pool.Count > 0)
            {
                for (int i = usedString.Count - 1; i >= 0; i--)
                {
                    bool found = false;
                    int j = 0;
                    for (j = 0; j < pool.Count; j++)
                    {
                        if (pool.Values[j] == usedString[i])
                        {
                            found = true;
                            break;
                        }
                    }
                    if (found)
                    {
                        return pool.Keys[j];
                    }
                }
                return pool.Keys[0];
            }
            else
            {
                return -1;
            }
        }
        private int HitInDataGridWithMemoryCap(string data, out bool probably)
        {
            probably = false;
            data = data.ToLower();
            string[] alldata = new string[dataGridView.Count];
            int allstart = 0;
            for (int i = 0; i < dataGridView.Count; i++)
            {
                alldata[i] = (dataGridView[i]).ToLower();
            }
            for (int i = 1; i <= data.Length; i++)
            {
                string tempst = data.Substring(0, i);
                int val = Array.BinarySearch(alldata, tempst, new CustomStringComparer());
                if (val >= 0)
                {
                    int up = val, down = val;
                    while (up >= 0)
                    {
                        if (alldata[up].StartsWith(tempst))
                        {
                            up--;
                        }
                        else
                        {
                            up++;
                            break;
                        }
                    }
                    while (down < alldata.Length)
                    {
                        if (alldata[down].StartsWith(tempst))
                        {
                            down++;
                        }
                        else
                        {
                            down--;
                            break;
                        }
                    }
                    if (up < 0) up = 0;
                    if (down >= alldata.Length) down = alldata.Length - 1;
                    string[] tempalldata = new string[down - up + 1];
                    allstart += up;
                    Array.ConstrainedCopy(alldata, up, tempalldata, 0, tempalldata.Length);
                    alldata = tempalldata;
                }
                else
                {
                    probably = true;
                    break;
                }
            }
            if (alldata.Length == 0)
            {
                return -1;
            }
            else
            {
                for (int i = usedString.Count - 1; i >= 0; i--)
                {
                    bool found = false;
                    int j = 0;
                    for (j = 0; j < alldata.Length; j++)
                    {
                        if (alldata[j] == usedString[i].ToLower())
                        {
                            found = true;
                            break;
                        }
                    }
                    if (found)
                    {
                        return allstart + j;
                    }
                }
                return allstart;
            }
        }
        public bool ReplaceAssist()
        {
            int begin = 0, end = 0;
            this.GetSelection(out begin, out end);
            if (end - begin == 0 && dataGridView.Count > 0 && dataGridView.SelectedIndex >= 0 && begin > 0)
            {
                //変換する部分を探す

                string replaceText = dataGridView[dataGridView.SelectedIndex];
                string replaceTextLower = replaceText.ToLower();

                int headIndex = this.GetLineHeadIndexFromCharIndex(begin);
                string lineText = this.GetTextInRange(headIndex, begin);
                int lastOKIndex = -1;

                for (int i = begin - 1; i >= headIndex; i--)
                {
                    string cmpText = this.GetTextInRange(i, begin).ToLower();
                    if (replaceTextLower.StartsWith(cmpText))
                    {
                        lastOKIndex = i;
                    }
                }

                if (lastOKIndex < 0)
                {
                    // 見つからなかった場合
                    // とりあえず最初の記号までを置き換える
                    for (int i = begin - 1; i >= headIndex; i--)
                    {
                        char c = this.Document[i];
                        if (!Char.IsLetterOrDigit(c))
                        {
                            lastOKIndex = i + 1;
                            break;
                        }
                    }
                }

                if (lastOKIndex < headIndex)
                {
                    lastOKIndex = headIndex;
                }

                this.Document.Replace(replaceText, lastOKIndex, begin);
                usedString.Add(replaceText);
                if (usedString.Count > 500)
                {
                    usedString.RemoveRange(0, 100);
                }
                dataGridView.Visible = false;
                toolTip.Hide();
                return true;

            }
            return false;
        }
        private void CheckFormat(int lineIndex)
        {
            string line = this.Document.GetLineContent(lineIndex);
            int lineHeadIndex = this.Document.GetLineHeadIndex(lineIndex);
            string newLine = CheckFormat(line, lineHeadIndex);
            if (line == newLine)
            {
                return;
            }

            int begin = lineHeadIndex, end = lineHeadIndex + line.Length;
            this.Document.Replace(newLine, begin, end);
            try
            {
                this.Document.Highlighter.Highlight(this.Document, ref begin, ref end);
            }
            catch
            {

            }
        }
        private string CheckFormat(string line, int lineHeadIndex)
        {
            List<bool> ignorePoints = new List<bool>();
            for (int i = 0; i < line.Length; i++)
            {
                ignorePoints.Add(this.Document.ShouldBeIgnoredGrammatically(lineHeadIndex + i));
            }
            foreach (string ignorePattern in extensionInfo.IgnorePattern)
            {
                foreach (Match match in Regex.Matches(line, ignorePattern))
                {
                    for (int i = match.Index; i < match.Index + match.Length; i++)
                    {
                        ignorePoints[i] = true;
                    }
                }
            }
            for (int i = 0; i < extensionInfo.OperationData.Length; i++)
            {
                try
                {
                    Regex regex = new Regex(extensionInfo.OperationData[i][0]);
                    line = regex.Replace(line, new MatchEvaluator(m =>
                    {
                        for (int j = m.Index; j < m.Index + m.Length; j++)
                        {
                            if (ignorePoints[j])
                            {
                                return m.Value;
                            }
                        }

                        // change size of ignorePattern
                        string replace = m.Result(extensionInfo.OperationData[i][1]);
                        if (replace.Length > m.Length)
                        {
                            for (int j = 0; j < replace.Length - m.Length; j++)
                            {
                                ignorePoints.Insert(m.Index + m.Length + j, false);
                            }
                        }
                        else if (replace.Length < m.Length)
                        {
                            for (int j = 0; j < m.Length - replace.Length; j++)
                            {
                                ignorePoints.RemoveAt(m.Index + replace.Length);
                            }
                        }
                        return replace;
                    }));
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message);
                }
            }
            string whiteSpaceSpared = line.TrimEnd(' ', '\t');
            if (whiteSpaceSpared.Length > 0)
            {
                line = whiteSpaceSpared;
            }

            return line;
        }
        private void HighlightLine(int lineindex)
        {
            if (lineindex >= 0 && lineindex < this.LineCount)
            {
                int dirtybegin = Document.GetLineHeadIndex(lineindex);
                int dirtyend = Document.GetLineLength(lineindex) + dirtybegin;
                if (this.Highlighter != null) this.Highlighter.Highlight(Document, ref dirtybegin, ref dirtyend);
            }
        }
        private void CheckIndent(int lineIndex)
        {
            if (lineIndex > 0)
            {
                string data = this.Document.GetLineContent(lineIndex);
                int length = data.Length, beforeIndex = lineIndex - 1;
                while (beforeIndex >= 0)
                {
                    string before = this.Document.GetLineContent(beforeIndex);
                    if (!String.IsNullOrEmpty(before.Trim()))
                    {
                        break;
                    }
                    beforeIndex--;
                }
                if (beforeIndex < 0)
                {
                    beforeIndex = 0;
                }
                string beforedata = this.Document.GetLineContent(beforeIndex);
                int beforehead = this.GetLineHeadIndex(lineIndex - 1),
                    currenthead = this.GetLineHeadIndex(lineIndex);
                if (UsesTabForIndent)
                {
                    int beforelevel = CountLevel(beforedata, beforehead);
                    int currentlevel = JustCountHeadCountLevel(data, currenthead);
                    int minuslevel = CountCloseSignNum(data, currenthead);
                    minuslevel = minuslevel < 0 ? 0 : minuslevel;
                    if (beforelevel != currentlevel + minuslevel)
                    {
                        int gap = data.Length;
                        data = data.TrimStart(new char[] { '\t', ' ' });
                        gap -= data.Length;
                        StringBuilder sb = new StringBuilder();
                        if (beforelevel - minuslevel >= 0)
                        {
                            sb.Append('\t', beforelevel - minuslevel);
                        }
                        data = sb.ToString();
                        this.Document.Replace(data, currenthead, currenthead + gap);
                    }
                }
                else
                {
                    beforedata = beforedata.Replace("\t", " ");
                    data = data.Replace("\t", " ");
                    int gain = CountLevel(beforedata, beforehead);
                    int temp = CountCloseSignNum(data, currenthead);
                    gain += -temp;
                    int beforespacenum = CountHeadSpace(beforedata);
                    int currentspacenum = CountHeadSpace(data);
                    if (beforespacenum + gain * TabWidth != currentspacenum)
                    {
                        //replace
                        data = CreateSpace(beforespacenum + gain * TabWidth);
                        this.Document.Replace(data, currenthead, currenthead + currentspacenum);
                    }
                }
            }
            else if (lineIndex == 0)
            {
                string data = this.Document.GetLineContent(lineIndex);
                int length = data.Length;
                data = data.TrimStart(new char[] { '\t', ' ' });
                length -= data.Length;
                this.Document.Replace("", 0, length);
            }

            // trim end space
            string lineContent = this.Document.GetLineContent(lineIndex);
            int lineLength = lineContent.Length;
            lineContent = lineContent.TrimEnd(new char[] { '\t', ' ' });
            if (lineContent.Length != 0)
            {
                int beginIndex = this.GetLineHeadIndex(lineIndex);
                this.Document.Replace(lineContent, beginIndex, beginIndex + lineLength);
            }

            HighlightLine(lineIndex);
        }
        private int CountHeadSpace(string data)
        {
            int ret = 0, iter = 0;
            while (iter < data.Length)
            {
                if (data[iter] == ' ')
                {
                    ret++;
                }
                else
                {
                    break;
                }
                iter++;
            }
            return ret;
        }
        private string CreateSpace(int num)
        {
            StringBuilder sb = new StringBuilder();
            if (num >= 0)
            {
                sb.Append(' ', num);
            }
            return sb.ToString();
        }
        private int CountLevel(string data, int startindex)
        {
            int ret = 0, iter = 0;
            bool enclosureok = (extensionInfo.LevelEnclosure.Length == 2 && extensionInfo.LevelEnclosure[0].Length >= 1 && extensionInfo.LevelEnclosure[1].Length >= 1);
            bool openfound = false;
            while (iter < data.Length)
            {
                if (!this.Document.ShouldBeIgnoredGrammatically(startindex + iter))
                {
                    if (data[iter] == '\t')
                    {
                        iter++;
                        ret++;
                    }
                    else if (enclosureok && (data.Length - iter) >= extensionInfo.LevelEnclosure[0].Length && data.Substring(iter, extensionInfo.LevelEnclosure[0].Length) == extensionInfo.LevelEnclosure[0])
                    {
                        iter += extensionInfo.LevelEnclosure[0].Length == 0 ? 1 : extensionInfo.LevelEnclosure[0].Length;
                        ret++;
                        openfound = true;
                    }
                    else if (enclosureok && (data.Length - iter) >= extensionInfo.LevelEnclosure[1].Length && data.Substring(iter, extensionInfo.LevelEnclosure[1].Length) == extensionInfo.LevelEnclosure[1] && openfound)
                    {
                        iter += extensionInfo.LevelEnclosure[1].Length == 0 ? 1 : extensionInfo.LevelEnclosure[1].Length;
                        ret--;
                    }
                    else
                    {
                        iter++;
                    }
                }
                else
                {
                    iter++;
                }
            }
            return ret;
        }
        private int JustCountHeadCountLevel(string data, int startindex)
        {
            int ret = 0, iter = 0;
            while (iter < data.Length)
            {
                if (!this.Document.ShouldBeIgnoredGrammatically(startindex + iter))
                {
                    if (data[iter] == '\t')
                    {
                        ret++;
                    }
                    else if (data[iter] == ' ')
                    {
                        ret = 100;
                        return ret;
                    }
                    else
                    {
                        break;
                    }
                }
                else
                {
                    break;
                }
                iter++;
            }
            return ret;
        }
        private int CountCloseSignNum(string data, int startindex)
        {
            int ret = 0, iter = 0;
            bool enclosureok = (extensionInfo.LevelEnclosure.Length == 2 && extensionInfo.LevelEnclosure[0].Length >= 1 && extensionInfo.LevelEnclosure[1].Length >= 1);
            bool openfound = false;
            while (iter < data.Length)
            {
                if (!this.Document.ShouldBeIgnoredGrammatically(startindex + iter))
                {
                    if (enclosureok && (data.Length - iter) >= extensionInfo.LevelEnclosure[0].Length && data.Substring(iter, extensionInfo.LevelEnclosure[0].Length) == extensionInfo.LevelEnclosure[0])
                    {
                        //ret--;
                        openfound = true;
                    }
                    if (enclosureok && (data.Length - iter) >= extensionInfo.LevelEnclosure[1].Length && data.Substring(iter, extensionInfo.LevelEnclosure[1].Length) == extensionInfo.LevelEnclosure[1] && !openfound)
                    {
                        ret++;
                    }
                }
                iter++;
            }
            return ret;
        }
        private void ClearBottomText()
        {
            mainForm.StatusLabel2 = "";
            mainForm.StatusLabel3 = "";
        }
        private void ChangeReferenceText(FunctionInfo functionInfo)
        {
            string text = functionInfo.HintText;
            string argname = "";
            string argtext = functionInfo.ArgumentFromCurrent(currentArgCount);
            if (extensionInfo.FunctionSeparator != '\0')
            {
                if (currentArgCount == 0)
                {
                    //find '('
                    int sindex = text.IndexOf('(');
                    int eindex = text.IndexOf(extensionInfo.FunctionSeparator);
                    if (eindex == -1)
                    {
                        eindex = text.IndexOf(')');
                    }
                    if (sindex != -1 && eindex != -1)
                    {
                        argname = GetFunctionArgument(text.Substring(sindex + 1, eindex - sindex - 1));
                        text = text.Insert(sindex + 1, "<#<b>#>");
                        text = text.Insert(eindex + 7, "<#<b>#>");
                    }
                }
                else
                {
                    int sindex = FindCharAtNum(text, extensionInfo.FunctionSeparator, currentArgCount);
                    int eindex = FindCharAtNum(text, extensionInfo.FunctionSeparator, currentArgCount + 1);
                    if (eindex == -1)
                    {
                        eindex = text.LastIndexOf(')');
                    }
                    if (sindex != -1 && eindex != -1)
                    {
                        argname = GetFunctionArgument(text.Substring(sindex + 1, eindex - sindex - 1));
                        text = text.Insert(sindex + 1, "<#<b>#>");
                        text = text.Insert(eindex + 7, "<#<b>#>");
                    }
                }
            }
            if (argname != "" && argtext != "")
            {
                StringBuilder sb = new StringBuilder(text);
                sb.Append("\n");
                sb.Append("<#<b>#>");
                sb.Append(argname);
                sb.Append(":\n");
                sb.Append(argtext);
                toolTip.DisplayText = sb.ToString();
            }
            else
            {
                toolTip.DisplayText = text;
            }
            toolTip.Show();
        }
        private string GetFunctionArgument(string text)
        {
            //think of this case
            //Hoge hoge   (not last is character)
            text = text.TrimEnd(' ');
            int index = -1;
            int kakkocount = 0;
            for (int i = text.Length - 1; i >= 0; i--)
            {
                if (text[i] == ')')
                {
                    kakkocount--;
                }
                else if (text[i] == '(')
                {
                    kakkocount++;
                }
                if (text[i] == ' ' && kakkocount == 0)
                {
                    index = i;
                    break;
                }
            }
            if (index >= 0 && index < text.Length)
            {
                return text.Substring(index + 1);
            }
            return text;
        }
        private void ChangeReferenceText(string text, int index, int argc)
        {
            Point p = mainForm.PointToClient(this.PointToScreen(this.GetPositionFromIndex(index)));
            toolTip.Location = new Point(p.X, p.Y + this.Font.Height);
            currentArgCount = argc;
            ChangeReferenceText(currentShowingFunctionInfo);
        }
        private int FindCharAtNum(string data, char c, int num)
        {
            int index = -1;
            int iter = 0;
            int kakkocount = 0;
            for (int i = 0; i < data.Length; i++)
            {
                if (data[i] == '(')
                {
                    kakkocount++;
                }
                else if (data[i] == ')')
                {
                    kakkocount--;
                }
                else if (data[i] == c && kakkocount == 1)
                {
                    iter++;
                    if (iter >= num)
                    {
                        index = i;
                        break;
                    }
                }
            }
            return index;
        }
        private bool CheckFunction()
        {
            if (!notepadUtility.FunctionAssist)
            {
                return false;
            }

            int begin = 0, end = 0;
            int argc = 0;
            this.GetSelection(out begin, out end);
            if (end - begin != 0 || begin <= 0)
            {
                return false;
            }

            int lineindex = GetLineHeadIndexFromCharIndex(begin);
            string linedata = Document.GetTextInRange(lineindex, begin);
            int kakkocount = 0;
            bool findanchor = false;
            int anchor = 0;
            for (int i = linedata.Length - 1; i >= 0; i--)
            {
                if (findanchor)
                {
                    break;
                }
                if (Document.ShouldBeIgnoredGrammatically(i + lineindex)) continue;
                if (kakkocount == 0 && linedata[i] == extensionInfo.FunctionSeparator)
                {
                    argc++;
                }
                if (linedata[i] == '(' && i > 0)
                {
                    anchor = i;
                    kakkocount--;
                    if (kakkocount == -1)
                    {
                        findanchor = true;
                    }
                }
                if (linedata[i] == ')')
                {
                    kakkocount++;
                }
            }
            if (!findanchor)
            {
                return false;
            }

            int iter = anchor - 1;
            int endanchor = anchor;
            InputInfo[] inputInfos = CheckInput(lineindex + anchor);
            if (inputInfos.Length == 0)
            {
                return false;
            }
            if (inputInfos.Length == 1)
            {
                //グローバルデータ
                //ユーザー定義の関数、あるいはグローバルな関数、あるいは名前空間で読み込まれている関数
                //から探してあれば表示する
                if (currentAssistData.VariableDatas != null)
                {
                    userFunctions = currentAssistData.VariableDatas.GetFunctionData(begin);
                }
                string target = inputInfos[0].Name.Trim(new char[] { '\t', '\r', '\n', ' ' });
                string displaydata = FindFuncContent(target);
                if (displaydata != "")
                {
                    ChangeReferenceText(displaydata, lineindex + anchor - 1, argc);
                    return true;
                }
                else
                {
                    return false;
                }
            }
            string lastTarget;
            AssistInformation prevAssistInformation;
            AssistInformation assistInformation = FindAssistInformation(anchor, inputInfos,
                out prevAssistInformation, out lastTarget);
            if (assistInformation == null)
            {
                assistInformation = prevAssistInformation;
            }
            if (assistInformation == null || lastTarget == null)
            {
                return false;
            }
            Action<FunctionInfo> setFunction = fi =>
            {
                currentShowingFunctionInfo = fi;
                string displaydata = fi.ContentAt(fi.Displaynum) + fi.NumOfOverride;
                ChangeReferenceText(displaydata, lineindex + anchor - 1, argc);
            };
            if (assistInformation is FunctionInfo)
            {
                setFunction((FunctionInfo)assistInformation);
                return true;
            }
            else if (assistInformation is ObjectInfo)
            {
                foreach (FunctionInfo fi in ((ObjectInfo)assistInformation).GetAllFunction())
                {
                    if (lastTarget == fi.Name)
                    {
                        setFunction(fi);
                        return true;
                    }
                }
            }
            else if (assistInformation is NameSpaceInfo)
            {
                foreach (FunctionInfo fi in ((NameSpaceInfo)assistInformation).GetAllFunction())
                {
                    if (lastTarget == fi.Name)
                    {
                        setFunction(fi);
                        return true;
                    }
                }
            }

            return false;
        }
        private string FindFuncContent(string functionName)
        {
            if (userFunctions != null)
            {
                for (int i = 0; i < userFunctions.Length; i++)
                {
                    if (userFunctions[i].Name == functionName)
                    {
                        currentShowingFunctionInfo = userFunctions[i];
                        return userFunctions[i].ContentAt(userFunctions[i].Displaynum) + userFunctions[i].NumOfOverride;
                    }
                }
            }
            if (currentAssistData.GlobalFunction != null)
            {
                for (int i = 0; i < currentAssistData.GlobalFunction.Count; i++)
                {
                    FunctionInfo tempfi = currentAssistData.GlobalFunction[i] as FunctionInfo;
                    if (functionName == tempfi.Name)
                    {
                        currentShowingFunctionInfo = tempfi;
                        return tempfi.ContentAt(tempfi.Displaynum) + tempfi.NumOfOverride;
                    }
                }
            }
            currentShowingFunctionInfo = null;
            return "";
        }
        private void Analyze()
        {
            int begin = 0, end = 0;
            lock (this)
            {
                GetSelection(out begin, out end);
            }
            updatingAssistData = new EditorAssistData(this);
            updatingAssistData.CaretPos = end;
            ParseEventArgs ea = new ParseEventArgs(updatingAssistData, AnalyzeText, FileName, extensionInfo.Extension);
            if (mainForm.Parse(ea))
            {
                lock (this)
                {
                    completeAssistData = updatingAssistData;
                }
            }
        }
        public void GotoIndex(int index)
        {
            if (index < 0 || index >= TextLength)
            {
                return;
            }

            this.SetSelection(index, index);
            this.ScrollToCaret();
            this.Focus();
        }
        private string SafeSubstring(string src, int begin)
        {
            if (begin < 0) begin = 0;
            if (begin >= src.Length) begin = src.Length;
            return src.Substring(begin);
        }
        private void RefreshDataGrid()
        {
            dataGridView.Clear();
        }
        private void ClearDataGrid()
        {
            dataGridView.Clear();
        }
        private void AddToDataGridVariableInfo(VariableInfo[] vis)
        {
            foreach (VariableInfo variableInfo in vis)
            {
                if (this.Document.ShouldBeIgnoredGrammatically(variableInfo.DefineLocation.DefineIndex))
                {
                    continue;
                }
                if (OnFilter(variableInfo))
                {
                    dataGridView.Add(variableInfo);
                }
            }
        }
        private void ChangeStyleDataGrid()
        {
            dataGridView.RemoveSameInData();
        }

        private void AddToDataGridObjectVariableAndFunction(ObjectInfo oi)
        {
            foreach (VariableInfo vi in oi.GetAllVariable())
            {
                if (OnFilter(vi))
                {
                    dataGridView.Add(vi);
                }
            }
            foreach (FunctionInfo fi in oi.GetAllFunction())
            {
                if (OnFilter(fi))
                {
                    dataGridView.Add(fi);
                }
            }
            foreach (DefineValueInfo dvi in oi.GetAllDefineValue())
            {
                if (OnFilter(dvi))
                {
                    dataGridView.Add(dvi);
                }
            }
        }

        [Flags]
        enum AddType
        {
            None = 0,
            DefineValue = 1,
            GlobalNameSpace = 2,
            GlobalVariable = 4,
            GlobalFunction = 8,
            GlobalClass = 16,
            UserFunction = 32,
            ReservedWord = 64,
        }

        private void AddToDataGrid(AddType addType)
        {
            if ((addType & AddType.DefineValue) == AddType.DefineValue)
            {
                if (currentAssistData.GlobalDefineValue != null)
                {
                    foreach (DefineValueInfo dvi in currentAssistData.GlobalDefineValue)
                    {
                        if (filter != null && filter.Filter(dvi))
                        {
                            dataGridView.Add(dvi);
                        }
                    }
                }
            }

            if ((addType & AddType.GlobalNameSpace) == AddType.GlobalNameSpace)
            {
                if (currentAssistData.GlobalNameSpace != null)
                {
                    foreach (NameSpaceInfo nameSpaceInfo in currentAssistData.GlobalNameSpace)
                    {
                        if (OnFilter(nameSpaceInfo))
                        {
                            dataGridView.Add(nameSpaceInfo);
                        }
                    }
                }
            }

            if ((addType & AddType.GlobalVariable) == AddType.GlobalVariable)
            {
                if (currentAssistData.GlobalVariable != null)
                {
                    foreach (VariableInfo variableInfo in currentAssistData.GlobalVariable)
                    {
                        if (OnFilter(variableInfo))
                        {
                            dataGridView.Add(variableInfo);
                        }
                    }
                }
            }

            if ((addType & AddType.GlobalFunction) == AddType.GlobalFunction)
            {
                if (currentAssistData.GlobalFunction != null)
                {
                    foreach (FunctionInfo functionInfo in currentAssistData.GlobalFunction)
                    {
                        if (OnFilter(functionInfo))
                        {
                            dataGridView.Add(functionInfo);
                        }
                    }
                }
            }

            if ((addType & AddType.GlobalClass) == AddType.GlobalClass)
            {
                if (currentAssistData.GlobalClass != null)
                {
                    foreach (ObjectInfo objectInfo in currentAssistData.GlobalClass)
                    {
                        if (OnFilter(objectInfo))
                        {
                            dataGridView.Add(objectInfo);
                        }
                    }
                }
            }

            if ((addType & AddType.UserFunction) == AddType.UserFunction)
            {
                foreach (FunctionInfo functionInfo in userFunctions)
                {
                    if (OnFilter(functionInfo))
                    {
                        dataGridView.Add(functionInfo);
                    }
                }
            }

            if ((addType & AddType.ReservedWord) == AddType.ReservedWord)
            {
                foreach (AssistInformation assistInformation in extensionInfo.DefaultInfos)
                {
                    if (OnFilter(assistInformation))
                    {
                        dataGridView.Add(assistInformation);
                    }
                }
            }
        }

        private void AddToDataGridNameSpaceObjectAndFunctionAndNameSpaceAndVariable(NameSpaceInfo nsm)
        {
            foreach (NameSpaceInfo tempnsm in nsm.GetAllNameSpace())
            {
                if (OnFilter(tempnsm))
                {
                    dataGridView.Add(tempnsm);
                }
            }
            foreach (ObjectInfo oi in nsm.GetAllObjectType())
            {
                if (OnFilter(oi))
                {
                    dataGridView.Add(oi);
                }
            }
            foreach (FunctionInfo fi in nsm.GetAllFunction())
            {
                if (OnFilter(fi))
                {
                    dataGridView.Add(fi);
                }
            }
            foreach (VariableInfo vi in nsm.GetAllVariable())
            {
                if (OnFilter(vi))
                {
                    dataGridView.Add(vi);
                }
            }
            foreach (DefineValueInfo dvi in nsm.GetAllDefineValue())
            {
                if (OnFilter(dvi))
                {
                    dataGridView.Add(dvi);
                }
            }
        }

        private bool OnFilter(AssistInformation assistInformation)
        {
            if (filter != null)
            {
                return filter.Filter(assistInformation);
            }
            return true;
        }

        private Point lastMousePos = Point.Empty;
        private void ExAzukiControl_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Location != lastMousePos)
            {
                hoverTimer.Stop();
                hoverTimer.Start();
                lastMousePos = e.Location;
            }
        }

        void hoverTimer_Tick(object sender, EventArgs e)
        {
            hoverTimer.Stop();

            Point p = PointToClient(Cursor.Position);
            int begin = this.GetIndexFromPosition(p);

            if (Document.ShouldBeIgnoredGrammatically(begin))
            {
                toolTip.Hide();
                return;
            }

            AssistInformation[] assistInfos = FindAssistInformation(begin);
            if (assistInfos.Length == 1)
            {
                var assistInfo = assistInfos[0];
                p = mainForm.PointToClient(this.PointToScreen(this.GetPositionFromIndex(begin)));
                currentArgCount = -1;
                currentShowingFunctionInfo = null;
                toolTip.Location = new Point(p.X, p.Y + this.Font.Height);
                toolTip.DisplayText = String.Format((String.IsNullOrEmpty(assistInfo.Summary) ? "{0}" : "{0}\n{1}"), assistInfo.HintText, assistInfo.Summary);
                if (!String.IsNullOrEmpty(toolTip.DisplayText.Trim()))
                {
                    toolTip.Show();
                }
                else
                {
                    toolTip.Hide();
                }
            }
            else
            {
                toolTip.Hide();
            }
        }
    }
    public class CustomStringComparer : System.Collections.IComparer, System.Collections.Generic.IComparer<string>
    {
        public int Compare(string x, string y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;
            //比較する
            if (x.StartsWith(y))
            {
                return 0;
            }
            else
            {
                StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
                return sc.Compare(x, y);
            }
        }
        public int Compare(object x, object y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;

            //String型以外の比較はエラー
            if (!(x is string) || !(y is string))
                throw new ArgumentException();
            CustomStringComparer csc = new CustomStringComparer();

            return csc.Compare((string)x, (string)y);
        }
    }
}
