﻿using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Text;

using WeifenLuo.WinFormsUI.Docking;
using NotepadNeueExtension;

namespace NotepadNeue
{
    public class ExNotepadNeueSkin : NotepadNeueExtension.NotepadNeueSkin
    {
        public ExNotepadNeueSkin()
        {
            OverLayColor = Color.FromArgb(220, 255, 255, 255);
            FillColor = Color.FromArgb(255, 255, 255);
            BorderColor = Color.FromArgb(255, 128, 128, 128);
            TransparentTextColor = Color.Black;
            DisplayMode = BackGroundDisplayMode.right;
            DockPanelSkin skin = new DockPanelSkin();
            skin.AutoHideStripSkin.DockStripGradient = CreateDockPanelGradient(81, 85, 94, 37, 42, 45, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.AutoHideStripSkin.TabGradient = CreateTabGradient(147, 207, 208, 7, 117, 118, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.DocumentGradient.ActiveTabGradient = CreateTabGradient(231, 245, 248, 0, 157, 188, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.DocumentGradient.DockStripGradient = CreateTabGradient(37, 42, 45, 81, 85, 94, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.DocumentGradient.InactiveTabGradient = CreateTabGradient(147, 207, 208, 7, 117, 118, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.ToolWindowGradient.ActiveCaptionGradient = CreateTabGradient(231, 245, 248, 0, 157, 188, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.ToolWindowGradient.ActiveTabGradient = CreateTabGradient(231, 245, 248, 0, 157, 188, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.ToolWindowGradient.DockStripGradient = CreateTabGradient(81, 85, 94, 37, 42, 45, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.ToolWindowGradient.InactiveCaptionGradient = CreateTabGradient(147, 207, 208, 7, 117, 118, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            skin.DockPaneStripSkin.ToolWindowGradient.InactiveTabGradient = CreateTabGradient(147, 207, 208, 7, 117, 118, System.Drawing.Drawing2D.LinearGradientMode.Horizontal);
            Skin = skin;
        }
        public void Initialize(string filename,string currentdirectory)
        {
            try
            {
                if (File.Exists(filename))
                {
                    Regex rgb = new Regex("(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
                    Regex argb = new Regex("(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
                    StreamReader sr = new StreamReader(filename);
                    string data = sr.ReadToEnd();
                    sr.Close();
                    SettingAnalyzer sanal = new SettingAnalyzer(data);
                    string backfilename = currentdirectory + sanal["BackGround"];
                    if (File.Exists(backfilename))
                    {
                        BackGround = new Bitmap(backfilename);
                    }
                    int displaymode = int.Parse(sanal["DisplayMode"]);
                    if (displaymode >= 0 && displaymode < 4)
                    {
                        DisplayMode = (BackGroundDisplayMode)displaymode;
                    }
                    string fillcolor = sanal["FillColor"];
                    FillColor = GetColorFromString(rgb, argb, fillcolor);
                    string overlaycolor = sanal["OverLayColor"];
                    OverLayColor = GetColorFromString(rgb, argb, overlaycolor);
                    string bordercolor = sanal["BorderColor"];
                    BorderColor = GetColorFromString(rgb, argb, bordercolor);
                    string transparenttextcolor = sanal["TransparentTextColor"];
                    TransparentTextColor = GetColorFromString(rgb, argb, transparenttextcolor);
                    DockPanelSkin skin = new DockPanelSkin();
                    string[] Name = new string[]{
                        "AutoHideDockStripGradient",
                        "AutoHideTabGradient",
                        "DocumentActiveTabGradient",
                        "DocumentDockStripGradient",
                        "DocumentInactiveTabGradient",
                        "ToolWindowActiveCaptionGradient",
                        "ToolWindowActiveTabGradient",
                        "ToolWindowDockStripGradient",
                        "ToolWindowInactiveCaptionGradient",
                        "ToolWindowInactiveTabGradient"
                    };
                    DockPanelGradient[] dpg = new DockPanelGradient[10];
                    dpg[0] = skin.AutoHideStripSkin.DockStripGradient;
                    dpg[1] = skin.AutoHideStripSkin.TabGradient;
                    dpg[2] = skin.DockPaneStripSkin.DocumentGradient.ActiveTabGradient;
                    dpg[3] = skin.DockPaneStripSkin.DocumentGradient.DockStripGradient;
                    dpg[4] = skin.DockPaneStripSkin.DocumentGradient.InactiveTabGradient;
                    dpg[5] = skin.DockPaneStripSkin.ToolWindowGradient.ActiveCaptionGradient;
                    dpg[6] = skin.DockPaneStripSkin.ToolWindowGradient.ActiveTabGradient;
                    dpg[7] = skin.DockPaneStripSkin.ToolWindowGradient.DockStripGradient;
                    dpg[8] = skin.DockPaneStripSkin.ToolWindowGradient.InactiveCaptionGradient;
                    dpg[9] = skin.DockPaneStripSkin.ToolWindowGradient.InactiveTabGradient;
                    for (int i = 0; i < dpg.Length; i++)
                    {
                        int mode = int.Parse(sanal[Name[i] + "Mode"]);
                        LinearGradientMode Mode = LinearGradientMode.Horizontal;
                        if (mode >= 0 && mode < 4)
                        {
                            Mode = (LinearGradientMode)mode;
                        }
                        string start = sanal[Name[i] + "StartColor"];
                        Color StartColor = GetColorFromString(rgb, argb, start);
                        string end = sanal[Name[i] + "EndColor"];
                        Color EndColor = GetColorFromString(rgb, argb, end);
                        if (dpg[i] is TabGradient)
                        {
                            TabGradient tg = dpg[i] as TabGradient;
                            string text = sanal[Name[i] + "TextColor"];
                            Color TextColor = GetColorFromString(rgb, argb, text);
                            tg.TextColor = TextColor;
                            tg.StartColor = StartColor;
                            tg.EndColor = EndColor;
                            tg.LinearGradientMode = Mode;
                        }
                        else
                        {
                            dpg[i].StartColor = StartColor;
                            dpg[i].EndColor = EndColor;
                            dpg[i].LinearGradientMode = Mode;
                        }
                    }
                    Skin = skin;
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
        }
        private Color GetColorFromString(Regex rgb, Regex argb, string data)
        {
            Color ret = SystemColors.Control;
            Match m = argb.Match(data);
            if (!m.Success)
            {
                m = rgb.Match(data);
            }
            if (m.Success)
            {
                if (m.Groups.Count == 4)
                {
                    ret = Color.FromArgb(int.Parse(m.Groups[1].Captures[0].Value), int.Parse(m.Groups[2].Captures[0].Value), int.Parse(m.Groups[3].Captures[0].Value));
                }
                else if (m.Groups.Count == 5)
                {
                    ret = Color.FromArgb(int.Parse(m.Groups[1].Captures[0].Value), int.Parse(m.Groups[2].Captures[0].Value), int.Parse(m.Groups[3].Captures[0].Value), int.Parse(m.Groups[4].Captures[0].Value));
                }
            }
            return ret;
        }
        private DockPanelGradient CreateDockPanelGradient(int sred, int sgreen, int sblue, int ered, int egreen, int eblue, LinearGradientMode gramode)
        {
            DockPanelGradient gra = new DockPanelGradient();
            gra.StartColor = Color.FromArgb(sred, sgreen, sblue);
            gra.EndColor = Color.FromArgb(ered, egreen, eblue);
            gra.LinearGradientMode = gramode;
            return gra;
        }
        private TabGradient CreateTabGradient(int sred, int sgreen, int sblue, int ered, int egreen, int eblue, LinearGradientMode gramode)
        {
            TabGradient tabgra = new TabGradient();
            tabgra.StartColor = Color.FromArgb(sred, sgreen, sblue);
            tabgra.EndColor = Color.FromArgb(ered, egreen, eblue);
            tabgra.LinearGradientMode = gramode;
            return tabgra;
        }
        public Bitmap BackGround
        {
            get;
            set;
        }
        public Color OverLayColor
        {
            get;
            set;
        }
        public Color FillColor
        {
            get;
            set;
        }
        public Color BorderColor
        {
            get;
            set;
        }
        public BackGroundDisplayMode DisplayMode
        {
            get;
            set;
        }
        public DockPanelSkin Skin
        {
            get;
            set;
        }
        public Color TransparentTextColor
        {
            get;
            set;
        }
    }
}
