﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Linq;

namespace NotepadNeue
{
    class ExtensionSettingManager
    {
        const string FileName = "ExtensionSetting.xml";

        Dictionary<string, ExtensionSetting> settings;

        public ExtensionSettingManager()
        {
            settings = new Dictionary<string, ExtensionSetting>();
            Initialize();
        }

        private string GetSettingFileName()
        {
            return Path.Combine(Program.AppDir, FileName);
        }

        private void Initialize()
        {
            try
            {
                string fileName = GetSettingFileName();
                if (!File.Exists(fileName))
                {
                    return;
                }

                XDocument document = XDocument.Load(fileName);
                var query = from p in document.Root.Elements("ExtensionSetting")
                            select new
                            {
                                Name = p.Element("Name").Value,
                                Element = p,
                            };
                foreach (var elem in query)
                {
                    ExtensionSetting setting = new ExtensionSetting(elem.Name);
                    settings.Add(elem.Name, setting);
                    var childQuery = from p in elem.Element.Elements("Setting")
                                     select new
                                     {
                                         Key = p.Element("Key").Value,
                                         Value = p.Element("Value").Value,
                                     };
                    foreach (var childElem in childQuery)
                    {
                        setting[childElem.Key] = childElem.Value;
                    }
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
#if DEBUG
                MessageBox.Show(e.StackTrace);
#endif
            }
        }

        public void SetSetting(string extensionName, string key, string value)
        {
            ExtensionSetting setting;
            if (!settings.TryGetValue(extensionName, out setting))
            {
                setting = new ExtensionSetting(extensionName);
                settings.Add(extensionName, setting);
            }
            setting[key] = value;
        }

        public string GetSetting(string extensionName, string key)
        {
            ExtensionSetting setting;
            if (settings.TryGetValue(extensionName, out setting))
            {
                return setting[key];
            }
            return null;
        }

        public void Save()
        {
            try
            {
                XDocument document = new XDocument(new XElement("Root"));
                foreach (KeyValuePair<string, ExtensionSetting> kvp in settings)
                {
                    var elem = new XElement("ExtensionSetting", new XElement("Name", kvp.Key));
                    document.Root.Add(elem);
                    foreach (KeyValuePair<string, string> pair in kvp.Value.All)
                    {
                        var childElem = new XElement("Setting", new XElement("Key", pair.Key),
                            new XElement("Value", pair.Value));
                        elem.Add(childElem);
                    }
                }
                document.Save(GetSettingFileName());
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
#if DEBUG
                MessageBox.Show(e.StackTrace);
#endif
            }
        }
    }
}
