﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace NotepadNeue
{
    public partial class Form5 : Form
    {
        private string[] iniarray;
        SortedList<string, Compiledata> pool = new SortedList<string, Compiledata>();
        Compiledata Currentdata;
        public Form5(string[] iniarray)
        {
            this.iniarray = iniarray;
            InitializeComponent();
            addlist();
            this.openFileDialog1.FileName = "";
        }
        public void addlist()
        {
            this.listBox1.BeginUpdate();
            foreach (string s in iniarray)
            {
                this.listBox1.Items.Add("." + s.Substring(s.LastIndexOf('_') + 1, s.LastIndexOf('.') - s.LastIndexOf('_') - 1));
            }
            this.listBox1.EndUpdate();
        }
        public string CurrentIni
        {
            set
            {
                for (int i = 0; i < iniarray.Length; i++)
                {
                    if (Path.GetFileName(iniarray[i]) == value)
                    {
                        this.listBox1.SelectedIndex = i;
                        break;
                    }
                }
            }
        }
        public bool ChangeDefault
        {
            get
            {
                return checkBox1.Checked;
            }
        }
        public int ChangeIndex
        {
            get
            {
                return listBox1.SelectedIndex;
            }
        }
        private void button3_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.Filter = "batファイル(*.bat)|*.bat";

            if (this.openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                this.textBox1.Text = this.openFileDialog1.FileName;
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.Filter = "exeファイル(*.exe)|*.exe";
            if (this.openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                this.textBox2.Text = this.openFileDialog1.FileName;
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.Filter = "exeファイル(*.exe)|*.exe";
            if (this.openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                this.textBox4.Text = this.openFileDialog1.FileName;
            }
        }

        private void change(object sender, EventArgs e)
        {
            try
            {
                if (Currentdata != null)
                {
                    Currentdata.BatBeforeCompile = this.textBox1.Text;
                    Currentdata.Compiler = this.textBox2.Text;
                    Currentdata.CompilerOption = this.textBox3.Text;
                    Currentdata.Program = this.textBox4.Text;
                    Currentdata.ProgramOption = this.textBox6.Text;
                    Currentdata.Filename = this.textBox5.Text;
                    Currentdata.Extra = this.textBox7.Text;
                    Currentdata.CharaCode = this.comboBox1.SelectedIndex.ToString();
                }
                int a = this.listBox1.SelectedIndex;
                string path = iniarray[a];
                Compiledata cdata = null;
                if (!pool.ContainsKey(path))
                {
                    StreamReader sr = new StreamReader(path);
                    string s = sr.ReadToEnd();
                    sr.Close();
                    cdata = new Compiledata();
                    SettingAnalyzer sanal = new SettingAnalyzer(s);
                    cdata.BatBeforeCompile = sanal["batbeforecompile"];
                    cdata.Compiler = sanal["compiler"];
                    cdata.CompilerOption = sanal["option"];
                    cdata.Extra = sanal["extra"];
                    cdata.Program = sanal["program"];
                    cdata.ProgramOption = sanal["programoption"];
                    cdata.Filename = sanal["filename"];
                    cdata.CharaCode = sanal["characode"];
                    pool.Add(path, cdata);
                }
                else
                {
                    pool.TryGetValue(path, out cdata);
                }
                this.textBox1.Text = cdata.BatBeforeCompile;
                this.textBox2.Text = cdata.Compiler;
                this.textBox3.Text = cdata.CompilerOption;
                this.textBox4.Text = cdata.Program;
                this.textBox6.Text = cdata.ProgramOption;
                this.textBox5.Text = cdata.Filename;
                this.textBox7.Text = cdata.Extra;
                this.comboBox1.SelectedIndex = int.Parse(cdata.CharaCode);
                Currentdata = cdata;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            try
            {
                if (Currentdata != null)
                {
                    Currentdata.BatBeforeCompile = this.textBox1.Text;
                    Currentdata.Compiler = this.textBox2.Text;
                    Currentdata.CompilerOption = this.textBox3.Text;
                    Currentdata.Program = this.textBox4.Text;
                    Currentdata.ProgramOption = this.textBox6.Text;
                    Currentdata.Filename = this.textBox5.Text;
                    Currentdata.Extra = this.textBox7.Text;
                    Currentdata.CharaCode = this.comboBox1.SelectedIndex.ToString();
                }
                foreach (KeyValuePair<string, Compiledata> data in pool)
                {
                    string filename = data.Key;
                    Compiledata cdata = data.Value;
                    SettingAnalyzer analyzer = new SettingAnalyzer(File.ReadAllText(filename));
                    analyzer.ReplaceOrAdd("batbeforecompile", cdata.BatBeforeCompile);
                    analyzer.ReplaceOrAdd("compiler", cdata.Compiler);
                    analyzer.ReplaceOrAdd("option", cdata.CompilerOption);
                    analyzer.ReplaceOrAdd("program", cdata.Program);
                    analyzer.ReplaceOrAdd("programoption", cdata.ProgramOption);
                    analyzer.ReplaceOrAdd("filename", cdata.Filename);
                    analyzer.ReplaceOrAdd("extra", cdata.Extra);
                    analyzer.ReplaceOrAdd("characode", cdata.CharaCode);
                    try
                    {
                        StreamWriter sw = new StreamWriter(filename);
                        sw.Write(analyzer.ToString());
                        sw.Close();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
        internal class Compiledata
        {
            public Compiledata()
            {
            }
            public string BatBeforeCompile
            {
                get;
                set;
            }
            public string Compiler
            {
                get;
                set;
            }
            public string CompilerOption
            {
                get;
                set;
            }
            public string Program
            {
                get;
                set;
            }
            public string ProgramOption
            {
                get;
                set;
            }
            public string Filename
            {
                get;
                set;
            }
            public string Extra
            {
                get;
                set;
            }
            public string CharaCode
            {
                get;
                set;
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            MessageBox.Show(@"
#sysdir#   NotepadNeueのフォルダパス
#filepath# 現在編集しているファイルの拡張子なしのパス
#file#     現在編集しているファイルの拡張子なしのパス
#dir#      現在編集しているファイルのフォルダパス
#filename# 現在編集しているファイルのファイル名
");
        }
    }
}
