﻿using System.Windows.Forms;
using System.IO;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;
using IronPython.Hosting;
using Microsoft.Scripting.Hosting;
using NotepadNeueExtension;


using WeifenLuo.WinFormsUI.Docking;
using System.Text.RegularExpressions;
using Sgry.Azuki;

namespace NotepadNeue
{
    public partial class MainForm : Form, NotepadNeueExtension.IExtensionHost
    {
        const string title = " - NotepadNeue";
        const string editorobjectname = "azuki";
        const string defaultplugin = "plugin\\default\\default.py";
        const string st1 = "現在のドキュメントを保存しますか？";
        const string st2 = "現在のドキュメントを保存しますか？";
        const string st3 = "セーブしました...";


        string currentDirectory;
        string currentIni;
        string[] wordFile;
        string[] shortcutData;

        Encoding currentEncoding = Encoding.UTF8;

        CustomToolStrip customToolStrip;
        CustomToolStrip currentCustomToolStrip;
        Shortcutmanager shortcutManager;
        CustomShortcut lastCustomShortcut;
        NotepadUtility notepadUtility = new NotepadUtility();
        SortedList<string, ExtensionInfomation> ExtensionInfomationManager;

        bool[] ifReleasedKey = new bool[] { true, true };

        ExtensionInfomation defaultExInfo;

        bool ErrorFinishing = true;

        ArrayList DockWindows = new ArrayList();
        List<CExtension> Extensions = new List<CExtension>();

        WatchPattern currentWatchPattern;

        public bool IsShouldIgnoreKey
        {
            get;
            set;
        }
        public int DocumentCount
        {
            get
            {
                int count = 0;
                foreach (IDockContent dc in dockPanel1.Documents)
                {
                    if (dc is TextEditWindow) count++;
                }
                return count;
            }
        }
        public ExAzukiControl CurrentDocument
        {
            get
            {
                /*if (this.dockPanel1.ActiveDocument != null)
                {
                    TextEditWindow tew = this.dockPanel1.ActiveDocument as TextEditWindow;
                    if (tew != null)
                    {
                        return tew.ExAzukiControl;
                    }
                }*/
                if (ActiveDocumentPane != null)
                {
                    TextEditWindow tew = ActiveDocumentPane.ActiveContent as TextEditWindow;
                    if (tew != null)
                    {
                        return tew.ExAzukiControl;
                    }
                }
                return null;
            }
        }
        public TextEditWindow CurrentWindow
        {
            get
            {
                if (ActiveDocumentPane != null)
                {
                    TextEditWindow tew = ActiveDocumentPane.ActiveContent as TextEditWindow;
                    if (tew != null)
                    {
                        return tew;
                    }
                }
                return null;
            }
        }
        public NotepadUtility Utility
        {
            get
            {
                return notepadUtility;
            }
        }
        public string StatusLabel1
        {
            get
            {
                return this.toolStripStatusLabel1.Text;
            }
            set
            {
                this.toolStripStatusLabel1.Text = value;
            }
        }
        public string StatusLabel2
        {
            get
            {
                return this.toolStripStatusLabel2.Text;
            }
            set
            {
                this.toolStripStatusLabel2.Text = value;
            }
        }
        public string StatusLabel3
        {
            get
            {
                return this.toolStripStatusLabel3.Text;
            }
            set
            {
                this.toolStripStatusLabel3.Text = value;
            }
        }
        private DialogResult AskSave()
        {
            DialogResult dr = MessageBox.Show(st1, st2, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question);
            return dr;
        }
        public void OpenLastTabs(string lastTabs)
        {
            if (CurrentWindow != null)
            {
                CurrentWindow.Close();
            }
            string[] fns = lastTabs.Split('\n');
            for (int i = fns.Length - 1; i >= 0; i--)
            {
                if (File.Exists(fns[i]))
                {
                    OpenFileToNewDocument(fns[i]);
                }
            }
            if (CurrentDocument == null)
            {
                //no document
                TextEditWindow tew = new TextEditWindow();
                tew.Filename = "new.txt";
                tew.Initialize(this, myToolTip1, myDataGridView1, notepadUtility, defaultExInfo);
                tew.Show(dockPanel1, DockState.Document);
            }
        }
        public DialogResult Save(TextEditWindow Tew)
        {
            string extension = "." + Tew.ExAzukiControl.ExtensionInfo.Extension;
            if (extension == "")
            {
                this.saveFileDialog1.FileName = "new.txt";
                this.saveFileDialog1.Filter = "テキストファイル(*.text;*.txt)|*.text;*.txt|すべてのファイル(*.*)|*.*";
            }
            else
            {
                this.saveFileDialog1.FileName = "new" + extension;
                string temp = extension.Substring(1).ToUpper() + "ファイル" + "(*" + extension + ")|*" + extension;
                this.saveFileDialog1.Filter = temp + "|" + "テキストファイル(*.text;*.txt)|*.text;*.txt|すべてのファイル(*.*)|*.*";
            }
            if (this.saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                Encoding enc = Tew.ExAzukiControl.ExtensionInfo.Encoding;
                if (notepadUtility.AskWhenNewlySave)
                {
                    Form2 fm = new Form2();
                    if (fm.ShowDialog() == DialogResult.OK)
                    {
                        enc = fm.Encoding;
                    }
                    else
                    {
                        return DialogResult.Cancel;
                    }
                }
                Stream st;
                st = this.saveFileDialog1.OpenFile();
                if (st != null)
                {
                    try
                    {
                        StreamWriter sw = new StreamWriter(st, enc);
                        sw.Write(Tew.ExAzukiControl.Text);
                        sw.Close();
                        st.Close();
                        Tew.Filename = saveFileDialog1.FileName;
                        Tew.Save();
                        this.toolStripStatusLabel2.Text = st3;
                        this.toolStripStatusLabel3.Text = Tew.Filename;
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                    }
                    return DialogResult.OK;
                }
                else
                {
                    return DialogResult.Cancel;
                }
            }
            else
            {
                return DialogResult.Cancel;
            }
        }
        public DockContent ChangeToNextDocument()
        {
            DockPane dp = ActiveDocumentPane;
            if (dp == null) return null;
            DockContent target = (DockContent)dp.ActiveContent;
            DockContent next = null;
            bool isnext = false;
            foreach (DockContent dc in dp.Contents)
            {
                if (isnext)
                {
                    next = dc;
                    break;
                }
                if (dc == target)
                {
                    isnext = true;
                }
            }
            if (next == null)
            {
                DockPane nextpane = GetNextPane(dp);
                nextpane.Focus();
                nextpane.ActiveContent = nextpane.Contents[0];
                next = (DockContent)nextpane.Contents[0];
            }
            else
            {
                dp.ActiveContent = next;
            }
            if (CurrentDocument != null) CurrentDocument.Focus();
            return next;
        }
        public DockContent ChangeToPreviousDocument()
        {
            DockPane dp = ActiveDocumentPane;
            if (dp == null) return null;
            DockContent target = (DockContent)dp.ActiveContent;
            DockContent previous = null;
            bool found = false;
            foreach (DockContent dc in dp.Contents)
            {
                if (dc == target)
                {
                    found = true;
                    break;
                }
                previous = dc;
            }
            if (!found || previous == null)
            {
                DockPane previouspane = GetPreviousPane(dp);
                previouspane.Focus();
                previouspane.ActiveContent = previouspane.Contents[previouspane.Contents.Count - 1];
                previous = (DockContent)previouspane.Contents[previouspane.Contents.Count - 1];
            }
            else
            {
                dp.ActiveContent = previous;
            }
            if (CurrentDocument != null) CurrentDocument.Focus();
            return previous;
        }
        private DockPane ActiveDocumentPane
        {
            get
            {
                DockWindow docdw = null;
                foreach (DockWindow dw in dockPanel1.DockWindows)
                {
                    if (dw.DockState == DockState.Document)
                    {
                        docdw = dw;
                        break;
                    }
                }
                if (docdw == null) return null;
                DockPane ret = docdw.NestedPanes.Count > 0 ? docdw.NestedPanes[0] : null;
                foreach (DockPane dp in docdw.NestedPanes)
                {
                    if (dp.IsActiveDocumentPane)
                    {
                        ret = dp;
                        break;
                    }
                }
                return ret;
            }
        }
        private DockPane GetNextPane(DockPane dockpane)
        {
            DockWindow docdw = null;
            foreach (DockWindow dw in dockPanel1.DockWindows)
            {
                if (dw.DockState == DockState.Document)
                {
                    docdw = dw;
                    break;
                }
            }
            if (docdw == null) return null;
            if (docdw.NestedPanes.Count < 2) return dockpane;
            int index = docdw.NestedPanes.IndexOf(dockpane);
            if (index == -1) return dockpane;
            if (index < docdw.NestedPanes.Count - 1)
            {
                return docdw.NestedPanes[index + 1];
            }
            else
            {
                return docdw.NestedPanes[0];
            }
        }
        private DockPane GetPreviousPane(DockPane dockpane)
        {
            DockWindow docdw = null;
            foreach (DockWindow dw in dockPanel1.DockWindows)
            {
                if (dw.DockState == DockState.Document)
                {
                    docdw = dw;
                    break;
                }
            }
            if (docdw == null) return null;
            if (docdw.NestedPanes.Count < 2) return dockpane;
            int index = docdw.NestedPanes.IndexOf(dockpane);
            if (index == -1) return dockpane;
            if (index == 0)
            {
                return docdw.NestedPanes[docdw.NestedPanes.Count - 1];
            }
            else
            {
                return docdw.NestedPanes[index - 1];
            }
        }


        private void ChangeBackground()
        {
            if (skin.BackGround == null || this.ClientSize.Width == 0 || this.ClientSize.Height == 0) return;
            try
            {
                this.dockPanel1.BackColor = skin.BorderColor;
                ToolStripPanel top = this.toolStripContainer1.TopToolStripPanel;
                ToolStripContentPanel center = this.toolStripContainer1.ContentPanel;
                ToolStripPanel bottom = this.toolStripContainer1.BottomToolStripPanel;
                Bitmap original = skin.BackGround;
                Bitmap target = new Bitmap(this.ClientSize.Width, this.ClientSize.Height);
                float ratio = (float)target.Height / original.Height;
                Graphics g = Graphics.FromImage(target);
                SolidBrush sb = new SolidBrush(skin.FillColor);
                g.FillRectangle(sb, new Rectangle(0, 0, target.Size.Width, target.Size.Height));
                sb.Dispose();
                sb = new SolidBrush(skin.OverLayColor);
                switch (skin.DisplayMode)
                {
                    case NotepadNeueExtension.BackGroundDisplayMode.right:
                        g.DrawImage(original, new Rectangle(target.Width - (int)(original.Width * ratio), 0, (int)(original.Width * ratio), target.Height), new Rectangle(0, 0, original.Width, original.Height), GraphicsUnit.Pixel);
                        break;
                    case NotepadNeueExtension.BackGroundDisplayMode.left:
                        g.DrawImage(original, new Rectangle(0, 0, (int)(original.Width * ratio), target.Height), new Rectangle(0, 0, original.Width, original.Height), GraphicsUnit.Pixel);
                        break;
                    case NotepadNeueExtension.BackGroundDisplayMode.center:
                        if (target.Width > (int)(original.Width * ratio))
                        {
                            g.DrawImage(original, new Rectangle((target.Width - (int)(original.Width * ratio)) / 2, 0, (int)(original.Width * ratio), target.Height), new Rectangle(0, 0, original.Width, original.Height), GraphicsUnit.Pixel);
                        }
                        else
                        {
                            g.DrawImage(original, new Rectangle(0, 0, target.Width, target.Height), new Rectangle((original.Width - (int)(target.Width / ratio)) / 2, 0, (int)(target.Width / ratio), original.Height), GraphicsUnit.Pixel);
                        }
                        break;
                    case NotepadNeueExtension.BackGroundDisplayMode.fill:
                        g.DrawImage(original, new Rectangle(0, 0, target.Width, target.Height), new Rectangle(0, 0, original.Width, original.Height), GraphicsUnit.Pixel);
                        break;
                }
                Bitmap topbit = new Bitmap(top.Width, top.Height);
                g = Graphics.FromImage(topbit);
                g.DrawImage(target, new Rectangle(topbit.Width - target.Width, 0, target.Width, topbit.Height), new Rectangle(0, 0, target.Width, topbit.Height), GraphicsUnit.Pixel);
                g.FillRectangle(sb, new Rectangle(0, 0, topbit.Width, topbit.Height));
                top.BackgroundImage = topbit;
                Bitmap centbit = new Bitmap(center.Width, center.Height);
                g = Graphics.FromImage(centbit);
                g.DrawImage(target, new Rectangle(centbit.Width - target.Width, 0, target.Width, centbit.Height), new Rectangle(0, topbit.Height, target.Width, centbit.Height), GraphicsUnit.Pixel);
                center.BackgroundImage = centbit;
                dockPanel1.BackgroundImage = centbit;
                Bitmap bottombit = new Bitmap(bottom.Width, bottom.Height);
                g = Graphics.FromImage(bottombit);
                g.DrawImage(target, new Rectangle(bottombit.Width - target.Width, 0, target.Width, bottombit.Height), new Rectangle(0, topbit.Height + centbit.Height, target.Width, bottombit.Height), GraphicsUnit.Pixel);
                g.FillRectangle(sb, new Rectangle(0, 0, bottombit.Width, bottombit.Height));
                bottom.BackgroundImage = bottombit;
                statusStrip1.BackgroundImage = bottombit;
                sb.Dispose();
            }
            catch { }
        }
        private void ReadPlugin(string path)
        {
            ScriptScope scope = null;
            try
            {
                if (!notepadUtility.AllowScriptUse) return;
                RunPython(path);
            }
            catch (Exception e)
            {
                StringBuilder sb = new StringBuilder();
                if (scope != null)
                {
                    foreach (System.Collections.Generic.KeyValuePair<string, object> data in scope.GetItems())
                    {
                        sb.Append(data.Key + "\n");
                    }
                }
                MessageBox.Show("スクリプトエラーです\n" + e.Message + "\n" + sb.ToString());
            }
        }

        private void RunPython(string path)
        {
            ScriptSource source = StaticObjects.PythonEngine.CreateScriptSourceFromFile(path);
            ScriptScope scope = StaticObjects.PythonEngine.CreateScope();
            //fm1.CurrentDocument.MakeInvalidChange();
            scope.SetVariable("usertoolstrip", customToolStrip);
            source.Execute(scope);
        }
        private bool CheckVisible(DockContent dc)
        {
            if (dc.Visible || (dc.DockState > DockState.Unknown && dc.DockState < DockState.Hidden))
            {
                return true;
            }
            return false;
        }
        public void ReadDir()
        {
            try
            {
                this.currentDirectory = Path.GetDirectoryName(Application.ExecutablePath) + "\\";
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }

        }
        public void ReadWord()
        {
            wordFile = Directory.GetFiles(currentDirectory + "ini", "reserved_" + "*.ini");
        }
        private ExtensionInfomation CheckAlreadyLoadedExtensionInfo(string filename)
        {
            ExtensionInfomation ret = defaultExInfo;
            string tempextension = Path.GetExtension(filename);
            if (tempextension.Length == 0) return defaultExInfo;
            string extension = (tempextension).Substring(1);
            if (!ExtensionInfomationManager.ContainsKey(extension))
            {
                if (File.Exists(currentDirectory + "ini\\" + "reserved_" + extension + ".ini"))
                {
                    ExtensionInfomation exinfo = new ExtensionInfomation(currentDirectory, this);
                    exinfo.Extension = extension;
                    exinfo.readini(currentDirectory + "ini\\" + "reserved_" + extension + ".ini");
                    ExtensionInfomationManager.Add(exinfo.Extension, exinfo);
                    ret = exinfo;
                }
            }
            else
            {
                ExtensionInfomationManager.TryGetValue(extension, out ret);
            }
            return ret;
        }
        public void ChangeSettingState()
        {
            if (CurrentDocument == null) return;
            string extension = "." + this.CurrentDocument.ExtensionInfo.Extension;
            if (extension == string.Empty) return;
            foreach (ToolStripItem tsi in this.toolStripDropDownButton9.DropDownItems)
            {
                ToolStripMenuItem tsmi = tsi as ToolStripMenuItem;
                if (tsmi != null)
                {
                    if (tsmi.Text == extension)
                    {
                        tsmi.Checked = true;
                    }
                    else
                    {
                        tsmi.Checked = false;
                    }
                }
            }

        }
        public TextEditWindow QueryWindowForFilename(string filename)
        {
            TextEditWindow ret = null;
            foreach (DockContent df in dockPanel1.Documents)
            {
                TextEditWindow tew = df as TextEditWindow;
                if (tew != null)
                {
                    if (FileUtil.IsSameFile(tew.Filename, filename))
                    {
                        ret = tew;
                        break;
                    }
                }
            }
            return ret;
        }
        public void ReadConfig()
        {
            string s = "";
            try
            {
                StreamReader sr = new StreamReader(currentDirectory + "config.ini");
                s = sr.ReadToEnd();
                sr.Close();
                SettingAnalyzer sanal = new SettingAnalyzer(s);
                currentIni = sanal["ini"];
                notepadUtility.InputAssist = sanal["functioninp"] == "1";
                notepadUtility.FunctionAssist = sanal["functionref"] == "1";
                notepadUtility.AutoFormat = sanal["autoformat"] == "1";
                notepadUtility.Fontname = sanal["fontname"];
                if (notepadUtility.Fontname == "") notepadUtility.Fontname = "ＭＳ Ｐゴシック";
                float fontsize = 0;
                float.TryParse(sanal["fontsize"], out fontsize);
                notepadUtility.Fontsize = fontsize;
                if (notepadUtility.Fontsize <= 0) notepadUtility.Fontsize = 10;
                int intervaltime = 0;
                int.TryParse(sanal["scrapinginterval"], out intervaltime);
                if (intervaltime <= 0)
                {
                    intervaltime = 500;
                }
                notepadUtility.UpdateInfomsec = intervaltime;
                int maxdisplaynum = 0;
                int.TryParse(sanal["assistdisplaymaxnum"], out maxdisplaynum);
                notepadUtility.DisplayAssistnum = maxdisplaynum;
                if (notepadUtility.DisplayAssistnum <= 0)
                {
                    notepadUtility.DisplayAssistnum = 6;
                }
                int tabwidth = 0;
                int.TryParse(sanal["tabwidth"], out tabwidth);
                notepadUtility.TabWidth = tabwidth;
                if (tabwidth <= 0 || tabwidth > 9) notepadUtility.TabWidth = 3;
                int backupnum = 0;
                int.TryParse(sanal["backupnum"], out backupnum);
                if (backupnum < 1) backupnum = 1;
                if (backupnum >= 10) backupnum = 9;
                notepadUtility.BackUpNum = backupnum;
                notepadUtility.DrawEol = sanal["draweol"] == "1";
                notepadUtility.DrawFullWidthSpace = sanal["drawfullwidthspace"] == "1";
                notepadUtility.DrawLineNumber = sanal["drawlinenumber"] == "1";
                notepadUtility.DrawSpace = sanal["drawspace"] == "1";
                notepadUtility.DrawTab = sanal["drawtab"] == "1";
                notepadUtility.HighlightCurrentline = sanal["highlightcurrentline"] == "1";
                notepadUtility.AdjustOpenEnclosure = sanal["adjustopenenclosure"] == "1";
                notepadUtility.AdjustCloseEnclosure = sanal["adjustcloseenclosure"] == "1";
                notepadUtility.AutoFormatInScope = sanal["autoformatinscope"] == "1";
                notepadUtility.AskSaveTabs = sanal["asksavetabs"] == "1";
                notepadUtility.SaveTabs = sanal["savetabs"] == "1";
                int colnum = 0;
                int.TryParse(sanal["forecolor"], out colnum);
                notepadUtility.Forecolor = Color.FromArgb(colnum);
                notepadUtility.Forecolor = Color.FromArgb(255, notepadUtility.Forecolor);
                int.TryParse(sanal["backcolor"], out colnum);
                notepadUtility.Backcolor = Color.FromArgb(colnum);
                notepadUtility.Backcolor = Color.FromArgb(255, notepadUtility.Backcolor);
                int.TryParse(sanal["correspondfore"], out colnum);
                notepadUtility.Correspondfore = Color.FromArgb(colnum);
                notepadUtility.Correspondfore = Color.FromArgb(255, notepadUtility.Correspondfore);
                int.TryParse(sanal["correspondback"], out colnum);
                notepadUtility.Correspondback = Color.FromArgb(colnum);
                notepadUtility.Correspondback = Color.FromArgb(255, notepadUtility.Correspondback);
                int.TryParse(sanal["linenumberfore"], out colnum);
                notepadUtility.Linenumberfore = Color.FromArgb(colnum);
                notepadUtility.Linenumberfore = Color.FromArgb(255, notepadUtility.Linenumberfore);
                int.TryParse(sanal["linenumberback"], out colnum);
                notepadUtility.Linenumberback = Color.FromArgb(colnum);
                notepadUtility.Linenumberback = Color.FromArgb(255, notepadUtility.Linenumberback);
                int.TryParse(sanal["selectionfore"], out colnum);
                notepadUtility.Selectionfore = Color.FromArgb(colnum);
                notepadUtility.Selectionfore = Color.FromArgb(255, notepadUtility.Selectionfore);
                int.TryParse(sanal["selectionback"], out colnum);
                notepadUtility.Selectionback = Color.FromArgb(colnum);
                notepadUtility.Selectionback = Color.FromArgb(255, notepadUtility.Selectionback);
                int.TryParse(sanal["eolcolor"], out colnum);
                notepadUtility.Eolcolor = Color.FromArgb(colnum);
                notepadUtility.Eolcolor = Color.FromArgb(255, notepadUtility.Eolcolor);
                int.TryParse(sanal["highlightcolor"], out colnum);
                notepadUtility.Highlightcolor = Color.FromArgb(colnum);
                notepadUtility.Highlightcolor = Color.FromArgb(255, notepadUtility.Highlightcolor);
                int.TryParse(sanal["whitespacecolor"], out colnum);
                notepadUtility.Whitespacecolor = Color.FromArgb(colnum);
                notepadUtility.Whitespacecolor = Color.FromArgb(255, notepadUtility.Whitespacecolor);



                int.TryParse(sanal["eofcolor"], out colnum);
                notepadUtility.EofColor = Color.FromArgb(colnum);
                notepadUtility.EofColor = Color.FromArgb(255, notepadUtility.EofColor);

                int.TryParse(sanal["cleanedlinebar"], out colnum);
                notepadUtility.CleanedLineBar = Color.FromArgb(colnum);
                notepadUtility.CleanedLineBar = Color.FromArgb(255, notepadUtility.CleanedLineBar);

                int.TryParse(sanal["dirtylinebar"], out colnum);
                notepadUtility.DirtyLineBar = Color.FromArgb(colnum);
                notepadUtility.DirtyLineBar = Color.FromArgb(255, notepadUtility.DirtyLineBar);


                if (sanal["maximized"] == "1")
                {
                    this.WindowState = FormWindowState.Maximized;
                }
                else if (sanal["minimized"] != "1")
                {
                    string size = sanal["size"];
                    string location = sanal["location"];
                    string[] splitsize = size.Split(',');
                    this.Width = int.Parse(splitsize[0]);
                    this.Height = int.Parse(splitsize[1]);
                    string[] splitlocation = location.Split(',');
                    this.Location = new Point(int.Parse(splitlocation[0]), int.Parse(splitlocation[1]));
                }
                this.入力補助ToolStripMenuItem.Checked = notepadUtility.InputAssist;
                this.参照補助ToolStripMenuItem.Checked = notepadUtility.FunctionAssist;
                this.オートフォーマットToolStripMenuItem.Checked = notepadUtility.AutoFormat;
                notepadUtility.AskWhenNewlySave = sanal["askwhennewlysave"] == "1";
                notepadUtility.NotExecuteProgramWhenError = sanal["notexecuteprogramwhenerror"] == "1";
                notepadUtility.NotExecuteProgramWhenWarning = sanal["notexecuteprogramwhenwarning"] == "1";
                notepadUtility.DrawEofMark = sanal["draweofmark"] == "1";
                notepadUtility.ShowDirtBar = sanal["showdirtbar"] == "1";
                notepadUtility.ShowHRuler = sanal["showhruler"] == "1";
                notepadUtility.UseTabForIndent = sanal["usetabforindent"] == "1";
                notepadUtility.DetectNewLineString = sanal["detectnewlinestring"] == "1";
                notepadUtility.TellMixedNewLine = sanal["tellmixedlinestring"] == "1";
                notepadUtility.DefaultNewLineString = sanal["defaultnewlinestring"].Replace("\\n", "\n").Replace("\\r", "\r");
                notepadUtility.DefaultNewLineString = notepadUtility.DefaultNewLineString == "" ? "\r\n" : notepadUtility.DefaultNewLineString;

                switch (sanal["textquality"])
                {
                    case "0":
                        notepadUtility.Antialias = Sgry.Azuki.Antialias.Default;
                        myToolTip1.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SystemDefault;
                        break;
                    case "1":
                        notepadUtility.Antialias = Sgry.Azuki.Antialias.None;
                        myToolTip1.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit;
                        break;
                    case "2":
                        notepadUtility.Antialias = Sgry.Azuki.Antialias.Gray;
                        myToolTip1.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit;
                        break;
                    case "3":
                        notepadUtility.Antialias = Sgry.Azuki.Antialias.Subpixel;
                        myToolTip1.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;
                        break;
                    default:
                        notepadUtility.Antialias = Sgry.Azuki.Antialias.Default;
                        myToolTip1.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SystemDefault;
                        break;
                }
                Sgry.Azuki.UserPref.Antialias = notepadUtility.Antialias;
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
        }
        public string GetExtensionFromIni(string ini)
        {
            string ret = "";
            System.Text.RegularExpressions.Match m = System.Text.RegularExpressions.Regex.Match(ini, "reserved_(\\w+).ini");
            if (m.Groups.Count > 1)
            {
                ret = m.Groups[1].Captures[0].Value;
            }
            return ret;
        }
        public void ReadSettingType()
        {
            for (int i = 0; i < wordFile.Length; i++)
            {
                System.Text.RegularExpressions.Match m = System.Text.RegularExpressions.Regex.Match(wordFile[i], "reserved_(\\w+).ini");
                if (m.Groups.Count > 1)
                {
                    ToolStripMenuItem tsmi = new ToolStripMenuItem("." + m.Groups[1].Captures[0].Value);
                    this.toolStripDropDownButton9.DropDownItems.Add(tsmi);
                    tsmi.Click += new EventHandler(tsmi_Click);
                }

            }
        }
        void tsmi_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            ToolStripMenuItem tsmi = sender as ToolStripMenuItem;
            if (tsmi != null)
            {
                string extension = tsmi.Text.Substring(1);
                if (CurrentDocument.ExtensionInfo.Extension != extension)
                {
                    this.CurrentDocument.ExtensionInfo = CheckAlreadyLoadedExtensionInfo("sample" + tsmi.Text);
                    ChangeSettingState();
                    ChangeCustomToolStrip();
                }
            }
        }
        private void ChangeCustomToolStrip()
        {
            if (this.CurrentDocument != null)
            {
                this.toolStripContainer1.TopToolStripPanel.Controls.Remove(currentCustomToolStrip);
                currentCustomToolStrip = CurrentDocument.ExtensionInfo.CustomToolStrip;
                Control lastcontrolintop = customToolStrip;
                currentCustomToolStrip.Location = new Point(lastcontrolintop.Location.X + lastcontrolintop.Width + 1, lastcontrolintop.Location.Y + 1);
                this.toolStripContainer1.TopToolStripPanel.Controls.Add(currentCustomToolStrip);
            }
        }
        public void ReadKeyBind()
        {
            string s = "";
            try
            {
                StreamReader sr = new StreamReader(currentDirectory + "keybind.ini");
                s = sr.ReadToEnd();
                sr.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                return;
            }
            SettingAnalyzer sanal = new SettingAnalyzer(s);
            string[] temp = GetToolBarName();
            ArrayList tempstackdata = new ArrayList(100);
            int iter = 0;
            foreach (ToolStripDropDownItem tsi in this.menuStrip1.Items)
            {
                bool paneloperation = tsi.Name == "表示ToolStripMenuItem";
                foreach (ToolStripMenuItem tsmi in tsi.DropDownItems)
                {
                    if (tsmi.DropDownItems.Count == 0)
                    {
                        ArrayList eventData = new ArrayList();
                        EventDescriptorCollection events = TypeDescriptor.GetEvents(tsmi);
                        EventDatum ed = null;
                        foreach (System.ComponentModel.EventDescriptor myEvent in events)
                        {
                            ed = EventDatum.Create(tsmi, myEvent);
                            if (ed == null) continue;
                            break;
                        }
                        if (ed != null)
                        {
                            string ss = sanal[temp[iter]];
                            if (ss == "")
                            {
                                ss = "Control, None, None";
                            }
                            tempstackdata.Add(ss);
                            //Customshortcut cs = sm.addshortcut(shortcutdata[iter], ed.Event);
                            CustomShortcut cs = shortcutManager.AddShortcut(ss, ed.Event);
                            if (cs != null)
                            {
                                tsmi.ShortcutKeyDisplayString = cs.displaystring();
                                cs.IsPanelOperation = paneloperation;
                                cs.ToolStripMenuItem = tsmi;
                            }
                            iter++;
                        }
                    }
                    else
                    {
                        foreach (ToolStripMenuItem ttsmi in tsmi.DropDownItems)
                        {
                            ArrayList eventData = new ArrayList();
                            EventDescriptorCollection events = TypeDescriptor.GetEvents(ttsmi);
                            EventDatum ed = null;
                            foreach (System.ComponentModel.EventDescriptor myEvent in events)
                            {
                                ed = EventDatum.Create(ttsmi, myEvent);
                                if (ed == null) continue;
                                break;
                            }
                            if (ed != null)
                            {
                                string ss = sanal[temp[iter]];
                                if (ss == "")
                                {
                                    tempstackdata.Add("Control, None, None");
                                }
                                else
                                {
                                    tempstackdata.Add(ss);
                                }
                                //Customshortcut cs = sm.addshortcut(shortcutdata[iter], ed.Event);
                                CustomShortcut cs = shortcutManager.AddShortcut(ss, ed.Event);
                                if (cs != null)
                                {
                                    ttsmi.ShortcutKeyDisplayString = cs.displaystring();
                                    cs.IsPanelOperation = paneloperation;
                                    cs.ToolStripMenuItem = ttsmi;
                                }
                                iter++;
                            }
                        }
                    }
                }
            }
            shortcutData = new string[tempstackdata.Count];
            Array.Copy(tempstackdata.ToArray(), shortcutData, shortcutData.Length);
        }
        public bool IfContainsShiftAndControl(Keys keys)
        {
            if (keys == Keys.Control && keys == Keys.Shift)
            {
                return true;
            }
            return false;
        }
        public string[] GetToolBarName()
        {
            ArrayList data = new ArrayList(39);
            foreach (ToolStripDropDownItem tsi in this.menuStrip1.Items)
            {
                foreach (ToolStripMenuItem tsmi in tsi.DropDownItems)
                {
                    if (tsmi.DropDownItems.Count == 0)
                    {
                        data.Add(tsmi.Text + "(" + tsi.Text + ")");
                    }
                    else
                    {
                        foreach (ToolStripMenuItem ttsmi in tsmi.DropDownItems)
                        {
                            data.Add(ttsmi.Text + "(" + tsi.Text + "->" + tsmi.Text + ")");
                        }
                    }
                }
            }
            return data.ToArray(typeof(string)) as string[];
        }
        private void ReadExtension()
        {
            NotepadNeueExtensionInfo[] nneis = NotepadNeueExtensionInfo.FindExtensions(currentDirectory + "extension");
            foreach (NotepadNeueExtensionInfo nnei in nneis)
            {
                NotepadNeueExtension.CExtension cex = nnei.CreateInstance(this);
                if (cex == null)
                {
                    MessageBox.Show("エクステンション読み取りエラー  " + nnei.ClassName);
                    continue;
                }
                cex.TabText = cex.ExtensionName;
                cex.HideOnClose = true;
                cex.DockStateChanged += new EventHandler(windowvisiblechanged);
                cex.DockAreas = DockAreas.DockBottom | DockAreas.DockLeft | DockAreas.DockRight | DockAreas.DockTop | DockAreas.Float;
                Extensions.Add(cex);
            }

            foreach (CExtension cex in Extensions)
            {
                ToolStripMenuItem tsmi = new ToolStripMenuItem(cex.ExtensionName);
                tsmi.Click += new EventHandler(ExtensionMenuClicked);
                tsmi.Tag = cex;
                this.表示ToolStripMenuItem.DropDownItems.Add(tsmi);
            }
        }
        private bool CheckAlreadyOpenFile(string filename, out TextEditWindow outtew)
        {
            outtew = null;
            foreach (DockContent df in dockPanel1.Documents)
            {
                TextEditWindow tew = df as TextEditWindow;
                if (tew != null)
                {
                    if (tew.Filename == filename)
                    {
                        outtew = tew;
                        return true;
                    }
                }
            }
            return false;
        }
        public void RestoreWindow()
        {
            dockPanel1.SuspendLayout(true);
            if (File.Exists(currentDirectory + "dockinfo.xml"))
            {
                dockPanel1.LoadFromXml(currentDirectory + "dockinfo.xml", this.DeserializeForm);
            }
            else
            {
                errorWindow.Show(dockPanel1, DockState.DockBottom);
                lastErrorCodeWindow.Show(dockPanel1, DockState.DockBottom);
                errorWindow.Pane.ActiveContent = errorWindow;
            }
            dockPanel1.ResumeLayout(true, true);
        }
        private void ExtensionMenuClicked(object sender, EventArgs e)
        {
            ToolStripMenuItem tsmi = sender as ToolStripMenuItem;
            if (tsmi != null)
            {
                ShowOrHideWindow(tsmi.Tag as CExtension);
            }
        }
        private IDockContent DeserializeForm(string persistentString)
        {
            switch (persistentString)
            {
                case "NotepadNeue.ErrorWindow":
                    return errorWindow;
                case "NotepadNeue.LastErrorCodeWindow":
                    return lastErrorCodeWindow;
                case "NotepadNeue.ScrapedDataView":
                    return scrapedDataView;
            }
            foreach (CExtension cex in Extensions)
            {
                if (cex.ExtensionName == persistentString)
                    return cex;
            }
            return null;
        }
        public void SaveConfig()
        {
            try
            {
                StreamWriter sw = new StreamWriter(currentDirectory + "config.ini");
                StringBuilder sb = new StringBuilder();
                sb.Append("[ini]" + currentIni + System.Environment.NewLine);
                sb.Append("[functioninp]" + (notepadUtility.InputAssist ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[functionref]" + (notepadUtility.FunctionAssist ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[autoformat]" + (notepadUtility.AutoFormat ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[size]" + this.Width + "," + this.Height + System.Environment.NewLine);
                sb.Append("[location]" + this.Location.X + "," + this.Location.Y + System.Environment.NewLine);
                sb.Append("[maximized]" + (this.WindowState == FormWindowState.Maximized ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[minimized]" + (this.WindowState == FormWindowState.Minimized ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[fontname]" + notepadUtility.Fontname + System.Environment.NewLine);
                sb.Append("[fontsize]" + notepadUtility.Fontsize.ToString() + System.Environment.NewLine);
                sb.Append("[scrapinginterval]" + notepadUtility.UpdateInfomsec.ToString() + System.Environment.NewLine);
                sb.Append("[assistdisplaymaxnum]" + notepadUtility.DisplayAssistnum.ToString() + System.Environment.NewLine);
                sb.Append("[draweol]" + (notepadUtility.DrawEol ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[drawfullwidthspace]" + (notepadUtility.DrawFullWidthSpace ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[drawlinenumber]" + (notepadUtility.DrawLineNumber ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[drawspace]" + (notepadUtility.DrawSpace ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[drawtab]" + (notepadUtility.DrawTab ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[draweofmark]" + (notepadUtility.DrawEofMark ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[showdirtbar]" + (notepadUtility.ShowDirtBar ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[showhruler]" + (notepadUtility.ShowHRuler ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[highlightcurrentline]" + (notepadUtility.HighlightCurrentline ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[forecolor]" + (notepadUtility.Forecolor.ToArgb()) + System.Environment.NewLine);
                sb.Append("[backcolor]" + (notepadUtility.Backcolor.ToArgb()) + System.Environment.NewLine);
                sb.Append("[correspondfore]" + (notepadUtility.Correspondfore.ToArgb()) + System.Environment.NewLine);
                sb.Append("[correspondback]" + (notepadUtility.Correspondback.ToArgb()) + System.Environment.NewLine);
                sb.Append("[linenumberfore]" + (notepadUtility.Linenumberfore.ToArgb()) + System.Environment.NewLine);
                sb.Append("[linenumberback]" + (notepadUtility.Linenumberback.ToArgb()) + System.Environment.NewLine);
                sb.Append("[selectionfore]" + (notepadUtility.Selectionfore.ToArgb()) + System.Environment.NewLine);
                sb.Append("[selectionback]" + (notepadUtility.Selectionback.ToArgb()) + System.Environment.NewLine);
                sb.Append("[eolcolor]" + (notepadUtility.Eolcolor.ToArgb()) + System.Environment.NewLine);
                sb.Append("[eofcolor]" + (notepadUtility.EofColor.ToArgb()) + System.Environment.NewLine);
                sb.Append("[cleanedlinebar]" + (notepadUtility.CleanedLineBar.ToArgb()) + System.Environment.NewLine);
                sb.Append("[dirtylinebar]" + (notepadUtility.DirtyLineBar.ToArgb()) + System.Environment.NewLine);
                sb.Append("[highlightcolor]" + (notepadUtility.Highlightcolor.ToArgb()) + System.Environment.NewLine);
                sb.Append("[whitespacecolor]" + (notepadUtility.Whitespacecolor.ToArgb()) + System.Environment.NewLine);
                sb.Append("[askwhennewlysave]" + (notepadUtility.AskWhenNewlySave ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[notexecuteprogramwhenerror]" + (notepadUtility.NotExecuteProgramWhenError ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[notexecuteprogramwhenwarning]" + (notepadUtility.NotExecuteProgramWhenWarning ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[usetabforindent]" + (notepadUtility.UseTabForIndent ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[tabwidth]" + notepadUtility.TabWidth + System.Environment.NewLine);
                sb.Append("[textquality]" + (int)notepadUtility.Antialias + System.Environment.NewLine);
                sb.Append("[backupnum]" + notepadUtility.BackUpNum + System.Environment.NewLine);
                sb.Append("[autoformatinscope]" + (notepadUtility.AutoFormatInScope ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[adjustopenenclosure]" + (notepadUtility.AdjustOpenEnclosure ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[adjustcloseenclosure]" + (notepadUtility.AdjustCloseEnclosure ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[asksavetabs]" + (notepadUtility.AskSaveTabs ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[savetabs]" + (notepadUtility.SaveTabs ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[detectnewlinestring]" + (notepadUtility.DetectNewLineString ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[tellmixedlinestring]" + (notepadUtility.TellMixedNewLine ? "1" : "0") + System.Environment.NewLine);
                sb.Append("[defaultnewlinestring]" + notepadUtility.DefaultNewLineString.Replace("\n", "\\n").Replace("\r", "\\r"));
                string temp = sb.ToString();
                sw.Write(temp);
                sw.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public void SafeClose(TextEditWindow tew)
        {
            DockWindows.Remove(tew);
        }
        public void RescueData()
        {
            if (!Directory.Exists(currentDirectory + "RescuedData"))
            {
                Directory.CreateDirectory(currentDirectory + "RescuedData");
            }
            for (int i = DockWindows.Count - 1; i >= 0; i--)
            {
                TextEditWindow tew = DockWindows[i] as TextEditWindow;
                if (tew != null)
                {
                    string filename = currentDirectory + "RescuedData\\" + Path.GetFileName(tew.Filename);
                    try
                    {
                        StreamWriter sw = new StreamWriter(filename, false, tew.ExAzukiControl.ExtensionInfo.Encoding);
                        sw.Write(tew.ExAzukiControl.ForError);
                        sw.Close();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                    }
                }
            }
            MessageBox.Show("エラーが発生したので\n" + currentDirectory + "RescuedData\\" + "\nにデータを保存しました。");

        }
        public void OverSave()
        {
            if (CurrentDocument == null) return;
            if (this.CurrentWindow.Filename == "new.txt")
            {

                DialogResult dr = AskSave();
                if (dr == DialogResult.Yes)
                {
                    Save(CurrentWindow);
                }
            }
            else
            {
                try
                {
                    StreamWriter sw = new StreamWriter(this.CurrentWindow.Filename, false, this.CurrentDocument.ExtensionInfo.Encoding);
                    sw.Write(this.CurrentDocument.Text);
                    sw.Close();
                    this.toolStripStatusLabel2.Text = st3;
                    this.toolStripStatusLabel3.Text = this.CurrentWindow.Filename;
                    this.CurrentWindow.Save();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
        }
        public void CloseExceptThisWindow(DockContent dc)
        {
            DockContent[] temp = new DockContent[dockPanel1.DocumentsCount];
            int iter = 0;
            foreach (DockContent df in dockPanel1.Documents)
            {
                temp[iter] = df;
                iter++;
            }
            for (int i = temp.Length - 1; i >= 0; i--)
            {
                if (temp[i] == dc) continue;
                TextEditWindow tew = temp[i] as TextEditWindow;
                if (tew != null)
                {
                    tew.Pane.ActiveContent = tew;
                    temp[i].Close();
                    if (!tew.Saved)
                    {
                        break;
                    }
                }
                else
                {
                    temp[i].HideOnClose = false;
                    temp[i].Close();
                }
            }
        }
        private void SetTextToDocument(Sgry.Azuki.Document dc, string text)
        {
            if (text == null) return;
            List<int> crindex = new List<int>();
            List<int> lfindex = new List<int>();
            int index = 0;
            index = text.IndexOf("\r");
            while (index != -1)
            {
                crindex.Add(index);
                index = text.IndexOf("\r", index + 1);
            }
            index = text.IndexOf("\n");
            while (index != -1)
            {
                lfindex.Add(index);
                index = text.IndexOf("\n", index + 1);
            }
            if (crindex.Count == 0 && lfindex.Count == 0)
            {
                //default
                dc.EolCode = notepadUtility.DefaultNewLineString;
            }
            else if (crindex.Count == 0)
            {
                //some lf
                dc.EolCode = "\n";
            }
            else if (lfindex.Count == 0)
            {
                //some cr
                dc.EolCode = "\r";
            }
            else
            {
                //check cr+lf
                if (crindex.Count == lfindex.Count)
                {
                    bool ok = true;
                    for (int i = 0; i < crindex.Count; i++)
                    {
                        if (crindex[i] + 1 != lfindex[i])
                        {
                            ok = false;
                            break;
                        }
                    }
                    if (ok)
                    {
                        //cr+lf
                        dc.EolCode = "\r\n";
                        dc.Text = text;
                        return;
                    }
                }
                if (!notepadUtility.TellMixedNewLine) return;
                //mixed eol
                bool foundcrlf = false;
                for (int j = crindex.Count - 1; j >= 0 && crindex.Count > 0; j--)
                {
                    int findex = lfindex.BinarySearch(crindex[j] + 1);
                    if (findex >= 0)
                    {
                        foundcrlf = true;
                        crindex.RemoveAt(j);
                        lfindex.RemoveAt(findex);
                    }
                }
                //check rest
                Form9 fm9 = new Form9();
                fm9.SetUsed(crindex.Count != 0, lfindex.Count != 0, foundcrlf);
                if (fm9.ShowDialog() == DialogResult.OK)
                {
                    switch (fm9.Mode)
                    {
                        case Form9.ChangeEOLMode.nochange:
                            dc.EolCode = notepadUtility.DefaultNewLineString;
                            break;
                        case Form9.ChangeEOLMode.cr:
                            text = text.Replace("\r\n", "\r").Replace("\n", "\r");
                            dc.EolCode = "\r";
                            break;
                        case Form9.ChangeEOLMode.lf:
                            text = text.Replace("\r\n", "\n").Replace("\r", "\n");
                            dc.EolCode = "\n";
                            break;
                        case Form9.ChangeEOLMode.crlf:
                            string[] sps = text.Split(new string[] { "\r\n" }, StringSplitOptions.None);
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < sps.Length; i++)
                            {
                                sb.Append(sps[i].Replace("\r", "\n").Replace("\n", "\r\n"));
                                if (i != sps.Length - 1) sb.Append("\r\n");
                            }
                            text = sb.ToString();
                            dc.EolCode = "\r\n";
                            break;
                    }
                }
            }
            dc.Text = text;
        }
        public int CheckError(TextEditWindow tew, string results, int exitcode)
        {
            if (exitcode != 0)
            {
                AnalyzeError(tew, results);
                TellError();
                return 1;
            }
            else
            {
                HideError();
                AnalyzeError(tew, results);
                if (notepadUtility.NotExecuteProgramWhenError && errorWindow.ErrorCount > 0)
                {
                    return 1;
                }
                if (notepadUtility.NotExecuteProgramWhenWarning && errorWindow.WarningCount > 0)
                {
                    return 1;
                }
                return 0;
            }
        }
        public void AnalyzeError(TextEditWindow tew, string data)
        {
            lastErrorCodeWindow.TextBoxText = data;
            errorWindow.Clear();
            data = data.Replace("\r", "");
            string[] splitdata = data.Split('\n');
            for (int i = 0; i < splitdata.Length; i++)
            {
                if (tew.ExAzukiControl.ExtensionInfo.CompileWarnRegex != null)
                {
                    AddErrorOrWarning(tew, tew.ExAzukiControl.ExtensionInfo.CompileWarnRegex, splitdata[i], false);
                }
                if (tew.ExAzukiControl.ExtensionInfo.CompileErrorRegex != null)
                {
                    AddErrorOrWarning(tew, tew.ExAzukiControl.ExtensionInfo.CompileErrorRegex, splitdata[i], true);
                }
            }
            tew.ExAzukiControl.Invalidate();
            errorWindow.FinishAdd();
        }

        private void AddErrorOrWarning(TextEditWindow tew, Regex regex, string line, bool isError)
        {
            Match m = null;
            m = regex.Match(line);
            if (m.Success)
            {
                string text = "";
                string row = "0";
                string column = "0";
                string filename = "";
                if (m.Groups["content"] != null)
                {
                    text = m.Groups["content"].Value;
                }
                if (m.Groups["line"] != null)
                {
                    row = m.Groups["line"].Value;
                }
                if (m.Groups["column"] != null)
                {
                    column = m.Groups["column"].Value;
                }
                if (m.Groups["filename"] != null)
                {
                    filename = m.Groups["filename"].Value;
                }
                if (row == "") row = "0";
                if (column == "") column = "0";
                if (filename == "") filename = tew.Filename;

                int rowIndex, columnIndex;
                int.TryParse(row, out rowIndex);
                int.TryParse(column, out columnIndex);

                if (isError)
                {
                    errorWindow.Add(0, text, rowIndex, columnIndex, filename);
                    tew.AddMark(filename, rowIndex, columnIndex, NotepadUtility.ErrorMarkId);
                }
                else
                {
                    errorWindow.Add(1, text, rowIndex, columnIndex, filename);
                    tew.AddMark(filename, rowIndex, columnIndex, NotepadUtility.WarningMarkId);
                }
            }
        }

        public void TellError()
        {
            errorWindow.ChangeErrorState(true);
        }
        public void HideError()
        {
            errorWindow.ChangeErrorState(false);
            this.toolStripStatusLabel2.Text = "";
            this.toolStripStatusLabel3.Text = "";
            lastErrorCodeWindow.TextBoxText = "";
        }
    }

}