﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using NotepadNeueExtension;
using IronPython.Hosting;
using WeifenLuo.WinFormsUI.Docking;
using System.Linq;
using NotepadNeue.Docks;

namespace NotepadNeue
{
    public partial class MainForm : Form, IExtensionHost
    {
        static ErrorWindow errorWindow = new ErrorWindow();
        static LastErrorCodeWindow lastErrorCodeWindow = new LastErrorCodeWindow();
        public ExNotepadNeueSkin skin = new ExNotepadNeueSkin();
        static ScrapedDataView scrapedDataView = new ScrapedDataView();
        static DefineLocationWindow defineLocationWindow = new DefineLocationWindow();

        static Form3 VersionSprite = new Form3();
        ExtensionSettingManager extensionSettingManager;
        public MainForm(string filename)
        {
            InitializeComponent();
            errorWindow.CellDoubleClick += new ErrorWindow.CompileErrorEventHandler(ew_CellDoubleClick);
            defineLocationWindow.DefineLocationChanged += new Action<DefineLocation>(defineLocationWindow_DefineLocationChanged);
            extensionSettingManager = new ExtensionSettingManager();
            ReadDir();
            ReadWord();
            ReadSettingType();
            ReadConfig();
            if (filename == "-safemode")
            {
                notepadUtility.AllowScriptUse = false;
            }
            if (notepadUtility.AllowScriptUse) ReadExtension();
            myDataGridView1.MaxDisplayNum = notepadUtility.DisplayAssistnum;
            ExtensionInfomationManager = new SortedList<string, ExtensionInfomation>();
            shortcutManager = new Shortcutmanager();
            customToolStrip = new CustomToolStrip(currentDirectory, this, shortcutManager);
            customToolStrip.BackColor = Color.Transparent;
            Control lastcontrolintop = toolStrip4;
            this.toolStripContainer1.TopToolStripPanel.Controls.Add(customToolStrip);
            defaultExInfo = new ExtensionInfomation(currentDirectory, this);
            defaultExInfo.readini(currentDirectory + "ini\\" + currentIni);
            defaultExInfo.Extension = GetExtensionFromIni(currentIni);
            currentCustomToolStrip = defaultExInfo.CustomToolStrip;
            lastcontrolintop = customToolStrip;
            this.toolStripContainer1.TopToolStripPanel.Controls.Add(currentCustomToolStrip);
            ExtensionInfomationManager.Add(defaultExInfo.Extension, defaultExInfo);
            ReadKeyBind();
            //for checkwindowvisible
            errorWindow.VisibleChanged += new EventHandler(windowvisiblechanged);
            lastErrorCodeWindow.VisibleChanged += new EventHandler(windowvisiblechanged);
            scrapedDataView.VisibleChanged += new EventHandler(windowvisiblechanged);
            RestoreWindow();
            Action prepareDefaultTab = () =>
            {
                TextEditWindow tew = new TextEditWindow();
                tew.Filename = "new.txt";
                tew.Initialize(this, myToolTip1, myDataGridView1, notepadUtility, defaultExInfo);
                tew.Show(dockPanel1, DockState.Document);
            };
            if (filename != "")
            {
                if (File.Exists(filename))
                {
                    prepareDefaultTab();
                    OpenFile(filename);
                    Utility.SetToEditor(CurrentDocument);
                }
            }
            else
            {
                string lastTabs = extensionSettingManager.GetSetting("NotepadNeue", "LastTabs");
                if (!String.IsNullOrEmpty(lastTabs))
                {
                    OpenLastTabs(lastTabs);
                    extensionSettingManager.SetSetting("NotepadNeue", "LastTabs", null);
                }
                else
                {
                    prepareDefaultTab();
                    Utility.SetToEditor(CurrentDocument);
                }
            }
            CurrentDocument.Font = new Font(notepadUtility.Fontname, notepadUtility.Fontsize);
            this.myToolTip1.Font = CurrentDocument.Font;
            if (notepadUtility.AutoFormat)
            {
                CurrentDocument.AutoIndentHook = Sgry.Azuki.AutoIndentHooks.GenericHook;
            }
            else
            {
                CurrentDocument.AutoIndentHook = null;
            }
            this.Controls.Add(this.myToolTip1);
            this.Controls.SetChildIndex(this.myToolTip1, 0);
            this.Controls.Add(this.myDataGridView1);
            this.Controls.SetChildIndex(this.myDataGridView1, 1);
            ReadPlugin(currentDirectory + "\\" + defaultplugin);
            if (File.Exists(currentDirectory + "skin.ini"))
            {
                skin.Initialize(currentDirectory + "skin.ini", currentDirectory);
                this.dockPanel1.Skin = skin.Skin;
                ChangeBackground();
            }
            ChangeSettingState();
            scrapedDataView.MainForm = this;
            foreach (ToolStripMenuItem tsmi in menuStrip1.Items)
            {
                tsmi.DropDownClosed += new EventHandler(tsmi_DropDownClosed);
            }
            //for rescuedata
            Application.ThreadException += new ThreadExceptionEventHandler(Application_ThreadException);
            ManageDocument();
        }

        private void windowvisiblechanged(object sender, EventArgs e)
        {
            this.エラー一覧ToolStripMenuItem.Checked = CheckVisible(errorWindow);
            this.最終エラーログToolStripMenuItem.Checked = CheckVisible(lastErrorCodeWindow);
            this.取得データ表示ToolStripMenuItem.Checked = CheckVisible(scrapedDataView);
            foreach (ToolStripMenuItem tsmi in 表示ToolStripMenuItem.DropDownItems)
            {
                DockContent dc = tsmi.Tag as DockContent;
                if (dc != null)
                {
                    tsmi.Checked = CheckVisible(dc);
                }
            }
        }

        void tsmi_DropDownClosed(object sender, EventArgs e)
        {
            Refresh();
        }
        void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
        {
#if DEBUG
            MessageBox.Show(e.Exception.Message + "\n" + e.Exception.StackTrace);
#endif
            if (e.Exception != null)
            {
                Program.WriteError(e.Exception);
            }

            if (ErrorFinishing)
            {
                MessageBox.Show(e.Exception.Message);
                RescueData();
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            bool savetab = false;
            if (dockPanel1.DocumentsCount != 0 && notepadUtility.AskSaveTabs)
            {
                Form8 fm8 = new Form8();
                if (fm8.ShowDialog() == DialogResult.OK)
                {
                    savetab = true;
                }
                notepadUtility.AskSaveTabs = !fm8.NeverAsk;
                notepadUtility.SaveTabs = fm8.DialogResult == DialogResult.OK ? true : false;
            }
            else
            {
                savetab = notepadUtility.SaveTabs;
            }
            DockContent[] temp = new DockContent[dockPanel1.DocumentsCount];
            int iter = 0;
            foreach (DockContent df in dockPanel1.Documents)
            {
                temp[iter] = df;
                iter++;
            }
            List<string> lastTabs = new List<string>();
            for (int i = temp.Length - 1; i >= 0; i--)
            {
                TextEditWindow tew = temp[i] as TextEditWindow;
                if (tew != null)
                {
                    tew.Pane.ActiveContent = tew;
                    temp[i].Close();
                    if (!tew.Saved)
                    {
                        e.Cancel = true;
                        return;
                    }
                    else
                    {
                        if (savetab && tew.Filename != "new.txt")
                        {
                            lastTabs.Add(tew.Filename);
                        }
                    }
                }
                else
                {
                    temp[i].HideOnClose = false;
                    temp[i].Close();
                }
            }
            if (savetab && lastTabs.Count > 0)
            {
                extensionSettingManager.SetSetting("NotepadNeue", "LastTabs",
                    lastTabs.Aggregate("", (s1, s2) => String.Format("{0}\n{1}", s1, s2)));
            }
            SaveConfig();
            if (!e.Cancel)
            {
                ErrorFinishing = false;
                dockPanel1.SaveAsXml(currentDirectory + "dockinfo.xml");
                if (MainFormClosed != null)
                {
                    MainFormClosed.Invoke(this, EventArgs.Empty);
                }
                extensionSettingManager.Save();
            }
        }
        private void 現在のドキュメントにToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (this.CurrentDocument.Text != "")
            {
                DialogResult dr = AskSave();
                if (dr == DialogResult.Yes)
                {
                    Save(CurrentWindow);
                }
                else if (dr == DialogResult.No)
                {
                    this.CurrentDocument.Text = "";
                    this.Text = "new.txt" + title;
                }
                ChangeFormText();
            }
        }

        private void 新しいドキュメントにToolStripMenuItem_Click(object sender, EventArgs e)
        {
            CreateNewDocument();
        }

        private void 現在のドキュメントにToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.openFileDialog1.FileName = "";
            this.openFileDialog1.RestoreDirectory = true;
            if (this.CurrentDocument.Text != "" && !this.CurrentWindow.Saved)
            {
                DialogResult dr = AskSave();
                if (dr == DialogResult.Cancel) return;
                else if (dr == DialogResult.Yes)
                {
                    OverSave();
                }
            }
            string extension = "." + this.CurrentDocument.ExtensionInfo.Extension;
            if (extension != null)
            {
                string temp = extension.Substring(1).ToUpper() + "ファイル" + "(*" + extension + ")|*" + extension;
                this.openFileDialog1.Filter = temp + "|" + "テキストファイル(*.text;*.txt)|*.text;*.txt|すべてのファイル(*.*)|*.*";
            }
            else
            {
                this.openFileDialog1.Filter += "テキストファイル(*.text;*.txt)|*.text;*.txt|すべてのファイル(*.*)|*.*";
            }

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                OpenFile(openFileDialog1.FileName);
            }
        }
        private void 新しいドキュメントにToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.FileName = "";
            this.openFileDialog1.RestoreDirectory = true;
            if (CurrentDocument != null)
            {
                string extension = "." + this.CurrentDocument.ExtensionInfo.Extension;
                string temp = extension.Substring(1).ToUpper() + "ファイル" + "(*" + extension + ")|*" + extension;
                this.openFileDialog1.Filter = temp + "|" + "テキストファイル(*.text;*.txt)|*.text;*.txt|すべてのファイル(*.*)|*.*";
            }
            else
            {
                this.openFileDialog1.Filter += "テキストファイル(*.text;*.txt)|*.text;*.txt|すべてのファイル(*.*)|*.*";
            }

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                OpenFileToNewDocument(openFileDialog1.FileName);
            }
        }
        private void 閉じるToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.CurrentWindow != null)
            {
                this.CurrentWindow.Close();
            }
        }
        private void 次のドキュメントToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ChangeToNextDocument();
        }

        private void 前のドキュメントToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ChangeToPreviousDocument();
        }
        private void 上書き保存ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OverSave();
        }
        private void 上ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (!CurrentDocument.MoveUp())
            {
                Sgry.Azuki.Actions.MoveUp(this.CurrentDocument);
                this.myDataGridView1.Visible = false;
                this.myToolTip1.Visible = false;
            }
        }

        private void 下ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (!CurrentDocument.MoveDown())
            {
                Sgry.Azuki.Actions.MoveDown(this.CurrentDocument);
                this.myDataGridView1.Visible = false;
                this.myToolTip1.Visible = false;
            }
        }

        private void 左ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (!CurrentDocument.MoveLeft())
            {
                Sgry.Azuki.Actions.MoveLeft(this.CurrentDocument);
                this.myDataGridView1.Visible = false;
                this.myToolTip1.Visible = false;
            }
        }

        private void 右ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveRight(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }
        private void 前の単語ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (!CurrentDocument.MoveRight())
            {
                Sgry.Azuki.Actions.MoveToPrevWord(this.CurrentDocument);
                this.myDataGridView1.Visible = false;
                this.myToolTip1.Visible = false;
            }
        }

        private void 後の単語ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveToNextWord(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }
        private void ページ上へToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MovePageUp(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ページ下へToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MovePageDown(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }
        private void dELETEToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.DeleteChange();
            ExActions.SmartDelete(this.CurrentDocument);
        }

        private void 単語DELETEToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.DeleteChange();
            Sgry.Azuki.Actions.DeleteWord(this.CurrentDocument);
        }

        private void backSpaceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.DeleteChange();
            ExActions.SmartBackSpace(this.CurrentDocument);
        }

        private void 単語BackSpaceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.DeleteChange();
            Sgry.Azuki.Actions.BackSpaceWord(this.CurrentDocument);
        }

        private void 切り取りToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.Cut(this.CurrentDocument);
        }

        private void コピーToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.Copy(this.CurrentDocument);
        }

        private void 貼り付けToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.UndoOrRedo();
            Sgry.Azuki.Actions.Paste(this.CurrentDocument);
        }

        private void 元に戻すToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.UndoOrRedo();
            Sgry.Azuki.Actions.Undo(this.CurrentDocument);
        }

        private void やり直すToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.Redo(this.CurrentDocument);
        }

        private void 全てToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.SelectAll();
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }


        private void 一行ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            int begin, end;
            this.CurrentDocument.GetSelection(out begin, out end);
            int columnindex, rowindex;
            this.CurrentDocument.GetLineColumnIndexFromCharIndex(begin, out rowindex, out columnindex);
            this.CurrentDocument.SetSelection(this.CurrentDocument.GetLineHeadIndex(rowindex), (this.CurrentDocument.GetLineHeadIndex(rowindex)));
            Sgry.Azuki.Actions.SelectToLineEnd(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }
        private void 上ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToUp(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 下ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToDown(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 左ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToLeft(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 右ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToRight(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 前の単語ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToPrevWord(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 後の単語ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToNextWord(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ページ上ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToPageUp(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ページ下ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToPageDown(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ファイル始端ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToFileHead(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ファイル終端ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToFileEnd(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 行頭ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToLineHead(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 行末ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToLineEnd(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ホワイトスペースを無視して行頭ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.SelectToLineHeadSmart(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ファイル始端へToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveToFileHead(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ファイル終端へToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveToFileEnd(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 行頭ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveToLineHead(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void 行末ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveToLineEnd(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }

        private void ホワイトスペースを無視して行頭ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            Sgry.Azuki.Actions.MoveToLineHeadSmart(this.CurrentDocument);
            this.myDataGridView1.Visible = false;
            this.myToolTip1.Visible = false;
        }
        private void 再読み込みToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ReloadDocument();
        }
        private void 入力補助ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notepadUtility.InputAssist = !notepadUtility.InputAssist;
            入力補助ToolStripMenuItem.Checked = notepadUtility.InputAssist;
            SaveConfig();
        }

        private void 参照補助ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notepadUtility.FunctionAssist = !notepadUtility.FunctionAssist;
            参照補助ToolStripMenuItem.Checked = notepadUtility.FunctionAssist;
            SaveConfig();
        }
        private void オートフォーマットToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notepadUtility.AutoFormat = !notepadUtility.AutoFormat;
            オートフォーマットToolStripMenuItem.Checked = notepadUtility.AutoFormat;
            if (CurrentDocument != null)
            {
                if (notepadUtility.AutoFormat)
                {
                    this.CurrentDocument.AutoIndentHook = Sgry.Azuki.AutoIndentHooks.GenericHook;
                }
                else
                {
                    this.CurrentDocument.AutoIndentHook = null;
                }
            }
            SaveConfig();
        }
        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form5 fm = new Form5(wordFile);
            string ini = this.currentIni;
            if (CurrentDocument != null)
            {
                ini = "reserved_" + CurrentDocument.ExtensionInfo.Extension + ".ini";
            }
            fm.CurrentIni = this.currentIni;
            if (fm.ShowDialog() == DialogResult.OK)
            {
                if (fm.ChangeDefault)
                {
                    currentIni = Path.GetFileName(wordFile[fm.ChangeIndex]);
                    SaveConfig();
                }
                MessageBox.Show("次回起動時に有効になります");
            }
            fm.Dispose();
        }
        private void 新しく保存ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.Save(CurrentWindow);
        }
        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void キーバインドToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form6 fm = new Form6(shortcutData, GetToolBarName());
            if (fm.ShowDialog() == DialogResult.OK)
            {
                this.shortcutData = fm.sdata;
                string[] metas = GetToolBarName();
                string s = "";
                for (int i = 0; i < shortcutData.Length; i++)
                {
                    if (i != 0)
                    {
                        s += System.Environment.NewLine;
                    }
                    s += "[" + metas[i] + "]";
                    s += shortcutData[i];
                }
                try
                {
                    StreamWriter sw = new StreamWriter(currentDirectory + "keybind.ini");
                    sw.Write(s);
                    sw.Close();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
                MessageBox.Show("次回起動時に有効になります");
            }
        }
        private void タブToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            this.CurrentDocument.Document.Replace("\t");
        }

        private void コンパイルToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (this.CurrentWindow.Filename == "new.txt")
            {
                if (AskSave() == DialogResult.Yes)
                {
                    if (Save(CurrentWindow) == DialogResult.Cancel)
                    {
                        return;
                    }
                }
                else
                {
                    return;
                }
            }
            //save
            try
            {
                StreamWriter swt = new StreamWriter(this.CurrentWindow.Filename, false, this.CurrentDocument.ExtensionInfo.Encoding);
                swt.Write(this.CurrentDocument.Text);
                swt.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                return;
            }
            this.CurrentWindow.Save();
            this.toolStripStatusLabel2.Text = st3;
            this.toolStripStatusLabel3.Text = this.CurrentWindow.Filename;
            BackUpFile();
            this.CurrentWindow.CompileAndExecute(null);
        }
        private void 全行自動フォーマットToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (this.CurrentDocument.TextLength == 0) return;
            this.CurrentDocument.ForceAutoFormat();
        }
        private void バージョン情報ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            VersionSprite.TopMost = true;
            VersionSprite.ShowDialog();
        }
        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            bool maybeshouldignore = true;
            if (dockPanel1.ActivePane == null)
            {
                maybeshouldignore = false;
            }
            else if (dockPanel1.ActivePane != null && dockPanel1.ActivePane.DockState != DockState.Document)
            {
                IsShouldIgnoreKey = false;
                //return;
            }
            else
            {
                maybeshouldignore = false;
            }
            if (lastCustomShortcut == null)
            {
                if (e.Control || e.Alt || (Keys.F1 <= e.KeyData && e.KeyData <= Keys.F24))
                {
                    if (lastCustomShortcut == null)
                    {
                        CustomShortcut cs = new CustomShortcut();
                        cs.firstkey = (Keys)e.KeyData;
                        if (e.Control)
                        {
                            cs.firstkey -= (int)Keys.Control;
                            cs.modifiers |= Keys.Control;
                        }
                        if (e.Shift)
                        {
                            cs.firstkey -= (int)Keys.Shift;
                            cs.modifiers |= Keys.Shift;
                        }
                        if (e.Alt)
                        {
                            cs.firstkey -= (int)Keys.Alt;
                            cs.modifiers |= Keys.Alt;
                        }
                        lastCustomShortcut = cs;
                        ifReleasedKey[0] = false;
                        CustomShortcut outcs;
                        if (shortcutManager.Containshortcut(cs, out outcs))
                        {
                            if (maybeshouldignore && !outcs.IsPanelOperation)
                            {
                                lastCustomShortcut = null;
                                IsShouldIgnoreKey = false;
                                return;
                            }
                            Delegate del = shortcutManager.Getdelegate(cs);
                            this.Invoke(del, outcs.ToolStripMenuItem, EventArgs.Empty);
                            lastCustomShortcut = null;
                            ifReleasedKey[0] = true;
                        }
                        else if (CurrentDocument != null && this.CurrentDocument.ExtensionInfo.ShortCutManager.Containshortcut(cs, out outcs))
                        {
                            Delegate del = this.CurrentDocument.ExtensionInfo.ShortCutManager.Getdelegate(outcs);
                            this.Invoke(del, outcs.ToolStripMenuItem, EventArgs.Empty);
                            lastCustomShortcut = null;
                            ifReleasedKey[0] = true;
                        }
                        if ((int)cs.firstkey <= 18)
                        {
                            lastCustomShortcut = null;
                            ifReleasedKey[0] = true;
                        }
                        if (lastCustomShortcut != null)
                        {
                            this.toolStripStatusLabel3.Text = lastCustomShortcut.displaystring() + "...二つ目のキーが押されるのを待っています";
                        }
                        e.Handled = true;
                    }
                }
                IsShouldIgnoreKey = false;
            }
            else if (lastCustomShortcut != null)
            {
                lastCustomShortcut.secondkey = (Keys)e.KeyData;
                if (e.Control)
                {
                    lastCustomShortcut.secondkey -= (int)Keys.Control;
                }
                if (e.Shift)
                {
                    lastCustomShortcut.secondkey -= (int)Keys.Shift;
                }
                if (e.Alt)
                {
                    lastCustomShortcut.secondkey -= (int)Keys.Alt;
                }
                /*if ((int)lastcs.secondkey <= 18 || lastcs.firstkey != lastcs.secondkey)
                {
                    ifreleasedkey[0] = true;
                }*/
                if ((int)lastCustomShortcut.secondkey >= 19 && ifReleasedKey[0])
                {
                    CustomShortcut outcs;
                    if (shortcutManager.Containshortcut(lastCustomShortcut, out outcs))
                    {
                        if (maybeshouldignore && !outcs.IsPanelOperation)
                        {
                            lastCustomShortcut = null;
                            IsShouldIgnoreKey = false;
                            return;
                        }
                        Delegate del = shortcutManager.Getdelegate(lastCustomShortcut);
                        this.Invoke(del, outcs.ToolStripMenuItem, EventArgs.Empty);
                        this.toolStripStatusLabel3.Text = "";
                        lastCustomShortcut = null;
                    }
                    else if (CurrentDocument != null && this.CurrentDocument.ExtensionInfo.ShortCutManager.Containshortcut(lastCustomShortcut, out outcs))
                    {
                        Delegate del = this.CurrentDocument.ExtensionInfo.ShortCutManager.Getdelegate(outcs);
                        this.Invoke(del, outcs.ToolStripMenuItem, EventArgs.Empty);
                        this.toolStripStatusLabel3.Text = "";
                        lastCustomShortcut = null;
                    }
                    else
                    {
                        //no shortcut
                        this.toolStripStatusLabel3.Text = "対応するショートカットがありませんでした";
                        lastCustomShortcut = null;
                    }
                }
                e.Handled = true;
                IsShouldIgnoreKey = true;
            }
            else
            {
                IsShouldIgnoreKey = false;
            }
        }

        private void Form1_KeyUp(object sender, KeyEventArgs e)
        {
            if (lastCustomShortcut != null)
            {
                ifReleasedKey[0] = true;
            }
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (lastCustomShortcut != null)
            {
                e.Handled = true;
            }
        }

        private void 環境設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form7 fm7 = new Form7();
            fm7.utility = notepadUtility;
            //nu.SetAll(fm7.utility);
            if (fm7.ShowDialog() == DialogResult.OK && fm7.Changed)
            {
                fm7.utility.SetAll(notepadUtility);
                SaveConfig();
                MessageBox.Show("次回起動時に有効になります");
            }
            fm7.Dispose();
        }
        private void myDataGridView1_ListDoubleClick(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (this.CurrentDocument.ReplaceAssist())
            {
                this.CurrentDocument.Focus();
            }
        }

        private void myDataGridView1_ListKeyDown(object sender, KeyEventArgs e)
        {
            if (CurrentDocument == null) return;
            if (e.KeyCode == Keys.Return)
            {
                if (this.CurrentDocument.ReplaceAssist())
                {
                    this.CurrentDocument.Focus();
                }
            }
        }

        private void myDataGridView1_ListSelectionChanged(object sender, EventArgs e)
        {
            if (CurrentDocument == null) return;
            if (this.myDataGridView1.SelectedText != "")
            {
                Point p = this.PointToClient(myDataGridView1.PointToScreen(myDataGridView1.ClientRectangle.Location));
                this.myToolTip1.Location = new Point(p.X + this.myDataGridView1.Width, p.Y);
                if (this.myDataGridView1.SelectedHintText != "" && this.myDataGridView1.SelectedSummary != "")
                {
                    myToolTip1.DisplayText = this.myDataGridView1.SelectedHintText + "\n" + this.myDataGridView1.SelectedSummary;
                    myToolTip1.Show();
                }
                else if (myDataGridView1.SelectedHintText != "")
                {
                    myToolTip1.DisplayText = this.myDataGridView1.SelectedHintText;
                    myToolTip1.Show();
                }
                else if (myDataGridView1.SelectedSummary != "")
                {
                    myToolTip1.DisplayText = this.myDataGridView1.SelectedSummary;
                    myToolTip1.Show();
                }
                else
                {
                    myToolTip1.Hide();
                }
            }
        }
        private void ew_CellDoubleClick(object sender, ErrorWindow.CompileErrorEventArgs e)
        {
            bool found = false;
            TextEditWindow tew = null;
            foreach (DockContent df in dockPanel1.Documents)
            {
                tew = df as TextEditWindow;
                if (tew != null)
                {
                    if (FileUtil.IsSameFile(tew.Filename, e.Filename))
                    {
                        tew.Pane.ActiveContent = tew;
                        this.CurrentDocument.Focus();
                        found = true;
                        break;
                    }
                }
            }
            if (!found)
            {
                if (File.Exists(e.Filename))
                {
                    OpenFileToNewDocument(e.Filename);
                }
            }
            try
            {
                var index = this.CurrentDocument.GetCharIndexFromLineColumnIndex(
                    Math.Max(0, e.Row - 1), Math.Max(0, e.Column - 1));
                this.CurrentDocument.SetSelection(index, index);
                this.CurrentDocument.ScrollToCaret();
                this.CurrentDocument.Focus();
            }
            catch
            {
            }
        }

        void defineLocationWindow_DefineLocationChanged(DefineLocation obj)
        {
            FindAndFocus(obj);
        }

        private void ドキュメントToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DockPane dp = ActiveDocumentPane;
            if (dp != null)
            {
                dp.Focus();
                if (CurrentWindow != null) CurrentWindow.Focus();
                if (CurrentDocument != null) CurrentDocument.Focus();
            }
        }

        private void エラー一覧ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowOrHideWindow(errorWindow);
        }

        private void 最終エラーログToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowOrHideWindow(lastErrorCodeWindow);
        }

        private void 動画ウィンドウToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MovieWindow mw = new MovieWindow();
            mw.Filename = "new.txt";
            mw.Initialize(this, myToolTip1, myDataGridView1, notepadUtility, defaultExInfo);
            mw.Show(dockPanel1, DockState.Document);
            Utility.SetToEditor(mw.ExAzukiControl);
            mw.Prepare();
            mw.Font = new Font(notepadUtility.Fontname, notepadUtility.Fontsize);
            this.myToolTip1.Font = CurrentDocument.Font;
            CurrentDocument.AutoIndentHook = Sgry.Azuki.AutoIndentHooks.GenericHook;
            mw.RunDX();
        }
        private void 取得データ表示ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShowOrHideWindow(scrapedDataView);
        }
        private void ShowOrHideWindow(DockContent dockcontent)
        {
            if (!dockcontent.Visible || (DockState.DockTopAutoHide <= dockcontent.DockState && dockcontent.DockState <= DockState.DockRightAutoHide))
            {
                if (dockcontent.Pane != null)
                {
                    dockcontent.Show(dockPanel1);
                    dockcontent.Pane.ActiveContent = dockcontent;
                }
                else
                {
                    dockcontent.Show(dockPanel1, WeifenLuo.WinFormsUI.Docking.DockState.Float);
                }
            }
            else
            {
                if (dockPanel1.ActivePane == dockcontent.Pane || dockcontent.DockState == DockState.Float)
                {
                    dockcontent.Hide();
                }
                else
                {
                    dockcontent.Focus();
                }
            }
        }
        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            ChangeBackground();
        }

        private void dockPanel1_ActiveDocumentChanged(object sender, EventArgs e)
        {
            myDataGridView1.Clear();
            myDataGridView1.EndUpdate();
            myDataGridView1.Visible = false;
            myToolTip1.Visible = false;

            var currentDocument = CurrentDocument;
            if (currentDocument != null)
            {
                currentDocument.Document.WatchPatterns.Unregister(NotepadUtility.SearchHighlightId);
                if (currentWatchPattern != null)
                {
                    ActivateIncrementalSearch();
                }
                else
                {
                    ClearIncrementalSearch();
                }
            }

            if (dockPanel1.DocumentsCount == 0)
            {
                CreateNewDocument();
            }
            ChangeFormText();
        }
        private void ChangeFormText()
        {
            TextEditWindow tew = dockPanel1.ActiveDocument as TextEditWindow;
            if (tew != null)
            {
                this.Text = tew.Filename + title;
                ChangeSettingState();
                ChangeCustomToolStrip();
            }
        }
        private void ManageDocument()
        {
            DockWindows = new System.Collections.ArrayList();
            foreach (DockContent df in dockPanel1.Documents)
            {
                DockWindows.Add(df);
            }
        }

        private void toolStripDropDownButton9_DropDownClosed(object sender, EventArgs e)
        {
            Refresh();
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.Activate();
        }

        private void notifyIcon1_BalloonTipClosed(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
        }

        private void dockPanel1_DocumentTabFileDroped(string[] obj)
        {
            foreach (string fileName in obj)
            {
                OpenFileToNewDocument(fileName);
            }
        }
    }
}
