﻿using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using DirectShowLib;
using System.Runtime.InteropServices;

namespace NotepadNeue
{
    class Movie : IDisposable
    {

        protected int left = 0;
        protected int right = 0;
        protected int top = 0;
        protected int bottom = 0;
        protected const int fadestep = 2;
        protected double length;
        public bool initialized = false;
        public bool playing = false;
        bool disposed = false;
        public bool displaymovie = true;
        public int lastvolume;
        //directshow
        protected const int WMGraphNotify = 0x0400 + 13;
        protected const int VolumeFull = -1000;
        protected const int VolumeSilence = -10000;
#if DEBUG
        private DsROTEntry rot = null;
#endif
        private double needtime;
        private int width;
        private int height;
        private IFilterGraph2 graphBuilder2 = null;
        private IBaseFilter nullrenderer;
        private IMediaControl mediaControl = null;
        private IMediaEventEx mediaEventEx = null;
        private IBasicAudio basicAudio = null;
        private IBasicVideo basicVideo = null;
        private IMediaSeeking mediaSeeking = null;
        protected IMediaPosition mediaPosition = null;
        private IVideoWindow videoWindow = null;
        //private IVideoFrameStep frameStep = null;
        protected string filename = string.Empty;
        private bool isAudioOnly = false;
        private IntPtr hDrain = IntPtr.Zero;
        public IntPtr hwnd;
        // Application-defined message to notify app of filtergraph events
        public const int WM_GRAPHNOTIFY = 0x8000 + 1;
        public Movie(string filename)
        {
            this.filename = filename;
        }

        public int initialize()
        {
            //directshowtest
            //サンプルグラバーを接続するフォーマットを指定
            string filename1 = this.filename;
            try
            {
                int hr = 0;


                this.graphBuilder2 = (IFilterGraph2)new FilterGraph();
                hr = this.graphBuilder2.RenderFile(filename1, null);
                DsError.ThrowExceptionForHR(hr);
                // QueryInterface for DirectShow interfaces
                this.mediaControl = (IMediaControl)this.graphBuilder2;
                this.mediaEventEx = (IMediaEventEx)this.graphBuilder2;
                this.mediaSeeking = (IMediaSeeking)this.graphBuilder2;
                this.mediaPosition = (IMediaPosition)this.graphBuilder2;
                // Query for video interfaces, which may not be relevant for audio files
                this.basicVideo = this.graphBuilder2 as IBasicVideo;
                // Query for audio interfaces, which may not be relevant for video-only files
                this.basicAudio = this.graphBuilder2 as IBasicAudio;
                this.videoWindow = this.graphBuilder2 as IVideoWindow;



                hr = 0;


                //sampleGrabber.SetCallback(this, 1);





                // Is this an audio-only file (no video component)?
                //CheckVisibility();

                // Have the graph signal event via window callbacks for performance
                //hr = this.mediaEventEx.SetNotifyWindow(this.Window.Handle, WMGraphNotify, IntPtr.Zero);
                //DsError.ThrowExceptionForHR(hr);
                if (!this.isAudioOnly)
                {
                    // Setup the video window
                    //hr = this.videoWindow.put_Owner(this.Window.Handle);
                    //DsError.ThrowExceptionForHR(hr);

                    //hr = this.videoWindow.put_WindowStyle(WindowStyle.Child | WindowStyle.ClipSiblings | WindowStyle.ClipChildren | WindowStyle.Visible);
                    //DsError.ThrowExceptionForHR(hr);

                    //hr = InitVideoWindow(1, 1);
                    //DsError.ThrowExceptionForHR(hr);

                    //GetFrameStepInterface();
                }
                else
                {
                    // Initialize the default player size and enable playback menu items
                    //hr = InitPlayerWindow();
                    DsError.ThrowExceptionForHR(hr);

                    //EnablePlaybackMenu(true, MediaType.Audio);
                }

                // Complete window initialization
                //CheckSizeMenu(menuFileSizeNormal);
                //UpdateMainTitle();

                if (displaymovie)
                {
                    this.videoWindow.put_Owner(hwnd);
                    this.videoWindow.put_WindowStyle(WindowStyle.Child | WindowStyle.ClipSiblings);
                    this.basicVideo.get_SourceWidth(out width);
                    this.basicVideo.get_SourceHeight(out height);
                }
                else
                {
                    this.videoWindow.put_AutoShow(OABool.False);
                    this.videoWindow.put_Visible(OABool.False);
                }
                this.basicVideo.get_AvgTimePerFrame(out needtime);
                //this.Focus();
                hr = this.mediaPosition.get_Duration(out this.length);
                DsError.ThrowExceptionForHR(hr);
                this.initialized = true;
                this.Play();
                this.Pause();
            }
            catch (Exception e)
            {
                return -1;
            }
            return 0;
        }
        public void changeposition(int width,int height)
        {
            if (this.videoWindow != null)
            {
                float sourceasp = (float)this.width / this.height;
                float windowasp = (float)width / height;
                if (windowasp > sourceasp)
                {
                    this.videoWindow.SetWindowPosition((width - (int)(sourceasp * height)) / 2, 0, (int)(sourceasp * height), height);
                }
                else
                {
                    this.videoWindow.SetWindowPosition(0, (height - (int)(width / sourceasp)) / 2, width, (int)(width / sourceasp));
                }
            }
        }
        public void nextframe()
        {
            OABool oab;
            this.mediaPosition.CanSeekForward(out oab);
            if (oab == OABool.True)
            {
                double currenttime = 0;
                this.mediaPosition.get_CurrentPosition(out currenttime);
                this.mediaPosition.put_CurrentPosition(needtime + currenttime);
            }
        }
        public void beforeframe()
        {
            OABool oab;
            this.mediaPosition.CanSeekBackward(out oab);
            if (oab == OABool.True)
            {
                double currenttime = 0;
                this.mediaPosition.get_CurrentPosition(out currenttime);
                this.mediaPosition.put_CurrentPosition(-needtime + currenttime);
            }
        }
        public void Seek(double time)
        {
            if (time <= this.length && time >= 0)
            {
                int hr = this.mediaPosition.put_CurrentPosition(time);
                DsError.ThrowExceptionForHR(hr);
            }
        }
        public Bitmap getpic()
        {
            if (this.basicVideo != null)
            {
                int buffsize = 0;
                int hr = this.basicVideo.GetCurrentImage(ref buffsize, IntPtr.Zero);
                DsError.ThrowExceptionForHR(hr);
                if (buffsize < 1)
                {
                    MessageBox.Show("small");
                }
                byte[] data = new byte[buffsize];
                IntPtr ptr = Marshal.AllocCoTaskMem(buffsize);
                this.basicVideo.GetCurrentImage(ref buffsize, ptr);
                Marshal.Copy(ptr, data, 0, buffsize);
                Marshal.FreeCoTaskMem(ptr);
                ptr = IntPtr.Zero;
                int width = 0;
                this.basicVideo.get_VideoWidth(out width);
                int height = 0;
                this.basicVideo.get_VideoHeight(out height);
                int stride = width * 4;
                GCHandle GcHandle = GCHandle.Alloc(data, GCHandleType.Pinned);
                IntPtr scan0 = (IntPtr)(GcHandle.AddrOfPinnedObject().ToInt32() + (height - 1) * stride + 40);
                Bitmap bitmap = new Bitmap(width, height, -stride, System.Drawing.Imaging.PixelFormat.Format32bppRgb, scan0);
                GcHandle.Free();
                return bitmap;
            }
            return null;
        }
        public void Play()
        {
            int hr = this.mediaControl.Run();
            DsError.ThrowExceptionForHR(hr);
            playing = true;
        }
        public double CurrentTime
        {
            get
            {
                double ret = 0;
                this.mediaPosition.get_CurrentPosition(out ret);
                return ret;
            }
        }
        public void Stop()
        {
            if (!initialized) return;
            int hr = this.mediaControl.Stop();
            DsError.ThrowExceptionForHR(hr);
            playing = false;
        }

        public void Pause()
        {
            if (!initialized) return;
            int hr = this.mediaControl.Pause();
            DsError.ThrowExceptionForHR(hr);
            playing = false;
        }
        public void setvolume(int num)
        {
            if (this.basicAudio != null)
            {
                int hr = this.basicAudio.put_Volume(num);
                DsError.ThrowExceptionForHR(hr);
            }
        }
        public int getvolume()
        {
            if (this.basicAudio != null)
            {
                int ret = 0;
                int hr = this.basicAudio.get_Volume(out ret); 
                DsError.ThrowExceptionForHR(hr);
                return ret;
            }
            return -10000;
        }

        public virtual void setsetting(int a, int b, int c, int d)
        {
            left = a;
            right = b;
            top = c;
            bottom = d;
        }




        private void setnum(ref byte[] b, uint data, uint pos, uint bitnum)
        {
            for (uint i = pos; i <= pos + bitnum - 1; i++)
            {
                b[i] = (byte)(data & 0xff);
                data >>= 8;
            }
        }
        public void releaseCOM()
        {
            if (!initialized) return;
            int hr = 0;
            // Stop previewing data
            if (this.mediaControl != null)
            {
                hr = this.mediaControl.StopWhenReady();
                DsError.ThrowExceptionForHR(hr);
            }



            // Stop receiving events
            if (this.mediaEventEx != null)
            {
                hr = this.mediaEventEx.SetNotifyWindow(IntPtr.Zero, WM_GRAPHNOTIFY, IntPtr.Zero);
                DsError.ThrowExceptionForHR(hr);
            }
            // Relinquish ownership (IMPORTANT!) of the video window.
            // Failing to call put_Owner can lead to assert failures within
            // the video renderer, as it still assumes that it has a valid
            // parent window.


            // Remove filter graph from the running object table
#if DEBUG
            if (rot != null)
            {
                rot.Dispose();
                rot = null;
            }
#endif

            // Release DirectShow interfaces
            if (nullrenderer != null)
            {
                Marshal.ReleaseComObject(this.nullrenderer); this.nullrenderer = null;
            }
            if (this.graphBuilder2 != null)
            {
                Marshal.ReleaseComObject(this.graphBuilder2); this.graphBuilder2 = null;
            }
            this.initialized = false;
        }
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        private void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    releaseCOM();
                }
            }
            disposed = true;
        }
        public double Length
        {
            get
            {
                return this.length;
            }
        }
        public double Position
        {
            get
            {
                double check = 0;
                this.mediaPosition.get_CurrentPosition(out check);
                return check;
            }
        }
    }
}
